/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "global.h"

#include <QString>
#include <QSplashScreen>
#include "rxwidget.h"
#include "txwidget.h"
#include "gallerywidget.h"
#include "dispatcher.h"
#include "configdialog.h"
#include "ftp.h"
#ifndef QT_NO_DEBUG
#include "scopeview.h"
#endif


const QString MAJORVERSION  = "7.1";
const QString CONFIGVERSION = "7.1";
const QString MINORVERSION  = ".7";
const QString ORGANIZATION = "ON4QZ";
const QString APPLICATION  = ("qsstv" +CONFIGVERSION);
const QString qsstv_version=QString("QSSTV " + MAJORVERSION);

configDialog *confDiag;  
galleryWidget *galMW;
rxWidget *rxMW;
imageViewer *rxViewer;
txWidget *txMW;
imageViewer *txViewer;
dispatcher *dispatchPtr;
#ifndef QT_NO_DEBUG
scopeView *scopeViewer;
#endif
QStatusBar *statusBarPtr;
mainWindow *mw;

QCursor *cpCursor;

void globalInit(void)
{
	QPixmap pm(":/icons/colorpicker.png");
	cpCursor=new QCursor(pm,0,pm.height()-1);

  logfile=new logFile;
  logfile->open(APPLICATION+ ".log");
  #ifndef QT_NO_DEBUG
	scopeViewer=new scopeView("QSSTV");
	scopeViewer->setWindowTitle( "QSSTV Scope" );
	scopeViewer->setAlternativeScaleMultiplier(1./11025);
#endif
  ftpIntf=new ftpInterface();
}

void globalEnd(void)
{
  delete ftpIntf;
#ifndef QT_NO_DEBUG
  delete scopeViewer;
#endif
  delete dispatchPtr;
  logfile->close();
}

