/***************************************************************************
 *   Copyright (C) 2000-2011 by Johan Maes -ON4QZ                               *
 *   on4qz@telenet.be   http://users.telenet.be/on4qz                      *
 *   http://users.telenet.be/on4qz                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LOGGING_H
#define LOGGING_H
#include <QString>
#include <QFile>
#include <QMutex>
#include <QTime>
#include <bitset>
#include <QSettings>

#define NUMDEBUGLEVELS 22
#ifndef QT_NO_DEBUG
  #define addToLog(x,y) logfile->add(__FILE__,__func__,__LINE__,x,y)
 #else
  #define addToLog(x,y) { }
#endif

class QTextStream;

class logFile
{
  public:
    logFile();
    logFile(QString logname);
    ~logFile();
    bool open(QString logname);
//		void add(const char *fmt, ...);
    void add(QString t,short unsigned int posMask);
    void add(const char *fileName,const char *functionName, int line, QString t,short unsigned int posMask);
    void addToAux(QString t);
    bool setEnabled(bool e);
    void setLogMask(std::bitset<NUMDEBUGLEVELS> logMask);
    void maskSelect(QWidget *wPtr=0);
    void readSettings(QSettings &qSettings);
    void writeSettings(QSettings &qSettings);
    void close();
    void reset();
    bool reopen();

  private:
    QString tmp;
    QString tmp2;
    QFile *lf;
    QTextStream *ts;
    QFile *auxFile;
    QTextStream *auxTs;
    bool enabled;
    QMutex mutex;
    QTime timer;
    std::bitset <NUMDEBUGLEVELS> mask;
    QString savedLogEntry;
    int logCount;
    int savedPosMask;
};



//debuglevels
#define DBALL       99
#define DBGALLERY   0
#define DBPARAM     1
#define DBFFT       2
#define DBWAVIO     3
#define DBSYNTHES   4
#define DBDISPAT    5
#define DBSOUND     6
#define DBRXFUNC    7
#define DBTXFUNC    8
#define DBSYNC1     9
#define DBSYNC2     10
#define DBSLANT     11
#define DBMODES     12
#define DBFTP       13
#define DBIMAG      14
#define DBSCOPE     15
#define DBCAM       16
#define DBRXMAIN    17
#define DBTXMAIN    18
#define DBEDIT      19
#define RIGCTRL     20
#define DBPERFORM   21


#endif
