#ifndef RXWIDGET_H
#define RXWIDGET_H

#include <QWidget>
#include "ui_rxwidget.h"

namespace Ui {
    class rxWidget;
}

class rxWidget : public QWidget
{
    Q_OBJECT

public:
    explicit rxWidget(QWidget *parent = 0);
    ~rxWidget();
  void init();
  void writeSettings();
  void readSettings();
  fftDisplay *fftFrame() {return ui->fftFrame;}
  QVUMeter *syncWidget() {return ui->syncWidget;}
  bool useVIS;
  bool autoSlantAdjust;
  bool autoSave;
  //bool dxMode;
  int squelch;
  int filterIndex;

public slots:
void slotGetParams();
void slotSetParams();

void slotStartRX();
void slotStopRX();
void slotResyncRX();

void slotAdjustChanged(int b);
void slotUseVISChanged(int b);
//void slotDXModeChanged(int b);
void slotSaveImage();


void slotFilterChanged(int);
void slotSquelchChanged(int);


private:
    Ui::rxWidget *ui;
    void initView();
    void initActions();
};

#endif // RXWIDGET_H

