/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_QuantLibJNI = NULL;
    jmethodID director_method_ids[3];
  }
}

SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x011200f0
    #error using an old version of QuantLib, please update
#endif

#ifdef BOOST_MSVC
#ifdef QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN
#define BOOST_LIB_NAME boost_thread
#include <boost/config/auto_link.hpp>
#undef BOOST_LIB_NAME
#define BOOST_LIB_NAME boost_system
#include <boost/config/auto_link.hpp>
#undef BOOST_LIB_NAME
#endif
#endif

#if defined (SWIGJAVA) || defined (SWIGCSHARP) 
  #ifndef QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN
    #ifdef BOOST_MSVC
      #pragma message(\
          "Quantlib has not been compiled with the thread-safe "           \
          "observer pattern being enabled. This can lead to spurious "     \
          "crashes or pure virtual function call within the JVM or .NET "  \
          "ecosystem due to the async garbage collector. Please consider " \
          "enabling QL_ENABLE_THREAD_SAFE_OBSERVER_PATTERN "               \
          "in ql/userconfig.hpp.")
    #else
      #warning \
          Quantlib has not been compiled with the thread-safe           \
          observer pattern being enabled. This can lead to spurious     \
          crashes or pure virtual function call within the JVM or .NET  \
          ecosystem due to the async garbage collector. Please consider \
          passing --enable-thread-safe-observer-pattern when using the  \
          GNU autoconf configure script.
    #endif
  #endif
#endif


// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <typeinfo>
#include <stdexcept>


#include <string>


#include <vector>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// This is necessary to avoid compile failures on 
// GCC 4
// see http://svn.boost.org/trac/boost/ticket/1793

#if defined(NDEBUG)
#define BOOST_DISABLE_ASSERTS 1
#endif

#include <boost/algorithm/string/case_conv.hpp>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;


using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Probability;
using QuantLib::Size;


#ifndef QL_HIGH_RESOLUTION_DATE
    // They are not defined in the library, so we define them here
    namespace QuantLib {
        typedef int Hour;
        typedef int Minute;
        typedef int Second;
        typedef int Millisecond;
        typedef int Microsecond;
    }
#endif

using QuantLib::Day;
using QuantLib::Year;
using QuantLib::Hour;
using QuantLib::Minute;
using QuantLib::Second;
using QuantLib::Millisecond;
using QuantLib::Microsecond;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;
using QuantLib::Hours;
using QuantLib::Minutes;
using QuantLib::Seconds;
using QuantLib::Milliseconds;
using QuantLib::Microseconds;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;
using QuantLib::EveryFourthWeek;
using QuantLib::Biweekly;
using QuantLib::Weekly;
using QuantLib::Daily;
using QuantLib::OtherFrequency;


using QuantLib::Period;
using QuantLib::PeriodParser;

SWIGINTERN Period *new_Period__SWIG_3(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
SWIGINTERN std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
SWIGINTERN std::vector< Period >::const_reference std_vector_Sl_Period_Sg__get(std::vector< Period > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Period_Sg__set(std::vector< Period > *self,int i,std::vector< Period >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Date;
using QuantLib::DateParser;


    // used in Date(string, string) defined below
    void _replace_format(std::string& s, const std::string& old_format,
                         const std::string& new_format) {
        std::string::size_type i = s.find(old_format);
        if (i != std::string::npos)
            s.replace(i, old_format.length(), new_format);
    }

SWIGINTERN Date *new_Date__SWIG_2(Day d,Month m,Year y,Hour hours,Minute minutes,Second seconds,Millisecond millisec=0,Microsecond microsec=0){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return new Date(d, m, y, hours, minutes, seconds,
                            millisec, microsec);
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Hour Date_hours(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->hours();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Minute Date_minutes(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->minutes();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Second Date_seconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->seconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Millisecond Date_milliseconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->milliseconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Microsecond Date_microseconds(Date *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->microseconds();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Time Date_fractionOfDay(Date const *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->fractionOfDay();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Time Date_fractionOfSecond(Date const *self){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return self->fractionOfSecond();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Date Date_localDateTime(){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return Date::localDateTime();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
        }
SWIGINTERN Date Date_universalDateTime(){
        #ifdef QL_HIGH_RESOLUTION_DATE
            return Date::universalDateTime();
        #else
            throw std::runtime_error("QuantLib was not compiled "
                                     "with intraday support");
        #endif
         }
SWIGINTERN Date *new_Date__SWIG_6(std::string const &str,std::string fmt){
            // convert our old format into the corresponding Boost one
            _replace_format(fmt, "YYYY", "%Y");
            _replace_format(fmt, "yyyy", "%Y");
            _replace_format(fmt, "YY", "%y");
            _replace_format(fmt, "yy", "%y");
            _replace_format(fmt, "MM", "%m");
            _replace_format(fmt, "mm", "%m");
            _replace_format(fmt, "DD", "%d");
            _replace_format(fmt, "dd", "%d");
            return new Date(DateParser::parseFormatted(str,fmt));
        }
SWIGINTERN Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
SWIGINTERN std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Date___repr__(Date *self){
            std::ostringstream out;
            if (*self == Date())
                out << "Date()";
            else
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
SWIGINTERN std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
SWIGINTERN Date DateParser_parse(std::string const &str,std::string fmt){
            // convert our old format into the corresponding Boost one
            _replace_format(fmt, "YYYY", "%Y");
            _replace_format(fmt, "yyyy", "%Y");
            _replace_format(fmt, "YY", "%y");
            _replace_format(fmt, "yy", "%y");
            _replace_format(fmt, "MM", "%m");
            _replace_format(fmt, "mm", "%m");
            _replace_format(fmt, "DD", "%d");
            _replace_format(fmt, "dd", "%d");
            return DateParser::parseFormatted(str,fmt);
        }
SWIGINTERN std::vector< Date >::const_reference std_vector_Sl_Date_Sg__get(std::vector< Date > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Date_Sg__set(std::vector< Date > *self,int i,std::vector< Date >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::IMM;


using QuantLib::ASX;

SWIGINTERN std::vector< int >::const_reference std_vector_Sl_int_Sg__get(std::vector< int > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_int_Sg__set(std::vector< int > *self,int i,std::vector< int >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< unsigned int >::const_reference std_vector_Sl_unsigned_SS_int_Sg__get(std::vector< unsigned int > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_unsigned_SS_int_Sg__set(std::vector< unsigned int > *self,int i,std::vector< unsigned int >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< double >::const_reference std_vector_Sl_double_Sg__get(std::vector< double > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_double_Sg__set(std::vector< double > *self,int i,std::vector< double >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< std::string >::const_reference std_vector_Sl_std_string_Sg__get(std::vector< std::string > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_string_Sg__set(std::vector< std::string > *self,int i,std::vector< std::string >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN bool std_vector_Sl_bool_Sg__get(std::vector< bool > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_bool_Sg__set(std::vector< bool > *self,int i,std::vector< bool >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< std::pair< Date,double > >::const_reference std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__get(std::vector< std::pair< Date,double > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__set(std::vector< std::pair< Date,double > > *self,int i,std::vector< std::pair< Date,double > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Exercise;

SWIGINTERN bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr< Exercise > *self){
                return !(*self);
            }
SWIGINTERN Exercise::Type boost_shared_ptr_Sl_Exercise_Sg__exerciseType(boost::shared_ptr< Exercise > *self){ 
		return boost::dynamic_pointer_cast<Exercise>(*self)->type(); 
	}

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
using QuantLib::RebatedExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;
typedef boost::shared_ptr<Exercise> RebatedExercisePtr;

SWIGINTERN EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
SWIGINTERN AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));

        }
SWIGINTERN BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector< Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

using QuantLib::BusinessDayConvention;
using QuantLib::Calendar;
using QuantLib::Following;
using QuantLib::NullCalendar;

SWIGINTERN RebatedExercisePtr *new_RebatedExercisePtr__SWIG_0(boost::shared_ptr< Exercise > const exercise,std::vector< Real > const rebates,Natural rebateSettlementDays=0,Calendar const &rebatePaymentCalendar=NullCalendar(),BusinessDayConvention const rebatePaymentConvention=Following){
            return new RebatedExercisePtr(new RebatedExercise(*exercise, rebates,
                                                              rebateSettlementDays,
                                                              rebatePaymentCalendar,
                                                              rebatePaymentConvention));
        }

using QuantLib::Observer;
using QuantLib::Observable;

SWIGINTERN bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr< Observable > *self){
                return !(*self);
            }

using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::SampledCurve;

SWIGINTERN std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Array_get(Array *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("array index out of range");
        }
SWIGINTERN void Array_set(Array *self,Size i,Real x){
            if (i<self->size())
                (*self)[i] = x;
            else
                throw std::out_of_range("array index out of range");
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    DefaultLexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    DefaultLexicographicalViewColumn;

SWIGINTERN DefaultLexicographicalView *new_DefaultLexicographicalView(Array &a,Size xSize){
            return new DefaultLexicographicalView(a.begin(),a.end(),xSize);
        }
SWIGINTERN std::string DefaultLexicographicalView___str__(DefaultLexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    Array::value_type value = (*self)[i][j];
                    s << value;
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

SWIGINTERN std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Matrix_get(Matrix *self,Size i,Size j){
            return (*self)[i][j];
        }
SWIGINTERN void Matrix_set(Matrix *self,Size i,Size j,Real x){
            (*self)[i][j] = x;
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::CostFunction;
using QuantLib::Disposable;


class UnaryFunctionDelegate {
  public:
    virtual ~UnaryFunctionDelegate() {}
    virtual Real value(Real x) const {
        QL_FAIL("implementation of UnaryFunctionDelegate.value is missing");
    };
};

class UnaryFunction : public std::unary_function<Real, Real> {
  public:
    UnaryFunction(UnaryFunctionDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~UnaryFunction() { }

    Real operator()(Real x) const {
        return delegate_->value(x);
    }

  private:
    UnaryFunctionDelegate* delegate_;
};


class CostFunctionDelegate {
  public:
    virtual ~CostFunctionDelegate() {}
    virtual Real value(const Array& x) const {
      QL_FAIL("implementation of CostFunctionDelegate.value is missing");
    }

    virtual Array values(const Array& x) const {
      QL_FAIL("implementation of CostFunctionDelegate.values is missing");
    }
};

class JavaCostFunction : public CostFunction {
  public:
    JavaCostFunction(CostFunctionDelegate* delegate)
    : delegate_(delegate) { }

    virtual ~JavaCostFunction(){ }

    virtual Real value(const Array& x ) const{
      return delegate_->value(x);
    }

    virtual Disposable<Array> values(const Array& x) const {
      Array retVal = delegate_->values(x);
      return retVal;
    }

  private:
    CostFunctionDelegate* delegate_;
};


using QuantLib::Quote;

SWIGINTERN bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr< Quote > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr< Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_Quote_Sg__asObservable(Handle< Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

SWIGINTERN SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
SWIGINTERN void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
SWIGINTERN std::vector< boost::shared_ptr< Quote > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__get(std::vector< boost::shared_ptr< Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(std::vector< boost::shared_ptr< Quote > > *self,int i,std::vector< boost::shared_ptr< Quote > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< std::vector< boost::shared_ptr< Quote > > >::const_reference std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__get(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__set(std::vector< std::vector< boost::shared_ptr< Quote > > > *self,int i,std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< Handle< Quote > >::const_reference std_vector_Sl_Handle_Sl_Quote_Sg__Sg__get(std::vector< Handle< Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(std::vector< Handle< Quote > > *self,int i,std::vector< Handle< Quote > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< std::vector< Handle< Quote > > >::const_reference std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__get(std::vector< std::vector< Handle< Quote > > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__set(std::vector< std::vector< Handle< Quote > > > *self,int i,std::vector< std::vector< Handle< Quote > > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< RelinkableHandle< Quote > >::const_reference std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__get(std::vector< RelinkableHandle< Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__set(std::vector< RelinkableHandle< Quote > > *self,int i,std::vector< RelinkableHandle< Quote > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< std::vector< RelinkableHandle< Quote > > >::const_reference std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__get(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__set(std::vector< std::vector< RelinkableHandle< Quote > > > *self,int i,std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Unadjusted;
using QuantLib::HalfMonthModifiedFollowing;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

SWIGINTERN std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
SWIGINTERN bool Calendar___eq__(Calendar *self,Calendar const &other){
            return (*self) == other;
        }
SWIGINTERN bool Calendar___ne__(Calendar *self,Calendar const &other){
            return (*self) != other;
        }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

SWIGINTERN std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
SWIGINTERN bool DayCounter___eq__(DayCounter *self,DayCounter const &other){
            return (*self) == other;
        }
SWIGINTERN bool DayCounter___ne__(DayCounter *self,DayCounter const &other){
            return (*self) != other;
        }

    /* avoid deprecation warnings */
    DayCounter Actual365NoLeap() {
        return QuantLib::Actual365Fixed(QuantLib::Actual365Fixed::NoLeap);
    }


using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;
using QuantLib::CompoundedThenSimple;


using QuantLib::InterestRate;

SWIGINTERN std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::vector< InterestRate >::const_reference std_vector_Sl_InterestRate_Sg__get(std::vector< InterestRate > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_InterestRate_Sg__set(std::vector< InterestRate > *self,int i,std::vector< InterestRate >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;
using QuantLib::Money;

SWIGINTERN std::string Currency___str__(Currency *self){
            return self->name();
        }
SWIGINTERN bool Currency___eq__(Currency *self,Currency const &other){
            return (*self) == other;
        }
SWIGINTERN bool Currency___ne__(Currency *self,Currency const &other){
            return (*self) != other;
        }

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::CubicNaturalSpline> SafeCubicNaturalSpline;

SWIGINTERN Real SafeCubicNaturalSpline_derivative__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeCubicNaturalSpline_secondDerivative__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeCubicNaturalSpline_primitive__SWIG_0(SafeCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::LogCubicNaturalSpline> SafeLogCubicNaturalSpline;

SWIGINTERN Real SafeLogCubicNaturalSpline_derivative__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogCubicNaturalSpline_secondDerivative__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogCubicNaturalSpline_primitive__SWIG_0(SafeLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicCubicNaturalSpline> SafeMonotonicCubicNaturalSpline;

SWIGINTERN Real SafeMonotonicCubicNaturalSpline_derivative__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicCubicNaturalSpline_secondDerivative__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicCubicNaturalSpline_primitive__SWIG_0(SafeMonotonicCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicLogCubicNaturalSpline> SafeMonotonicLogCubicNaturalSpline;

SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_derivative__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_secondDerivative__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogCubicNaturalSpline_primitive__SWIG_0(SafeMonotonicLogCubicNaturalSpline *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::KrugerCubic> SafeKrugerCubic;

SWIGINTERN Real SafeKrugerCubic_derivative__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerCubic_secondDerivative__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerCubic_primitive__SWIG_0(SafeKrugerCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::KrugerLogCubic> SafeKrugerLogCubic;

SWIGINTERN Real SafeKrugerLogCubic_derivative__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerLogCubic_secondDerivative__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeKrugerLogCubic_primitive__SWIG_0(SafeKrugerLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::FritschButlandCubic> SafeFritschButlandCubic;

SWIGINTERN Real SafeFritschButlandCubic_derivative__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandCubic_secondDerivative__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandCubic_primitive__SWIG_0(SafeFritschButlandCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::FritschButlandLogCubic> SafeFritschButlandLogCubic;

SWIGINTERN Real SafeFritschButlandLogCubic_derivative__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandLogCubic_secondDerivative__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeFritschButlandLogCubic_primitive__SWIG_0(SafeFritschButlandLogCubic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::Parabolic> SafeParabolic;

SWIGINTERN Real SafeParabolic_derivative__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeParabolic_secondDerivative__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeParabolic_primitive__SWIG_0(SafeParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::LogParabolic> SafeLogParabolic;

SWIGINTERN Real SafeLogParabolic_derivative__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogParabolic_secondDerivative__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeLogParabolic_primitive__SWIG_0(SafeLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicParabolic> SafeMonotonicParabolic;

SWIGINTERN Real SafeMonotonicParabolic_derivative__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicParabolic_secondDerivative__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicParabolic_primitive__SWIG_0(SafeMonotonicParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::MonotonicLogParabolic> SafeMonotonicLogParabolic;

SWIGINTERN Real SafeMonotonicLogParabolic_derivative__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogParabolic_secondDerivative__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
SWIGINTERN Real SafeMonotonicLogParabolic_primitive__SWIG_0(SafeMonotonicLogParabolic *self,Real x,bool extrapolate=false){
        return self->f_.primitive(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::BackwardFlat;
using QuantLib::ForwardFlat;
using QuantLib::Linear;
using QuantLib::LogLinear;
using QuantLib::Cubic;

class MonotonicCubic : public Cubic {
  public:
    MonotonicCubic()
    : Cubic(QuantLib::CubicInterpolation::Spline, true,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0,
            QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};

class DefaultLogCubic : public QuantLib::LogCubic {
  public:
    DefaultLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Kruger) {}
};

class MonotonicLogCubic : public QuantLib::LogCubic {
  public:
    MonotonicLogCubic()
    : QuantLib::LogCubic(QuantLib::CubicInterpolation::Spline, true,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0,
                         QuantLib::CubicInterpolation::SecondDerivative, 0.0) {}
};


using QuantLib::YieldTermStructure;

SWIGINTERN bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr< YieldTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr< YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle< YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

SWIGINTERN ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle< YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

SWIGINTERN ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr__SWIG_0(Handle< YieldTermStructure > const &curveHandle,Handle< Quote > const &spreadHandle,Compounding comp=QuantLib::Continuous,Frequency freq=QuantLib::NoFrequency,DayCounter const &dc=DayCounter()){
            return new ZeroSpreadedTermStructurePtr(
                new ZeroSpreadedTermStructure(curveHandle,spreadHandle, comp, freq, dc));
        }
SWIGINTERN ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle< YieldTermStructure > const &curveHandle,Handle< Quote > const &spreadHandle){
            return new ForwardSpreadedTermStructurePtr(
                new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

using QuantLib::InterpolatedPiecewiseZeroSpreadedTermStructure;


typedef boost::shared_ptr<YieldTermStructure> SpreadedLinearZeroInterpolatedTermStructurePtr;

SWIGINTERN SpreadedLinearZeroInterpolatedTermStructurePtr *new_SpreadedLinearZeroInterpolatedTermStructurePtr__SWIG_0(Handle< YieldTermStructure > const &curveHandle,std::vector< Handle< Quote > > const &spreadHandles,std::vector< Date > const &dates,Compounding comp=QuantLib::Continuous,Frequency freq=QuantLib::NoFrequency,DayCounter const &dc=DayCounter(),Linear const &factory=Linear()){
            return new SpreadedLinearZeroInterpolatedTermStructurePtr(
                new InterpolatedPiecewiseZeroSpreadedTermStructure<Linear>(
                          curveHandle,spreadHandles,dates,comp,freq,dc,factory));
        }

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle< Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle< Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

using QuantLib::TimeSeries;
using QuantLib::IntervalPrice;

SWIGINTERN TimeSeries< Real > *new_TimeSeries_Sl_Real_Sg___SWIG_1(std::vector< Date > const &d,std::vector< double > const &v){
            return new TimeSeries<double>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN TimeSeries< IntervalPrice > *new_TimeSeries_Sl_IntervalPrice_Sg___SWIG_1(std::vector< Date > const &d,std::vector< IntervalPrice > const &v){
            return new TimeSeries<IntervalPrice>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN std::vector< IntervalPrice >::const_reference std_vector_Sl_IntervalPrice_Sg__get(std::vector< IntervalPrice > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__set(std::vector< IntervalPrice > *self,int i,std::vector< IntervalPrice >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::IndexManager;


using QuantLib::Index;

SWIGINTERN bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr< Index > *self){
                return !(*self);
            }
SWIGINTERN void boost_shared_ptr_Sl_Index_Sg__addFixings(boost::shared_ptr< Index > *self,std::vector< Date > const &fixingDates,std::vector< Rate > const &fixings){
        (*self)->addFixings(fixingDates.begin(),fixingDates.end(),
                            fixings.begin());
    }
SWIGINTERN std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr< Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_Index_Sg__asObservable(boost::shared_ptr< Index > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::InterestRateIndex;
typedef boost::shared_ptr<Index> InterestRateIndexPtr;

SWIGINTERN std::string InterestRateIndexPtr_familyName(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->familyName();
        }
SWIGINTERN Period InterestRateIndexPtr_tenor(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->tenor();
        }
SWIGINTERN Natural InterestRateIndexPtr_fixingDays(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->fixingDays();
        }
SWIGINTERN Date InterestRateIndexPtr_fixingDate(InterestRateIndexPtr *self,Date const &valueDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->fixingDate(valueDate);
        }
SWIGINTERN Currency InterestRateIndexPtr_currency(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->currency();
        }
SWIGINTERN DayCounter InterestRateIndexPtr_dayCounter(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->dayCounter();
        }
SWIGINTERN Date InterestRateIndexPtr_maturityDate(InterestRateIndexPtr *self,Date const &valueDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->maturityDate(valueDate);
        }
SWIGINTERN Date InterestRateIndexPtr_valueDate(InterestRateIndexPtr *self,Date const &fixingDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->valueDate(fixingDate);
        }

using QuantLib::IborIndex;
using QuantLib::OvernightIndex;
typedef boost::shared_ptr<Index> IborIndexPtr;
typedef boost::shared_ptr<Index> OvernightIndexPtr;

SWIGINTERN IborIndexPtr *new_IborIndexPtr__SWIG_0(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
            return new IborIndexPtr(new IborIndex(familyName, tenor,
                                                  settlementDays,
                                                  currency, calendar,
                                                  convention,
                                                  endOfMonth,
                                                  dayCounter, h));
        }
SWIGINTERN BusinessDayConvention IborIndexPtr_businessDayConvention(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)
                ->businessDayConvention();
        }
SWIGINTERN bool IborIndexPtr_endOfMonth(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)->endOfMonth();
        }
SWIGINTERN Handle< YieldTermStructure > IborIndexPtr_forwardingTermStructure(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)
                ->forwardingTermStructure();
        }
SWIGINTERN IborIndexPtr IborIndexPtr_clone(IborIndexPtr *self,Handle< YieldTermStructure > const &h){
            return boost::dynamic_pointer_cast<IborIndex>(*self)
                ->clone(h);
    }

    IborIndexPtr as_iborindex(const InterestRateIndexPtr& index) {
        return boost::dynamic_pointer_cast<IborIndex>(index);
    }

SWIGINTERN OvernightIndexPtr *new_OvernightIndexPtr__SWIG_0(std::string const &familyName,Integer settlementDays,Currency const &currency,Calendar const &calendar,DayCounter const &dayCounter,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
            return new OvernightIndexPtr(
                new OvernightIndex(familyName, settlementDays,
                                   currency, calendar,
                                   dayCounter, h));
        }

using QuantLib::Libor;
typedef boost::shared_ptr<Index> LiborPtr;

SWIGINTERN LiborPtr *new_LiborPtr__SWIG_0(std::string const &familyName,Period const &tenor,Natural settlementDays,Currency const &currency,Calendar const &financialCenterCalendar,DayCounter const &dayCounter,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
            return new LiborPtr(
                new Libor(familyName,
                          tenor,
                          settlementDays,
                          currency,
                          financialCenterCalendar,
                          dayCounter,
                          h));
        }

using QuantLib::SwapIndex;
typedef boost::shared_ptr<Index> SwapIndexPtr;

SWIGINTERN SwapIndexPtr *new_SwapIndexPtr__SWIG_0(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency const &currency,Calendar const &calendar,Period const &fixedLegTenor,BusinessDayConvention fixedLegConvention,DayCounter const &fixedLegDayCounter,IborIndexPtr const &iborIndex){
            boost::shared_ptr<IborIndex> xibor =
                boost::dynamic_pointer_cast<IborIndex>(iborIndex);
            return new SwapIndexPtr(new SwapIndex(familyName,
                                                  tenor, settlementDays,
                                                  currency, calendar,
                                                  fixedLegTenor,
                                                  fixedLegConvention,
                                                  fixedLegDayCounter,
                                                  xibor));
        }
SWIGINTERN SwapIndexPtr *new_SwapIndexPtr__SWIG_1(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency const &currency,Calendar const &calendar,Period const &fixedLegTenor,BusinessDayConvention fixedLegConvention,DayCounter const &fixedLegDayCounter,IborIndexPtr const &iborIndex,Handle< YieldTermStructure > const &discountCurve){
            boost::shared_ptr<IborIndex> xibor =
                boost::dynamic_pointer_cast<IborIndex>(iborIndex);
            return new SwapIndexPtr(new SwapIndex(familyName,
                                                  tenor, settlementDays,
                                                  currency, calendar,
                                                  fixedLegTenor,
                                                  fixedLegConvention,
                                                  fixedLegDayCounter,
                                                  xibor, discountCurve));
        }
SWIGINTERN Period SwapIndexPtr_fixedLegTenor(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->fixedLegTenor();
        }
SWIGINTERN BusinessDayConvention SwapIndexPtr_fixedLegConvention(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                 ->fixedLegConvention();
        }
SWIGINTERN IborIndexPtr SwapIndexPtr_iborIndex(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->iborIndex();
        }
SWIGINTERN Handle< YieldTermStructure > SwapIndexPtr_forwardingTermStructure(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->forwardingTermStructure();
        }

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

SWIGINTERN AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new AUDLiborPtr(new AUDLibor(tenor,h));
      }

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

SWIGINTERN CADLiborPtr *new_CADLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new CADLiborPtr(new CADLibor(tenor,h));
      }

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

SWIGINTERN CdorPtr *new_CdorPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new CdorPtr(new Cdor(tenor,h));
      }

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

SWIGINTERN CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new CHFLiborPtr(new CHFLibor(tenor,h));
      }

using QuantLib::DKKLibor;
typedef boost::shared_ptr<Index> DKKLiborPtr;

SWIGINTERN DKKLiborPtr *new_DKKLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new DKKLiborPtr(new DKKLibor(tenor,h));
      }

using QuantLib::Bbsw;
typedef boost::shared_ptr<Index> BbswPtr;

SWIGINTERN BbswPtr *new_BbswPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new BbswPtr(new Bbsw(tenor,h));
      }

using QuantLib::Bbsw1M;
typedef boost::shared_ptr<Index> Bbsw1MPtr;

SWIGINTERN Bbsw1MPtr *new_Bbsw1MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bbsw1MPtr(new Bbsw1M(h));
      }

using QuantLib::Bbsw2M;
typedef boost::shared_ptr<Index> Bbsw2MPtr;

SWIGINTERN Bbsw2MPtr *new_Bbsw2MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bbsw2MPtr(new Bbsw2M(h));
      }

using QuantLib::Bbsw3M;
typedef boost::shared_ptr<Index> Bbsw3MPtr;

SWIGINTERN Bbsw3MPtr *new_Bbsw3MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bbsw3MPtr(new Bbsw3M(h));
      }

using QuantLib::Bbsw4M;
typedef boost::shared_ptr<Index> Bbsw4MPtr;

SWIGINTERN Bbsw4MPtr *new_Bbsw4MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bbsw4MPtr(new Bbsw4M(h));
      }

using QuantLib::Bbsw5M;
typedef boost::shared_ptr<Index> Bbsw5MPtr;

SWIGINTERN Bbsw5MPtr *new_Bbsw5MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bbsw5MPtr(new Bbsw5M(h));
      }

using QuantLib::Bbsw6M;
typedef boost::shared_ptr<Index> Bbsw6MPtr;

SWIGINTERN Bbsw6MPtr *new_Bbsw6MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bbsw6MPtr(new Bbsw6M(h));
      }

using QuantLib::Bkbm;
typedef boost::shared_ptr<Index> BkbmPtr;

SWIGINTERN BkbmPtr *new_BkbmPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new BkbmPtr(new Bkbm(tenor,h));
      }

using QuantLib::Bkbm1M;
typedef boost::shared_ptr<Index> Bkbm1MPtr;

SWIGINTERN Bkbm1MPtr *new_Bkbm1MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bkbm1MPtr(new Bkbm1M(h));
      }

using QuantLib::Bkbm2M;
typedef boost::shared_ptr<Index> Bkbm2MPtr;

SWIGINTERN Bkbm2MPtr *new_Bkbm2MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bkbm2MPtr(new Bkbm2M(h));
      }

using QuantLib::Bkbm3M;
typedef boost::shared_ptr<Index> Bkbm3MPtr;

SWIGINTERN Bkbm3MPtr *new_Bkbm3MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bkbm3MPtr(new Bkbm3M(h));
      }

using QuantLib::Bkbm4M;
typedef boost::shared_ptr<Index> Bkbm4MPtr;

SWIGINTERN Bkbm4MPtr *new_Bkbm4MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bkbm4MPtr(new Bkbm4M(h));
      }

using QuantLib::Bkbm5M;
typedef boost::shared_ptr<Index> Bkbm5MPtr;

SWIGINTERN Bkbm5MPtr *new_Bkbm5MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bkbm5MPtr(new Bkbm5M(h));
      }

using QuantLib::Bkbm6M;
typedef boost::shared_ptr<Index> Bkbm6MPtr;

SWIGINTERN Bkbm6MPtr *new_Bkbm6MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Bkbm6MPtr(new Bkbm6M(h));
      }

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

SWIGINTERN EuriborPtr *new_EuriborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EuriborPtr(new Euribor(tenor,h));
      }

using QuantLib::EuriborSW;
typedef boost::shared_ptr<Index> EuriborSWPtr;

SWIGINTERN EuriborSWPtr *new_EuriborSWPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EuriborSWPtr(new EuriborSW(h));
      }

using QuantLib::Euribor2W;
typedef boost::shared_ptr<Index> Euribor2WPtr;

SWIGINTERN Euribor2WPtr *new_Euribor2WPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor2WPtr(new Euribor2W(h));
      }

using QuantLib::Euribor3W;
typedef boost::shared_ptr<Index> Euribor3WPtr;

SWIGINTERN Euribor3WPtr *new_Euribor3WPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor3WPtr(new Euribor3W(h));
      }

using QuantLib::Euribor1M;
typedef boost::shared_ptr<Index> Euribor1MPtr;

SWIGINTERN Euribor1MPtr *new_Euribor1MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor1MPtr(new Euribor1M(h));
      }

using QuantLib::Euribor2M;
typedef boost::shared_ptr<Index> Euribor2MPtr;

SWIGINTERN Euribor2MPtr *new_Euribor2MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor2MPtr(new Euribor2M(h));
      }

using QuantLib::Euribor3M;
typedef boost::shared_ptr<Index> Euribor3MPtr;

SWIGINTERN Euribor3MPtr *new_Euribor3MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor3MPtr(new Euribor3M(h));
      }

using QuantLib::Euribor4M;
typedef boost::shared_ptr<Index> Euribor4MPtr;

SWIGINTERN Euribor4MPtr *new_Euribor4MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor4MPtr(new Euribor4M(h));
      }

using QuantLib::Euribor5M;
typedef boost::shared_ptr<Index> Euribor5MPtr;

SWIGINTERN Euribor5MPtr *new_Euribor5MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor5MPtr(new Euribor5M(h));
      }

using QuantLib::Euribor6M;
typedef boost::shared_ptr<Index> Euribor6MPtr;

SWIGINTERN Euribor6MPtr *new_Euribor6MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor6MPtr(new Euribor6M(h));
      }

using QuantLib::Euribor7M;
typedef boost::shared_ptr<Index> Euribor7MPtr;

SWIGINTERN Euribor7MPtr *new_Euribor7MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor7MPtr(new Euribor7M(h));
      }

using QuantLib::Euribor8M;
typedef boost::shared_ptr<Index> Euribor8MPtr;

SWIGINTERN Euribor8MPtr *new_Euribor8MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor8MPtr(new Euribor8M(h));
      }

using QuantLib::Euribor9M;
typedef boost::shared_ptr<Index> Euribor9MPtr;

SWIGINTERN Euribor9MPtr *new_Euribor9MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor9MPtr(new Euribor9M(h));
      }

using QuantLib::Euribor10M;
typedef boost::shared_ptr<Index> Euribor10MPtr;

SWIGINTERN Euribor10MPtr *new_Euribor10MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor10MPtr(new Euribor10M(h));
      }

using QuantLib::Euribor11M;
typedef boost::shared_ptr<Index> Euribor11MPtr;

SWIGINTERN Euribor11MPtr *new_Euribor11MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor11MPtr(new Euribor11M(h));
      }

using QuantLib::Euribor1Y;
typedef boost::shared_ptr<Index> Euribor1YPtr;

SWIGINTERN Euribor1YPtr *new_Euribor1YPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor1YPtr(new Euribor1Y(h));
      }

using QuantLib::Euribor365;
typedef boost::shared_ptr<Index> Euribor365Ptr;

SWIGINTERN Euribor365Ptr *new_Euribor365Ptr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365Ptr(new Euribor365(tenor,h));
      }

using QuantLib::Euribor365_SW;
typedef boost::shared_ptr<Index> Euribor365_SWPtr;

SWIGINTERN Euribor365_SWPtr *new_Euribor365_SWPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_SWPtr(new Euribor365_SW(h));
      }

using QuantLib::Euribor365_2W;
typedef boost::shared_ptr<Index> Euribor365_2WPtr;

SWIGINTERN Euribor365_2WPtr *new_Euribor365_2WPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_2WPtr(new Euribor365_2W(h));
      }

using QuantLib::Euribor365_3W;
typedef boost::shared_ptr<Index> Euribor365_3WPtr;

SWIGINTERN Euribor365_3WPtr *new_Euribor365_3WPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_3WPtr(new Euribor365_3W(h));
      }

using QuantLib::Euribor365_1M;
typedef boost::shared_ptr<Index> Euribor365_1MPtr;

SWIGINTERN Euribor365_1MPtr *new_Euribor365_1MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_1MPtr(new Euribor365_1M(h));
      }

using QuantLib::Euribor365_2M;
typedef boost::shared_ptr<Index> Euribor365_2MPtr;

SWIGINTERN Euribor365_2MPtr *new_Euribor365_2MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_2MPtr(new Euribor365_2M(h));
      }

using QuantLib::Euribor365_3M;
typedef boost::shared_ptr<Index> Euribor365_3MPtr;

SWIGINTERN Euribor365_3MPtr *new_Euribor365_3MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_3MPtr(new Euribor365_3M(h));
      }

using QuantLib::Euribor365_4M;
typedef boost::shared_ptr<Index> Euribor365_4MPtr;

SWIGINTERN Euribor365_4MPtr *new_Euribor365_4MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_4MPtr(new Euribor365_4M(h));
      }

using QuantLib::Euribor365_5M;
typedef boost::shared_ptr<Index> Euribor365_5MPtr;

SWIGINTERN Euribor365_5MPtr *new_Euribor365_5MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_5MPtr(new Euribor365_5M(h));
      }

using QuantLib::Euribor365_6M;
typedef boost::shared_ptr<Index> Euribor365_6MPtr;

SWIGINTERN Euribor365_6MPtr *new_Euribor365_6MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_6MPtr(new Euribor365_6M(h));
      }

using QuantLib::Euribor365_7M;
typedef boost::shared_ptr<Index> Euribor365_7MPtr;

SWIGINTERN Euribor365_7MPtr *new_Euribor365_7MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_7MPtr(new Euribor365_7M(h));
      }

using QuantLib::Euribor365_8M;
typedef boost::shared_ptr<Index> Euribor365_8MPtr;

SWIGINTERN Euribor365_8MPtr *new_Euribor365_8MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_8MPtr(new Euribor365_8M(h));
      }

using QuantLib::Euribor365_9M;
typedef boost::shared_ptr<Index> Euribor365_9MPtr;

SWIGINTERN Euribor365_9MPtr *new_Euribor365_9MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_9MPtr(new Euribor365_9M(h));
      }

using QuantLib::Euribor365_10M;
typedef boost::shared_ptr<Index> Euribor365_10MPtr;

SWIGINTERN Euribor365_10MPtr *new_Euribor365_10MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_10MPtr(new Euribor365_10M(h));
      }

using QuantLib::Euribor365_11M;
typedef boost::shared_ptr<Index> Euribor365_11MPtr;

SWIGINTERN Euribor365_11MPtr *new_Euribor365_11MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_11MPtr(new Euribor365_11M(h));
      }

using QuantLib::Euribor365_1Y;
typedef boost::shared_ptr<Index> Euribor365_1YPtr;

SWIGINTERN Euribor365_1YPtr *new_Euribor365_1YPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new Euribor365_1YPtr(new Euribor365_1Y(h));
      }

using QuantLib::EURLibor;
typedef boost::shared_ptr<Index> EURLiborPtr;

SWIGINTERN EURLiborPtr *new_EURLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLiborPtr(new EURLibor(tenor,h));
      }

using QuantLib::EURLiborSW;
typedef boost::shared_ptr<Index> EURLiborSWPtr;

SWIGINTERN EURLiborSWPtr *new_EURLiborSWPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLiborSWPtr(new EURLiborSW(h));
      }

using QuantLib::EURLibor2W;
typedef boost::shared_ptr<Index> EURLibor2WPtr;

SWIGINTERN EURLibor2WPtr *new_EURLibor2WPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor2WPtr(new EURLibor2W(h));
      }

using QuantLib::EURLibor1M;
typedef boost::shared_ptr<Index> EURLibor1MPtr;

SWIGINTERN EURLibor1MPtr *new_EURLibor1MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor1MPtr(new EURLibor1M(h));
      }

using QuantLib::EURLibor2M;
typedef boost::shared_ptr<Index> EURLibor2MPtr;

SWIGINTERN EURLibor2MPtr *new_EURLibor2MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor2MPtr(new EURLibor2M(h));
      }

using QuantLib::EURLibor3M;
typedef boost::shared_ptr<Index> EURLibor3MPtr;

SWIGINTERN EURLibor3MPtr *new_EURLibor3MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor3MPtr(new EURLibor3M(h));
      }

using QuantLib::EURLibor4M;
typedef boost::shared_ptr<Index> EURLibor4MPtr;

SWIGINTERN EURLibor4MPtr *new_EURLibor4MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor4MPtr(new EURLibor4M(h));
      }

using QuantLib::EURLibor5M;
typedef boost::shared_ptr<Index> EURLibor5MPtr;

SWIGINTERN EURLibor5MPtr *new_EURLibor5MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor5MPtr(new EURLibor5M(h));
      }

using QuantLib::EURLibor6M;
typedef boost::shared_ptr<Index> EURLibor6MPtr;

SWIGINTERN EURLibor6MPtr *new_EURLibor6MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor6MPtr(new EURLibor6M(h));
      }

using QuantLib::EURLibor7M;
typedef boost::shared_ptr<Index> EURLibor7MPtr;

SWIGINTERN EURLibor7MPtr *new_EURLibor7MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor7MPtr(new EURLibor7M(h));
      }

using QuantLib::EURLibor8M;
typedef boost::shared_ptr<Index> EURLibor8MPtr;

SWIGINTERN EURLibor8MPtr *new_EURLibor8MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor8MPtr(new EURLibor8M(h));
      }

using QuantLib::EURLibor9M;
typedef boost::shared_ptr<Index> EURLibor9MPtr;

SWIGINTERN EURLibor9MPtr *new_EURLibor9MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor9MPtr(new EURLibor9M(h));
      }

using QuantLib::EURLibor10M;
typedef boost::shared_ptr<Index> EURLibor10MPtr;

SWIGINTERN EURLibor10MPtr *new_EURLibor10MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor10MPtr(new EURLibor10M(h));
      }

using QuantLib::EURLibor11M;
typedef boost::shared_ptr<Index> EURLibor11MPtr;

SWIGINTERN EURLibor11MPtr *new_EURLibor11MPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor11MPtr(new EURLibor11M(h));
      }

using QuantLib::EURLibor1Y;
typedef boost::shared_ptr<Index> EURLibor1YPtr;

SWIGINTERN EURLibor1YPtr *new_EURLibor1YPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EURLibor1YPtr(new EURLibor1Y(h));
      }

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

SWIGINTERN GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new GBPLiborPtr(new GBPLibor(tenor,h));
      }

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

SWIGINTERN JibarPtr *new_JibarPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new JibarPtr(new Jibar(tenor,h));
      }

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

SWIGINTERN JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new JPYLiborPtr(new JPYLibor(tenor,h));
      }

using QuantLib::NZDLibor;
typedef boost::shared_ptr<Index> NZDLiborPtr;

SWIGINTERN NZDLiborPtr *new_NZDLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new NZDLiborPtr(new NZDLibor(tenor,h));
      }

using QuantLib::SEKLibor;
typedef boost::shared_ptr<Index> SEKLiborPtr;

SWIGINTERN SEKLiborPtr *new_SEKLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new SEKLiborPtr(new SEKLibor(tenor,h));
      }

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

SWIGINTERN TiborPtr *new_TiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new TiborPtr(new Tibor(tenor,h));
      }

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

SWIGINTERN TRLiborPtr *new_TRLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new TRLiborPtr(new TRLibor(tenor,h));
      }

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

SWIGINTERN USDLiborPtr *new_USDLiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new USDLiborPtr(new USDLibor(tenor,h));
      }

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

SWIGINTERN ZiborPtr *new_ZiborPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new ZiborPtr(new Zibor(tenor,h));
      }

using QuantLib::Aonia;
typedef boost::shared_ptr<Index> AoniaPtr;

SWIGINTERN AoniaPtr *new_AoniaPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new AoniaPtr(new Aonia(h));
      }

using QuantLib::Eonia;
typedef boost::shared_ptr<Index> EoniaPtr;

SWIGINTERN EoniaPtr *new_EoniaPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EoniaPtr(new Eonia(h));
      }

using QuantLib::Sonia;
typedef boost::shared_ptr<Index> SoniaPtr;

SWIGINTERN SoniaPtr *new_SoniaPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new SoniaPtr(new Sonia(h));
      }

using QuantLib::FedFunds;
typedef boost::shared_ptr<Index> FedFundsPtr;

SWIGINTERN FedFundsPtr *new_FedFundsPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new FedFundsPtr(new FedFunds(h));
      }

using QuantLib::Nzocr;
typedef boost::shared_ptr<Index> NzocrPtr;

SWIGINTERN NzocrPtr *new_NzocrPtr__SWIG_0(Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new NzocrPtr(new Nzocr(h));
      }

using QuantLib::EuriborSwapIsdaFixA;
typedef boost::shared_ptr<Index> EuriborSwapIsdaFixAPtr;

SWIGINTERN EuriborSwapIsdaFixAPtr *new_EuriborSwapIsdaFixAPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EuriborSwapIsdaFixAPtr(new EuriborSwapIsdaFixA(tenor,h));
      }
SWIGINTERN EuriborSwapIsdaFixAPtr *new_EuriborSwapIsdaFixAPtr__SWIG_2(Period const &tenor,Handle< YieldTermStructure > const &h1,Handle< YieldTermStructure > const &h2){
          return new EuriborSwapIsdaFixAPtr(new EuriborSwapIsdaFixA(tenor,h1,h2));
      }

using QuantLib::EuriborSwapIsdaFixB;
typedef boost::shared_ptr<Index> EuriborSwapIsdaFixBPtr;

SWIGINTERN EuriborSwapIsdaFixBPtr *new_EuriborSwapIsdaFixBPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EuriborSwapIsdaFixBPtr(new EuriborSwapIsdaFixB(tenor,h));
      }
SWIGINTERN EuriborSwapIsdaFixBPtr *new_EuriborSwapIsdaFixBPtr__SWIG_2(Period const &tenor,Handle< YieldTermStructure > const &h1,Handle< YieldTermStructure > const &h2){
          return new EuriborSwapIsdaFixBPtr(new EuriborSwapIsdaFixB(tenor,h1,h2));
      }

using QuantLib::EuriborSwapIfrFix;
typedef boost::shared_ptr<Index> EuriborSwapIfrFixPtr;

SWIGINTERN EuriborSwapIfrFixPtr *new_EuriborSwapIfrFixPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EuriborSwapIfrFixPtr(new EuriborSwapIfrFix(tenor,h));
      }
SWIGINTERN EuriborSwapIfrFixPtr *new_EuriborSwapIfrFixPtr__SWIG_2(Period const &tenor,Handle< YieldTermStructure > const &h1,Handle< YieldTermStructure > const &h2){
          return new EuriborSwapIfrFixPtr(new EuriborSwapIfrFix(tenor,h1,h2));
      }

using QuantLib::EurLiborSwapIsdaFixA;
typedef boost::shared_ptr<Index> EurLiborSwapIsdaFixAPtr;

SWIGINTERN EurLiborSwapIsdaFixAPtr *new_EurLiborSwapIsdaFixAPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EurLiborSwapIsdaFixAPtr(new EurLiborSwapIsdaFixA(tenor,h));
      }
SWIGINTERN EurLiborSwapIsdaFixAPtr *new_EurLiborSwapIsdaFixAPtr__SWIG_2(Period const &tenor,Handle< YieldTermStructure > const &h1,Handle< YieldTermStructure > const &h2){
          return new EurLiborSwapIsdaFixAPtr(new EurLiborSwapIsdaFixA(tenor,h1,h2));
      }

using QuantLib::EurLiborSwapIsdaFixB;
typedef boost::shared_ptr<Index> EurLiborSwapIsdaFixBPtr;

SWIGINTERN EurLiborSwapIsdaFixBPtr *new_EurLiborSwapIsdaFixBPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EurLiborSwapIsdaFixBPtr(new EurLiborSwapIsdaFixB(tenor,h));
      }
SWIGINTERN EurLiborSwapIsdaFixBPtr *new_EurLiborSwapIsdaFixBPtr__SWIG_2(Period const &tenor,Handle< YieldTermStructure > const &h1,Handle< YieldTermStructure > const &h2){
          return new EurLiborSwapIsdaFixBPtr(new EurLiborSwapIsdaFixB(tenor,h1,h2));
      }

using QuantLib::EurLiborSwapIfrFix;
typedef boost::shared_ptr<Index> EurLiborSwapIfrFixPtr;

SWIGINTERN EurLiborSwapIfrFixPtr *new_EurLiborSwapIfrFixPtr__SWIG_0(Period const &tenor,Handle< YieldTermStructure > const &h=Handle< YieldTermStructure >()){
          return new EurLiborSwapIfrFixPtr(new EurLiborSwapIfrFix(tenor,h));
      }
SWIGINTERN EurLiborSwapIfrFixPtr *new_EurLiborSwapIfrFixPtr__SWIG_2(Period const &tenor,Handle< YieldTermStructure > const &h1,Handle< YieldTermStructure > const &h2){
          return new EurLiborSwapIfrFixPtr(new EurLiborSwapIfrFix(tenor,h1,h2));
      }

using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;

SWIGINTERN Real Brent_solve__SWIG_0(Brent *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Brent_solve__SWIG_1(Brent *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Bisection_solve__SWIG_0(Bisection *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Bisection_solve__SWIG_1(Bisection *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real FalsePosition_solve__SWIG_0(FalsePosition *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real FalsePosition_solve__SWIG_1(FalsePosition *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Ridder_solve__SWIG_0(Ridder *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Ridder_solve__SWIG_1(Ridder *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
SWIGINTERN Real Secant_solve__SWIG_0(Secant *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
SWIGINTERN Real Secant_solve__SWIG_1(Secant *self,UnaryFunctionDelegate *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;
using QuantLib::CompositeConstraint;
using QuantLib::NonhomogeneousBoundaryConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;
using QuantLib::BFGS;
using QuantLib::LevenbergMarquardt;
using QuantLib::DifferentialEvolution;
using QuantLib::SamplerGaussian;
using QuantLib::SamplerLogNormal;
using QuantLib::SamplerMirrorGaussian;
using QuantLib::ProbabilityBoltzmannDownhill;
using QuantLib::TemperatureExponential;
using QuantLib::ReannealingTrivial;
using QuantLib::GaussianSimulatedAnnealing;
using QuantLib::MirrorGaussianSimulatedAnnealing;
using QuantLib::LogNormalSimulatedAnnealing;



using QuantLib::Problem;


    class Optimizer {};

SWIGINTERN Array Optimizer_solve(Optimizer *self,CostFunctionDelegate *function,Constraint &c,OptimizationMethod &m,EndCriteria &e,Array &iv){
        JavaCostFunction f(function);
        Problem p(f,c,iv);
        m.minimize(p, e);
        return p.currentValue();
    }

using QuantLib::VolatilityType;
using QuantLib::ShiftedLognormal;
using QuantLib::Normal;


using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;
using QuantLib::OptionletVolatilityStructure;
using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr< BlackVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr< BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle< BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr< LocalVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr< LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle< LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__isNull(boost::shared_ptr< OptionletVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__asObservable(boost::shared_ptr< OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_OptionletVolatilityStructure_Sg__asObservable(Handle< OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr< SwaptionVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr< SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle< SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Calendar const &c,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, c,
                                     volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Calendar const &c,Handle< Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, c,
                                     volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Natural settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Natural settlementDays,Calendar const &calendar,Handle< Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::BlackVarianceCurve;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceCurvePtr;

SWIGINTERN BlackVarianceCurvePtr *new_BlackVarianceCurvePtr__SWIG_0(Date const &referenceDate,std::vector< Date > const &dates,std::vector< Real > const &volatilities,DayCounter const &dayCounter,bool forceMonotoneVariance=true){
            return new BlackVarianceCurvePtr(
                new BlackVarianceCurve(referenceDate,
                                       dates, volatilities,
                                       dayCounter, forceMonotoneVariance));
        }

using QuantLib::BlackVarianceSurface;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

SWIGINTERN BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,Calendar const &cal,std::vector< Date > const &dates,std::vector< Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,BlackVarianceSurface::Extrapolation lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,BlackVarianceSurface::Extrapolation upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation,std::string const &interpolator=""){
            BlackVarianceSurface* surf =
                new BlackVarianceSurface(referenceDate,cal,
                                         dates,strikes,
                                         blackVols,dayCounter,lower,upper);
            std::string s = boost::algorithm::to_lower_copy(interpolator);
            if (s == "" || s == "bilinear") {
                surf->setInterpolation<QuantLib::Bilinear>();
            } else if (s == "bicubic") {
                surf->setInterpolation<QuantLib::Bicubic>();
            } else {
                QL_FAIL("Unknown interpolator: " << interpolator);
            }
            return new BlackVarianceSurfacePtr(surf);
        }
SWIGINTERN void BlackVarianceSurfacePtr_setInterpolation__SWIG_0(BlackVarianceSurfacePtr *self,std::string const &interpolator=""){
            std::string s = boost::algorithm::to_lower_copy(interpolator);
            boost::shared_ptr<BlackVarianceSurface> surf =
                boost::dynamic_pointer_cast<BlackVarianceSurface>(*self);
            if (s == "" || s == "bilinear") {
                surf->setInterpolation<QuantLib::Bilinear>();
            } else if (s == "bicubic") {
                surf->setInterpolation<QuantLib::Bicubic>();
            } else {
                QL_FAIL("Unknown interpolator: " << interpolator);
            }
            
        }

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle< Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle< Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::LocalVolSurface;
typedef boost::shared_ptr<LocalVolTermStructure> LocalVolSurfacePtr;

SWIGINTERN LocalVolSurfacePtr *new_LocalVolSurfacePtr__SWIG_0(Handle< BlackVolTermStructure > const &blackTS,Handle< YieldTermStructure > const &riskFreeTS,Handle< YieldTermStructure > const &dividendTS,Handle< Quote > const &underlying){
            return new LocalVolSurfacePtr(
                new LocalVolSurface(blackTS, riskFreeTS, 
                    dividendTS, underlying));
        
        }
SWIGINTERN LocalVolSurfacePtr *new_LocalVolSurfacePtr__SWIG_1(Handle< BlackVolTermStructure > const &blackTS,Handle< YieldTermStructure > const &riskFreeTS,Handle< YieldTermStructure > const &dividendTS,Real underlying){
            return new LocalVolSurfacePtr(
                new LocalVolSurface(blackTS, riskFreeTS, 
                    dividendTS, underlying));
        }

using QuantLib::ConstantOptionletVolatility;
typedef boost::shared_ptr<OptionletVolatilityStructure>
    ConstantOptionletVolatilityPtr;

SWIGINTERN ConstantOptionletVolatilityPtr *new_ConstantOptionletVolatilityPtr__SWIG_0(Date const &referenceDate,Calendar const &cal,BusinessDayConvention bdc,Volatility volatility,DayCounter const &dayCounter,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantOptionletVolatilityPtr(
                new ConstantOptionletVolatility(referenceDate,
                                                cal, bdc, volatility,
                                                dayCounter, type, shift));
        }
SWIGINTERN ConstantOptionletVolatilityPtr *new_ConstantOptionletVolatilityPtr__SWIG_3(Date const &referenceDate,Calendar const &cal,BusinessDayConvention bdc,Handle< Quote > const &volatility,DayCounter const &dayCounter,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantOptionletVolatilityPtr(
                new ConstantOptionletVolatility(referenceDate,
                                                cal, bdc, volatility,
                                                dayCounter, type, shift));
        }
SWIGINTERN ConstantOptionletVolatilityPtr *new_ConstantOptionletVolatilityPtr__SWIG_6(Natural settlementDays,Calendar const &cal,BusinessDayConvention bdc,Volatility volatility,DayCounter const &dayCounter,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantOptionletVolatilityPtr(
                new ConstantOptionletVolatility(settlementDays,
                                                cal, bdc, volatility,
                                                dayCounter, type, shift));
        }
SWIGINTERN ConstantOptionletVolatilityPtr *new_ConstantOptionletVolatilityPtr__SWIG_9(Natural settlementDays,Calendar const &cal,BusinessDayConvention bdc,Handle< Quote > const &volatility,DayCounter const &dayCounter,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantOptionletVolatilityPtr(
                new ConstantOptionletVolatility(settlementDays,
                                                cal, bdc, volatility,
                                                dayCounter, type, shift));
        }

using QuantLib::ConstantSwaptionVolatility;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    ConstantSwaptionVolatilityPtr;

SWIGINTERN ConstantSwaptionVolatilityPtr *new_ConstantSwaptionVolatilityPtr__SWIG_0(Natural settlementDays,Calendar const &cal,BusinessDayConvention bdc,Handle< Quote > const &volatility,DayCounter const &dc,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantSwaptionVolatilityPtr(
                new ConstantSwaptionVolatility(settlementDays, cal, bdc,
                                               volatility, dc, type, shift));
        }
SWIGINTERN ConstantSwaptionVolatilityPtr *new_ConstantSwaptionVolatilityPtr__SWIG_3(Date const &referenceDate,Calendar const &cal,BusinessDayConvention bdc,Handle< Quote > const &volatility,DayCounter const &dc,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantSwaptionVolatilityPtr(
                new ConstantSwaptionVolatility(referenceDate, cal, bdc,
                                               volatility, dc, type, shift));
        }
SWIGINTERN ConstantSwaptionVolatilityPtr *new_ConstantSwaptionVolatilityPtr__SWIG_6(Natural settlementDays,Calendar const &cal,BusinessDayConvention bdc,Volatility volatility,DayCounter const &dc,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantSwaptionVolatilityPtr(
                new ConstantSwaptionVolatility(settlementDays, cal, bdc,
                                               volatility, dc, type, shift));
        }
SWIGINTERN ConstantSwaptionVolatilityPtr *new_ConstantSwaptionVolatilityPtr__SWIG_9(Date const &referenceDate,Calendar const &cal,BusinessDayConvention bdc,Volatility volatility,DayCounter const &dc,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            return new ConstantSwaptionVolatilityPtr(
                new ConstantSwaptionVolatility(referenceDate, cal, bdc,
                                               volatility, dc, type, shift));
        }

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

SWIGINTERN SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr__SWIG_0(Date const &referenceDate,std::vector< Date > const &dates,std::vector< Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter,bool const flatExtrapolation=false,VolatilityType const type=ShiftedLognormal,Matrix const &shifts=Matrix()){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter,
                                             flatExtrapolation, type, shifts));
        }
SWIGINTERN SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr__SWIG_4(Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &optionTenors,std::vector< Period > const &swapTenors,std::vector< std::vector< Handle< Quote > > > const &vols,DayCounter const &dayCounter,bool const flatExtrapolation=false,VolatilityType const type=ShiftedLognormal,std::vector< std::vector< Real > > const &shifts=std::vector< std::vector< Real > >()){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(calendar,bdc,optionTenors,
                                             swapTenors,vols,dayCounter,
                                             flatExtrapolation, type, shifts));
        }
SWIGINTERN SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr__SWIG_8(Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &optionTenors,std::vector< Period > const &swapTenors,Matrix const &vols,DayCounter const &dayCounter,bool const flatExtrapolation=false,VolatilityType const type=ShiftedLognormal,Matrix const &shifts=Matrix()){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(calendar,bdc,optionTenors,
                                             swapTenors,vols,dayCounter,
                                             flatExtrapolation, type, shifts));
        }

using QuantLib::SwaptionVolCube1;
using QuantLib::SwaptionVolCube2;
typedef boost::shared_ptr<SwaptionVolatilityStructure> SwaptionVolCube1Ptr;
typedef boost::shared_ptr<SwaptionVolatilityStructure> SwaptionVolCube2Ptr;

SWIGINTERN SwaptionVolCube1Ptr *new_SwaptionVolCube1Ptr__SWIG_0(Handle< SwaptionVolatilityStructure > const &atmVolStructure,std::vector< Period > const &optionTenors,std::vector< Period > const &swapTenors,std::vector< Spread > const &strikeSpreads,std::vector< std::vector< Handle< Quote > > > const &volSpreads,SwapIndexPtr const &swapIndexBase,SwapIndexPtr const &shortSwapIndexBase,bool vegaWeightedSmileFit,std::vector< std::vector< Handle< Quote > > > const &parametersGuess,std::vector< bool > const &isParameterFixed,bool isAtmCalibrated,boost::shared_ptr< EndCriteria > const &endCriteria=boost::shared_ptr< EndCriteria >(),Real maxErrorTolerance=Null< Real >(),boost::shared_ptr< OptimizationMethod > const &optMethod=boost::shared_ptr< OptimizationMethod >()){
            const boost::shared_ptr<SwapIndex> swi =
                boost::dynamic_pointer_cast<SwapIndex>(swapIndexBase);
            const boost::shared_ptr<SwapIndex> shortSwi =
                boost::dynamic_pointer_cast<SwapIndex>(shortSwapIndexBase);
            return new SwaptionVolCube1Ptr(
                new SwaptionVolCube1(
                    atmVolStructure,optionTenors,swapTenors, strikeSpreads,
                    volSpreads, swi, shortSwi, vegaWeightedSmileFit,
                    parametersGuess,isParameterFixed,isAtmCalibrated,
                    endCriteria,maxErrorTolerance,optMethod));
        }
SWIGINTERN Matrix SwaptionVolCube1Ptr_sparseSabrParameters(SwaptionVolCube1Ptr const *self){
            return boost::dynamic_pointer_cast<SwaptionVolCube1>(*self)
                ->sparseSabrParameters();
        }
SWIGINTERN Matrix SwaptionVolCube1Ptr_denseSabrParameters(SwaptionVolCube1Ptr const *self){
            return boost::dynamic_pointer_cast<SwaptionVolCube1>(*self)
                ->denseSabrParameters();
        }
SWIGINTERN Matrix SwaptionVolCube1Ptr_marketVolCube(SwaptionVolCube1Ptr const *self){
            return boost::dynamic_pointer_cast<SwaptionVolCube1>(*self)
                ->marketVolCube();
        }
SWIGINTERN Matrix SwaptionVolCube1Ptr_volCubeAtmCalibrated(SwaptionVolCube1Ptr const *self){
            return boost::dynamic_pointer_cast<SwaptionVolCube1>(*self)
                ->volCubeAtmCalibrated();
        }
SWIGINTERN SwaptionVolCube2Ptr *new_SwaptionVolCube2Ptr(Handle< SwaptionVolatilityStructure > const &atmVolStructure,std::vector< Period > const &optionTenors,std::vector< Period > const &swapTenors,std::vector< Spread > const &strikeSpreads,std::vector< std::vector< Handle< Quote > > > const &volSpreads,SwapIndexPtr const &swapIndexBase,SwapIndexPtr const &shortSwapIndexBase,bool vegaWeightedSmileFit){
            const boost::shared_ptr<SwapIndex> swi =
                boost::dynamic_pointer_cast<SwapIndex>(swapIndexBase);
            const boost::shared_ptr<SwapIndex> shortSwi =
                boost::dynamic_pointer_cast<SwapIndex>(shortSwapIndexBase);
            return new SwaptionVolCube2Ptr(
                new SwaptionVolCube2(
                    atmVolStructure,optionTenors,swapTenors,strikeSpreads,
                    volSpreads, swi, shortSwi, vegaWeightedSmileFit));
        }

using QuantLib::StochasticProcess;

SWIGINTERN bool boost_shared_ptr_Sl_StochasticProcess_Sg__isNull(boost::shared_ptr< StochasticProcess > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_StochasticProcess_Sg__asObservable(boost::shared_ptr< StochasticProcess > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN std::vector< boost::shared_ptr< StochasticProcess > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__get(std::vector< boost::shared_ptr< StochasticProcess > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__set(std::vector< boost::shared_ptr< StochasticProcess > > *self,int i,std::vector< boost::shared_ptr< StochasticProcess > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<StochasticProcess> StochasticProcess1DPtr;

SWIGINTERN Real StochasticProcess1DPtr_x0(StochasticProcess1DPtr *self){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)->x0();
      }
SWIGINTERN Real StochasticProcess1DPtr_drift(StochasticProcess1DPtr *self,Time t,Real x){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->drift(t, x);
      }
SWIGINTERN Real StochasticProcess1DPtr_diffusion(StochasticProcess1DPtr *self,Time t,Real x){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->diffusion(t, x);
      }
SWIGINTERN Real StochasticProcess1DPtr_expectation(StochasticProcess1DPtr *self,Time t0,Real x0,Time dt){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->expectation(t0, x0, dt);
      }
SWIGINTERN Real StochasticProcess1DPtr_stdDeviation(StochasticProcess1DPtr *self,Time t0,Real x0,Time dt){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->stdDeviation(t0, x0, dt);
      }
SWIGINTERN Real StochasticProcess1DPtr_variance(StochasticProcess1DPtr *self,Time t0,Real x0,Time dt){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->variance(t0, x0, dt);
      }
SWIGINTERN Real StochasticProcess1DPtr_evolve(StochasticProcess1DPtr *self,Time t0,Real x0,Time dt,Real dw){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->evolve(t0, x0, dt, dw);
      }
SWIGINTERN Real StochasticProcess1DPtr_apply(StochasticProcess1DPtr *self,Real x0,Real dx){
          return boost::dynamic_pointer_cast<StochasticProcess1D>(*self)
              ->apply(x0, dx);
      }

using QuantLib::GeneralizedBlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> GeneralizedBlackScholesProcessPtr;

SWIGINTERN GeneralizedBlackScholesProcessPtr *new_GeneralizedBlackScholesProcessPtr(Handle< Quote > const &s0,Handle< YieldTermStructure > const &dividendTS,Handle< YieldTermStructure > const &riskFreeTS,Handle< BlackVolTermStructure > const &volTS){
          return new GeneralizedBlackScholesProcessPtr(
                       new GeneralizedBlackScholesProcess(s0, dividendTS,
                                                          riskFreeTS, volTS));
      }
SWIGINTERN Handle< Quote > GeneralizedBlackScholesProcessPtr_stateVariable(GeneralizedBlackScholesProcessPtr *self){
          return boost::dynamic_pointer_cast<
                      GeneralizedBlackScholesProcess>(*self)->stateVariable();
      }
SWIGINTERN Handle< YieldTermStructure > GeneralizedBlackScholesProcessPtr_dividendYield(GeneralizedBlackScholesProcessPtr *self){
          return boost::dynamic_pointer_cast<
                      GeneralizedBlackScholesProcess>(*self)->dividendYield();
      }
SWIGINTERN Handle< YieldTermStructure > GeneralizedBlackScholesProcessPtr_riskFreeRate(GeneralizedBlackScholesProcessPtr *self){
          return boost::dynamic_pointer_cast<
                      GeneralizedBlackScholesProcess>(*self)->riskFreeRate();
      }
SWIGINTERN Handle< BlackVolTermStructure > GeneralizedBlackScholesProcessPtr_blackVolatility(GeneralizedBlackScholesProcessPtr const *self){
          return boost::dynamic_pointer_cast<
                      GeneralizedBlackScholesProcess>(*self)->blackVolatility();
      }

using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesProcessPtr;

SWIGINTERN BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle< Quote > const &s0,Handle< YieldTermStructure > const &riskFreeTS,Handle< BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                            new BlackScholesProcess(s0, riskFreeTS, volTS));
      }

using QuantLib::BlackScholesMertonProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesMertonProcessPtr;

SWIGINTERN BlackScholesMertonProcessPtr *new_BlackScholesMertonProcessPtr(Handle< Quote > const &s0,Handle< YieldTermStructure > const &dividendTS,Handle< YieldTermStructure > const &riskFreeTS,Handle< BlackVolTermStructure > const &volTS){
          return new BlackScholesMertonProcessPtr(
                            new BlackScholesMertonProcess(s0, dividendTS,
                                                          riskFreeTS, volTS));
      }

using QuantLib::BlackProcess;
typedef boost::shared_ptr<StochasticProcess> BlackProcessPtr;

SWIGINTERN BlackProcessPtr *new_BlackProcessPtr(Handle< Quote > const &s0,Handle< YieldTermStructure > const &riskFreeTS,Handle< BlackVolTermStructure > const &volTS){
          return new BlackProcessPtr(new BlackProcess(s0, riskFreeTS, volTS));
      }

using QuantLib::GarmanKohlagenProcess;
typedef boost::shared_ptr<StochasticProcess> GarmanKohlagenProcessPtr;

SWIGINTERN GarmanKohlagenProcessPtr *new_GarmanKohlagenProcessPtr(Handle< Quote > const &s0,Handle< YieldTermStructure > const &foreignRiskFreeTS,Handle< YieldTermStructure > const &domesticRiskFreeTS,Handle< BlackVolTermStructure > const &volTS){
          return new GarmanKohlagenProcessPtr(
                        new GarmanKohlagenProcess(s0, foreignRiskFreeTS,
                                                  domesticRiskFreeTS, volTS));
      }

using QuantLib::Merton76Process;
typedef boost::shared_ptr<StochasticProcess> Merton76ProcessPtr;

SWIGINTERN Merton76ProcessPtr *new_Merton76ProcessPtr(Handle< Quote > const &stateVariable,Handle< YieldTermStructure > const &dividendTS,Handle< YieldTermStructure > const &riskFreeTS,Handle< BlackVolTermStructure > const &volTS,Handle< Quote > const &jumpIntensity,Handle< Quote > const &meanLogJump,Handle< Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }

using QuantLib::StochasticProcessArray;
typedef boost::shared_ptr<StochasticProcess> StochasticProcessArrayPtr;

SWIGINTERN StochasticProcessArrayPtr *new_StochasticProcessArrayPtr(std::vector< boost::shared_ptr< StochasticProcess > > const &array,Matrix const &correlation){
          std::vector<boost::shared_ptr<StochasticProcess1D> > in_array;
          for (Size j=0; j < array.size(); j++)
              in_array.push_back(
                  boost::dynamic_pointer_cast<StochasticProcess1D>(array[j]));
          return new StochasticProcessArrayPtr(
                           new StochasticProcessArray(in_array, correlation));
      }

using QuantLib::GeometricBrownianMotionProcess;
typedef boost::shared_ptr<StochasticProcess> GeometricBrownianMotionProcessPtr;

SWIGINTERN GeometricBrownianMotionProcessPtr *new_GeometricBrownianMotionProcessPtr(Real initialValue,Real mu,Real sigma){
          return new GeometricBrownianMotionProcessPtr(
                 new GeometricBrownianMotionProcess(initialValue, mu, sigma));
      }

using QuantLib::VarianceGammaProcess;
typedef boost::shared_ptr<StochasticProcess> VarianceGammaProcessPtr;

SWIGINTERN VarianceGammaProcessPtr *new_VarianceGammaProcessPtr(Handle< Quote > const &s0,Handle< YieldTermStructure > const &dividendYield,Handle< YieldTermStructure > const &riskFreeRate,Real sigma,Real nu,Real theta){
          return new VarianceGammaProcessPtr(
                 new VarianceGammaProcess(s0,dividendYield,riskFreeRate,sigma,nu,theta));
      }

using QuantLib::HestonProcess;
typedef boost::shared_ptr<StochasticProcess> HestonProcessPtr;

SWIGINTERN HestonProcessPtr *new_HestonProcessPtr(Handle< YieldTermStructure > const &riskFreeTS,Handle< YieldTermStructure > const &dividendTS,Handle< Quote > const &s0,Real v0,Real kappa,Real theta,Real sigma,Real rho){
		return new HestonProcessPtr(
			new HestonProcess(riskFreeTS, dividendTS, s0, v0, 
						      kappa, theta, sigma, rho));	
      }
SWIGINTERN Handle< Quote > HestonProcessPtr_s0(HestonProcessPtr *self){
          return boost::dynamic_pointer_cast<
                      HestonProcess>(*self)->s0();
      }
SWIGINTERN Handle< YieldTermStructure > HestonProcessPtr_dividendYield(HestonProcessPtr *self){
          return boost::dynamic_pointer_cast<
                      HestonProcess>(*self)->dividendYield();
      }
SWIGINTERN Handle< YieldTermStructure > HestonProcessPtr_riskFreeRate(HestonProcessPtr *self){
          return boost::dynamic_pointer_cast<
                      HestonProcess>(*self)->riskFreeRate();
      }

using QuantLib::BatesProcess;
typedef boost::shared_ptr<StochasticProcess> BatesProcessPtr;

SWIGINTERN BatesProcessPtr *new_BatesProcessPtr(Handle< YieldTermStructure > const &riskFreeRate,Handle< YieldTermStructure > const &dividendYield,Handle< Quote > const &s0,Real v0,Real kappa,Real theta,Real sigma,Real rho,Real lambda,Real nu,Real delta){
		return new BatesProcessPtr(
			new BatesProcess(riskFreeRate, dividendYield, s0, v0, 
							 kappa, theta, sigma, rho, 
							 lambda, nu, delta));
	  }

using QuantLib::HullWhiteProcess;
typedef boost::shared_ptr<StochasticProcess> HullWhiteProcessPtr;

SWIGINTERN HullWhiteProcessPtr *new_HullWhiteProcessPtr(Handle< YieldTermStructure > const &riskFreeTS,Real a,Real sigma){
            return new HullWhiteProcessPtr(new HullWhiteProcess(riskFreeTS, a, sigma));	
        }

using QuantLib::HullWhiteForwardProcess;
typedef boost::shared_ptr<StochasticProcess> HullWhiteForwardProcessPtr;

SWIGINTERN HullWhiteForwardProcessPtr *new_HullWhiteForwardProcessPtr(Handle< YieldTermStructure > const &riskFreeTS,Real a,Real sigma){
            return new HullWhiteForwardProcessPtr(
                new HullWhiteForwardProcess(riskFreeTS, a, sigma));
        }
SWIGINTERN Real HullWhiteForwardProcessPtr_alpha(HullWhiteForwardProcessPtr const *self,Time t){
            return boost::dynamic_pointer_cast<HullWhiteForwardProcess>(*self)      ->alpha(t);
        }
SWIGINTERN Real HullWhiteForwardProcessPtr_M_T(HullWhiteForwardProcessPtr const *self,Real s,Real t,Real T){
            return boost::dynamic_pointer_cast<HullWhiteForwardProcess>(*self)      ->M_T(s, t, T);
        }
SWIGINTERN Real HullWhiteForwardProcessPtr_B(HullWhiteForwardProcessPtr const *self,Time t,Time T){
            return boost::dynamic_pointer_cast<HullWhiteForwardProcess>(*self)      ->B(t, T);
        }
SWIGINTERN void HullWhiteForwardProcessPtr_setForwardMeasureTime(HullWhiteForwardProcessPtr *self,Time t){
            boost::dynamic_pointer_cast<HullWhiteForwardProcess>(*self)             ->setForwardMeasureTime(t);
        }

using QuantLib::GsrProcess;
typedef boost::shared_ptr<StochasticProcess> GsrProcessPtr;

SWIGINTERN GsrProcessPtr *new_GsrProcessPtr__SWIG_0(Array const &times,Array const &vols,Array const &reversions,Real const T=60.0){
            return new GsrProcessPtr(new GsrProcess(times, vols, reversions, T));
        }
SWIGINTERN Real GsrProcessPtr_sigma(GsrProcessPtr *self,Time t){
            return boost::dynamic_pointer_cast<GsrProcess>(*self)->sigma(t);
        }
SWIGINTERN Real GsrProcessPtr_reversion(GsrProcessPtr *self,Time t){
            return boost::dynamic_pointer_cast<GsrProcess>(*self)->reversion(t);
        }
SWIGINTERN Real GsrProcessPtr_y(GsrProcessPtr *self,Time t){
            return boost::dynamic_pointer_cast<GsrProcess>(*self)->y(t);
        }
SWIGINTERN Real GsrProcessPtr_G(GsrProcessPtr *self,Time t,Time T,Real x){
            return boost::dynamic_pointer_cast<GsrProcess>(*self)->G(t, T, x);
        }
SWIGINTERN void GsrProcessPtr_setForwardMeasureTime(GsrProcessPtr *self,Time t){
            boost::dynamic_pointer_cast<GsrProcess>(*self)->setForwardMeasureTime(t);
        }

    GsrProcessPtr as_gsr_process(
                           const boost::shared_ptr<StochasticProcess>& proc) {
        return boost::dynamic_pointer_cast<GsrProcess>(proc);
    }


using QuantLib::PricingEngine;

SWIGINTERN bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr< PricingEngine > *self){
                return !(*self);
            }

using QuantLib::Instrument;

SWIGINTERN bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr< Instrument > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr< Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN std::vector< boost::shared_ptr< Instrument > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__get(std::vector< boost::shared_ptr< Instrument > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Instrument_Sg__Sg__set(std::vector< boost::shared_ptr< Instrument > > *self,int i,std::vector< boost::shared_ptr< Instrument > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

SWIGINTERN StockPtr *new_StockPtr(Handle< Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }

using QuantLib::CompositeInstrument;
typedef boost::shared_ptr<Instrument> CompositeInstrumentPtr;

SWIGINTERN CompositeInstrumentPtr *new_CompositeInstrumentPtr(){
            return new CompositeInstrumentPtr(new CompositeInstrument);
        }
SWIGINTERN void CompositeInstrumentPtr_add__SWIG_0(CompositeInstrumentPtr *self,boost::shared_ptr< Instrument > const &instrument,Real multiplier=1.0){
            boost::dynamic_pointer_cast<CompositeInstrument>(*self)
                ->add(instrument, multiplier);
        }
SWIGINTERN void CompositeInstrumentPtr_subtract__SWIG_0(CompositeInstrumentPtr *self,boost::shared_ptr< Instrument > const &instrument,Real multiplier=1.0){
            boost::dynamic_pointer_cast<CompositeInstrument>(*self)
                ->subtract(instrument, multiplier);
        }

using QuantLib::Schedule;
using QuantLib::DateGeneration;


using QuantLib::CashFlow;

SWIGINTERN bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr< CashFlow > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr< CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__get(std::vector< boost::shared_ptr< CashFlow > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__set(std::vector< boost::shared_ptr< CashFlow > > *self,int i,std::vector< boost::shared_ptr< CashFlow > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::SimpleCashFlow;
using QuantLib::Redemption;
using QuantLib::AmortizingPayment;
using QuantLib::Coupon;
using QuantLib::FixedRateCoupon;
using QuantLib::IborCoupon;
using QuantLib::Leg;
using QuantLib::FloatingRateCoupon;

typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> RedemptionPtr;
typedef boost::shared_ptr<CashFlow> AmortizingPaymentPtr;
typedef boost::shared_ptr<CashFlow> CouponPtr;
typedef boost::shared_ptr<CashFlow> IborCouponPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> FloatingRateCouponPtr;

SWIGINTERN SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
SWIGINTERN RedemptionPtr *new_RedemptionPtr(Real amount,Date const &date){
            return new RedemptionPtr(new Redemption(amount,date));
        }
SWIGINTERN AmortizingPaymentPtr *new_AmortizingPaymentPtr(Real amount,Date const &date){
            return new AmortizingPaymentPtr(new AmortizingPayment(amount,date));
        }
SWIGINTERN Real CouponPtr_nominal(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)->nominal();
        }
SWIGINTERN Date CouponPtr_accrualStartDate(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->accrualStartDate();
        }
SWIGINTERN Date CouponPtr_accrualEndDate(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->accrualEndDate();
        }
SWIGINTERN Date CouponPtr_referencePeriodStart(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->referencePeriodStart();
        }
SWIGINTERN Date CouponPtr_referencePeriodEnd(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->referencePeriodEnd();
        }
SWIGINTERN Date CouponPtr_exCouponDate(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->exCouponDate();
        }
SWIGINTERN Real CouponPtr_rate(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)->rate();
        }
SWIGINTERN Time CouponPtr_accrualPeriod(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->accrualPeriod();
        }
SWIGINTERN BigInteger CouponPtr_accrualDays(CouponPtr *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->accrualDays();
        }
SWIGINTERN DayCounter CouponPtr_dayCounter(CouponPtr const *self){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->dayCounter();
        }
SWIGINTERN Real CouponPtr_accruedAmount(CouponPtr *self,Date const &date){
            return boost::dynamic_pointer_cast<Coupon>(*self)
                ->accruedAmount(date);
        }

    CouponPtr as_coupon(const boost::shared_ptr<CashFlow>& cf) {
        return boost::dynamic_pointer_cast<Coupon>(cf);
    }

SWIGINTERN FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Date const &paymentDate,Real nominal,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),Date const &exCouponDate=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(paymentDate, nominal, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd,
                                    exCouponDate));
        }
SWIGINTERN InterestRate FixedRateCouponPtr_interestRate(FixedRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FixedRateCoupon>(*self)
                ->interestRate();
        }

    FixedRateCouponPtr as_fixed_rate_coupon(
                                      const boost::shared_ptr<CashFlow>& cf) {
        return boost::dynamic_pointer_cast<FixedRateCoupon>(cf);
    }


using QuantLib::FloatingRateCouponPricer;

SWIGINTERN bool boost_shared_ptr_Sl_FloatingRateCouponPricer_Sg__isNull(boost::shared_ptr< FloatingRateCouponPricer > *self){
                return !(*self);
            }
SWIGINTERN Date FloatingRateCouponPtr_fixingDate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDate();
        }
SWIGINTERN Integer FloatingRateCouponPtr_fixingDays(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDays();
        }
SWIGINTERN bool FloatingRateCouponPtr_isInArrears(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->isInArrears();
        }
SWIGINTERN Real FloatingRateCouponPtr_gearing(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->gearing();
        }
SWIGINTERN Rate FloatingRateCouponPtr_spread(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->spread();
        }
SWIGINTERN Rate FloatingRateCouponPtr_indexFixing(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Rate FloatingRateCouponPtr_adjustedFixing(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->adjustedFixing();
        }
SWIGINTERN Rate FloatingRateCouponPtr_convexityAdjustment(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->convexityAdjustment();
        }
SWIGINTERN Real FloatingRateCouponPtr_price(FloatingRateCouponPtr *self,Handle< YieldTermStructure > const &discountCurve){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->price(discountCurve);
        }
SWIGINTERN InterestRateIndexPtr FloatingRateCouponPtr_index(FloatingRateCouponPtr const *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->index();
        }
SWIGINTERN void FloatingRateCouponPtr_setPricer(FloatingRateCouponPtr *self,boost::shared_ptr< FloatingRateCouponPricer > const &p){
            boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->setPricer(p);
        }

    FloatingRateCouponPtr as_floating_rate_coupon(
                                      const boost::shared_ptr<CashFlow>& cf) {
        return boost::dynamic_pointer_cast<FloatingRateCoupon>(cf);
    }


using QuantLib::CappedFlooredCoupon;
typedef boost::shared_ptr<CashFlow> CappedFlooredCouponPtr;

SWIGINTERN CappedFlooredCouponPtr *new_CappedFlooredCouponPtr__SWIG_0(FloatingRateCouponPtr const &underlying,Rate cap=Null< Rate >(),Rate floor=Null< Rate >()){
            boost::shared_ptr<FloatingRateCoupon> u =
                boost::dynamic_pointer_cast<FloatingRateCoupon>(underlying);
            return new CappedFlooredCouponPtr(
                new CappedFlooredCoupon(u,cap,floor));
        }
SWIGINTERN Rate CappedFlooredCouponPtr_cap(CappedFlooredCouponPtr *self){
           return boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->cap();
        }
SWIGINTERN Rate CappedFlooredCouponPtr_floor(CappedFlooredCouponPtr *self){
           return boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->floor();
        }
SWIGINTERN Rate CappedFlooredCouponPtr_effectiveCap(CappedFlooredCouponPtr *self){
           return boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->effectiveCap();
        }
SWIGINTERN Rate CappedFlooredCouponPtr_effectiveFloor(CappedFlooredCouponPtr *self){
           return boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->effectiveFloor();
        }
SWIGINTERN bool CappedFlooredCouponPtr_isCapped(CappedFlooredCouponPtr *self){
           return boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->isCapped();
        }
SWIGINTERN bool CappedFlooredCouponPtr_isFloored(CappedFlooredCouponPtr *self){
           return boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->isFloored();
        }
SWIGINTERN void CappedFlooredCouponPtr_setPricer(CappedFlooredCouponPtr *self,boost::shared_ptr< FloatingRateCouponPricer > const &p){
            boost::dynamic_pointer_cast<CappedFlooredCoupon>(*self)
                ->setPricer(p);
        }
SWIGINTERN IborCouponPtr *new_IborCouponPtr__SWIG_0(Date const &paymentDate,Real nominal,Date const &startDate,Date const &endDate,Integer fixingDays,InterestRateIndexPtr &index,Real gearing=1.0,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter()){
            const boost::shared_ptr<IborIndex> iri =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new IborCouponPtr(
                new IborCoupon(paymentDate, nominal, startDate, endDate,
                               fixingDays, iri, gearing, spread,
                               refPeriodStart, refPeriodEnd, dayCounter));
        }

using QuantLib::IborCouponPricer;
using QuantLib::BlackIborCouponPricer;
typedef boost::shared_ptr<FloatingRateCouponPricer> IborCouponPricerPtr;
typedef boost::shared_ptr<FloatingRateCouponPricer> BlackIborCouponPricerPtr;

SWIGINTERN Handle< OptionletVolatilityStructure > IborCouponPricerPtr_capletVolatility(IborCouponPricerPtr *self){
            return boost::dynamic_pointer_cast<IborCouponPricer>(*self)
                ->capletVolatility();
        }
SWIGINTERN void IborCouponPricerPtr_setCapletVolatility__SWIG_0(IborCouponPricerPtr *self,Handle< OptionletVolatilityStructure > const &v=Handle< OptionletVolatilityStructure >()){
            boost::dynamic_pointer_cast<IborCouponPricer>(*self)
                ->setCapletVolatility(v);
        }
SWIGINTERN BlackIborCouponPricerPtr *new_BlackIborCouponPricerPtr__SWIG_0(Handle< OptionletVolatilityStructure > const &v=Handle< OptionletVolatilityStructure >()){
            return new BlackIborCouponPricerPtr(new BlackIborCouponPricer(v));
        }

using QuantLib::CmsCoupon;
using QuantLib::CappedFlooredCmsCoupon;
typedef boost::shared_ptr<CashFlow> CmsCouponPtr;
typedef boost::shared_ptr<CashFlow> CappedFlooredCmsCouponPtr;

SWIGINTERN CmsCouponPtr *new_CmsCouponPtr__SWIG_0(Date const &paymentDate,Real nominal,Date const &startDate,Date const &endDate,Integer fixingDays,SwapIndexPtr const &index,Real gearing=1.0,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter(),bool isInArrears=false){
            const boost::shared_ptr<SwapIndex> swi =
                boost::dynamic_pointer_cast<SwapIndex>(index);
            return new CmsCouponPtr(
                new CmsCoupon(paymentDate,nominal,startDate,endDate,
                              fixingDays,swi,gearing,spread,
                              refPeriodStart,refPeriodEnd,
                              dayCounter,isInArrears));
        }

using QuantLib::CmsCouponPricer;
using QuantLib::AnalyticHaganPricer;
using QuantLib::NumericHaganPricer;
using QuantLib::GFunctionFactory;
using QuantLib::LinearTsrPricer;
typedef boost::shared_ptr<FloatingRateCouponPricer> CmsCouponPricerPtr;
typedef boost::shared_ptr<FloatingRateCouponPricer> AnalyticHaganPricerPtr;
typedef boost::shared_ptr<FloatingRateCouponPricer> NumericHaganPricerPtr;
typedef boost::shared_ptr<FloatingRateCouponPricer> LinearTsrPricerPtr;

SWIGINTERN Handle< SwaptionVolatilityStructure > CmsCouponPricerPtr_swaptionVolatility(CmsCouponPricerPtr *self){
            return boost::dynamic_pointer_cast<CmsCouponPricer>(*self)
                ->swaptionVolatility();
        }
SWIGINTERN void CmsCouponPricerPtr_setSwaptionVolatility__SWIG_0(CmsCouponPricerPtr *self,Handle< SwaptionVolatilityStructure > const &v=Handle< SwaptionVolatilityStructure >()){
            boost::dynamic_pointer_cast<CmsCouponPricer>(*self)
                ->setSwaptionVolatility(v);
        }
SWIGINTERN AnalyticHaganPricerPtr *new_AnalyticHaganPricerPtr(Handle< SwaptionVolatilityStructure > const &v,GFunctionFactory::YieldCurveModel model,Handle< Quote > const &meanReversion){
            return new AnalyticHaganPricerPtr(
                            new AnalyticHaganPricer(v, model, meanReversion));
        }
SWIGINTERN NumericHaganPricerPtr *new_NumericHaganPricerPtr__SWIG_0(Handle< SwaptionVolatilityStructure > const &v,GFunctionFactory::YieldCurveModel model,Handle< Quote > const &meanReversion,Rate lowerLimit=0.0,Rate upperLimit=1.0,Real precision=1.0e-6){
             return new NumericHaganPricerPtr(
                 new NumericHaganPricer(v, model, meanReversion,
                                        lowerLimit, upperLimit, precision));
        }
SWIGINTERN CappedFlooredCmsCouponPtr *new_CappedFlooredCmsCouponPtr__SWIG_0(Date const &paymentDate,Real nominal,Date const &startDate,Date const &endDate,Natural fixingDays,SwapIndexPtr const &index,Real gearing=1.0,Spread spread=0.0,Rate const cap=Null< Rate >(),Rate const floor=Null< Rate >(),Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter(),bool isInArrears=false){
            const boost::shared_ptr<SwapIndex> swi =
                boost::dynamic_pointer_cast<SwapIndex>(index);
            return new CappedFlooredCmsCouponPtr(
                new CappedFlooredCmsCoupon(
                      paymentDate, nominal, startDate, endDate, fixingDays,
                      swi, gearing, spread, cap, floor, refPeriodStart,
                      refPeriodEnd, dayCounter, isInArrears));
        }
SWIGINTERN LinearTsrPricerPtr *new_LinearTsrPricerPtr__SWIG_0(Handle< SwaptionVolatilityStructure > const &swaptionVol,Handle< Quote > const &meanReversion,Handle< YieldTermStructure > const &couponDiscountCurve=Handle< YieldTermStructure >(),LinearTsrPricer::Settings const &settings=LinearTsrPricer::Settings()){
            return new LinearTsrPricerPtr(
                          new LinearTsrPricer(swaptionVol, meanReversion,
                                              couponDiscountCurve, settings));
        }

Leg _FixedRateLeg(const Schedule& schedule,
                  const DayCounter& dayCount,
                  const std::vector<Real>& nominals,
                  const std::vector<Rate>& couponRates,
                  BusinessDayConvention paymentAdjustment = Following,
                  const DayCounter& firstPeriodDayCount = DayCounter()) {
    return QuantLib::FixedRateLeg(schedule)
        .withNotionals(nominals)
        .withCouponRates(couponRates,dayCount)
        .withPaymentAdjustment(paymentAdjustment)
        .withFirstPeriodDayCounter(firstPeriodDayCount);
}


Leg _IborLeg(const std::vector<Real>& nominals,
             const Schedule& schedule,
             const boost::shared_ptr<Index>& index,
             const DayCounter& paymentDayCounter = DayCounter(),
             const BusinessDayConvention paymentConvention = Following,
             const std::vector<Natural>& fixingDays = std::vector<Natural>(),
             const std::vector<Real>& gearings = std::vector<Real>(),
             const std::vector<Spread>& spreads = std::vector<Spread>(),
             const std::vector<Rate>& caps = std::vector<Rate>(),
             const std::vector<Rate>& floors = std::vector<Rate>(),
             bool isInArrears = false) {
    boost::shared_ptr<IborIndex> libor =
        boost::dynamic_pointer_cast<IborIndex>(index);
    return QuantLib::IborLeg(schedule, libor)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const boost::shared_ptr<Index>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsZeroLeg(const std::vector<Real>& nominals,
                const Schedule& schedule,
                const boost::shared_ptr<Index>& index,
                const DayCounter& paymentDayCounter = DayCounter(),
                const BusinessDayConvention paymentConvention = Following,
                const std::vector<Natural>& fixingDays = std::vector<Natural>(),
                const std::vector<Real>& gearings = std::vector<Real>(),
                const std::vector<Spread>& spreads = std::vector<Spread>(),
                const std::vector<Rate>& caps = std::vector<Rate>(),
                const std::vector<Rate>& floors = std::vector<Rate>()) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withZeroPayments();
}


using QuantLib::CashFlows;
using QuantLib::Duration;

SWIGINTERN Real CashFlows_npv__SWIG_0(Leg const &leg,boost::shared_ptr< YieldTermStructure > const &discountCurve,Spread zSpread,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::npv(leg, discountCurve,
                                            zSpread,
                                            dayCounter,
                                            compounding,
                                            frequency,
                                            includeSettlementDateFlows,
                                            settlementDate,
                                            npvDate);
        }
SWIGINTERN Real CashFlows_npv__SWIG_3(Leg const &leg,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::npv(leg, **discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Real CashFlows_bps__SWIG_0(Leg const &leg,boost::shared_ptr< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::bps(leg, *discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Real CashFlows_bps__SWIG_3(Leg const &leg,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return QuantLib::CashFlows::bps(leg, **discountCurve,
                                            includeSettlementDateFlows,
                                            settlementDate, npvDate);
        }
SWIGINTERN Rate CashFlows_atmRate__SWIG_0(Leg const &leg,boost::shared_ptr< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date(),Real npv=Null< Real >()){
            return QuantLib::CashFlows::atmRate(leg, *discountCurve,
                                                includeSettlementDateFlows,
                                                settlementDate, npvDate,
                                                npv);
        }

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
using QuantLib::HestonModelHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> HestonModelHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr< CalibrationHelper > *self){
                return !(*self);
            }
SWIGINTERN Date boost_shared_ptr_Sl_CalibrationHelper_Sg__swaptionExpiryDate(boost::shared_ptr< CalibrationHelper > *self){
        boost::shared_ptr<SwaptionHelper> s = boost::dynamic_pointer_cast<SwaptionHelper>(*self);
        return s ? s->swaption()->exercise()->date(0) : Null<Date>();
    }
SWIGINTERN Real boost_shared_ptr_Sl_CalibrationHelper_Sg__swaptionStrike(boost::shared_ptr< CalibrationHelper > *self){
        boost::shared_ptr<SwaptionHelper> s = boost::dynamic_pointer_cast<SwaptionHelper>(*self);
        return s ? s->swaption()->underlyingSwap()->fixedRate() : Null<Real>();
    }
SWIGINTERN Real boost_shared_ptr_Sl_CalibrationHelper_Sg__swaptionNominal(boost::shared_ptr< CalibrationHelper > *self){
        boost::shared_ptr<SwaptionHelper> s = boost::dynamic_pointer_cast<SwaptionHelper>(*self);
        return s ? s->swaption()->underlyingSwap()->nominal() : Null<Real>();
    }
SWIGINTERN Date boost_shared_ptr_Sl_CalibrationHelper_Sg__swaptionMaturityDate(boost::shared_ptr< CalibrationHelper > *self){
        boost::shared_ptr<SwaptionHelper> s = boost::dynamic_pointer_cast<SwaptionHelper>(*self);
        return s ? s->swaption()->underlyingSwap()->fixedSchedule().dates().back() : Null<Date>();
    }
SWIGINTERN SwaptionHelperPtr *new_SwaptionHelperPtr__SWIG_0(Period const &maturity,Period const &length,Handle< Quote > const &volatility,IborIndexPtr const &index,Period const &fixedLegTenor,DayCounter const &fixedLegDayCounter,DayCounter const &floatingLegDayCounter,Handle< YieldTermStructure > const &termStructure,CalibrationHelper::CalibrationErrorType errorType=CalibrationHelper::RelativePriceError,Real const strike=Null< Real >(),Real const nominal=1.0,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegTenor,
                                   fixedLegDayCounter,
                                   floatingLegDayCounter,
                                   termStructure,
                                   errorType,
                                   strike, nominal, 
                                   type, shift));
        }
SWIGINTERN SwaptionHelperPtr *new_SwaptionHelperPtr__SWIG_6(Date const &exerciseDate,Period const &length,Handle< Quote > const &volatility,IborIndexPtr const &index,Period const &fixedLegTenor,DayCounter const &fixedLegDayCounter,DayCounter const &floatingLegDayCounter,Handle< YieldTermStructure > const &termStructure,CalibrationHelper::CalibrationErrorType errorType=CalibrationHelper::RelativePriceError,Real const strike=Null< Real >(),Real const nominal=1.0,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(exerciseDate,length,volatility,
                                   libor,fixedLegTenor,
                                   fixedLegDayCounter,
                                   floatingLegDayCounter,
                                   termStructure,
                                   errorType,
                                   strike, nominal, 
                                   type, shift));
        }
SWIGINTERN SwaptionHelperPtr *new_SwaptionHelperPtr__SWIG_12(Date const &exerciseDate,Date const &endDate,Handle< Quote > const &volatility,IborIndexPtr const &index,Period const &fixedLegTenor,DayCounter const &fixedLegDayCounter,DayCounter const &floatingLegDayCounter,Handle< YieldTermStructure > const &termStructure,CalibrationHelper::CalibrationErrorType errorType=CalibrationHelper::RelativePriceError,Real const strike=Null< Real >(),Real const nominal=1.0,VolatilityType const type=ShiftedLognormal,Real const shift=0.0){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(exerciseDate,endDate,volatility,
                                   libor,fixedLegTenor,
                                   fixedLegDayCounter,
                                   floatingLegDayCounter,
                                   termStructure,
                                   errorType,
                                   strike, nominal, 
                                   type, shift));
        }
SWIGINTERN std::vector< Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN CapHelperPtr *new_CapHelperPtr__SWIG_0(Period const &length,Handle< Quote > const &volatility,IborIndexPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle< YieldTermStructure > const &termStructure,CalibrationHelper::CalibrationErrorType errorType=CalibrationHelper::RelativePriceError){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
SWIGINTERN std::vector< Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN HestonModelHelperPtr *new_HestonModelHelperPtr__SWIG_0(Period const &maturity,Calendar const &calendar,Real const s0,Real const strikePrice,Handle< Quote > const &volatility,Handle< YieldTermStructure > const &riskFreeRate,Handle< YieldTermStructure > const &dividendYield,CalibrationHelper::CalibrationErrorType errorType=CalibrationHelper::RelativePriceError){
			return new HestonModelHelperPtr(
				new HestonModelHelper(maturity, calendar, s0, strikePrice,
									  volatility, riskFreeRate, dividendYield,
									  errorType)); 
		}
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__get(std::vector< boost::shared_ptr< CalibrationHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__set(std::vector< boost::shared_ptr< CalibrationHelper > > *self,int i,std::vector< boost::shared_ptr< CalibrationHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::CalibratedModel;

SWIGINTERN bool boost_shared_ptr_Sl_CalibratedModel_Sg__isNull(boost::shared_ptr< CalibratedModel > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_CalibratedModel_Sg__asObservable(boost::shared_ptr< CalibratedModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_CalibratedModel_Sg__asObservable(Handle< CalibratedModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::TimeGrid;

SWIGINTERN TimeGrid *new_TimeGrid__SWIG_2(std::vector< Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
SWIGINTERN TimeGrid *new_TimeGrid__SWIG_3(std::vector< Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }
SWIGINTERN Time TimeGrid_ref(TimeGrid *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("time-grid index out of range");
        }
SWIGINTERN Time TimeGrid_dt(TimeGrid *self,Size i){
            if (i<self->size())
                return self->dt(i);
            else
                throw std::out_of_range("time-grid index out of range");
        }

using QuantLib::Parameter;
using QuantLib::ConstantParameter;
using QuantLib::NullParameter;
using QuantLib::PiecewiseConstantParameter;


using QuantLib::Option;
using QuantLib::Barrier;


using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

SWIGINTERN bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr< Payoff > *self){
                return !(*self);
            }

using QuantLib::VanillaOption;
using QuantLib::ForwardVanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;
typedef boost::shared_ptr<Instrument> MultiAssetOptionPtr;

SWIGINTERN VanillaOptionPtr *new_VanillaOptionPtr(boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(new VanillaOption(stPayoff,exercise));
        }
SWIGINTERN SampledCurve VanillaOptionPtr_priceCurve(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->impliedVolatility(targetValue, bsProcess, accuracy,
                                    maxEvaluations, minVol, maxVol);
        }
SWIGINTERN Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
    }
SWIGINTERN Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
    }
SWIGINTERN Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
    }
SWIGINTERN Real VanillaOptionPtr_thetaPerDay(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->thetaPerDay();
    }
SWIGINTERN Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
    }
SWIGINTERN Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
    }
SWIGINTERN Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->dividendRho();
    }
SWIGINTERN Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<VanillaOption>(*self)->strikeSensitivity();
    }

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

SWIGINTERN EuropeanOptionPtr *new_EuropeanOptionPtr(boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(new EuropeanOption(stPayoff,exercise));
        }

using QuantLib::ForwardVanillaOption;
typedef boost::shared_ptr<Instrument> ForwardVanillaOptionPtr;

SWIGINTERN ForwardVanillaOptionPtr *new_ForwardVanillaOptionPtr(Real moneyness,Date resetDate,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new ForwardVanillaOptionPtr(
                                new ForwardVanillaOption(moneyness, resetDate,
                                                         stPayoff, exercise));
        }

using QuantLib::QuantoVanillaOption;
typedef boost::shared_ptr<Instrument> QuantoVanillaOptionPtr;

SWIGINTERN QuantoVanillaOptionPtr *new_QuantoVanillaOptionPtr(boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoVanillaOptionPtr(
                                 new QuantoVanillaOption(stPayoff, exercise));
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qvega(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qvega();
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qrho(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qrho();
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qlambda(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qlambda();
        }

using QuantLib::QuantoForwardVanillaOption;
typedef boost::shared_ptr<Instrument> QuantoForwardVanillaOptionPtr;

SWIGINTERN QuantoForwardVanillaOptionPtr *new_QuantoForwardVanillaOptionPtr(Real moneyness,Date resetDate,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoForwardVanillaOptionPtr(
                          new QuantoForwardVanillaOption(moneyness, resetDate,
                                                         stPayoff, exercise));
        }

using QuantLib::MultiAssetOption;

SWIGINTERN Real MultiAssetOptionPtr_delta(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->delta();
        }
SWIGINTERN Real MultiAssetOptionPtr_gamma(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->gamma();
        }
SWIGINTERN Real MultiAssetOptionPtr_theta(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->theta();
        }
SWIGINTERN Real MultiAssetOptionPtr_vega(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)->vega();
        }
SWIGINTERN Real MultiAssetOptionPtr_rho(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)->rho();
        }
SWIGINTERN Real MultiAssetOptionPtr_dividendRho(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->dividendRho();
        }

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

SWIGINTERN AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticEuropeanEnginePtr(
                                       new AnalyticEuropeanEngine(bsProcess));
        }

using QuantLib::HestonModel;
typedef boost::shared_ptr<CalibratedModel> HestonModelPtr;

SWIGINTERN HestonModelPtr *new_HestonModelPtr(HestonProcessPtr const &process){

            boost::shared_ptr<HestonProcess> hProcess =
                 boost::dynamic_pointer_cast<HestonProcess>(process);
            QL_REQUIRE(hProcess, "Heston process required");

            return new HestonModelPtr(new HestonModel(hProcess));
        }
SWIGINTERN Real HestonModelPtr_theta(HestonModelPtr const *self){
            return boost::dynamic_pointer_cast<HestonModel>(*self)->theta();
        }
SWIGINTERN Real HestonModelPtr_kappa(HestonModelPtr const *self){
            return boost::dynamic_pointer_cast<HestonModel>(*self)->kappa();
        }
SWIGINTERN Real HestonModelPtr_sigma(HestonModelPtr const *self){
            return boost::dynamic_pointer_cast<HestonModel>(*self)->sigma();
        }
SWIGINTERN Real HestonModelPtr_rho(HestonModelPtr const *self){
            return boost::dynamic_pointer_cast<HestonModel>(*self)->rho();
        }
SWIGINTERN Real HestonModelPtr_v0(HestonModelPtr const *self){
            return boost::dynamic_pointer_cast<HestonModel>(*self)->v0();
        }

using QuantLib::PiecewiseTimeDependentHestonModel;
typedef boost::shared_ptr<CalibratedModel> PiecewiseTimeDependentHestonModelPtr;

SWIGINTERN PiecewiseTimeDependentHestonModelPtr *new_PiecewiseTimeDependentHestonModelPtr(Handle< YieldTermStructure > const &riskFreeRate,Handle< YieldTermStructure > const &dividendYield,Handle< Quote > const &s0,Real v0,Parameter const &theta,Parameter const &kappa,Parameter const &sigma,Parameter const &rho,TimeGrid const &timeGrid){
            return new PiecewiseTimeDependentHestonModelPtr (
                new PiecewiseTimeDependentHestonModel(riskFreeRate,
                    dividendYield, s0, v0, theta, kappa, 
                    sigma, rho, timeGrid));
        }
SWIGINTERN Real PiecewiseTimeDependentHestonModelPtr_theta(PiecewiseTimeDependentHestonModelPtr const *self,Time t){ 
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->theta(t);
        }
SWIGINTERN Real PiecewiseTimeDependentHestonModelPtr_kappa(PiecewiseTimeDependentHestonModelPtr const *self,Time t){
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->kappa(t);
        }
SWIGINTERN Real PiecewiseTimeDependentHestonModelPtr_sigma(PiecewiseTimeDependentHestonModelPtr const *self,Time t){
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->sigma(t);
        }
SWIGINTERN Real PiecewiseTimeDependentHestonModelPtr_rho(PiecewiseTimeDependentHestonModelPtr const *self,Time t){ 
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->rho(t);
        }
SWIGINTERN Real PiecewiseTimeDependentHestonModelPtr_v0(PiecewiseTimeDependentHestonModelPtr const *self){ 
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->v0();
        }
SWIGINTERN Real PiecewiseTimeDependentHestonModelPtr_s0(PiecewiseTimeDependentHestonModelPtr const *self){ 
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->s0();
        }
SWIGINTERN TimeGrid const &PiecewiseTimeDependentHestonModelPtr_timeGrid(PiecewiseTimeDependentHestonModelPtr const *self){
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->timeGrid();
        }
SWIGINTERN Handle< YieldTermStructure > const &PiecewiseTimeDependentHestonModelPtr_dividendYield(PiecewiseTimeDependentHestonModelPtr const *self){
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->dividendYield();
        }
SWIGINTERN Handle< YieldTermStructure > const &PiecewiseTimeDependentHestonModelPtr_riskFreeRate(PiecewiseTimeDependentHestonModelPtr const *self){
            return boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(*self)->riskFreeRate();
        }

using QuantLib::AnalyticHestonEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticHestonEnginePtr;

SWIGINTERN AnalyticHestonEnginePtr *new_AnalyticHestonEnginePtr__SWIG_0(HestonModelPtr const &model,Size integrationOrder=144){
            boost::shared_ptr<HestonModel> hModel =
                 boost::dynamic_pointer_cast<HestonModel>(model);
            QL_REQUIRE(hModel, "Heston model required");

            return new AnalyticHestonEnginePtr(
                new AnalyticHestonEngine(hModel, integrationOrder));
        }
SWIGINTERN AnalyticHestonEnginePtr *new_AnalyticHestonEnginePtr__SWIG_2(HestonModelPtr const &model,Real relTolerance,Size maxEvaluations){
            boost::shared_ptr<HestonModel> hModel =
                 boost::dynamic_pointer_cast<HestonModel>(model);
            QL_REQUIRE(hModel, "Heston model required");

            return new AnalyticHestonEnginePtr(
                new AnalyticHestonEngine(hModel, relTolerance,maxEvaluations));
        }

using QuantLib::AnalyticPTDHestonEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticPTDHestonEnginePtr;

SWIGINTERN AnalyticPTDHestonEnginePtr *new_AnalyticPTDHestonEnginePtr__SWIG_0(PiecewiseTimeDependentHestonModelPtr const &model,Real relTolerance,Size maxEvaluations){
                const boost::shared_ptr<PiecewiseTimeDependentHestonModel> hmodel = 
                    boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(model);
                return new AnalyticPTDHestonEnginePtr(
                    new AnalyticPTDHestonEngine(hmodel, relTolerance, maxEvaluations)
            );
        }
SWIGINTERN AnalyticPTDHestonEnginePtr *new_AnalyticPTDHestonEnginePtr__SWIG_1(PiecewiseTimeDependentHestonModelPtr const &model,Size integrationOrder=144){
                const boost::shared_ptr<PiecewiseTimeDependentHestonModel> hmodel = 
                    boost::dynamic_pointer_cast<PiecewiseTimeDependentHestonModel>(model);
                return new AnalyticPTDHestonEnginePtr(
                    new AnalyticPTDHestonEngine(hmodel, integrationOrder)
            );
        }

using QuantLib::BatesModel;
typedef boost::shared_ptr<CalibratedModel> BatesModelPtr;

SWIGINTERN BatesModelPtr *new_BatesModelPtr(BatesProcessPtr const &process){

            boost::shared_ptr<BatesProcess> bProcess =
                 boost::dynamic_pointer_cast<BatesProcess>(process);
            QL_REQUIRE(bProcess, "Bates process required");

            return new BatesModelPtr(new BatesModel(bProcess));
        }
SWIGINTERN Real BatesModelPtr_nu(BatesModelPtr const *self){
            return boost::dynamic_pointer_cast<BatesModel>(*self)->nu();
        }
SWIGINTERN Real BatesModelPtr_delta(BatesModelPtr const *self){
            return boost::dynamic_pointer_cast<BatesModel>(*self)->delta();
        }
SWIGINTERN Real BatesModelPtr_lambda(BatesModelPtr const *self){
            return boost::dynamic_pointer_cast<BatesModel>(*self)->lambda();
        }

using QuantLib::BatesEngine;
typedef boost::shared_ptr<PricingEngine> BatesEnginePtr;

SWIGINTERN BatesEnginePtr *new_BatesEnginePtr__SWIG_0(BatesModelPtr const &model,Size integrationOrder=144){
            boost::shared_ptr<BatesModel> bModel =
                 boost::dynamic_pointer_cast<BatesModel>(model);
            QL_REQUIRE(bModel, "Bates model required");

            return new BatesEnginePtr(
                new BatesEngine(bModel, integrationOrder));
        }
SWIGINTERN BatesEnginePtr *new_BatesEnginePtr__SWIG_2(BatesModelPtr const &model,Real relTolerance,Size maxEvaluations){
            boost::shared_ptr<BatesModel> bModel =
                 boost::dynamic_pointer_cast<BatesModel>(model);
            QL_REQUIRE(bModel, "Bates model required");

            return new BatesEnginePtr(
                new BatesEngine(bModel, relTolerance,maxEvaluations));
        }

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

SWIGINTERN IntegralEnginePtr *new_IntegralEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new IntegralEnginePtr(new IntegralEngine(bsProcess));
        }

using QuantLib::FDBermudanEngine;
typedef boost::shared_ptr<PricingEngine> FDBermudanEnginePtr;

SWIGINTERN FDBermudanEnginePtr *new_FDBermudanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDBermudanEnginePtr(
                            new FDBermudanEngine<>(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

SWIGINTERN FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDEuropeanEnginePtr(
                            new FDEuropeanEngine<>(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
using QuantLib::Joshi4;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

SWIGINTERN BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(
                                                            bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(bsProcess,steps));
            else if (s == "eqp" || s == "additiveeqpbinomialtree")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(
                                                            bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(bsProcess,steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Joshi4>(bsProcess,steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

SWIGINTERN MCEuropeanEnginePtr *new_MCEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,intOrNull timeSteps=Null< Size >(),intOrNull timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(bsProcess,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(bsProcess,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

SWIGINTERN FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDAmericanEnginePtr(
                            new FDAmericanEngine<>(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::FdBlackScholesVanillaEngine;
typedef boost::shared_ptr<PricingEngine> FdBlackScholesVanillaEnginePtr;

SWIGINTERN FdBlackScholesVanillaEnginePtr *new_FdBlackScholesVanillaEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size tGrid=100,Size xGrid=100,Size dampingSteps=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FdBlackScholesVanillaEnginePtr(
                            new FdBlackScholesVanillaEngine( bsProcess,tGrid, xGrid, dampingSteps));
        }

using QuantLib::FdBatesVanillaEngine;
typedef boost::shared_ptr<PricingEngine> FdBatesVanillaEnginePtr;

SWIGINTERN FdBatesVanillaEnginePtr *new_FdBatesVanillaEnginePtr__SWIG_0(BatesModelPtr const &model,Size tGrid=100,Size xGrid=100,Size vGrid=50,Size dampingSteps=0){
            boost::shared_ptr<BatesModel> bModel =
                 boost::dynamic_pointer_cast<BatesModel>(model);
            QL_REQUIRE(bModel, "Bates model required");
            return new FdBatesVanillaEnginePtr(
                               new FdBatesVanillaEngine(bModel, tGrid, xGrid,
                                                        vGrid, dampingSteps));
        }

using QuantLib::ContinuousArithmeticAsianLevyEngine;
typedef boost::shared_ptr<PricingEngine> ContinuousArithmeticAsianLevyEnginePtr;

SWIGINTERN ContinuousArithmeticAsianLevyEnginePtr *new_ContinuousArithmeticAsianLevyEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle< Quote > const &runningAverage,Date const &startDate){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new ContinuousArithmeticAsianLevyEnginePtr(
                            new ContinuousArithmeticAsianLevyEngine(bsProcess,runningAverage, startDate));
        }

using QuantLib::FdBlackScholesAsianEngine;
typedef boost::shared_ptr<PricingEngine> FdBlackScholesAsianEnginePtr;

SWIGINTERN FdBlackScholesAsianEnginePtr *new_FdBlackScholesAsianEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Size tGrid,Size xGrid,Size aGrid){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FdBlackScholesAsianEnginePtr(
                            new FdBlackScholesAsianEngine(bsProcess,tGrid, xGrid, aGrid));
        }
SWIGINTERN FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDShoutEnginePtr(
                               new FDShoutEngine<>(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

SWIGINTERN BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                         new BaroneAdesiWhaleyApproximationEngine(bsProcess));
        }

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

SWIGINTERN BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new BjerksundStenslandApproximationEnginePtr(
                        new BjerksundStenslandApproximationEngine(bsProcess));
        }

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

SWIGINTERN AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDigitalAmericanEnginePtr(
                                new AnalyticDigitalAmericanEngine(bsProcess));
        }

using QuantLib::AnalyticDigitalAmericanKOEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanKOEnginePtr;

SWIGINTERN AnalyticDigitalAmericanKOEnginePtr *new_AnalyticDigitalAmericanKOEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDigitalAmericanKOEnginePtr(
                                new AnalyticDigitalAmericanKOEngine(bsProcess));
        }

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

SWIGINTERN DividendVanillaOptionPtr *new_DividendVanillaOptionPtr(boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise,std::vector< Date > const &dividendDates,std::vector< Real > const &dividends){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                          new DividendVanillaOption(stPayoff,exercise,
                                                    dividendDates,dividends));
        }
SWIGINTERN SampledCurve DividendVanillaOptionPtr_priceCurve(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->impliedVolatility(targetValue, bsProcess, accuracy,
                                    maxEvaluations, minVol, maxVol);
        }
SWIGINTERN Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->delta();
    }
SWIGINTERN Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->gamma();
    }
SWIGINTERN Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->theta();
    }
SWIGINTERN Real DividendVanillaOptionPtr_thetaPerDay(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->thetaPerDay();
    }
SWIGINTERN Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->vega();
    }
SWIGINTERN Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->rho();
    }
SWIGINTERN Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->dividendRho();
    }
SWIGINTERN Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
        return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)->strikeSensitivity();
    }

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

SWIGINTERN AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDividendEuropeanEnginePtr(
                               new AnalyticDividendEuropeanEngine(bsProcess));
        }

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

SWIGINTERN FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDDividendEuropeanEnginePtr(
                   new FDDividendEuropeanEngine<>(bsProcess,timeSteps,
                                                  gridPoints, timeDependent));
        }
SWIGINTERN FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDDividendAmericanEnginePtr(
                   new FDDividendAmericanEngine<>(bsProcess,timeSteps,
                                                  gridPoints, timeDependent));
        }

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

SWIGINTERN BarrierOptionPtr *new_BarrierOptionPtr(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                               new BarrierOption(barrierType, barrier, rebate,
                                                 stPayoff,exercise));
        }
SWIGINTERN SampledCurve BarrierOptionPtr_priceCurve(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue, bsProcess, accuracy,
                                     maxEvaluations, minVol, maxVol);
        }
SWIGINTERN Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
    }
SWIGINTERN Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
    }
SWIGINTERN Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
    }
SWIGINTERN Real BarrierOptionPtr_thetaPerDay(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->thetaPerDay();
    }
SWIGINTERN Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
    }
SWIGINTERN Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
    }
SWIGINTERN Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->dividendRho();
    }
SWIGINTERN Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<BarrierOption>(*self)->strikeSensitivity();
    }

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

SWIGINTERN AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticBarrierEnginePtr(
                                        new AnalyticBarrierEngine(bsProcess));
        }

using QuantLib::MCBarrierEngine;
typedef boost::shared_ptr<PricingEngine> MCBarrierEnginePtr;

SWIGINTERN MCBarrierEnginePtr *new_MCBarrierEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),bool isBiased=false,BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCBarrierEnginePtr(
                         new MCBarrierEngine<PseudoRandom>(bsProcess,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCBarrierEnginePtr(
                       new MCBarrierEngine<LowDiscrepancy>(bsProcess,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FdmSchemeDesc;


using QuantLib::FdBlackScholesBarrierEngine;
typedef boost::shared_ptr<PricingEngine> FdBlackScholesBarrierEnginePtr;

SWIGINTERN FdBlackScholesBarrierEnginePtr *new_FdBlackScholesBarrierEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size tGrid=100,Size xGrid=100,Size dampingSteps=0,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Douglas(),bool localVol=false,Real illegalLocalVolOverwrite=-Null< Real >()){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FdBlackScholesBarrierEnginePtr(
                            new FdBlackScholesBarrierEngine(bsProcess,
                                                              tGrid,  xGrid, dampingSteps, 
                                                              schemeDesc, localVol,
                                                              illegalLocalVolOverwrite));
        }

using QuantLib::AnalyticBinaryBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBinaryBarrierEnginePtr;

SWIGINTERN AnalyticBinaryBarrierEnginePtr *new_AnalyticBinaryBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticBinaryBarrierEnginePtr(
                                        new AnalyticBinaryBarrierEngine(bsProcess));
        }

using QuantLib::BinomialBarrierEngine;
using QuantLib::DiscretizedDermanKaniBarrierOption;
typedef boost::shared_ptr<PricingEngine> BinomialBarrierEnginePtr;

SWIGINTERN BinomialBarrierEnginePtr *new_BinomialBarrierEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps,Size max_steps=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<CoxRossRubinstein,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<JarrowRudd,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else if (s == "eqp" || s == "additiveeqpbinomialtree")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<AdditiveEQPBinomialTree,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else if (s == "trigeorgis")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<Trigeorgis,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else if (s == "tian")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<Tian,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<LeisenReimer,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialBarrierEnginePtr(
                    new BinomialBarrierEngine<Joshi4,
                                          DiscretizedDermanKaniBarrierOption>(
                                                  bsProcess,steps,max_steps));
            else
                QL_FAIL("unknown binomial barrier engine type: "+s);
        }

using QuantLib::QuantoEngine;
using QuantLib::ForwardVanillaEngine;
typedef boost::shared_ptr<PricingEngine> ForwardEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> QuantoEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> QuantoForwardEuropeanEnginePtr;

SWIGINTERN ForwardEuropeanEnginePtr *new_ForwardEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new ForwardEuropeanEnginePtr(
                 new ForwardVanillaEngine<AnalyticEuropeanEngine>(bsProcess));
        }
SWIGINTERN QuantoEuropeanEnginePtr *new_QuantoEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle< YieldTermStructure > const &foreignRiskFreeRate,Handle< BlackVolTermStructure > const &exchangeRateVolatility,Handle< Quote > const &correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new QuantoEuropeanEnginePtr(
                new QuantoEngine<VanillaOption,AnalyticEuropeanEngine>(
                                                       bsProcess,
                                                       foreignRiskFreeRate,
                                                       exchangeRateVolatility,
                                                       correlation));
        }
SWIGINTERN QuantoForwardEuropeanEnginePtr *new_QuantoForwardEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle< YieldTermStructure > const &foreignRiskFreeRate,Handle< BlackVolTermStructure > const &exchangeRateVolatility,Handle< Quote > const &correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new QuantoForwardEuropeanEnginePtr(
                new QuantoEngine<ForwardVanillaOption,AnalyticEuropeanEngine>(
                                                       bsProcess,
                                                       foreignRiskFreeRate,
                                                       exchangeRateVolatility,
                                                       correlation));
        }

using QuantLib::BlackCalculator;

SWIGINTERN BlackCalculator *new_BlackCalculator__SWIG_0(boost::shared_ptr< Payoff > const &payoff,Real forward,Real stdDev,Real discount=1.0){

            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);

            QL_REQUIRE(stPayoff, "wrong payoff given");

            return new BlackCalculator(stPayoff,forward,stdDev,discount);
        }

using QuantLib::Average;
using QuantLib::ContinuousAveragingAsianOption;
using QuantLib::DiscreteAveragingAsianOption;
typedef boost::shared_ptr<Instrument> ContinuousAveragingAsianOptionPtr;
typedef boost::shared_ptr<Instrument> DiscreteAveragingAsianOptionPtr;

SWIGINTERN ContinuousAveragingAsianOptionPtr *new_ContinuousAveragingAsianOptionPtr(Average::Type averageType,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new ContinuousAveragingAsianOptionPtr(
                       new ContinuousAveragingAsianOption(averageType,
                                                          stPayoff,exercise));
        }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_delta(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->delta();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_gamma(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->gamma();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_theta(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->theta();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_thetaPerDay(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->thetaPerDay();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_vega(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->vega();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_rho(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->rho();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_dividendRho(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->dividendRho();
    }
SWIGINTERN Real ContinuousAveragingAsianOptionPtr_strikeSensitivity(ContinuousAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<ContinuousAveragingAsianOption>(*self)->strikeSensitivity();
    }
SWIGINTERN DiscreteAveragingAsianOptionPtr *new_DiscreteAveragingAsianOptionPtr(Average::Type averageType,Real runningAccumulator,Size pastFixings,std::vector< Date > const &fixingDates,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DiscreteAveragingAsianOptionPtr(
                          new DiscreteAveragingAsianOption(averageType,
                                                           runningAccumulator,
                                                           pastFixings,
                                                           fixingDates,
                                                           stPayoff,
                                                           exercise));
        }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_delta(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->delta();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_gamma(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->gamma();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_theta(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->theta();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_thetaPerDay(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->thetaPerDay();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_vega(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->vega();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_rho(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->rho();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_dividendRho(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->dividendRho();
    }
SWIGINTERN Real DiscreteAveragingAsianOptionPtr_strikeSensitivity(DiscreteAveragingAsianOptionPtr *self){
        return boost::dynamic_pointer_cast<DiscreteAveragingAsianOption>(*self)->strikeSensitivity();
    }

using QuantLib::AnalyticContinuousGeometricAveragePriceAsianEngine;
typedef boost::shared_ptr<PricingEngine>
    AnalyticContinuousGeometricAveragePriceAsianEnginePtr;

SWIGINTERN AnalyticContinuousGeometricAveragePriceAsianEnginePtr *new_AnalyticContinuousGeometricAveragePriceAsianEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticContinuousGeometricAveragePriceAsianEnginePtr(
                new AnalyticContinuousGeometricAveragePriceAsianEngine(
                                                                  bsProcess));
        }

using QuantLib::AnalyticDiscreteGeometricAveragePriceAsianEngine;
typedef boost::shared_ptr<PricingEngine>
    AnalyticDiscreteGeometricAveragePriceAsianEnginePtr;

SWIGINTERN AnalyticDiscreteGeometricAveragePriceAsianEnginePtr *new_AnalyticDiscreteGeometricAveragePriceAsianEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDiscreteGeometricAveragePriceAsianEnginePtr(
                new AnalyticDiscreteGeometricAveragePriceAsianEngine(
                                                                  bsProcess));
        }

using QuantLib::AnalyticDiscreteGeometricAverageStrikeAsianEngine;
typedef boost::shared_ptr<PricingEngine>
    AnalyticDiscreteGeometricAverageStrikeAsianEnginePtr;

SWIGINTERN AnalyticDiscreteGeometricAverageStrikeAsianEnginePtr *new_AnalyticDiscreteGeometricAverageStrikeAsianEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDiscreteGeometricAverageStrikeAsianEnginePtr(
                new AnalyticDiscreteGeometricAverageStrikeAsianEngine(
                                                                  bsProcess));
        }

using QuantLib::MCDiscreteArithmeticAPEngine;
typedef boost::shared_ptr<PricingEngine> MCDiscreteArithmeticAPEnginePtr;

SWIGINTERN MCDiscreteArithmeticAPEnginePtr *new_MCDiscreteArithmeticAPEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCDiscreteArithmeticAPEnginePtr(
                         new MCDiscreteArithmeticAPEngine<PseudoRandom>(
                                                            bsProcess,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCDiscreteArithmeticAPEnginePtr(
                       new MCDiscreteArithmeticAPEngine<LowDiscrepancy>(
                                                            bsProcess,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::MCDiscreteArithmeticASEngine;
typedef boost::shared_ptr<PricingEngine> MCDiscreteArithmeticASEnginePtr;

SWIGINTERN MCDiscreteArithmeticASEnginePtr *new_MCDiscreteArithmeticASEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCDiscreteArithmeticASEnginePtr(
                         new MCDiscreteArithmeticASEngine<PseudoRandom>(
                                                            bsProcess,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCDiscreteArithmeticASEnginePtr(
                       new MCDiscreteArithmeticASEngine<LowDiscrepancy>(
                                                            bsProcess,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::MCDiscreteGeometricAPEngine;
typedef boost::shared_ptr<PricingEngine> MCDiscreteGeometricAPEnginePtr;

SWIGINTERN MCDiscreteGeometricAPEnginePtr *new_MCDiscreteGeometricAPEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCDiscreteGeometricAPEnginePtr(
                         new MCDiscreteGeometricAPEngine<PseudoRandom>(
                                                            bsProcess,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCDiscreteGeometricAPEnginePtr(
                       new MCDiscreteGeometricAPEngine<LowDiscrepancy>(
                                                            bsProcess,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::VarianceGammaEngine;
typedef boost::shared_ptr<PricingEngine>
    VarianceGammaEnginePtr;

SWIGINTERN VarianceGammaEnginePtr *new_VarianceGammaEnginePtr(VarianceGammaProcessPtr const &process){
            boost::shared_ptr<VarianceGammaProcess> vgProcess =
                boost::dynamic_pointer_cast<VarianceGammaProcess>(process);
            QL_REQUIRE(vgProcess, "Variance-Gamma process required");
            return new VarianceGammaEnginePtr(new VarianceGammaEngine(vgProcess));
        }

using QuantLib::FFTVarianceGammaEngine;
typedef boost::shared_ptr<PricingEngine>
    FFTVarianceGammaEnginePtr;

SWIGINTERN FFTVarianceGammaEnginePtr *new_FFTVarianceGammaEnginePtr__SWIG_0(VarianceGammaProcessPtr const &process,Real logStrikeSpacing=0.001){
            boost::shared_ptr<VarianceGammaProcess> vgProcess =
                boost::dynamic_pointer_cast<VarianceGammaProcess>(process);
            QL_REQUIRE(vgProcess, "Variance Gamma process required");
            return new FFTVarianceGammaEnginePtr(new FFTVarianceGammaEngine(vgProcess, logStrikeSpacing));
        }
SWIGINTERN void FFTVarianceGammaEnginePtr_precalculate(FFTVarianceGammaEnginePtr *self,std::vector< boost::shared_ptr< Instrument > > const &optionList){
            boost::dynamic_pointer_cast<FFTVarianceGammaEngine>(*self)->precalculate(optionList);
        }

using QuantLib::DoubleBarrierOption;
using QuantLib::DoubleBarrier;


using QuantLib::DoubleBarrierOption;
typedef boost::shared_ptr<Instrument> DoubleBarrierOptionPtr;

SWIGINTERN DoubleBarrierOptionPtr *new_DoubleBarrierOptionPtr(DoubleBarrier::Type barrierType,Real barrier_lo,Real barrier_hi,Real rebate,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DoubleBarrierOptionPtr(
                               new DoubleBarrierOption(barrierType, barrier_lo, 
                                                 barrier_hi, rebate,
                                                 stPayoff,exercise));
        }
SWIGINTERN Real DoubleBarrierOptionPtr_delta(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->delta();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_gamma(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->gamma();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_theta(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->theta();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_thetaPerDay(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->thetaPerDay();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_vega(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->vega();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_rho(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->rho();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_dividendRho(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->dividendRho();
    }
SWIGINTERN Real DoubleBarrierOptionPtr_strikeSensitivity(DoubleBarrierOptionPtr *self){
        return boost::dynamic_pointer_cast<DoubleBarrierOption>(*self)->strikeSensitivity();
    }

using QuantLib::QuantoDoubleBarrierOption;
typedef boost::shared_ptr<Instrument> QuantoDoubleBarrierOptionPtr;

SWIGINTERN QuantoDoubleBarrierOptionPtr *new_QuantoDoubleBarrierOptionPtr(DoubleBarrier::Type barrierType,Real barrier_lo,Real barrier_hi,Real rebate,boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoDoubleBarrierOptionPtr(
                         new QuantoDoubleBarrierOption(barrierType, barrier_lo, 
                                      barrier_hi, rebate, stPayoff, exercise));
        }
SWIGINTERN Real QuantoDoubleBarrierOptionPtr_qvega(QuantoDoubleBarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoDoubleBarrierOption>(*self)
                ->qvega();
        }
SWIGINTERN Real QuantoDoubleBarrierOptionPtr_qrho(QuantoDoubleBarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoDoubleBarrierOption>(*self)
                ->qrho();
        }
SWIGINTERN Real QuantoDoubleBarrierOptionPtr_qlambda(QuantoDoubleBarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoDoubleBarrierOption>(*self)
                ->qlambda();
        }

using QuantLib::AnalyticDoubleBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDoubleBarrierEnginePtr;

SWIGINTERN AnalyticDoubleBarrierEnginePtr *new_AnalyticDoubleBarrierEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,int series=5){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDoubleBarrierEnginePtr(
                            new AnalyticDoubleBarrierEngine(bsProcess, series));
        }

using QuantLib::WulinYongDoubleBarrierEngine;
typedef boost::shared_ptr<PricingEngine> WulinYongDoubleBarrierEnginePtr;

SWIGINTERN WulinYongDoubleBarrierEnginePtr *new_WulinYongDoubleBarrierEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,int series=5){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new WulinYongDoubleBarrierEnginePtr(
                            new WulinYongDoubleBarrierEngine(bsProcess, series));
        }

using QuantLib::VannaVolgaDoubleBarrierEngine;
using QuantLib::DeltaVolQuote;
typedef boost::shared_ptr<PricingEngine> VannaVolgaDoubleBarrierEnginePtr;

SWIGINTERN bool boost_shared_ptr_Sl_DeltaVolQuote_Sg__isNull(boost::shared_ptr< DeltaVolQuote > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_DeltaVolQuote_Sg__asObservable(boost::shared_ptr< DeltaVolQuote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< DeltaVolQuote > *new_boost_shared_ptr_Sl_DeltaVolQuote_Sg___SWIG_0(Real delta,Handle< Quote > const &vol,Time maturity,DeltaVolQuote::DeltaType deltaType){
        return new boost::shared_ptr<DeltaVolQuote>(
                          new DeltaVolQuote(delta, vol, maturity, deltaType));
    }
SWIGINTERN boost::shared_ptr< DeltaVolQuote > *new_boost_shared_ptr_Sl_DeltaVolQuote_Sg___SWIG_1(Handle< Quote > const &vol,DeltaVolQuote::DeltaType deltaType,Time maturity,DeltaVolQuote::AtmType atmType){
        return new boost::shared_ptr<DeltaVolQuote>(
                        new DeltaVolQuote(vol, deltaType, maturity, atmType));
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_DeltaVolQuote_Sg__asObservable(Handle< DeltaVolQuote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN VannaVolgaDoubleBarrierEnginePtr *new_VannaVolgaDoubleBarrierEnginePtr__SWIG_0(Handle< DeltaVolQuote > const atmVol,Handle< DeltaVolQuote > const vol25Put,Handle< DeltaVolQuote > const vol25Call,Handle< Quote > const spotFX,Handle< YieldTermStructure > const domesticTS,Handle< YieldTermStructure > const foreignTS,std::string const &type="ik",bool const adaptVanDelta=false,Real const bsPriceWithSmile=0.0,int series=5){
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "ik" || s == "analytic")
                return new VannaVolgaDoubleBarrierEnginePtr(
                   new VannaVolgaDoubleBarrierEngine<AnalyticDoubleBarrierEngine>(
                                        atmVol, vol25Put, vol25Call, spotFX, 
                                        domesticTS, foreignTS, adaptVanDelta, 
                                        bsPriceWithSmile, series));
            else if (s == "wo")
                return new VannaVolgaDoubleBarrierEnginePtr(
                   new VannaVolgaDoubleBarrierEngine<WulinYongDoubleBarrierEngine>(
                                        atmVol, vol25Put, vol25Call, spotFX, 
                                        domesticTS, foreignTS, adaptVanDelta, 
                                        bsPriceWithSmile, series));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::AnalyticDoubleBarrierBinaryEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDoubleBarrierBinaryEnginePtr;

SWIGINTERN AnalyticDoubleBarrierBinaryEnginePtr *new_AnalyticDoubleBarrierBinaryEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDoubleBarrierBinaryEnginePtr(
                            new AnalyticDoubleBarrierBinaryEngine(bsProcess));
        }

using QuantLib::BinomialDoubleBarrierEngine;
using QuantLib::DiscretizedDermanKaniDoubleBarrierOption;
typedef boost::shared_ptr<PricingEngine> BinomialDoubleBarrierEnginePtr;

SWIGINTERN BinomialDoubleBarrierEnginePtr *new_BinomialDoubleBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<CoxRossRubinstein,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<JarrowRudd,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else if (s == "eqp" || s == "additiveeqpbinomialtree")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<AdditiveEQPBinomialTree,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<Trigeorgis,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else if (s == "tian")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<Tian,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<LeisenReimer,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialDoubleBarrierEnginePtr(
                    new BinomialDoubleBarrierEngine<Joshi4,
                                     DiscretizedDermanKaniDoubleBarrierOption>(
                                                  bsProcess,steps));
            else
                QL_FAIL("unknown binomial double barrier engine type: "+s);
        }

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
using QuantLib::GapPayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;
typedef boost::shared_ptr<Payoff> GapPayoffPtr;

SWIGINTERN PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
SWIGINTERN Option::Type PlainVanillaPayoffPtr_optionType(PlainVanillaPayoffPtr *self){
          	return boost::dynamic_pointer_cast<
									PlainVanillaPayoff>(*self)->optionType();
		}
SWIGINTERN Real PlainVanillaPayoffPtr_strike(PlainVanillaPayoffPtr *self){
          	return boost::dynamic_pointer_cast<
									PlainVanillaPayoff>(*self)->strike();
		}
SWIGINTERN PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
SWIGINTERN CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
SWIGINTERN AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
SWIGINTERN SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }
SWIGINTERN GapPayoffPtr *new_GapPayoffPtr(Option::Type type,Real strike,Real strikePayoff){
            return new GapPayoffPtr(
                               new GapPayoff(type, strike, strikePayoff));
        }

using QuantLib::BasketOption;
using QuantLib::BasketPayoff;
using QuantLib::MinBasketPayoff;
using QuantLib::MaxBasketPayoff;
using QuantLib::AverageBasketPayoff;
typedef boost::shared_ptr<Instrument> BasketOptionPtr;
typedef boost::shared_ptr<Payoff> BasketPayoffPtr;
typedef boost::shared_ptr<Payoff> MinBasketPayoffPtr;
typedef boost::shared_ptr<Payoff> MaxBasketPayoffPtr;
typedef boost::shared_ptr<Payoff> AverageBasketPayoffPtr;

SWIGINTERN MinBasketPayoffPtr *new_MinBasketPayoffPtr(boost::shared_ptr< Payoff > const p){
            return new MinBasketPayoffPtr(new MinBasketPayoff(p));
        }
SWIGINTERN MaxBasketPayoffPtr *new_MaxBasketPayoffPtr(boost::shared_ptr< Payoff > const p){
            return new MaxBasketPayoffPtr(new MaxBasketPayoff(p));
        }
SWIGINTERN AverageBasketPayoffPtr *new_AverageBasketPayoffPtr__SWIG_0(boost::shared_ptr< Payoff > const p,Array const &a){
            return new AverageBasketPayoffPtr(new AverageBasketPayoff(p, a));
        }
SWIGINTERN AverageBasketPayoffPtr *new_AverageBasketPayoffPtr__SWIG_1(boost::shared_ptr< Payoff > const p,Size n){
            return new AverageBasketPayoffPtr(new AverageBasketPayoff(p, n));
        }
SWIGINTERN BasketOptionPtr *new_BasketOptionPtr(boost::shared_ptr< Payoff > const &payoff,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<BasketPayoff> stPayoff =
                 boost::dynamic_pointer_cast<BasketPayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BasketOptionPtr(new BasketOption(stPayoff,exercise));
        }

using QuantLib::MCEuropeanBasketEngine;
typedef boost::shared_ptr<PricingEngine> MCEuropeanBasketEnginePtr;

SWIGINTERN MCEuropeanBasketEnginePtr *new_MCEuropeanBasketEnginePtr__SWIG_0(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanBasketEnginePtr(
                   new MCEuropeanBasketEngine<PseudoRandom>(processes,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanBasketEnginePtr(
                   new MCEuropeanBasketEngine<LowDiscrepancy>(processes,
                                                              timeSteps,
                                                              timeStepsPerYear,
                                                              brownianBridge,
                                                              antitheticVariate,
                                                              requiredSamples,
                                                              requiredTolerance,
                                                              maxSamples,
                                                              seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::MCAmericanBasketEngine;
typedef boost::shared_ptr<PricingEngine> MCAmericanBasketEnginePtr;

SWIGINTERN MCAmericanBasketEnginePtr *new_MCAmericanBasketEnginePtr__SWIG_0(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                  return new MCAmericanBasketEnginePtr(
                  new MCAmericanBasketEngine<PseudoRandom>(processes,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCAmericanBasketEnginePtr(
                new MCAmericanBasketEngine<LowDiscrepancy>(processes,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::StulzEngine;
typedef boost::shared_ptr<PricingEngine> StulzEnginePtr;

SWIGINTERN StulzEnginePtr *new_StulzEnginePtr(GeneralizedBlackScholesProcessPtr const &process1,GeneralizedBlackScholesProcessPtr const &process2,Real correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess1 =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                    process1);
            QL_REQUIRE(bsProcess1, "Black-Scholes process required");
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess2 =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                    process2);
            QL_REQUIRE(bsProcess2, "Black-Scholes process required");
            return new StulzEnginePtr(
                          new StulzEngine(bsProcess1,bsProcess2,correlation));
        }

using QuantLib::EverestOption;
typedef boost::shared_ptr<Instrument> EverestOptionPtr;
using QuantLib::MCEverestEngine;
typedef boost::shared_ptr<PricingEngine> MCEverestEnginePtr;

SWIGINTERN EverestOptionPtr *new_EverestOptionPtr(Real notional,Rate guarantee,boost::shared_ptr< Exercise > const &exercise){
            return new EverestOptionPtr(new EverestOption(notional,guarantee,
                                                          exercise));
        }
SWIGINTERN MCEverestEnginePtr *new_MCEverestEnginePtr__SWIG_0(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeSteps=Null< Size >(),Size timeStepsPerYear=Null< Size >(),bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCEverestEnginePtr(
                        new MCEverestEngine<PseudoRandom>(processes,
                                                          timeSteps,
                                                          timeStepsPerYear,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEverestEnginePtr(
                      new MCEverestEngine<LowDiscrepancy>(processes,
                                                          timeSteps,
                                                          timeStepsPerYear,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::HimalayaOption;
typedef boost::shared_ptr<Instrument> HimalayaOptionPtr;
using QuantLib::MCHimalayaEngine;
typedef boost::shared_ptr<PricingEngine> MCHimalayaEnginePtr;

SWIGINTERN HimalayaOptionPtr *new_HimalayaOptionPtr(std::vector< Date > const &fixingDates,Real strike){
            return new HimalayaOptionPtr(new HimalayaOption(fixingDates,
                                                            strike));
        }
SWIGINTERN MCHimalayaEnginePtr *new_MCHimalayaEnginePtr__SWIG_0(StochasticProcessArrayPtr const &process,std::string const &traits,bool brownianBridge=false,bool antitheticVariate=false,intOrNull requiredSamples=Null< Size >(),doubleOrNull requiredTolerance=Null< Real >(),intOrNull maxSamples=Null< Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCHimalayaEnginePtr(
                       new MCHimalayaEngine<PseudoRandom>(processes,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCHimalayaEnginePtr(
                     new MCHimalayaEngine<LowDiscrepancy>(processes,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::blackFormula;
using QuantLib::blackFormulaImpliedStdDev;
using QuantLib::blackFormulaCashItmProbability;
using QuantLib::bachelierBlackFormula;
using QuantLib::bachelierBlackFormulaImpliedVol;


using QuantLib::BlackDeltaCalculator;


using QuantLib::Callability;
using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> CallabilityPtr;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;
typedef Callability::Price CallabilityPrice;
using QuantLib::CallabilitySchedule;

SWIGINTERN bool boost_shared_ptr_Sl_Callability_Sg__isNull(boost::shared_ptr< Callability > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Callability > *new_boost_shared_ptr_Sl_Callability_Sg_(CallabilityPrice const &price,Callability::Type type,Date const &date){
        return new boost::shared_ptr<Callability>(
                                            new Callability(price,type,date));
    }

using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;

SWIGINTERN SoftCallabilityPtr *new_SoftCallabilityPtr(CallabilityPrice const &price,Date const &date,Real trigger){
            return new SoftCallabilityPtr(new SoftCallability(price,date,
                                                              trigger));
        }
SWIGINTERN std::vector< boost::shared_ptr< Callability > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__get(std::vector< boost::shared_ptr< Callability > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__set(std::vector< boost::shared_ptr< Callability > > *self,int i,std::vector< boost::shared_ptr< Callability > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

  using QuantLib::Seasonality;
  using QuantLib::MultiplicativePriceSeasonality;
  typedef boost::shared_ptr<Seasonality> MultiplicativePriceSeasonalityPtr;

SWIGINTERN bool boost_shared_ptr_Sl_Seasonality_Sg__isNull(boost::shared_ptr< Seasonality > *self){
                return !(*self);
            }
SWIGINTERN MultiplicativePriceSeasonalityPtr *new_MultiplicativePriceSeasonalityPtr(Date const &seasonalityBaseDate,Frequency frequency,std::vector< Rate > const &seasonalityFactors){
            return new MultiplicativePriceSeasonalityPtr(
                       new MultiplicativePriceSeasonality(seasonalityBaseDate,
                                                          frequency,
                                                          seasonalityFactors));
        }

  using QuantLib::InflationTermStructure;
  using QuantLib::YoYInflationTermStructure;
  using QuantLib::ZeroInflationTermStructure;

SWIGINTERN bool boost_shared_ptr_Sl_YoYInflationTermStructure_Sg__isNull(boost::shared_ptr< YoYInflationTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_YoYInflationTermStructure_Sg__asObservable(boost::shared_ptr< YoYInflationTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_YoYInflationTermStructure_Sg__asObservable(Handle< YoYInflationTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_ZeroInflationTermStructure_Sg__isNull(boost::shared_ptr< ZeroInflationTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_ZeroInflationTermStructure_Sg__asObservable(boost::shared_ptr< ZeroInflationTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_ZeroInflationTermStructure_Sg__asObservable(Handle< ZeroInflationTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

#include <ql/indexes/inflationindex.hpp>
#include <ql/indexes/inflation/all.hpp>
using QuantLib::Region;
using QuantLib::CustomRegion;
using QuantLib::InflationIndex;
using QuantLib::ZeroInflationIndex;
using QuantLib::YoYInflationIndex;
typedef boost::shared_ptr<Index> InflationIndexPtr;
typedef boost::shared_ptr<Index> ZeroInflationIndexPtr;
typedef boost::shared_ptr<Index> YoYInflationIndexPtr;

SWIGINTERN bool InflationIndexPtr_interpolated(InflationIndexPtr const *self){
            return boost::dynamic_pointer_cast<InflationIndex>(*self)
                ->interpolated();
        }
SWIGINTERN Frequency InflationIndexPtr_frequency(InflationIndexPtr const *self){
            return boost::dynamic_pointer_cast<InflationIndex>(*self)
                ->frequency();
        }
SWIGINTERN Period InflationIndexPtr_availabilityLag(InflationIndexPtr const *self){
            return boost::dynamic_pointer_cast<InflationIndex>(*self)
                ->availabilityLag();
        }
SWIGINTERN Currency InflationIndexPtr_currency(InflationIndexPtr const *self){
            return boost::dynamic_pointer_cast<InflationIndex>(*self)
                ->currency();
        }
SWIGINTERN ZeroInflationIndexPtr *new_ZeroInflationIndexPtr__SWIG_0(std::string const &familyName,Region const &region,bool revised,bool interpolated,Frequency frequency,Period const &availabilityLag,Currency const &currency,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new ZeroInflationIndexPtr(
              new ZeroInflationIndex(familyName, region, revised, interpolated,
                                     frequency, availabilityLag, currency, h));
      }

using QuantLib::EUHICP;
typedef boost::shared_ptr<Index> EUHICPPtr;

SWIGINTERN EUHICPPtr *new_EUHICPPtr__SWIG_0(bool interpolated,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new EUHICPPtr(new EUHICP(interpolated,h));
      }

using QuantLib::EUHICPXT;
typedef boost::shared_ptr<Index> EUHICPXTPtr;

SWIGINTERN EUHICPXTPtr *new_EUHICPXTPtr__SWIG_0(bool interpolated,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new EUHICPXTPtr(new EUHICPXT(interpolated,h));
      }

using QuantLib::FRHICP;
typedef boost::shared_ptr<Index> FRHICPPtr;

SWIGINTERN FRHICPPtr *new_FRHICPPtr__SWIG_0(bool interpolated,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new FRHICPPtr(new FRHICP(interpolated,h));
      }

using QuantLib::UKRPI;
typedef boost::shared_ptr<Index> UKRPIPtr;

SWIGINTERN UKRPIPtr *new_UKRPIPtr__SWIG_0(bool interpolated,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new UKRPIPtr(new UKRPI(interpolated,h));
      }

using QuantLib::USCPI;
typedef boost::shared_ptr<Index> USCPIPtr;

SWIGINTERN USCPIPtr *new_USCPIPtr__SWIG_0(bool interpolated,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new USCPIPtr(new USCPI(interpolated,h));
      }

using QuantLib::ZACPI;
typedef boost::shared_ptr<Index> ZACPIPtr;

SWIGINTERN ZACPIPtr *new_ZACPIPtr__SWIG_0(bool interpolated,Handle< ZeroInflationTermStructure > const &h=Handle< ZeroInflationTermStructure >()){
          return new ZACPIPtr(new ZACPI(interpolated,h));
      }

using QuantLib::YYEUHICP;
typedef boost::shared_ptr<Index> YYEUHICPPtr;

SWIGINTERN YYEUHICPPtr *new_YYEUHICPPtr__SWIG_0(bool interpolated,Handle< YoYInflationTermStructure > const &h=Handle< YoYInflationTermStructure >()){
          return new YYEUHICPPtr(new YYEUHICP(interpolated,h));
      }

using QuantLib::YYEUHICPXT;
typedef boost::shared_ptr<Index> YYEUHICPXTPtr;

SWIGINTERN YYEUHICPXTPtr *new_YYEUHICPXTPtr__SWIG_0(bool interpolated,Handle< YoYInflationTermStructure > const &h=Handle< YoYInflationTermStructure >()){
          return new YYEUHICPXTPtr(new YYEUHICPXT(interpolated,h));
      }

using QuantLib::YYFRHICP;
typedef boost::shared_ptr<Index> YYFRHICPPtr;

SWIGINTERN YYFRHICPPtr *new_YYFRHICPPtr__SWIG_0(bool interpolated,Handle< YoYInflationTermStructure > const &h=Handle< YoYInflationTermStructure >()){
          return new YYFRHICPPtr(new YYFRHICP(interpolated,h));
      }

using QuantLib::YYUKRPI;
typedef boost::shared_ptr<Index> YYUKRPIPtr;

SWIGINTERN YYUKRPIPtr *new_YYUKRPIPtr__SWIG_0(bool interpolated,Handle< YoYInflationTermStructure > const &h=Handle< YoYInflationTermStructure >()){
          return new YYUKRPIPtr(new YYUKRPI(interpolated,h));
      }

using QuantLib::YYUSCPI;
typedef boost::shared_ptr<Index> YYUSCPIPtr;

SWIGINTERN YYUSCPIPtr *new_YYUSCPIPtr__SWIG_0(bool interpolated,Handle< YoYInflationTermStructure > const &h=Handle< YoYInflationTermStructure >()){
          return new YYUSCPIPtr(new YYUSCPI(interpolated,h));
      }

using QuantLib::YYZACPI;
typedef boost::shared_ptr<Index> YYZACPIPtr;

SWIGINTERN YYZACPIPtr *new_YYZACPIPtr__SWIG_0(bool interpolated,Handle< YoYInflationTermStructure > const &h=Handle< YoYInflationTermStructure >()){
          return new YYZACPIPtr(new YYZACPI(interpolated,h));
      }

    using QuantLib::CPI;


typedef QuantLib::BootstrapHelper<ZeroInflationTermStructure> ZeroHelper;
typedef QuantLib::BootstrapHelper<YoYInflationTermStructure> YoYHelper;

using QuantLib::ZeroCouponInflationSwapHelper;
typedef boost::shared_ptr<ZeroHelper> ZeroCouponInflationSwapHelperPtr;

using QuantLib::YearOnYearInflationSwapHelper;
typedef boost::shared_ptr<YoYHelper> YearOnYearInflationSwapHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_ZeroHelper_Sg__isNull(boost::shared_ptr< ZeroHelper > *self){
                return !(*self);
            }
SWIGINTERN bool boost_shared_ptr_Sl_YoYHelper_Sg__isNull(boost::shared_ptr< YoYHelper > *self){
                return !(*self);
            }
SWIGINTERN std::vector< boost::shared_ptr< ZeroHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_ZeroHelper_Sg__Sg__get(std::vector< boost::shared_ptr< ZeroHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_ZeroHelper_Sg__Sg__set(std::vector< boost::shared_ptr< ZeroHelper > > *self,int i,std::vector< boost::shared_ptr< ZeroHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< boost::shared_ptr< YoYHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_YoYHelper_Sg__Sg__get(std::vector< boost::shared_ptr< YoYHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_YoYHelper_Sg__Sg__set(std::vector< boost::shared_ptr< YoYHelper > > *self,int i,std::vector< boost::shared_ptr< YoYHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN ZeroCouponInflationSwapHelperPtr *new_ZeroCouponInflationSwapHelperPtr(Rate rate,Period const &lag,Date const &maturity,Calendar const &calendar,BusinessDayConvention bdc,DayCounter const &dayCounter,ZeroInflationIndexPtr const &index){
            Handle<Quote> quote(
                boost::shared_ptr<Quote>(new SimpleQuote(rate)));
            boost::shared_ptr<ZeroInflationIndex> zeroIndex =
                boost::dynamic_pointer_cast<ZeroInflationIndex>(index);
            return new ZeroCouponInflationSwapHelperPtr(
                new ZeroCouponInflationSwapHelper(quote,lag,maturity,
                                                  calendar,bdc,
                                                  dayCounter,zeroIndex));
        }
SWIGINTERN YearOnYearInflationSwapHelperPtr *new_YearOnYearInflationSwapHelperPtr(Rate rate,Period const &lag,Date const &maturity,Calendar const &calendar,BusinessDayConvention bdc,DayCounter const &dayCounter,YoYInflationIndexPtr const &index){
            Handle<Quote> quote(
                boost::shared_ptr<Quote>(new SimpleQuote(rate)));
            boost::shared_ptr<YoYInflationIndex> yoyIndex =
                boost::dynamic_pointer_cast<YoYInflationIndex>(index);
            return new YearOnYearInflationSwapHelperPtr(
                new YearOnYearInflationSwapHelper(quote,lag,maturity,
                                                  calendar,bdc,
                                                  dayCounter,yoyIndex));
        }

using QuantLib::PiecewiseZeroInflationCurve;
using QuantLib::PiecewiseYoYInflationCurve;


typedef boost::shared_ptr<ZeroInflationTermStructure> PiecewiseZeroInflationPtr;

SWIGINTERN PiecewiseZeroInflationPtr *new_PiecewiseZeroInflationPtr__SWIG_0(Date const &referenceDate,Calendar const &calendar,DayCounter const &dayCounter,Period const &lag,Frequency frequency,bool indexIsInterpolated,Rate baseRate,Handle< YieldTermStructure > const &nominalTS,std::vector< boost::shared_ptr< ZeroHelper > > const &instruments,Real accuracy=1.0e-12,Linear const &i=Linear()){
            return new PiecewiseZeroInflationPtr(
                new PiecewiseZeroInflationCurve<Linear>(
                                        referenceDate, calendar, dayCounter,
                                        lag, frequency, indexIsInterpolated,
                                        baseRate, nominalTS, instruments,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseZeroInflationPtr_dates(PiecewiseZeroInflationPtr *self){
            typedef PiecewiseZeroInflationCurve<Linear> PiecewiseZeroInflation;
            return boost::dynamic_pointer_cast<PiecewiseZeroInflation>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseZeroInflationPtr_times(PiecewiseZeroInflationPtr *self){
            typedef PiecewiseZeroInflationCurve<Linear> PiecewiseZeroInflation;
            return boost::dynamic_pointer_cast<PiecewiseZeroInflation>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseZeroInflationPtr_nodes(PiecewiseZeroInflationPtr *self){
            typedef PiecewiseZeroInflationCurve<Linear> PiecewiseZeroInflation;
            return boost::dynamic_pointer_cast<PiecewiseZeroInflation>(*self)->nodes();
        }

typedef boost::shared_ptr<YoYInflationTermStructure> PiecewiseYoYInflationPtr;

SWIGINTERN PiecewiseYoYInflationPtr *new_PiecewiseYoYInflationPtr__SWIG_0(Date const &referenceDate,Calendar const &calendar,DayCounter const &dayCounter,Period const &lag,Frequency frequency,bool indexIsInterpolated,Rate baseRate,Handle< YieldTermStructure > const &nominalTS,std::vector< boost::shared_ptr< YoYHelper > > const &instruments,Real accuracy=1.0e-12,Linear const &i=Linear()){
            return new PiecewiseYoYInflationPtr(
                new PiecewiseYoYInflationCurve<Linear>(
                                        referenceDate, calendar, dayCounter,
                                        lag, frequency, indexIsInterpolated,
                                        baseRate, nominalTS, instruments,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseYoYInflationPtr_dates(PiecewiseYoYInflationPtr *self){
            typedef PiecewiseYoYInflationCurve<Linear> PiecewiseYoYInflation;
            return boost::dynamic_pointer_cast<PiecewiseYoYInflation>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseYoYInflationPtr_times(PiecewiseYoYInflationPtr *self){
            typedef PiecewiseYoYInflationCurve<Linear> PiecewiseYoYInflation;
            return boost::dynamic_pointer_cast<PiecewiseYoYInflation>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseYoYInflationPtr_nodes(PiecewiseYoYInflationPtr *self){
            typedef PiecewiseYoYInflationCurve<Linear> PiecewiseYoYInflation;
            return boost::dynamic_pointer_cast<PiecewiseYoYInflation>(*self)->nodes();
        }


    Date inflationBaseDate(const Date& referenceDate,
                           const Period& observationLag,
                           Frequency frequency,
                           bool indexIsInterpolated) {
        if (indexIsInterpolated) {
            return referenceDate - observationLag;
        } else {
            return QuantLib::inflationPeriod(referenceDate - observationLag,
                                             frequency).first;
        }
    }



using QuantLib::ZeroCouponInflationSwap;
using QuantLib::YearOnYearInflationSwap;
typedef boost::shared_ptr<Instrument> ZeroCouponInflationSwapPtr;
typedef boost::shared_ptr<Instrument> YearOnYearInflationSwapPtr;

SWIGINTERN ZeroCouponInflationSwapPtr *new_ZeroCouponInflationSwapPtr__SWIG_0(ZeroCouponInflationSwap::Type type,Real nominal,Date const &start,Date const &maturity,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate fixedRate,ZeroInflationIndexPtr const &index,Period const &lag,bool adjustInfObsDates=false,Calendar infCalendar=Calendar(),BusinessDayConvention infConvention=Following){
            boost::shared_ptr<ZeroInflationIndex> zeroIndex =
                boost::dynamic_pointer_cast<ZeroInflationIndex>(index);
            return new ZeroCouponInflationSwapPtr(
                new ZeroCouponInflationSwap(type, nominal, start, maturity,
                                            calendar, convention, dayCounter,
                                            fixedRate, zeroIndex, lag,
                                            adjustInfObsDates,
                                            infCalendar, infConvention));
        }
SWIGINTERN Rate ZeroCouponInflationSwapPtr_fairRate(ZeroCouponInflationSwapPtr *self){
            return boost::dynamic_pointer_cast<ZeroCouponInflationSwap>(*self)
                ->fairRate();
        }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > ZeroCouponInflationSwapPtr_fixedLeg(ZeroCouponInflationSwapPtr *self){
            return boost::dynamic_pointer_cast<ZeroCouponInflationSwap>(*self)
                ->fixedLeg();
        }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > ZeroCouponInflationSwapPtr_inflationLeg(ZeroCouponInflationSwapPtr *self){
            return boost::dynamic_pointer_cast<ZeroCouponInflationSwap>(*self)
                ->inflationLeg();
        }
SWIGINTERN ZeroCouponInflationSwap::Type ZeroCouponInflationSwapPtr_type(ZeroCouponInflationSwapPtr *self){
            return boost::dynamic_pointer_cast<ZeroCouponInflationSwap>(*self)
                ->type();
        }
SWIGINTERN YearOnYearInflationSwapPtr *new_YearOnYearInflationSwapPtr__SWIG_0(YearOnYearInflationSwap::Type type,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCounter,Schedule const &yoySchedule,YoYInflationIndexPtr const &index,Period const &lag,Spread spread,DayCounter const &yoyDayCounter,Calendar const &paymentCalendar,BusinessDayConvention paymentConvention=Following){
            boost::shared_ptr<YoYInflationIndex> yoyIndex =
                boost::dynamic_pointer_cast<YoYInflationIndex>(index);
            return new YearOnYearInflationSwapPtr(
                new YearOnYearInflationSwap(type, nominal, fixedSchedule,
                                            fixedRate, fixedDayCounter,
                                            yoySchedule, yoyIndex, lag, spread,
                                            yoyDayCounter, paymentCalendar,
                                            paymentConvention));
        }
SWIGINTERN Rate YearOnYearInflationSwapPtr_fairRate(YearOnYearInflationSwapPtr *self){
            return boost::dynamic_pointer_cast<YearOnYearInflationSwap>(*self)
                ->fairRate();
        }

using QuantLib::YoYInflationCapFloor;
using QuantLib::YoYInflationCap;
using QuantLib::YoYInflationFloor;
using QuantLib::YoYInflationCollar;

typedef boost::shared_ptr<Instrument> YoYInflationCapFloorPtr;
typedef boost::shared_ptr<Instrument> YoYInflationCapPtr;
typedef boost::shared_ptr<Instrument> YoYInflationFloorPtr;
typedef boost::shared_ptr<Instrument> YoYInflationCollarPtr;

SWIGINTERN Volatility YoYInflationCapFloorPtr_impliedVolatility__SWIG_0(YoYInflationCapFloorPtr const *self,Real price,Handle< YoYInflationTermStructure > const &curve,Volatility guess,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-7,Volatility maxVol=4.0){
             return boost::dynamic_pointer_cast<YoYInflationCapFloor>(*self)->
                 impliedVolatility(price, curve, guess, accuracy,
                                   maxEvaluations, minVol, maxVol);
         }
SWIGINTERN YoYInflationCapPtr *new_YoYInflationCapPtr(std::vector< boost::shared_ptr< CashFlow > > const &leg,std::vector< Rate > const &capRates){
            return new YoYInflationCapPtr(new YoYInflationCap(leg,capRates));
        }
SWIGINTERN YoYInflationFloorPtr *new_YoYInflationFloorPtr(std::vector< boost::shared_ptr< CashFlow > > const &leg,std::vector< Rate > const &floorRates){
            return new YoYInflationFloorPtr(
                                       new YoYInflationFloor(leg,floorRates));
        }
SWIGINTERN YoYInflationCollarPtr *new_YoYInflationCollarPtr(std::vector< boost::shared_ptr< CashFlow > > const &leg,std::vector< Rate > const &capRates,std::vector< Rate > const &floorRates){
            return new YoYInflationCollarPtr(
                             new YoYInflationCollar(leg,capRates,floorRates));
        }

using QuantLib::ShortRateModel;

SWIGINTERN bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr< ShortRateModel > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr< ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_ShortRateModel_Sg__asObservable(Handle< ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

    using QuantLib::Vasicek;
    using QuantLib::HullWhite;
    using QuantLib::BlackKarasinski;
    using QuantLib::G2;
    typedef boost::shared_ptr<ShortRateModel> VasicekPtr;
    typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
    typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
    typedef boost::shared_ptr<ShortRateModel> G2Ptr;

SWIGINTERN VasicekPtr *new_VasicekPtr__SWIG_0(Rate r0=0.05,Real a=0.1,Real b=0.05,Real sigma=0.01,Real lambda=0.0){
            return new VasicekPtr(new Vasicek(r0, a, b, sigma, lambda));
        }
SWIGINTERN DiscountFactor VasicekPtr_discount(VasicekPtr const *self,Time t){
            return boost::dynamic_pointer_cast<Vasicek>(*self)->discount(t);
        }
SWIGINTERN Real VasicekPtr_discountBond(VasicekPtr const *self,Time now,Time maturity,Rate rate){
            return boost::dynamic_pointer_cast<Vasicek>(*self)->discountBond(now, maturity, rate);
        }
SWIGINTERN HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle< YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
            return new HullWhitePtr(
                new HullWhite(termStructure, a, sigma));
        }
SWIGINTERN DiscountFactor HullWhitePtr_discount(HullWhitePtr const *self,Time t){
            return boost::dynamic_pointer_cast<HullWhite>(*self)->discount(t);
        }
SWIGINTERN Real HullWhitePtr_discountBond(HullWhitePtr const *self,Time now,Time maturity,Rate rate){
            return boost::dynamic_pointer_cast<HullWhite>(*self)->
                                            discountBond(now, maturity, rate);  
        }
SWIGINTERN Rate HullWhitePtr_convexityBias(Real futurePrice,Time t,Time T,Real sigma,Real a){
            return QuantLib::HullWhite::convexityBias(futurePrice, t, T, 
                                                      sigma, a);
        }
SWIGINTERN BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle< YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
            return new BlackKarasinskiPtr(
                new BlackKarasinski(termStructure, a, sigma));
        }
SWIGINTERN G2Ptr *new_G2Ptr__SWIG_0(Handle< YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
            return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }
SWIGINTERN DiscountFactor G2Ptr_discount(G2Ptr const *self,Time t){
            return boost::dynamic_pointer_cast<G2>(*self)->discount(t);
        }
SWIGINTERN Real G2Ptr_discountBond(G2Ptr const *self,Time t,Time T,Rate x,Rate y){
            return boost::dynamic_pointer_cast<G2>(*self)->discountBond(t, T, x, y);
        }

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
using QuantLib::FdG2SwaptionEngine;
using QuantLib::FdHullWhiteSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> FdG2SwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> FdHullWhiteSwaptionEnginePtr;

SWIGINTERN JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                               new JamshidianSwaptionEngine(m,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Size timeSteps,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                       new TreeSwaptionEngine(model,timeSteps,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_2(boost::shared_ptr< ShortRateModel > const &model,TimeGrid const &grid,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                            new TreeSwaptionEngine(model,grid,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_4(Handle< ShortRateModel > const &model,Size timeSteps,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                       new TreeSwaptionEngine(model,timeSteps,termStructure));
        }
SWIGINTERN AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                 new AnalyticCapFloorEngine(m,termStructure));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Size timeSteps,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeCapFloorEnginePtr(
                       new TreeCapFloorEngine(model,timeSteps,termStructure));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_2(boost::shared_ptr< ShortRateModel > const &model,TimeGrid const &grid,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeCapFloorEnginePtr(
                            new TreeCapFloorEngine(model,grid,termStructure));
        }
SWIGINTERN G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr< ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }
SWIGINTERN FdG2SwaptionEnginePtr *new_FdG2SwaptionEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Size tGrid=100,Size xGrid=50,Size yGrid=50,Size dampingSteps=0,Real invEps=1e-5,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Hundsdorfer()){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new FdG2SwaptionEnginePtr(
                                    new FdG2SwaptionEngine(g2,tGrid,xGrid,yGrid,dampingSteps,invEps,schemeDesc));
        }
SWIGINTERN FdHullWhiteSwaptionEnginePtr *new_FdHullWhiteSwaptionEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Size tGrid=100,Size xGrid=100,Size dampingSteps=0,Real invEps=1e-5,FdmSchemeDesc const &schemeDesc=FdmSchemeDesc::Douglas()){
            boost::shared_ptr<HullWhite> hw =
                boost::dynamic_pointer_cast<HullWhite>(model);
            return new FdHullWhiteSwaptionEnginePtr(
                                    new FdHullWhiteSwaptionEngine(hw,tGrid,xGrid,dampingSteps,invEps,schemeDesc));
        }

using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedRateBond;
using QuantLib::FloatingRateBond;
using QuantLib::DiscountingBondEngine;

typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedRateBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> DiscountingBondEnginePtr;

SWIGINTERN BondPtr *new_BondPtr__SWIG_0(Natural settlementDays,Calendar const &calendar,Real faceAmount,Date const &maturityDate,Date const &issueDate=Date(),Leg const &cashflows=Leg()){
            return new BondPtr(new Bond(settlementDays,
                                        calendar,
                                        faceAmount,
                                        maturityDate,
                                        issueDate,
                                        cashflows));
        }
SWIGINTERN Rate BondPtr_nextCouponRate__SWIG_0(BondPtr *self,Date const &d=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->nextCouponRate();
        }
SWIGINTERN Rate BondPtr_previousCouponRate__SWIG_0(BondPtr *self,Date const &d=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->previousCouponRate();
        }
SWIGINTERN Natural BondPtr_settlementDays(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->settlementDays();
        }
SWIGINTERN Date BondPtr_settlementDate__SWIG_0(BondPtr *self,Date d=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate(d);
        }
SWIGINTERN Date BondPtr_startDate(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->startDate();
        }
SWIGINTERN Date BondPtr_maturityDate(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->maturityDate();
        }
SWIGINTERN Date BondPtr_issueDate(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->issueDate();
        }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > BondPtr_redemptions(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemptions();
        }
SWIGINTERN boost::shared_ptr< CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
SWIGINTERN Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
SWIGINTERN std::vector< Real > BondPtr_notionals(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->notionals();
        }
SWIGINTERN Real BondPtr_notional__SWIG_0(BondPtr const *self,Date d=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)->notional(d);
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,DayCounter const &dc,Compounding compounding,Frequency frequency,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,dc, compounding, frequency, settlement);
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,DayCounter const &dc,Compounding compounding,Frequency frequency,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,dc, compounding,
                             frequency, settlement);
        }
SWIGINTERN Real BondPtr_yield__SWIG_0(BondPtr *self,DayCounter const &dc,Compounding compounding,Frequency freq,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(dc,compounding,freq,accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,DayCounter const &dc,Compounding compounding,Frequency freq,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,dc,compounding,freq,
                        settlement,accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
SWIGINTERN Real BondPtr_settlementValue__SWIG_0(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->settlementValue();
        }
SWIGINTERN Real BondPtr_settlementValue__SWIG_1(BondPtr const *self,Real cleanPrice){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->settlementValue(cleanPrice);
        }


    Real cleanPriceFromZSpread(
                   const BondPtr& bond,
                   const boost::shared_ptr<YieldTermStructure>& discountCurve,
                   Spread zSpread,
                   const DayCounter& dc,
                   Compounding compounding,
                   Frequency freq,
                   const Date& settlementDate = Date()) {
        return QuantLib::BondFunctions::cleanPrice(
                                  *(boost::dynamic_pointer_cast<Bond>(bond)),
                                  discountCurve,
                                  zSpread, dc, compounding,
                                  freq, settlementDate);
    }


SWIGINTERN ZeroCouponBondPtr *new_ZeroCouponBondPtr__SWIG_0(Natural settlementDays,Calendar const &calendar,Real faceAmount,Date const &maturityDate,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date const &issueDate=Date()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(settlementDays, calendar, faceAmount,
                                   maturityDate,
                                   paymentConvention, redemption,
                                   issueDate));
        }
SWIGINTERN FixedRateBondPtr *new_FixedRateBondPtr__SWIG_0(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector< Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date issueDate=Date(),Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false){
            return new FixedRateBondPtr(
                new FixedRateBond(settlementDays, faceAmount,
                                  schedule, coupons, paymentDayCounter,
                                  paymentConvention, redemption,
                                  issueDate, paymentCalendar,
                                  exCouponPeriod, exCouponCalendar,
                                  exCouponConvention, exCouponEndOfMonth));
        }
SWIGINTERN FixedRateBondPtr *new_FixedRateBondPtr__SWIG_9(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector< InterestRate > const &coupons,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Date const &issueDate=Date(),Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false){
	       return new FixedRateBondPtr(
		      new FixedRateBond(settlementDays, faceAmount,
		                  schedule, coupons, paymentConvention,
		                  redemption, issueDate, paymentCalendar,
		                  exCouponPeriod, exCouponCalendar,
		                  exCouponConvention, exCouponEndOfMonth));
		}
SWIGINTERN Frequency FixedRateBondPtr_frequency(FixedRateBondPtr const *self){
            return boost::dynamic_pointer_cast<FixedRateBond>(*self)
                ->frequency();
        }
SWIGINTERN DayCounter FixedRateBondPtr_dayCounter(FixedRateBondPtr const *self){
            return boost::dynamic_pointer_cast<FixedRateBond>(*self)
                ->dayCounter();
        }
SWIGINTERN FloatingRateBondPtr *new_FloatingRateBondPtr__SWIG_0(Size settlementDays,Real faceAmount,Schedule const &schedule,IborIndexPtr const &index,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=Following,Size fixingDays=Null< Size >(),std::vector< Real > const &gearings=std::vector< Real >(),std::vector< Spread > const &spreads=std::vector< Spread >(),std::vector< Rate > const &caps=std::vector< Rate >(),std::vector< Rate > const &floors=std::vector< Rate >(),bool inArrears=false,Real redemption=100.0,Date const &issueDate=Date()){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(settlementDays,
                                     faceAmount,
                                     schedule,
                                     libor,
                                     paymentDayCounter,
                                     paymentConvention,
                                     fixingDays,
                                     gearings,
                                     spreads,
                                     caps,
                                     floors,
                                     inArrears,
                                     redemption,
                                     issueDate));
        }

using QuantLib::CmsRateBond;
typedef boost::shared_ptr<Instrument> CmsRateBondPtr;

SWIGINTERN CmsRateBondPtr *new_CmsRateBondPtr__SWIG_0(Size settlementDays,Real faceAmount,Schedule const &schedule,SwapIndexPtr const &index,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention,Natural fixingDays,std::vector< Real > const &gearings,std::vector< Spread > const &spreads,std::vector< Rate > const &caps,std::vector< Rate > const &floors,bool inArrears=false,Real redemption=100.0,Date const &issueDate=Date()){
            boost::shared_ptr<SwapIndex> swap =
                boost::dynamic_pointer_cast<SwapIndex>(index);
            return new CmsRateBondPtr(
                new CmsRateBond(settlementDays,
                                faceAmount,
                                schedule,
                                swap,
                                paymentDayCounter,
                                paymentConvention,
                                fixingDays,
                                gearings,
                                spreads,
                                caps,
                                floors,
                                inArrears,
                                redemption,
                                issueDate));
        }
SWIGINTERN DiscountingBondEnginePtr *new_DiscountingBondEnginePtr(Handle< YieldTermStructure > const &discountCurve){
            return new DiscountingBondEnginePtr(
                                    new DiscountingBondEngine(discountCurve));
        }

using QuantLib::CallableBond;
using QuantLib::CallableFixedRateBond;
using QuantLib::TreeCallableFixedRateBondEngine;
using QuantLib::BlackCallableFixedRateBondEngine;
typedef boost::shared_ptr<Instrument> CallableFixedRateBondPtr;
typedef boost::shared_ptr<PricingEngine> TreeCallableFixedRateBondEnginePtr;
typedef boost::shared_ptr<PricingEngine> BlackCallableFixedRateBondEnginePtr;

SWIGINTERN CallableFixedRateBondPtr *new_CallableFixedRateBondPtr(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector< Rate > const &coupons,DayCounter const &accrualDayCounter,BusinessDayConvention paymentConvention,Real redemption,Date issueDate,std::vector< boost::shared_ptr< Callability > > const &putCallSchedule){
            return new CallableFixedRateBondPtr(
                new CallableFixedRateBond(settlementDays, faceAmount,
                                          schedule, coupons, accrualDayCounter,
                                          paymentConvention, redemption,
                                          issueDate, putCallSchedule));
        }
SWIGINTERN Real CallableFixedRateBondPtr_OAS__SWIG_0(CallableFixedRateBondPtr *self,Real cleanPrice,Handle< YieldTermStructure > const &engineTS,DayCounter const &dc,Compounding compounding,Frequency freq,Date const &settlementDate=Date(),Real accuracy=1e-10,Size maxIterations=100,Spread guess=0.0){
            return boost::dynamic_pointer_cast<CallableBond>(*self)
                ->OAS(cleanPrice,
                      engineTS,
                      dc, compounding, freq, settlementDate,
                      accuracy,
                      maxIterations,
                      guess);
        }
SWIGINTERN Real CallableFixedRateBondPtr_cleanPriceOAS__SWIG_0(CallableFixedRateBondPtr *self,Real oas,Handle< YieldTermStructure > const &engineTS,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return boost::dynamic_pointer_cast<CallableBond>(*self)
                ->cleanPriceOAS(oas,
                                engineTS,
                                dayCounter,
                                compounding,
                                frequency,
                                settlementDate);
        }
SWIGINTERN Real CallableFixedRateBondPtr_effectiveDuration__SWIG_0(CallableFixedRateBondPtr *self,Real oas,Handle< YieldTermStructure > const &engineTS,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Real bump=2e-4){
            return boost::dynamic_pointer_cast<CallableBond>(*self)
                ->effectiveDuration(oas,
                                    engineTS,
                                    dayCounter,
                                    compounding,
                                    frequency,
                                    bump);
        }
SWIGINTERN Real CallableFixedRateBondPtr_effectiveConvexity__SWIG_0(CallableFixedRateBondPtr *self,Real oas,Handle< YieldTermStructure > const &engineTS,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Real bump=2e-4){
            return boost::dynamic_pointer_cast<CallableBond>(*self)
                ->effectiveConvexity(oas,
                                     engineTS,
                                     dayCounter,
                                     compounding,
                                     frequency,
                                     bump);
        }
SWIGINTERN TreeCallableFixedRateBondEnginePtr *new_TreeCallableFixedRateBondEnginePtr__SWIG_0(boost::shared_ptr< ShortRateModel > const &model,Size timeSteps,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeCallableFixedRateBondEnginePtr(
                new TreeCallableFixedRateBondEngine(model, timeSteps,
                                                    termStructure));
        }
SWIGINTERN TreeCallableFixedRateBondEnginePtr *new_TreeCallableFixedRateBondEnginePtr__SWIG_2(boost::shared_ptr< ShortRateModel > const &model,TimeGrid const &grid,Handle< YieldTermStructure > const &termStructure=Handle< YieldTermStructure >()){
            return new TreeCallableFixedRateBondEnginePtr(
                new TreeCallableFixedRateBondEngine(model, grid,
                                                    termStructure));
        }
SWIGINTERN BlackCallableFixedRateBondEnginePtr *new_BlackCallableFixedRateBondEnginePtr(Handle< Quote > const &fwdYieldVol,Handle< YieldTermStructure > const &discountCurve){
            return new BlackCallableFixedRateBondEnginePtr(
                new BlackCallableFixedRateBondEngine(fwdYieldVol, discountCurve));
        }

using QuantLib::CPIBond;
typedef boost::shared_ptr<Instrument> CPIBondPtr;

SWIGINTERN CPIBondPtr *new_CPIBondPtr__SWIG_0(Natural settlementDays,Real faceAmount,bool growthOnly,Real baseCPI,Period const &observationLag,ZeroInflationIndexPtr const &cpiIndex,CPI::InterpolationType observationInterpolation,Schedule const &schedule,std::vector< Rate > const &coupons,DayCounter const &accrualDayCounter,BusinessDayConvention paymentConvention=ModifiedFollowing,Date const &issueDate=Date(),Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false){
            boost::shared_ptr<ZeroInflationIndex> zeroIndex =
                boost::dynamic_pointer_cast<ZeroInflationIndex>(cpiIndex);
            return new CPIBondPtr(
                new CPIBond(settlementDays, faceAmount, growthOnly, baseCPI,
                            observationLag, zeroIndex, observationInterpolation,
                            schedule, coupons, accrualDayCounter,
                            paymentConvention, issueDate, paymentCalendar,
                            exCouponPeriod, exCouponCalendar,
                            exCouponConvention, exCouponEndOfMonth));
        }

using QuantLib::BondFunctions;

SWIGINTERN Date BondFunctions_startDate(BondPtr const &bond){
            return QuantLib::BondFunctions::startDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)));
        }
SWIGINTERN Date BondFunctions_maturityDate(BondPtr const &bond){
            return QuantLib::BondFunctions::maturityDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)));
        }
SWIGINTERN bool BondFunctions_isTradable__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::isTradable(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Date BondFunctions_previousCashFlowDate__SWIG_0(BondPtr const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::previousCashFlowDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Date BondFunctions_nextCashFlowDate__SWIG_0(BondPtr const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::nextCashFlowDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Real BondFunctions_previousCashFlowAmount__SWIG_0(BondPtr const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::previousCashFlowAmount(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Real BondFunctions_nextCashFlowAmount__SWIG_0(BondPtr const &bond,Date refDate=Date()){
            return QuantLib::BondFunctions::nextCashFlowAmount(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    refDate);
        }
SWIGINTERN Rate BondFunctions_previousCouponRate__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::previousCouponRate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Rate BondFunctions_nextCouponRate__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::nextCouponRate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Date BondFunctions_accrualStartDate__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualStartDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Date BondFunctions_accrualEndDate__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualEndDate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Time BondFunctions_accrualPeriod__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualPeriod(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN BigInteger BondFunctions_accrualDays__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accrualDays(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    settlementDate);
        }
SWIGINTERN Time BondFunctions_accruedPeriod__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accruedPeriod(
                *(boost::dynamic_pointer_cast<Bond>(bond)),
                settlementDate);
        }
SWIGINTERN BigInteger BondFunctions_accruedDays__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){
            return QuantLib::BondFunctions::accruedDays(
                *(boost::dynamic_pointer_cast<Bond>(bond)),
                settlementDate);
        }
SWIGINTERN Real BondFunctions_accruedAmount__SWIG_0(BondPtr const &bond,Date settlementDate=Date()){

            return QuantLib::BondFunctions::accruedAmount(
                *(boost::dynamic_pointer_cast<Bond>(bond)), 
                settlementDate);
        }
SWIGINTERN Real BondFunctions_cleanPrice__SWIG_0(BondPtr const &bond,boost::shared_ptr< YieldTermStructure > const &discountCurve,Date settlementDate=Date()){
            return QuantLib::BondFunctions::cleanPrice(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    *discountCurve,
                    settlementDate);
        }
SWIGINTERN Real BondFunctions_bps__SWIG_0(BondPtr const &bond,boost::shared_ptr< YieldTermStructure > const &discountCurve,Date settlementDate=Date()){
            return QuantLib::BondFunctions::bps(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    *discountCurve,
                    settlementDate);
        }
SWIGINTERN Rate BondFunctions_atmRate__SWIG_0(BondPtr const &bond,boost::shared_ptr< YieldTermStructure > const &discountCurve,Date settlementDate=Date(),Real cleanPrice=Null< Real >()){
            return QuantLib::BondFunctions::atmRate(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    *discountCurve,
                    settlementDate,
                    cleanPrice);
        }
SWIGINTERN Real BondFunctions_cleanPrice__SWIG_2(BondPtr const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::cleanPrice(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    yield,
                    settlementDate);
        }
SWIGINTERN Real BondFunctions_cleanPrice__SWIG_4(BondPtr const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::cleanPrice(
                    *(boost::dynamic_pointer_cast<Bond>(bond)),
                    yield,
                    dayCounter,
                    compounding,
                    frequency,
                    settlementDate);
        }
SWIGINTERN Real BondFunctions_bps__SWIG_2(BondPtr const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::bps(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_bps__SWIG_4(BondPtr const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::bps(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Rate BondFunctions_yield__SWIG_0(BondPtr const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Size maxIterations=100,Rate guess=0.05){
            return QuantLib::BondFunctions::yield(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        maxIterations,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldBrent__SWIG_0(Brent solver,BondPtr const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Brent>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldBisection__SWIG_0(Bisection solver,BondPtr const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Bisection>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldFalsePosition__SWIG_0(FalsePosition solver,BondPtr const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<FalsePosition>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldRidder__SWIG_0(Ridder solver,BondPtr const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Ridder>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Rate BondFunctions_yieldSecant__SWIG_0(Secant solver,BondPtr const &bond,Real cleanPrice,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Rate guess=0.05){
            return QuantLib::BondFunctions::yield<Secant>(
                        solver,
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        guess);
        }
SWIGINTERN Time BondFunctions_duration__SWIG_0(BondPtr const &bond,InterestRate const &yield,Duration::Type type=Duration::Modified,Date settlementDate=Date()){
            return QuantLib::BondFunctions::duration(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        type,
                        settlementDate);
        }
SWIGINTERN Time BondFunctions_duration__SWIG_3(BondPtr const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Duration::Type type=Duration::Modified,Date settlementDate=Date()){
            return QuantLib::BondFunctions::duration(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        type,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_convexity__SWIG_0(BondPtr const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::convexity(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_convexity__SWIG_2(BondPtr const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::convexity(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_basisPointValue__SWIG_0(BondPtr const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::basisPointValue(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_basisPointValue__SWIG_2(BondPtr const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::basisPointValue(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_yieldValueBasisPoint__SWIG_0(BondPtr const &bond,InterestRate const &yield,Date settlementDate=Date()){
            return QuantLib::BondFunctions::yieldValueBasisPoint(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        settlementDate);
        }
SWIGINTERN Real BondFunctions_yieldValueBasisPoint__SWIG_2(BondPtr const &bond,Rate yield,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date()){
            return QuantLib::BondFunctions::yieldValueBasisPoint(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        yield,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate);
        }
SWIGINTERN Spread BondFunctions_zSpread__SWIG_0(BondPtr const &bond,Real cleanPrice,boost::shared_ptr< YieldTermStructure > const &discountCurve,DayCounter const &dayCounter,Compounding compounding,Frequency frequency,Date settlementDate=Date(),Real accuracy=1.0e-10,Size maxIterations=100,Rate guess=0.0){
            return QuantLib::BondFunctions::zSpread(
                        *(boost::dynamic_pointer_cast<Bond>(bond)),
                        cleanPrice,
                        discountCurve,
                        dayCounter,
                        compounding,
                        frequency,
                        settlementDate,
                        accuracy,
                        maxIterations,
                        guess);

        }

using QuantLib::CapFloor;
using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;

typedef boost::shared_ptr<Instrument> CapFloorPtr;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

SWIGINTERN Volatility CapFloorPtr_impliedVolatility__SWIG_0(CapFloorPtr const *self,Real price,Handle< YieldTermStructure > const &disc,Volatility guess,Real accuracy=1.0e-4,Natural maxEvaluations=100,Volatility minVol=1.0e-7,Volatility maxVol=4.0,VolatilityType type=ShiftedLognormal,Real displacement=0.0){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->
                impliedVolatility(price, disc, guess, accuracy,
                                  maxEvaluations, minVol, maxVol,
                                  type, displacement);
        }
SWIGINTERN Leg const &CapFloorPtr_floatingLeg(CapFloorPtr const *self){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->floatingLeg();
        }
SWIGINTERN std::vector< Rate > const &CapFloorPtr_capRates(CapFloorPtr const *self){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->capRates();
        }
SWIGINTERN std::vector< Rate > const &CapFloorPtr_floorRates(CapFloorPtr const *self){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->floorRates();
        }
SWIGINTERN Date CapFloorPtr_startDate(CapFloorPtr const *self){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->startDate();
        }
SWIGINTERN Date CapFloorPtr_maturityDate(CapFloorPtr const *self){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->maturityDate();
        }
SWIGINTERN Rate CapFloorPtr_atmRate(CapFloorPtr const *self,boost::shared_ptr< YieldTermStructure > const &discountCurve){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->atmRate(*discountCurve);
        }
SWIGINTERN CapPtr *new_CapPtr(std::vector< boost::shared_ptr< CashFlow > > const &leg,std::vector< Rate > const &capRates){
            return new CapPtr(new Cap(leg,capRates));
        }
SWIGINTERN FloorPtr *new_FloorPtr(std::vector< boost::shared_ptr< CashFlow > > const &leg,std::vector< Rate > const &floorRates){
            return new FloorPtr(new Floor(leg,floorRates));
        }
SWIGINTERN CollarPtr *new_CollarPtr(std::vector< boost::shared_ptr< CashFlow > > const &leg,std::vector< Rate > const &capRates,std::vector< Rate > const &floorRates){
            return new CollarPtr(new Collar(leg,capRates,floorRates));
        }

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr__SWIG_0(Handle< YieldTermStructure > const &termStructure,Handle< Quote > const &vol){
            return new BlackCapFloorEnginePtr(
                                  new BlackCapFloorEngine(termStructure,vol));
        }
SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr__SWIG_1(Handle< YieldTermStructure > const &termStructure,Handle< OptionletVolatilityStructure > const &vol){
            return new BlackCapFloorEnginePtr(
                                  new BlackCapFloorEngine(termStructure,vol));
        }

using QuantLib::BachelierCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BachelierCapFloorEnginePtr;

SWIGINTERN BachelierCapFloorEnginePtr *new_BachelierCapFloorEnginePtr__SWIG_0(Handle< YieldTermStructure > const &termStructure,Handle< Quote > const &vol){
            return new BachelierCapFloorEnginePtr(
                                new BachelierCapFloorEngine(termStructure,vol));
        }
SWIGINTERN BachelierCapFloorEnginePtr *new_BachelierCapFloorEnginePtr__SWIG_1(Handle< YieldTermStructure > const &termStructure,Handle< OptionletVolatilityStructure > const &vol){
            return new BachelierCapFloorEnginePtr(
                                new BachelierCapFloorEngine(termStructure,vol));
        }

using QuantLib::Dividend;

SWIGINTERN bool boost_shared_ptr_Sl_Dividend_Sg__isNull(boost::shared_ptr< Dividend > *self){
                return !(*self);
            }

using QuantLib::FixedDividend;
using QuantLib::FractionalDividend;

typedef boost::shared_ptr<Dividend> FixedDividendPtr;
typedef boost::shared_ptr<Dividend> FractionalDividendPtr;

SWIGINTERN FixedDividendPtr *new_FixedDividendPtr(Real amount,Date const &date){
            return new FixedDividendPtr(new FixedDividend(amount,date));
        }
SWIGINTERN FractionalDividendPtr *new_FractionalDividendPtr(Rate rate,Date const &date){
            return new FractionalDividendPtr(
                                     new FractionalDividend(rate,date));
        }
SWIGINTERN std::vector< boost::shared_ptr< Dividend > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__get(std::vector< boost::shared_ptr< Dividend > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__set(std::vector< boost::shared_ptr< Dividend > > *self,int i,std::vector< boost::shared_ptr< Dividend > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::ConvertibleZeroCouponBond;
using QuantLib::ConvertibleFixedCouponBond;
using QuantLib::ConvertibleFloatingRateBond;
using QuantLib::BinomialConvertibleEngine;
typedef boost::shared_ptr<Instrument> ConvertibleZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> BinomialConvertibleEnginePtr;

SWIGINTERN ConvertibleZeroCouponBondPtr *new_ConvertibleZeroCouponBondPtr__SWIG_0(boost::shared_ptr< Exercise > const &exercise,Real conversionRatio,std::vector< boost::shared_ptr< Dividend > > const &dividends,std::vector< boost::shared_ptr< Callability > > const &callability,Handle< Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            return new ConvertibleZeroCouponBondPtr(
                     new ConvertibleZeroCouponBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN ConvertibleFixedCouponBondPtr *new_ConvertibleFixedCouponBondPtr__SWIG_0(boost::shared_ptr< Exercise > const &exercise,Real conversionRatio,std::vector< boost::shared_ptr< Dividend > > const &dividends,std::vector< boost::shared_ptr< Callability > > const &callability,Handle< Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,std::vector< Rate > const &coupons,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            return new ConvertibleFixedCouponBondPtr(
                    new ConvertibleFixedCouponBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   coupons, dayCounter,
                                                   schedule, redemption));
        }
SWIGINTERN ConvertibleFloatingRateBondPtr *new_ConvertibleFloatingRateBondPtr__SWIG_0(boost::shared_ptr< Exercise > const &exercise,Real conversionRatio,std::vector< boost::shared_ptr< Dividend > > const &dividends,std::vector< boost::shared_ptr< Callability > > const &callability,Handle< Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,IborIndexPtr const &index,Integer fixingDays,std::vector< Spread > const &spreads,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new ConvertibleFloatingRateBondPtr(
                   new ConvertibleFloatingRateBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   libor, fixingDays, spreads,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN BinomialConvertibleEnginePtr *new_BinomialConvertibleEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<CoxRossRubinstein>(
                                                            bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<JarrowRudd>(
                                                            bsProcess,steps));
            else if (s == "eqp")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<AdditiveEQPBinomialTree>(
                                                            bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Trigeorgis>(
                                                            bsProcess,steps));
            else if (s == "tian")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Tian>(bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<LeisenReimer>(
                                                            bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Joshi4>(bsProcess,steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::DefaultProbabilityTermStructure;

SWIGINTERN bool boost_shared_ptr_Sl_DefaultProbabilityTermStructure_Sg__isNull(boost::shared_ptr< DefaultProbabilityTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_DefaultProbabilityTermStructure_Sg__asObservable(boost::shared_ptr< DefaultProbabilityTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_DefaultProbabilityTermStructure_Sg__asObservable(Handle< DefaultProbabilityTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::FlatHazardRate;
typedef boost::shared_ptr<DefaultProbabilityTermStructure> FlatHazardRatePtr;

SWIGINTERN FlatHazardRatePtr *new_FlatHazardRatePtr__SWIG_0(Integer settlementDays,Calendar const &calendar,Handle< Quote > const &hazardRate,DayCounter const &dayCounter){
            return new FlatHazardRatePtr(
                           new FlatHazardRate(settlementDays,calendar,
                                              hazardRate,dayCounter));
        }
SWIGINTERN FlatHazardRatePtr *new_FlatHazardRatePtr__SWIG_1(Date const &todaysDate,Handle< Quote > const &hazardRate,DayCounter const &dayCounter){
            return new FlatHazardRatePtr(
                        new FlatHazardRate(todaysDate,hazardRate,dayCounter));
        }

using QuantLib::InterpolatedHazardRateCurve;


typedef boost::shared_ptr<DefaultProbabilityTermStructure> HazardRateCurvePtr;

SWIGINTERN HazardRateCurvePtr *new_HazardRateCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Real > const &hazardRates,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),BackwardFlat const &i=BackwardFlat()){
            return new HazardRateCurvePtr(
                new InterpolatedHazardRateCurve<BackwardFlat>(dates,hazardRates,
                                                              dayCounter,
                                                              calendar,i));
        }
SWIGINTERN std::vector< Date > const &HazardRateCurvePtr_dates(HazardRateCurvePtr *self){
            typedef InterpolatedHazardRateCurve<BackwardFlat> HazardRateCurve;
            return boost::dynamic_pointer_cast<HazardRateCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Real > const &HazardRateCurvePtr_hazardRates(HazardRateCurvePtr *self){
            typedef InterpolatedHazardRateCurve<BackwardFlat> HazardRateCurve;
            return boost::dynamic_pointer_cast<HazardRateCurve>(*self)->hazardRates();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > HazardRateCurvePtr_nodes(HazardRateCurvePtr *self){
            typedef InterpolatedHazardRateCurve<BackwardFlat> HazardRateCurve;
            return boost::dynamic_pointer_cast<HazardRateCurve>(*self)->nodes();
        }

using QuantLib::InterpolatedDefaultDensityCurve;


typedef boost::shared_ptr<DefaultProbabilityTermStructure> DefaultDensityCurvePtr;

SWIGINTERN DefaultDensityCurvePtr *new_DefaultDensityCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Real > const &densities,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),Linear const &i=Linear()){
            return new DefaultDensityCurvePtr(
                new InterpolatedDefaultDensityCurve<Linear>(dates,
                                                                  densities,
                                                                  dayCounter,
                                                                  calendar,i));
        }
SWIGINTERN std::vector< Date > const &DefaultDensityCurvePtr_dates(DefaultDensityCurvePtr *self){
            typedef InterpolatedDefaultDensityCurve<Linear> DefaultDensityCurve;
            return boost::dynamic_pointer_cast<DefaultDensityCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Real > const &DefaultDensityCurvePtr_defaultDensities(DefaultDensityCurvePtr *self){
            typedef InterpolatedDefaultDensityCurve<Linear> DefaultDensityCurve;
            return boost::dynamic_pointer_cast<DefaultDensityCurve>(*self)->defaultDensities();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > DefaultDensityCurvePtr_nodes(DefaultDensityCurvePtr *self){
            typedef InterpolatedDefaultDensityCurve<Linear> DefaultDensityCurve;
            return boost::dynamic_pointer_cast<DefaultDensityCurve>(*self)->nodes();
        }

using QuantLib::DefaultProbabilityHelper;
using QuantLib::SpreadCdsHelper;
typedef boost::shared_ptr<DefaultProbabilityHelper> SpreadCdsHelperPtr;
using QuantLib::UpfrontCdsHelper;
typedef boost::shared_ptr<DefaultProbabilityHelper> UpfrontCdsHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__isNull(boost::shared_ptr< DefaultProbabilityHelper > *self){
                return !(*self);
            }
SWIGINTERN std::vector< boost::shared_ptr< DefaultProbabilityHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__get(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_DefaultProbabilityHelper_Sg__Sg__set(std::vector< boost::shared_ptr< DefaultProbabilityHelper > > *self,int i,std::vector< boost::shared_ptr< DefaultProbabilityHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN SpreadCdsHelperPtr *new_SpreadCdsHelperPtr__SWIG_0(Handle< Quote > const &spread,Period const &tenor,Integer settlementDays,Calendar const &calendar,Frequency frequency,BusinessDayConvention convention,DateGeneration::Rule rule,DayCounter const &dayCounter,Real recoveryRate,Handle< YieldTermStructure > const &discountCurve,bool settlesAccrual=true,bool paysAtDefaultTime=true){
            return new SpreadCdsHelperPtr(
                new SpreadCdsHelper(spread,tenor,settlementDays,calendar,
                                    frequency,convention,rule,dayCounter,
                                    recoveryRate,discountCurve,
                                    settlesAccrual,paysAtDefaultTime));
        }
SWIGINTERN SpreadCdsHelperPtr *new_SpreadCdsHelperPtr__SWIG_3(Rate spread,Period const &tenor,Integer settlementDays,Calendar const &calendar,Frequency frequency,BusinessDayConvention convention,DateGeneration::Rule rule,DayCounter const &dayCounter,Real recoveryRate,Handle< YieldTermStructure > const &discountCurve,bool settlesAccrual=true,bool paysAtDefaultTime=true){
            return new SpreadCdsHelperPtr(
                new SpreadCdsHelper(spread,tenor,settlementDays,calendar,
                                    frequency,convention,rule,dayCounter,
                                    recoveryRate,discountCurve,
                                    settlesAccrual,paysAtDefaultTime));
        }
SWIGINTERN UpfrontCdsHelperPtr *new_UpfrontCdsHelperPtr__SWIG_0(Handle< Quote > const &upfront,Rate spread,Period const &tenor,Integer settlementDays,Calendar const &calendar,Frequency frequency,BusinessDayConvention convention,DateGeneration::Rule rule,DayCounter const &dayCounter,Real recoveryRate,Handle< YieldTermStructure > const &discountCurve,Natural upfrontSettlementDays=0,bool settlesAccrual=true,bool paysAtDefaultTime=true){
            return new UpfrontCdsHelperPtr(
                new UpfrontCdsHelper(upfront,spread,tenor,
                                     settlementDays,calendar,
                                     frequency,convention,rule,dayCounter,
                                     recoveryRate,discountCurve,upfrontSettlementDays,
                                     settlesAccrual,paysAtDefaultTime));
        }
SWIGINTERN UpfrontCdsHelperPtr *new_UpfrontCdsHelperPtr__SWIG_4(Rate upfront,Rate spread,Period const &tenor,Integer settlementDays,Calendar const &calendar,Frequency frequency,BusinessDayConvention convention,DateGeneration::Rule rule,DayCounter const &dayCounter,Real recoveryRate,Handle< YieldTermStructure > const &discountCurve,Natural upfrontSettlementDays=0,bool settlesAccrual=true,bool paysAtDefaultTime=true){
            return new UpfrontCdsHelperPtr(
                new UpfrontCdsHelper(upfront,spread,tenor,
                                     settlementDays,calendar,
                                     frequency,convention,rule,dayCounter,
                                     recoveryRate,discountCurve,upfrontSettlementDays,
                                     settlesAccrual,paysAtDefaultTime));
        }

using QuantLib::HazardRate;
using QuantLib::DefaultDensity;


using QuantLib::PiecewiseDefaultCurve;


typedef boost::shared_ptr<DefaultProbabilityTermStructure> PiecewiseFlatHazardRatePtr;

SWIGINTERN PiecewiseFlatHazardRatePtr *new_PiecewiseFlatHazardRatePtr__SWIG_0(Date const &referenceDate,std::vector< boost::shared_ptr< DefaultProbabilityHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatHazardRatePtr(
                new PiecewiseDefaultCurve<HazardRate,BackwardFlat>(
                                                 referenceDate,instruments,
                                                 dayCounter, accuracy, i));
        }
SWIGINTERN PiecewiseFlatHazardRatePtr *new_PiecewiseFlatHazardRatePtr__SWIG_3(Integer settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< DefaultProbabilityHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatHazardRatePtr(
                new PiecewiseDefaultCurve<HazardRate,BackwardFlat>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseFlatHazardRatePtr_dates(PiecewiseFlatHazardRatePtr *self){
            typedef PiecewiseDefaultCurve<HazardRate,BackwardFlat> PiecewiseFlatHazardRate;
            return boost::dynamic_pointer_cast<PiecewiseFlatHazardRate>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseFlatHazardRatePtr_times(PiecewiseFlatHazardRatePtr *self){
            typedef PiecewiseDefaultCurve<HazardRate,BackwardFlat> PiecewiseFlatHazardRate;
            return boost::dynamic_pointer_cast<PiecewiseFlatHazardRate>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseFlatHazardRatePtr_nodes(PiecewiseFlatHazardRatePtr *self){
            typedef PiecewiseDefaultCurve<HazardRate,BackwardFlat> PiecewiseFlatHazardRate;
            return boost::dynamic_pointer_cast<PiecewiseFlatHazardRate>(*self)->nodes();
        }

using QuantLib::Protection;


using QuantLib::CreditDefaultSwap;
using QuantLib::MidPointCdsEngine;
using QuantLib::IntegralCdsEngine;

typedef boost::shared_ptr<Instrument> CreditDefaultSwapPtr;
typedef boost::shared_ptr<PricingEngine> MidPointCdsEnginePtr;
typedef boost::shared_ptr<PricingEngine> IntegralCdsEnginePtr;

SWIGINTERN CreditDefaultSwapPtr *new_CreditDefaultSwapPtr__SWIG_0(Protection::Side side,Real notional,Rate spread,Schedule const &schedule,BusinessDayConvention paymentConvention,DayCounter const &dayCounter,bool settlesAccrual=true,bool paysAtDefaultTime=true){
            return new CreditDefaultSwapPtr(
                    new CreditDefaultSwap(side, notional, spread, schedule,
                                          paymentConvention, dayCounter,
                                          settlesAccrual, paysAtDefaultTime));
        }
SWIGINTERN CreditDefaultSwapPtr *new_CreditDefaultSwapPtr__SWIG_3(Protection::Side side,Real notional,Rate upfront,Rate spread,Schedule const &schedule,BusinessDayConvention paymentConvention,DayCounter const &dayCounter,bool settlesAccrual=true,bool paysAtDefaultTime=true){
            return new CreditDefaultSwapPtr(
                    new CreditDefaultSwap(side, notional, upfront, spread,
                                          schedule, paymentConvention,
                                          dayCounter, settlesAccrual,
                                          paysAtDefaultTime));
        }
SWIGINTERN Protection::Side CreditDefaultSwapPtr_side(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->side();
        }
SWIGINTERN Real CreditDefaultSwapPtr_notional(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->notional();
        }
SWIGINTERN Rate CreditDefaultSwapPtr_runningSpread(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->runningSpread();
        }
SWIGINTERN doubleOrNull CreditDefaultSwapPtr_upfront(CreditDefaultSwapPtr const *self){
            boost::optional<Rate> result =
                boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->upfront();
            if (result)
                return *result;
            else
                return Null<double>();
        }
SWIGINTERN bool CreditDefaultSwapPtr_settlesAccrual(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->settlesAccrual();
        }
SWIGINTERN bool CreditDefaultSwapPtr_paysAtDefaultTime(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->paysAtDefaultTime();
        }
SWIGINTERN Rate CreditDefaultSwapPtr_fairSpread(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->fairSpread();
        }
SWIGINTERN Rate CreditDefaultSwapPtr_fairUpfront(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->fairUpfront();
        }
SWIGINTERN Real CreditDefaultSwapPtr_couponLegBPS(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->couponLegBPS();
        }
SWIGINTERN Real CreditDefaultSwapPtr_couponLegNPV(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->couponLegNPV();
        }
SWIGINTERN Real CreditDefaultSwapPtr_defaultLegNPV(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->defaultLegNPV();
        }
SWIGINTERN Real CreditDefaultSwapPtr_upfrontBPS(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->upfrontBPS();
        }
SWIGINTERN Real CreditDefaultSwapPtr_upfrontNPV(CreditDefaultSwapPtr const *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->upfrontNPV();
        }
SWIGINTERN Rate CreditDefaultSwapPtr_impliedHazardRate__SWIG_0(CreditDefaultSwapPtr const *self,Real targetNPV,Handle< YieldTermStructure > const &discountCurve,DayCounter const &dayCounter,Real recoveryRate=0.4,Real accuracy=1.0e-6){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->impliedHazardRate(targetNPV, discountCurve, dayCounter,
                                    recoveryRate, accuracy);
        }
SWIGINTERN std::vector< boost::shared_ptr< CashFlow > > CreditDefaultSwapPtr_coupons(CreditDefaultSwapPtr *self){
            return boost::dynamic_pointer_cast<CreditDefaultSwap>(*self)
                ->coupons();
        }
SWIGINTERN MidPointCdsEnginePtr *new_MidPointCdsEnginePtr(Handle< DefaultProbabilityTermStructure > const &probability,Real recoveryRate,Handle< YieldTermStructure > const &discountCurve){
            return new MidPointCdsEnginePtr(
                              new MidPointCdsEngine(probability, recoveryRate,
                                                    discountCurve));
        }
SWIGINTERN IntegralCdsEnginePtr *new_IntegralCdsEnginePtr__SWIG_0(Period const &integrationStep,Handle< DefaultProbabilityTermStructure > const &probability,Real recoveryRate,Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows=false){
            return new IntegralCdsEnginePtr(
                              new IntegralCdsEngine(integrationStep, probability,
                                                    recoveryRate, discountCurve,
													includeSettlementDateFlows));
        }

using QuantLib::InterpolatedDiscountCurve;


typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;

SWIGINTERN DiscountCurvePtr *new_DiscountCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< DiscountFactor > const &discounts,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),LogLinear const &i=LogLinear()){
            return new DiscountCurvePtr(
                new InterpolatedDiscountCurve<LogLinear>(dates,discounts,
                                                            dayCounter,
                                                            calendar,i));
        }
SWIGINTERN std::vector< Time > const &DiscountCurvePtr_times(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &DiscountCurvePtr_data(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
SWIGINTERN std::vector< DiscountFactor > const &DiscountCurvePtr_discounts(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->discounts();
        }
SWIGINTERN std::vector< std::pair< Date,DiscountFactor > > DiscountCurvePtr_nodes(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->nodes();
        }

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;
using QuantLib::BivariateCumulativeNormalDistribution;
using QuantLib::BinomialDistribution;
using QuantLib::CumulativeBinomialDistribution;
using QuantLib::BivariateCumulativeNormalDistributionDr78;
using QuantLib::BivariateCumulativeNormalDistributionWe04DP;
using QuantLib::CumulativeChiSquareDistribution;
using QuantLib::NonCentralCumulativeChiSquareDistribution;
using QuantLib::InverseNonCentralCumulativeChiSquareDistribution;
using QuantLib::CumulativeGammaDistribution;
using QuantLib::GammaFunction;
using QuantLib::PoissonDistribution;
using QuantLib::CumulativePoissonDistribution;
using QuantLib::InverseCumulativePoisson;
using QuantLib::StudentDistribution;
using QuantLib::CumulativeStudentDistribution;
using QuantLib::InverseCumulativeStudent;


using QuantLib::Money;

SWIGINTERN Money Money_operator_Sa___SWIG_1(Money *self,Money const &m){ return *self+m; }
SWIGINTERN Money Money_operator_Ss___SWIG_1(Money *self,Money const &m){ return *self-m; }
SWIGINTERN Money Money_operator_Sm_(Money *self,Decimal x){ return *self*x; }
SWIGINTERN Money Money_operator_Sd___SWIG_0(Money *self,Decimal x){ return *self/x; }
SWIGINTERN Decimal Money_operator_Sd___SWIG_1(Money *self,Money const &m){ return *self/m; }
SWIGINTERN int Money___cmp__(Money *self,Money const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else
                return 1;
        }
SWIGINTERN std::string Money___str__(Money *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
SWIGINTERN void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::Futures;


using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::VanillaSwap;
using QuantLib::NonstandardSwap;
using QuantLib::DiscountingSwapEngine;
using QuantLib::FloatFloatSwap;

typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> VanillaSwapPtr;
typedef boost::shared_ptr<Instrument> NonstandardSwapPtr;
typedef boost::shared_ptr<PricingEngine> DiscountingSwapEnginePtr;
typedef boost::shared_ptr<Instrument> FloatFloatSwapPtr;

SWIGINTERN SwapPtr *new_SwapPtr(std::vector< boost::shared_ptr< CashFlow > > const &firstLeg,std::vector< boost::shared_ptr< CashFlow > > const &secondLeg){
            return new SwapPtr(new Swap(firstLeg, secondLeg));
        }
SWIGINTERN Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
SWIGINTERN Date SwapPtr_maturityDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturityDate();
        }
SWIGINTERN Leg const &SwapPtr_leg(SwapPtr *self,Size i){
            return boost::dynamic_pointer_cast<Swap>(*self)->leg(i);
        }
SWIGINTERN Real SwapPtr_legNPV(SwapPtr const *self,Size j){
            return boost::dynamic_pointer_cast<Swap>(*self)->legNPV(j);
        }
SWIGINTERN VanillaSwapPtr *new_VanillaSwapPtr(VanillaSwap::Type type,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,IborIndexPtr const &index,Spread spread,DayCounter const &floatingDayCount){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new VanillaSwapPtr(
                    new VanillaSwap(type, nominal,fixedSchedule,fixedRate,
                                    fixedDayCount,floatSchedule,libor,
                                    spread, floatingDayCount));
        }
SWIGINTERN Rate VanillaSwapPtr_fairRate(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)->fairRate();
        }
SWIGINTERN Spread VanillaSwapPtr_fairSpread(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fairSpread();
        }
SWIGINTERN Real VanillaSwapPtr_fixedLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fixedLegBPS();
        }
SWIGINTERN Real VanillaSwapPtr_floatingLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->floatingLegBPS();
        }
SWIGINTERN Real VanillaSwapPtr_fixedLegNPV(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->fixedLegNPV();
        }
SWIGINTERN Real VanillaSwapPtr_floatingLegNPV(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->floatingLegNPV();
        }
SWIGINTERN Leg const &VanillaSwapPtr_fixedLeg(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->fixedLeg();
        }
SWIGINTERN Leg const &VanillaSwapPtr_floatingLeg(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->floatingLeg();
        }
SWIGINTERN Real VanillaSwapPtr_nominal(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->nominal();
        }
SWIGINTERN Schedule const &VanillaSwapPtr_fixedSchedule(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->fixedSchedule();
        }
SWIGINTERN Schedule const &VanillaSwapPtr_floatingSchedule(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->floatingSchedule();
        }
SWIGINTERN Rate VanillaSwapPtr_fixedRate(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->fixedRate();
        }
SWIGINTERN Spread VanillaSwapPtr_spread(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->spread();
        }
SWIGINTERN DayCounter const &VanillaSwapPtr_floatingDayCount(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->floatingDayCount();
        }
SWIGINTERN DayCounter const &VanillaSwapPtr_fixedDayCount(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap> (*self)
                ->fixedDayCount();
        }
SWIGINTERN NonstandardSwapPtr *new_NonstandardSwapPtr__SWIG_0(VanillaSwap::Type type,std::vector< Real > const &fixedNominal,std::vector< Real > const &floatingNominal,Schedule const &fixedSchedule,std::vector< Real > const &fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,IborIndexPtr const &index,std::vector< Real > const &gearing,std::vector< Spread > const &spread,DayCounter const &floatDayCount,bool const intermediateCapitalExchange=false,bool const finalCapitalExchange=false,BusinessDayConvention paymentConvention=Following){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new NonstandardSwapPtr(
                new NonstandardSwap(type,fixedNominal,floatingNominal,fixedSchedule,fixedRate,
                                    fixedDayCount,floatSchedule,libor,gearing,
                                    spread,floatDayCount,intermediateCapitalExchange,
                                    finalCapitalExchange, paymentConvention));
        }
SWIGINTERN Leg const &NonstandardSwapPtr_fixedLeg(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->fixedLeg();
        }
SWIGINTERN Leg const &NonstandardSwapPtr_floatingLeg(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->floatingLeg();
        }
SWIGINTERN std::vector< Real > NonstandardSwapPtr_fixedNominals(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->fixedNominal();
        }
SWIGINTERN std::vector< Real > NonstandardSwapPtr_floatingNominals(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->floatingNominal();
        }
SWIGINTERN Schedule const &NonstandardSwapPtr_fixedSchedule(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->fixedSchedule();
        }
SWIGINTERN Schedule const &NonstandardSwapPtr_floatingSchedule(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->floatingSchedule();
        }
SWIGINTERN std::vector< Rate > NonstandardSwapPtr_fixedRate(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->fixedRate();
        }
SWIGINTERN std::vector< Spread > NonstandardSwapPtr_spreads(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->spreads();
        }
SWIGINTERN std::vector< Spread > NonstandardSwapPtr_gearings(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->gearings();
        }
SWIGINTERN DayCounter const &NonstandardSwapPtr_floatingDayCount(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->floatingDayCount();
        }
SWIGINTERN DayCounter const &NonstandardSwapPtr_fixedDayCount(NonstandardSwapPtr *self){
            return boost::dynamic_pointer_cast<NonstandardSwap> (*self)
                ->fixedDayCount();
        }
SWIGINTERN DiscountingSwapEnginePtr *new_DiscountingSwapEnginePtr__SWIG_0(Handle< YieldTermStructure > const &discountCurve,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return new DiscountingSwapEnginePtr(
                                    new DiscountingSwapEngine(discountCurve,
                                                              boost::none,
                                                              settlementDate,
                                                              npvDate));
        }
SWIGINTERN DiscountingSwapEnginePtr *new_DiscountingSwapEnginePtr__SWIG_3(Handle< YieldTermStructure > const &discountCurve,bool includeSettlementDateFlows,Date const &settlementDate=Date(),Date const &npvDate=Date()){
            return new DiscountingSwapEnginePtr(
                         new DiscountingSwapEngine(discountCurve,
                                                   includeSettlementDateFlows,
                                                   settlementDate,
                                                   npvDate));
        }

using QuantLib::AssetSwap;
typedef boost::shared_ptr<Instrument> AssetSwapPtr;

SWIGINTERN AssetSwapPtr *new_AssetSwapPtr__SWIG_0(bool payFixedRate,BondPtr const &bond,Real bondCleanPrice,InterestRateIndexPtr const &index,Spread spread,Schedule const &floatSchedule=Schedule(),DayCounter const &floatingDayCount=DayCounter(),bool parAssetSwap=true){
            const boost::shared_ptr<Bond> b =
                boost::dynamic_pointer_cast<Bond>(bond);
            const boost::shared_ptr<IborIndex> i =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new AssetSwapPtr(
                new AssetSwap(payFixedRate,b,bondCleanPrice,i,spread,
                              floatSchedule,floatingDayCount,parAssetSwap));
        }
SWIGINTERN Real AssetSwapPtr_fairCleanPrice(AssetSwapPtr *self){
            return boost::dynamic_pointer_cast<AssetSwap>(*self)
                ->fairCleanPrice();
        }
SWIGINTERN Spread AssetSwapPtr_fairSpread(AssetSwapPtr *self){
            return boost::dynamic_pointer_cast<AssetSwap>(*self)
                ->fairSpread();
        }
SWIGINTERN FloatFloatSwapPtr *new_FloatFloatSwapPtr__SWIG_0(VanillaSwap::Type type,std::vector< Real > const &nominal1,std::vector< Real > const &nominal2,Schedule const &schedule1,InterestRateIndexPtr const &indexPtr1,DayCounter const &dayCount1,Schedule const &schedule2,InterestRateIndexPtr const &indexPtr2,DayCounter const &dayCount2,bool const intermediateCapitalExchange=false,bool const finalCapitalExchange=false,std::vector< Real > const &gearing1=std::vector< Real >(),std::vector< Real > const &spread1=std::vector< Real >(),std::vector< Real > const &cappedRate1=std::vector< Real >(),std::vector< Real > const &flooredRate1=std::vector< Real >(),std::vector< Real > const &gearing2=std::vector< Real >(),std::vector< Real > const &spread2=std::vector< Real >(),std::vector< Real > const &cappedRate2=std::vector< Real >(),std::vector< Real > const &flooredRate2=std::vector< Real >(),BusinessDayConvention paymentConvention1=Following,BusinessDayConvention paymentConvention2=Following){
            boost::shared_ptr<InterestRateIndex> index1 =
                boost::dynamic_pointer_cast<InterestRateIndex>(indexPtr1);
            boost::shared_ptr<InterestRateIndex> index2 =
                boost::dynamic_pointer_cast<InterestRateIndex>(indexPtr2);
            return new FloatFloatSwapPtr(
                    new FloatFloatSwap(type, nominal1,nominal2,schedule1,
                                    index1,dayCount1,schedule2,
                                    index2, dayCount2,
                                    intermediateCapitalExchange, finalCapitalExchange,
                                    gearing1, spread1, cappedRate1,
                                    flooredRate1, gearing2, spread2,
                                    cappedRate2, flooredRate2,
                                    paymentConvention1, paymentConvention2));
        }

using QuantLib::Pillar;
using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
using QuantLib::BondHelper;
using QuantLib::FixedRateBondHelper;
using QuantLib::OISRateHelper;
using QuantLib::DatedOISRateHelper;
using QuantLib::FxSwapRateHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;
typedef boost::shared_ptr<RateHelper> BondHelperPtr;
typedef boost::shared_ptr<RateHelper> FixedRateBondHelperPtr;
typedef boost::shared_ptr<RateHelper> OISRateHelperPtr;
typedef boost::shared_ptr<RateHelper> DatedOISRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FxSwapRateHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr< RateHelper > *self){
                return !(*self);
            }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle< Quote > const &rate,Period const &tenor,Natural fixingDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,fixingDays,
                                      calendar,convention,
                                      endOfMonth, dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Period const &tenor,Natural fixingDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate, tenor, fixingDays,
                                      calendar, convention,
                                      endOfMonth, dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_2(Handle< Quote > const &rate,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate, libor));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_3(Rate rate,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate, libor));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle< Quote > const &rate,Natural monthsToStart,Natural monthsToEnd,Natural fixingDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  fixingDays,calendar,convention,
                                  endOfMonth,dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Natural monthsToStart,Natural monthsToEnd,Natural fixingDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  fixingDays,calendar,convention,
                                  endOfMonth,dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_2(Handle< Quote > const &rate,Natural monthsToStart,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,libor));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_3(Rate rate,Natural monthsToStart,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,libor));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle< Quote > const &price,Date const &iborStartDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter,Handle< Quote > const &convexityAdjustment,Futures::Type type=Futures::IMM){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,iborStartDate,nMonths,
                                      calendar,convention,endOfMonth,
                                      dayCounter,convexityAdjustment,type));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_2(Real price,Date const &iborStartDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter,Rate convexityAdjustment=0.0,Futures::Type type=Futures::IMM){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,iborStartDate,nMonths,
                                      calendar,convention,endOfMonth,
                                      dayCounter,convexityAdjustment,type));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_5(Handle< Quote > const &price,Date const &iborStartDate,Date const &iborEndDate,DayCounter const &dayCounter,Handle< Quote > const &convexityAdjustment,Futures::Type type=Futures::IMM){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,iborStartDate,iborEndDate,
                                      dayCounter,convexityAdjustment,type));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_7(Real price,Date const &iborStartDate,Date const &iborEndDate,DayCounter const &dayCounter,Rate convexityAdjustment=0.0,Futures::Type type=Futures::IMM){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,iborStartDate,iborEndDate,
                                      dayCounter,convexityAdjustment,type));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_10(Handle< Quote > const &price,Date const &iborStartDate,IborIndexPtr const &index,Handle< Quote > const &convexityAdjustment,Futures::Type type=Futures::IMM){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,iborStartDate,libor,
                                      convexityAdjustment,type));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_12(Real price,Date const &iborStartDate,IborIndexPtr const &index,Real convexityAdjustment=0.0,Futures::Type type=Futures::IMM){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,iborStartDate,libor,
                                      convexityAdjustment,type));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle< Quote > const &rate,Period const &tenor,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,IborIndexPtr const &index,Handle< Quote > const &spread=Handle< Quote >(),Period const &fwdStart=0*Days,Handle< YieldTermStructure > const &discountingCurve=Handle< YieldTermStructure >(),Natural settlementDays=Null< Natural >(),Pillar::Choice pillar=Pillar::LastRelevantDate,Date customPillarDate=Date()){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, calendar,
                                   fixedFrequency, fixedConvention,
                                   fixedDayCount, libor,
                                   spread, fwdStart,
                                   discountingCurve, settlementDays,
                                   pillar, customPillarDate));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_7(Rate rate,Period const &tenor,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,IborIndexPtr const &index,Handle< Quote > const &spread=Handle< Quote >(),Period const &fwdStart=0*Days,Handle< YieldTermStructure > const &discountingCurve=Handle< YieldTermStructure >(),Natural settlementDays=Null< Natural >(),Pillar::Choice pillar=Pillar::LastRelevantDate,Date customPillarDate=Date()){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, calendar,
                                   fixedFrequency, fixedConvention,
                                   fixedDayCount, libor,
                                   spread, fwdStart,
                                   discountingCurve, settlementDays,
                                   pillar, customPillarDate));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_14(Handle< Quote > const &rate,SwapIndexPtr const &index,Handle< Quote > const &spread=Handle< Quote >(),Period const &fwdStart=0*Days,Handle< YieldTermStructure > const &discountingCurve=Handle< YieldTermStructure >(),Pillar::Choice pillar=Pillar::LastRelevantDate,Date customPillarDate=Date()){
            boost::shared_ptr<SwapIndex> swapIndex =
                boost::dynamic_pointer_cast<SwapIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, swapIndex,
                                   spread, fwdStart,
                                   discountingCurve,
                                   pillar, customPillarDate));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_20(Rate rate,SwapIndexPtr const &index,Handle< Quote > const &spread=Handle< Quote >(),Period const &fwdStart=0*Days,Handle< YieldTermStructure > const &discountingCurve=Handle< YieldTermStructure >(),Pillar::Choice pillar=Pillar::LastRelevantDate,Date customPillarDate=Date()){
            boost::shared_ptr<SwapIndex> swapIndex =
                boost::dynamic_pointer_cast<SwapIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, swapIndex,
                                   spread, fwdStart,
                                   discountingCurve,
                                   pillar, customPillarDate));
        }
SWIGINTERN VanillaSwapPtr SwapRateHelperPtr_swap(SwapRateHelperPtr *self){
            return boost::dynamic_pointer_cast<SwapRateHelper>(*self)->swap();
        }
SWIGINTERN BondHelperPtr *new_BondHelperPtr__SWIG_0(Handle< Quote > const &cleanPrice,BondPtr const &bond,bool useCleanPrice=true){
            boost::shared_ptr<Bond> b = boost::dynamic_pointer_cast<Bond>(bond);
            return new BondHelperPtr(
                new BondHelper(cleanPrice, b, useCleanPrice));
        }
SWIGINTERN BondPtr BondHelperPtr_bond(BondHelperPtr *self){
            return BondPtr(boost::dynamic_pointer_cast<BondHelper>(*self)->bond());
        }
SWIGINTERN FixedRateBondHelperPtr *new_FixedRateBondHelperPtr__SWIG_0(Handle< Quote > const &cleanPrice,Size settlementDays,Real faceAmount,Schedule const &schedule,std::vector< Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Date const &issueDate=Date(),Calendar const &paymentCalendar=Calendar(),Period const &exCouponPeriod=Period(),Calendar const &exCouponCalendar=Calendar(),BusinessDayConvention exCouponConvention=Unadjusted,bool exCouponEndOfMonth=false,bool useCleanPrice=true){
            return new FixedRateBondHelperPtr(
                new FixedRateBondHelper(cleanPrice, settlementDays, faceAmount,
                                        schedule, coupons, paymentDayCounter,
                                        paymentConvention, redemption,
                                        issueDate, paymentCalendar,
                                        exCouponPeriod, exCouponCalendar,
                                        exCouponConvention, exCouponEndOfMonth,
                                        useCleanPrice));
        }
SWIGINTERN FixedRateBondPtr FixedRateBondHelperPtr_bond(FixedRateBondHelperPtr *self){
            return FixedRateBondPtr(boost::dynamic_pointer_cast<FixedRateBondHelper>(*self)->bond());
        }
SWIGINTERN OISRateHelperPtr *new_OISRateHelperPtr__SWIG_0(Natural settlementDays,Period const &tenor,Handle< Quote > const &rate,OvernightIndexPtr const &index,Handle< YieldTermStructure > const &discountingCurve=Handle< YieldTermStructure >(),bool telescopicValueDates=false,Natural paymentLag=0,BusinessDayConvention paymentConvention=Following,Frequency paymentFrequency=Annual,Calendar const &paymentCalendar=Calendar(),Period const &forwardStart=0*Days,Spread const overnightSpread=0.0){
            boost::shared_ptr<OvernightIndex> overnight =
                boost::dynamic_pointer_cast<OvernightIndex>(index);
            return new OISRateHelperPtr(
                new OISRateHelper(settlementDays,tenor,rate,
                                  overnight,discountingCurve,
                                  telescopicValueDates, paymentLag,
                                  paymentConvention, paymentFrequency,
                                  paymentCalendar, forwardStart,
                                  overnightSpread));
        }
SWIGINTERN DatedOISRateHelperPtr *new_DatedOISRateHelperPtr__SWIG_0(Date const &startDate,Date const &endDate,Handle< Quote > const &rate,OvernightIndexPtr const &index,Handle< YieldTermStructure > const &discountingCurve=Handle< YieldTermStructure >()){
            boost::shared_ptr<OvernightIndex> overnight =
                boost::dynamic_pointer_cast<OvernightIndex>(index);
            return new DatedOISRateHelperPtr(
                new DatedOISRateHelper(startDate,endDate,rate,
                                       overnight,discountingCurve));
        }
SWIGINTERN FxSwapRateHelperPtr *new_FxSwapRateHelperPtr__SWIG_0(Handle< Quote > const &fwdPoint,Handle< Quote > const &spotFx,Period const &tenor,Natural fixingDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,bool isFxBaseCurrencyCollateralCurrency,Handle< YieldTermStructure > const &coll=Handle< YieldTermStructure >(),Calendar const &tradingCalendar=Calendar()){
            return new FxSwapRateHelperPtr(
                new FxSwapRateHelper(fwdPoint, spotFx, tenor,
                                     fixingDays, calendar, convention,
                                     endOfMonth,
                                     isFxBaseCurrencyCollateralCurrency,
                                     coll, tradingCalendar));
        }
SWIGINTERN std::vector< boost::shared_ptr< RateHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__get(std::vector< boost::shared_ptr< RateHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__set(std::vector< boost::shared_ptr< RateHelper > > *self,int i,std::vector< boost::shared_ptr< RateHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::FittedBondDiscountCurve;

typedef boost::shared_ptr<YieldTermStructure> FittedBondDiscountCurvePtr;
typedef QuantLib::FittedBondDiscountCurve::FittingMethod FittingMethod;

std::vector<boost::shared_ptr<BondHelper> > convert_bond_helpers(
                 const std::vector<boost::shared_ptr<RateHelper> >& helpers) {
    std::vector<boost::shared_ptr<BondHelper> > result(helpers.size());
    for (Size i=0; i<helpers.size(); ++i)
        result[i] = boost::dynamic_pointer_cast<BondHelper>(helpers[i]);
    return result;
}

SWIGINTERN FittedBondDiscountCurvePtr *new_FittedBondDiscountCurvePtr__SWIG_0(Natural settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< RateHelper > > const &helpers,DayCounter const &dayCounter,FittingMethod const &fittingMethod,Real accuracy=1.0e-10,Size maxEvaluations=10000,Array const &guess=Array(),Real simplexLambda=1.0){
            return new FittedBondDiscountCurvePtr(
                new FittedBondDiscountCurve(settlementDays,
                                            calendar,
                                            convert_bond_helpers(helpers),
                                            dayCounter,
                                            fittingMethod,
                                            accuracy,
                                            maxEvaluations,
                                            guess,
                                            simplexLambda));
        }
SWIGINTERN FittedBondDiscountCurvePtr *new_FittedBondDiscountCurvePtr__SWIG_5(Date const &referenceDate,std::vector< boost::shared_ptr< RateHelper > > const &helpers,DayCounter const &dayCounter,FittingMethod const &fittingMethod,Real accuracy=1.0e-10,Size maxEvaluations=10000,Array const &guess=Array(),Real simplexLambda=1.0){
            return new FittedBondDiscountCurvePtr(
                new FittedBondDiscountCurve(referenceDate,
                                            convert_bond_helpers(helpers),
                                            dayCounter,
                                            fittingMethod,
                                            accuracy,
                                            maxEvaluations,
                                            guess,
                                            simplexLambda));
        }
SWIGINTERN FittingMethod const &FittedBondDiscountCurvePtr_fitResults(FittedBondDiscountCurvePtr const *self){
            return boost::dynamic_pointer_cast<FittedBondDiscountCurve>(*self)
                ->fitResults();
        }

using QuantLib::ExponentialSplinesFitting;
using QuantLib::NelsonSiegelFitting;
using QuantLib::SvenssonFitting;
using QuantLib::CubicBSplinesFitting;
using QuantLib::SimplePolynomialFitting;


using QuantLib::InterpolatedForwardCurve;


typedef boost::shared_ptr<YieldTermStructure> ForwardCurvePtr;

SWIGINTERN ForwardCurvePtr *new_ForwardCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &forwards,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),BackwardFlat const &i=BackwardFlat()){
            return new ForwardCurvePtr(
                new InterpolatedForwardCurve<BackwardFlat>(dates,forwards,
                                                           dayCounter,
                                                           calendar,i));
        }
SWIGINTERN std::vector< Date > const &ForwardCurvePtr_dates(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &ForwardCurvePtr_forwards(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->forwards();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > ForwardCurvePtr_nodes(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->nodes();
        }

using QuantLib::Position;
using QuantLib::ForwardRateAgreement;
typedef boost::shared_ptr<Instrument> ForwardRateAgreementPtr;

SWIGINTERN ForwardRateAgreementPtr *new_ForwardRateAgreementPtr__SWIG_0(Date const &valueDate,Date const &maturityDate,Position::Type type,Rate strikeForwardRate,Real notionalAmount,IborIndexPtr const &index,Handle< YieldTermStructure > const &discountCurve=Handle< YieldTermStructure >()){
             
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);

            return new ForwardRateAgreementPtr(
                   new ForwardRateAgreement(valueDate, maturityDate, type,
                                            strikeForwardRate, notionalAmount,
                                            libor, discountCurve));
        }
SWIGINTERN Real ForwardRateAgreementPtr_spotIncome(ForwardRateAgreementPtr const *self,Handle< YieldTermStructure > const &discount){
            return boost::dynamic_pointer_cast<ForwardRateAgreement>(*self)
                ->spotIncome(discount);
        }
SWIGINTERN Real ForwardRateAgreementPtr_spotValue(ForwardRateAgreementPtr const *self){
            return boost::dynamic_pointer_cast<ForwardRateAgreement>(*self)
                ->spotValue();
        }
SWIGINTERN InterestRate ForwardRateAgreementPtr_forwardRate(ForwardRateAgreementPtr const *self){
            return boost::dynamic_pointer_cast<ForwardRateAgreement>(*self)
                ->forwardRate();
        }

using QuantLib::Gaussian1dModel;


SWIGINTERN bool boost_shared_ptr_Sl_Gaussian1dModel_Sg__isNull(boost::shared_ptr< Gaussian1dModel > *self){
                return !(*self);
            }

using QuantLib::Gsr;
using QuantLib::MarkovFunctional;

typedef boost::shared_ptr<Gaussian1dModel> GsrPtr;
typedef boost::shared_ptr<Gaussian1dModel> MarkovFunctionalPtr;

SWIGINTERN GsrPtr *new_GsrPtr__SWIG_0(Handle< YieldTermStructure > const &termStructure,std::vector< Date > const &volstepdates,std::vector< Handle< Quote > > const &volatilities,std::vector< Handle< Quote > > const &reversions,Real const T=60.0){
            return new GsrPtr(new Gsr(termStructure, volstepdates,
                                      volatilities, reversions, T));
        }
SWIGINTERN void GsrPtr_calibrateVolatilitiesIterative__SWIG_0(GsrPtr *self,std::vector< boost::shared_ptr< CalibrationHelper > > const &helpers,OptimizationMethod &method,EndCriteria const &endCriteria,Constraint const &constraint=Constraint(),std::vector< Real > const &weights=std::vector< Real >()){
            boost::dynamic_pointer_cast<Gsr>(*self)
                ->calibrateVolatilitiesIterative(helpers, method, endCriteria,
                                                 constraint, weights);
        }
SWIGINTERN void GsrPtr_calibrate__SWIG_0(GsrPtr *self,std::vector< boost::shared_ptr< CalibrationHelper > > const &helpers,OptimizationMethod &method,EndCriteria const &endCriteria,Constraint const &constraint=Constraint(),std::vector< Real > const &weights=std::vector< Real >(),std::vector< bool > const &fixParameters=std::vector< bool >()){
            boost::dynamic_pointer_cast<Gsr>(*self)
                ->calibrate(helpers, method, endCriteria,
                            constraint, weights, fixParameters);
        }
SWIGINTERN Array GsrPtr_params(GsrPtr const *self){
            return boost::dynamic_pointer_cast<Gsr>(*self)->params();
        }
SWIGINTERN Real GsrPtr_value(GsrPtr *self,Array const &params,std::vector< boost::shared_ptr< CalibrationHelper > > const &helpers){
            return boost::dynamic_pointer_cast<Gsr>(*self)->value(params, helpers);
        }
SWIGINTERN EndCriteria::Type GsrPtr_endCriteria(GsrPtr const *self){
            return boost::dynamic_pointer_cast<Gsr>(*self)->endCriteria();
        }
SWIGINTERN void GsrPtr_setParams(GsrPtr *self,Array const &params){
            boost::dynamic_pointer_cast<Gsr>(*self)->setParams(params);
        }
SWIGINTERN Integer GsrPtr_functionEvaluation(GsrPtr const *self){
            return boost::dynamic_pointer_cast<Gsr>(*self)->functionEvaluation();
        }
SWIGINTERN Array const &GsrPtr_reversion(GsrPtr const *self){
            return boost::dynamic_pointer_cast<Gsr>(*self)->reversion();
        }
SWIGINTERN Array const &GsrPtr_volatility(GsrPtr const *self){
            return boost::dynamic_pointer_cast<Gsr>(*self)->volatility();
        }
SWIGINTERN MarkovFunctionalPtr *new_MarkovFunctionalPtr__SWIG_0(Handle< YieldTermStructure > const &termStructure,Real const reversion,std::vector< Date > const &volstepdates,std::vector< Real > const &volatilities,Handle< SwaptionVolatilityStructure > const &swaptionVol,std::vector< Date > const &swaptionExpiries,std::vector< Period > const &swaptionTenors,SwapIndexPtr const &swapIndexBase,Size const yGridPoints=64,Real const yStdDevs=7.0,Size const gaussHermitePoints=32,Real const digitalGap=1E-5,Real const marketRateAccuracy=1E-7,Real const lowerRateBound=0.0,Real const upperRateBound=2.0,int const adjustments=MarkovFunctional::ModelSettings::KahaleSmile|MarkovFunctional::ModelSettings::SmileExponentialExtrapolation,std::vector< Real > const &smileMoneyCheckpoints=std::vector< Real >()){
            const boost::shared_ptr<SwapIndex> swapIndex =
                boost::dynamic_pointer_cast<SwapIndex>(swapIndexBase);
            MarkovFunctional::ModelSettings modelSettings =
                MarkovFunctional::ModelSettings(yGridPoints, yStdDevs,
                                                gaussHermitePoints, digitalGap,
                                                marketRateAccuracy,
                                                lowerRateBound,
                                                upperRateBound,
                                                adjustments,
                                                smileMoneyCheckpoints);
            return new MarkovFunctionalPtr(
                new MarkovFunctional(termStructure, reversion,
                                     volstepdates, volatilities,
                                     swaptionVol, swaptionExpiries,
                                     swaptionTenors, swapIndex,
                                     modelSettings));
        }
SWIGINTERN void MarkovFunctionalPtr_calibrate__SWIG_0(MarkovFunctionalPtr *self,std::vector< boost::shared_ptr< CalibrationHelper > > const &helper,OptimizationMethod &method,EndCriteria const &endCriteria,Constraint const &constraint=Constraint(),std::vector< Real > const &weights=std::vector< Real >(),std::vector< bool > const &fixParameters=std::vector< bool >()){
            boost::dynamic_pointer_cast<MarkovFunctional>(*self)->calibrate(helper, method, 
                                                                            endCriteria, constraint, weights, fixParameters);
        }
SWIGINTERN Array const &MarkovFunctionalPtr_volatility(MarkovFunctionalPtr const *self){
            return boost::dynamic_pointer_cast<MarkovFunctional>(*self)
                ->volatility();
        }

using QuantLib::Gaussian1dSwaptionEngine;
using QuantLib::Gaussian1dJamshidianSwaptionEngine;
using QuantLib::Gaussian1dNonstandardSwaptionEngine;
using QuantLib::Gaussian1dFloatFloatSwaptionEngine;
 
typedef boost::shared_ptr<PricingEngine> Gaussian1dSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> Gaussian1dJamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> Gaussian1dNonstandardSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> Gaussian1dFloatFloatSwaptionEnginePtr;

SWIGINTERN Gaussian1dSwaptionEnginePtr *new_Gaussian1dSwaptionEnginePtr__SWIG_0(boost::shared_ptr< Gaussian1dModel > const &model,int const integrationPoints=64,Real const stddevs=7.0,bool const extrapolatePayoff=true,bool const flatPayoffExtrapolation=false,Handle< YieldTermStructure > const &discountCurve=Handle< YieldTermStructure >()){
            return new Gaussian1dSwaptionEnginePtr(new Gaussian1dSwaptionEngine(model, integrationPoints, 
                    stddevs, extrapolatePayoff, flatPayoffExtrapolation, discountCurve));
        }
SWIGINTERN Gaussian1dJamshidianSwaptionEnginePtr *new_Gaussian1dJamshidianSwaptionEnginePtr(boost::shared_ptr< Gaussian1dModel > const &model){
            return new Gaussian1dJamshidianSwaptionEnginePtr(new Gaussian1dJamshidianSwaptionEngine(model));
        }
SWIGINTERN Gaussian1dNonstandardSwaptionEnginePtr *new_Gaussian1dNonstandardSwaptionEnginePtr__SWIG_0(boost::shared_ptr< Gaussian1dModel > const &model,int const integrationPoints=64,Real const stddevs=7.0,bool const extrapolatePayoff=true,bool const flatPayoffExtrapolation=false,Handle< Quote > const &oas=Handle< Quote >(),Handle< YieldTermStructure > const &discountCurve=Handle< YieldTermStructure >()){
            return new Gaussian1dNonstandardSwaptionEnginePtr(new Gaussian1dNonstandardSwaptionEngine(model, integrationPoints, 
                    stddevs, extrapolatePayoff, flatPayoffExtrapolation, oas, discountCurve));
        }
SWIGINTERN Gaussian1dFloatFloatSwaptionEnginePtr *new_Gaussian1dFloatFloatSwaptionEnginePtr__SWIG_0(boost::shared_ptr< Gaussian1dModel > const &model,int const integrationPoints=64,Real const stddevs=7.0,bool const extrapolatePayoff=true,bool const flatPayoffExtrapolation=false,Handle< Quote > const &oas=Handle< Quote >(),Handle< YieldTermStructure > const &discountCurve=Handle< YieldTermStructure >(),bool const includeTodaysExercise=false,Gaussian1dFloatFloatSwaptionEngine::Probabilities const probabilities=Gaussian1dFloatFloatSwaptionEngine::None){
            return new Gaussian1dFloatFloatSwaptionEnginePtr(
                new Gaussian1dFloatFloatSwaptionEngine(model,
                                                       integrationPoints,
                                                       stddevs,
                                                       extrapolatePayoff,
                                                       flatPayoffExtrapolation,
                                                       oas,
                                                       discountCurve,
                                                       includeTodaysExercise,
                                                       probabilities));
        }

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::Default;
using QuantLib::MidPoint;
using QuantLib::SimpsonIntegral;
using QuantLib::GaussKronrodAdaptive;
using QuantLib::GaussKronrodNonAdaptive;
using QuantLib::GaussLobattoIntegral;
using QuantLib::GaussLaguerreIntegration;
using QuantLib::GaussHermiteIntegration;
using QuantLib::GaussJacobiIntegration;
using QuantLib::GaussHyperbolicIntegration;
using QuantLib::GaussLegendreIntegration;
using QuantLib::GaussChebyshevIntegration;
using QuantLib::GaussChebyshev2ndIntegration;
using QuantLib::GaussGegenbauerIntegration;

SWIGINTERN Real SegmentIntegral_calculate(SegmentIntegral *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real TrapezoidIntegral_Sl_Default_Sg__calculate(TrapezoidIntegral< Default > *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real TrapezoidIntegral_Sl_MidPoint_Sg__calculate(TrapezoidIntegral< MidPoint > *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real SimpsonIntegral_calculate(SimpsonIntegral *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussKronrodAdaptive_calculate(GaussKronrodAdaptive *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussKronrodNonAdaptive_calculate(GaussKronrodNonAdaptive *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussLobattoIntegral_calculate(GaussLobattoIntegral *self,UnaryFunctionDelegate *f,Real a,Real b){
            return (*self)(UnaryFunction(f), a, b);		
        }
SWIGINTERN Real GaussLaguerreIntegration_calculate(GaussLaguerreIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussHermiteIntegration_calculate(GaussHermiteIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussJacobiIntegration_calculate(GaussJacobiIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussHyperbolicIntegration_calculate(GaussHyperbolicIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussLegendreIntegration_calculate(GaussLegendreIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussChebyshevIntegration_calculate(GaussChebyshevIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussChebyshev2ndIntegration_calculate(GaussChebyshev2ndIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }
SWIGINTERN Real GaussGegenbauerIntegration_calculate(GaussGegenbauerIntegration *self,UnaryFunctionDelegate *f){
            return (*self)(UnaryFunction(f));		
        }

using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;
using QuantLib::SobolBrownianGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;
using QuantLib::SobolBrownianBridgeRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

SWIGINTERN double Sample_Sl_Real_Sg__value(Sample< Real > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Real_Sg__weight(Sample< Real > *self){ return self->weight; }
SWIGINTERN Array Sample_Sl_Array_Sg__value(Sample< Array > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Array_Sg__weight(Sample< Array > *self){ return self->weight; }
SWIGINTERN std::vector< double > Sample_Sl_std_vector_Sl_Real_Sg__Sg__value(Sample< std::vector< Real > > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_std_vector_Sl_Real_Sg__Sg__weight(Sample< std::vector< Real > > *self){ return self->weight; }
SWIGINTERN Real UniformRandomGenerator_nextValue(UniformRandomGenerator const *self){
			return (*self).next().value;
		}
SWIGINTERN Real GaussianRandomGenerator_nextValue(GaussianRandomGenerator const *self){
			return (*self).next().value;
		}
SWIGINTERN std::vector< unsigned int > SobolRsg_nextInt32Sequence(SobolRsg *self){
        const std::vector<boost::uint_least32_t> &tmp = self->nextInt32Sequence();
        std::vector<unsigned int> outp(tmp.size());
        std::copy(tmp.begin(),tmp.end(),outp.begin());
        return outp;
      }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;


typedef QuantLib::PathGenerator<GaussianRandomSequenceGenerator>
    GaussianPathGenerator;

SWIGINTERN Path Sample_Sl_Path_Sg__value(Sample< Path > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Path_Sg__weight(Sample< Path > *self){ return self->weight; }
SWIGINTERN GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }

typedef QuantLib::PathGenerator<GaussianLowDiscrepancySequenceGenerator>
    GaussianSobolPathGenerator;

SWIGINTERN GaussianSobolPathGenerator *new_GaussianSobolPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianLowDiscrepancySequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianSobolPathGenerator(process1d,length,steps,
                                                  rsg,brownianBridge);
        }

using QuantLib::MultiPath;


typedef QuantLib::MultiPathGenerator<GaussianRandomSequenceGenerator>
    GaussianMultiPathGenerator;

SWIGINTERN MultiPath Sample_Sl_MultiPath_Sg__value(Sample< MultiPath > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_MultiPath_Sg__weight(Sample< MultiPath > *self){ return self->weight; }
SWIGINTERN GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr< StochasticProcess > const &process,std::vector< Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

using QuantLib::BrownianBridge;

SWIGINTERN std::vector< Real > BrownianBridge_transform(BrownianBridge *self,std::vector< Real > const &input){
      std::vector<Real> outp(input.size());
      self->transform(input.begin(),input.end(),outp.begin());
      return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_bridgeIndex(BrownianBridge const *self){
    	const std::vector<Size> &tmp = self->bridgeIndex();
    	std::vector<unsigned int> outp(tmp.size());
    	std::copy(tmp.begin(), tmp.end(), outp.begin());
    	return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_leftIndex(BrownianBridge const *self){
    	const std::vector<Size> &tmp = self->leftIndex();
    	std::vector<unsigned int> outp(tmp.size());
    	std::copy(tmp.begin(), tmp.end(), outp.begin());
    	return outp;
    }
SWIGINTERN std::vector< unsigned int > BrownianBridge_rightIndex(BrownianBridge const *self){
    	const std::vector<Size> &tmp = self->rightIndex();
    	std::vector<unsigned int> outp(tmp.size());
    	std::copy(tmp.begin(), tmp.end(), outp.begin());
    	return outp;
    }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
        DefaultBoundaryCondition;

SWIGINTERN bool boost_shared_ptr_Sl_DefaultBoundaryCondition_Sg__isNull(boost::shared_ptr< DefaultBoundaryCondition > *self){
                return !(*self);
            }

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<DefaultBoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<DefaultBoundaryCondition> DirichletBCPtr;

SWIGINTERN NeumannBCPtr *new_NeumannBCPtr(Real value,DefaultBoundaryCondition::Side side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
SWIGINTERN DirichletBCPtr *new_DirichletBCPtr(Real value,DefaultBoundaryCondition::Side side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::Discount;
using QuantLib::ZeroYield;
using QuantLib::ForwardRate;


using QuantLib::PiecewiseYieldCurve;


typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,BackwardFlat>(
                                                 referenceDate,instruments,
                                                 dayCounter, jumps, jumpDates,
                                                 accuracy,i));
        }
SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,BackwardFlat>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, jumps, jumpDates,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseFlatForwardPtr_nodes(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> PiecewiseLinearForwardPtr;

SWIGINTERN PiecewiseLinearForwardPtr *new_PiecewiseLinearForwardPtr__SWIG_0(Date const &referenceDate,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,Linear const &i=Linear()){
            return new PiecewiseLinearForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,Linear>(
                                                 referenceDate,instruments,
                                                 dayCounter, jumps, jumpDates,
                                                 accuracy,i));
        }
SWIGINTERN PiecewiseLinearForwardPtr *new_PiecewiseLinearForwardPtr__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,Linear const &i=Linear()){
            return new PiecewiseLinearForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,Linear>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, jumps, jumpDates,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseLinearForwardPtr_dates(PiecewiseLinearForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,Linear> PiecewiseLinearForward;
            return boost::dynamic_pointer_cast<PiecewiseLinearForward>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseLinearForwardPtr_times(PiecewiseLinearForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,Linear> PiecewiseLinearForward;
            return boost::dynamic_pointer_cast<PiecewiseLinearForward>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseLinearForwardPtr_nodes(PiecewiseLinearForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,Linear> PiecewiseLinearForward;
            return boost::dynamic_pointer_cast<PiecewiseLinearForward>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> PiecewiseLinearZeroPtr;

SWIGINTERN PiecewiseLinearZeroPtr *new_PiecewiseLinearZeroPtr__SWIG_0(Date const &referenceDate,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,Linear const &i=Linear()){
            return new PiecewiseLinearZeroPtr(
                new PiecewiseYieldCurve<ZeroYield,Linear>(
                                                 referenceDate,instruments,
                                                 dayCounter, jumps, jumpDates,
                                                 accuracy,i));
        }
SWIGINTERN PiecewiseLinearZeroPtr *new_PiecewiseLinearZeroPtr__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,Linear const &i=Linear()){
            return new PiecewiseLinearZeroPtr(
                new PiecewiseYieldCurve<ZeroYield,Linear>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, jumps, jumpDates,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseLinearZeroPtr_dates(PiecewiseLinearZeroPtr *self){
            typedef PiecewiseYieldCurve<ZeroYield,Linear> PiecewiseLinearZero;
            return boost::dynamic_pointer_cast<PiecewiseLinearZero>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseLinearZeroPtr_times(PiecewiseLinearZeroPtr *self){
            typedef PiecewiseYieldCurve<ZeroYield,Linear> PiecewiseLinearZero;
            return boost::dynamic_pointer_cast<PiecewiseLinearZero>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseLinearZeroPtr_nodes(PiecewiseLinearZeroPtr *self){
            typedef PiecewiseYieldCurve<ZeroYield,Linear> PiecewiseLinearZero;
            return boost::dynamic_pointer_cast<PiecewiseLinearZero>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> PiecewiseCubicZeroPtr;

SWIGINTERN PiecewiseCubicZeroPtr *new_PiecewiseCubicZeroPtr__SWIG_0(Date const &referenceDate,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,Cubic const &i=Cubic()){
            return new PiecewiseCubicZeroPtr(
                new PiecewiseYieldCurve<ZeroYield,Cubic>(
                                                 referenceDate,instruments,
                                                 dayCounter, jumps, jumpDates,
                                                 accuracy,i));
        }
SWIGINTERN PiecewiseCubicZeroPtr *new_PiecewiseCubicZeroPtr__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,Cubic const &i=Cubic()){
            return new PiecewiseCubicZeroPtr(
                new PiecewiseYieldCurve<ZeroYield,Cubic>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, jumps, jumpDates,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseCubicZeroPtr_dates(PiecewiseCubicZeroPtr *self){
            typedef PiecewiseYieldCurve<ZeroYield,Cubic> PiecewiseCubicZero;
            return boost::dynamic_pointer_cast<PiecewiseCubicZero>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseCubicZeroPtr_times(PiecewiseCubicZeroPtr *self){
            typedef PiecewiseYieldCurve<ZeroYield,Cubic> PiecewiseCubicZero;
            return boost::dynamic_pointer_cast<PiecewiseCubicZero>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseCubicZeroPtr_nodes(PiecewiseCubicZeroPtr *self){
            typedef PiecewiseYieldCurve<ZeroYield,Cubic> PiecewiseCubicZero;
            return boost::dynamic_pointer_cast<PiecewiseCubicZero>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> PiecewiseLogCubicDiscountPtr;

SWIGINTERN PiecewiseLogCubicDiscountPtr *new_PiecewiseLogCubicDiscountPtr__SWIG_0(Date const &referenceDate,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,MonotonicLogCubic const &i=MonotonicLogCubic()){
            return new PiecewiseLogCubicDiscountPtr(
                new PiecewiseYieldCurve<Discount,MonotonicLogCubic>(
                                                 referenceDate,instruments,
                                                 dayCounter, jumps, jumpDates,
                                                 accuracy,i));
        }
SWIGINTERN PiecewiseLogCubicDiscountPtr *new_PiecewiseLogCubicDiscountPtr__SWIG_5(Integer settlementDays,Calendar const &calendar,std::vector< boost::shared_ptr< RateHelper > > const &instruments,DayCounter const &dayCounter,std::vector< Handle< Quote > > const &jumps=std::vector< Handle< Quote > >(),std::vector< Date > const &jumpDates=std::vector< Date >(),Real accuracy=1.0e-12,MonotonicLogCubic const &i=MonotonicLogCubic()){
            return new PiecewiseLogCubicDiscountPtr(
                new PiecewiseYieldCurve<Discount,MonotonicLogCubic>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, jumps, jumpDates,
                                        accuracy, i));
        }
SWIGINTERN std::vector< Date > const &PiecewiseLogCubicDiscountPtr_dates(PiecewiseLogCubicDiscountPtr *self){
            typedef PiecewiseYieldCurve<Discount,MonotonicLogCubic> PiecewiseLogCubicDiscount;
            return boost::dynamic_pointer_cast<PiecewiseLogCubicDiscount>(*self)->dates();
        }
SWIGINTERN std::vector< Time > const &PiecewiseLogCubicDiscountPtr_times(PiecewiseLogCubicDiscountPtr *self){
            typedef PiecewiseYieldCurve<Discount,MonotonicLogCubic> PiecewiseLogCubicDiscount;
            return boost::dynamic_pointer_cast<PiecewiseLogCubicDiscount>(*self)->times();
        }
SWIGINTERN std::vector< std::pair< Date,Real > > PiecewiseLogCubicDiscountPtr_nodes(PiecewiseLogCubicDiscountPtr *self){
            typedef PiecewiseYieldCurve<Discount,MonotonicLogCubic> PiecewiseLogCubicDiscount;
            return boost::dynamic_pointer_cast<PiecewiseLogCubicDiscount>(*self)->nodes();
        }

using QuantLib::Settings;

SWIGINTERN Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
SWIGINTERN void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }
SWIGINTERN void Settings_includeReferenceDateEvents(Settings *self,bool b){
            self->includeReferenceDateEvents() = b;
        }
SWIGINTERN void Settings_includeTodaysCashFlows(Settings *self,bool b){
            self->includeTodaysCashFlows() = b;
        }

using QuantLib::Statistics;
using QuantLib::IncrementalStatistics;
using QuantLib::RiskStatistics;
using QuantLib::GenericSequenceStatistics;

SWIGINTERN void Statistics_add__SWIG_2(Statistics *self,std::vector< Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void Statistics_add__SWIG_3(Statistics *self,std::vector< Real > const &values,std::vector< Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }
SWIGINTERN void IncrementalStatistics_add__SWIG_2(IncrementalStatistics *self,std::vector< Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void IncrementalStatistics_add__SWIG_3(IncrementalStatistics *self,std::vector< Real > const &values,std::vector< Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::CapFloorTermVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_CapFloorTermVolatilityStructure_Sg__isNull(boost::shared_ptr< CapFloorTermVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr< Observable > boost_shared_ptr_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(boost::shared_ptr< CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr< Observable > Handle_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(Handle< CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::CapFloorTermVolCurve;
typedef boost::shared_ptr<CapFloorTermVolatilityStructure> CapFloorTermVolCurvePtr;

SWIGINTERN CapFloorTermVolCurvePtr *new_CapFloorTermVolCurvePtr__SWIG_0(Date const &referenceDate,Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &lengths,std::vector< Volatility > const &vols,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolCurvePtr(
                new CapFloorTermVolCurve(referenceDate,calendar,bdc,
                                         lengths,vols,dc));
        }
SWIGINTERN CapFloorTermVolCurvePtr *new_CapFloorTermVolCurvePtr__SWIG_2(Natural settlementDays,Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &lengths,std::vector< Volatility > const &vols,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolCurvePtr(
                new CapFloorTermVolCurve(settlementDays,calendar,bdc,
                                         lengths,vols,dc));
        }

using QuantLib::CapFloorTermVolSurface;
typedef boost::shared_ptr<CapFloorTermVolatilityStructure> CapFloorTermVolSurfacePtr;

SWIGINTERN CapFloorTermVolSurfacePtr *new_CapFloorTermVolSurfacePtr__SWIG_0(Natural settlementDays,Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &optionTenors,std::vector< Rate > const &strikes,std::vector< std::vector< Handle< Quote > > > const &quotes,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolSurfacePtr(new CapFloorTermVolSurface(settlementDays, 
            calendar,
            bdc,
            optionTenors,
            strikes,
            quotes,
            dc));
        }
SWIGINTERN CapFloorTermVolSurfacePtr *new_CapFloorTermVolSurfacePtr__SWIG_2(Date const &settlementDate,Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &optionTenors,std::vector< Rate > const &strikes,std::vector< std::vector< Handle< Quote > > > const &quotes,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolSurfacePtr(new CapFloorTermVolSurface(settlementDate, 
            calendar,
            bdc,
            optionTenors,
            strikes,
            quotes,
            dc));
        }
SWIGINTERN CapFloorTermVolSurfacePtr *new_CapFloorTermVolSurfacePtr__SWIG_4(Date const &settlementDate,Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &optionTenors,std::vector< Rate > const &strikes,Matrix const &volatilities,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolSurfacePtr(new CapFloorTermVolSurface(settlementDate, 
            calendar,
            bdc,
            optionTenors,
            strikes,
            volatilities,
            dc));
        }
SWIGINTERN CapFloorTermVolSurfacePtr *new_CapFloorTermVolSurfacePtr__SWIG_6(Natural settlementDays,Calendar const &calendar,BusinessDayConvention bdc,std::vector< Period > const &optionTenors,std::vector< Rate > const &strikes,Matrix const &volatilities,DayCounter const &dc=QuantLib::Actual365Fixed()){ 
            return new CapFloorTermVolSurfacePtr(new CapFloorTermVolSurface(settlementDays, 
            calendar,
            bdc,
            optionTenors,
            strikes,
            volatilities,
            dc));
        }

using QuantLib::StrippedOptionletBase;
using QuantLib::VolatilityType;

SWIGINTERN bool boost_shared_ptr_Sl_StrippedOptionletBase_Sg__isNull(boost::shared_ptr< StrippedOptionletBase > *self){
                return !(*self);
            }

using QuantLib::OptionletStripper1;
typedef boost::shared_ptr<StrippedOptionletBase> OptionletStripper1Ptr;

SWIGINTERN OptionletStripper1Ptr *new_OptionletStripper1Ptr__SWIG_0(CapFloorTermVolSurfacePtr const &parVolSurface,IborIndexPtr const &index,Rate switchStrikes=Null< Rate >(),Real accuracy=1.0e-6,Natural maxIter=100,Handle< YieldTermStructure > const &discount=Handle< YieldTermStructure >(),VolatilityType type=ShiftedLognormal,Real displacement=0.0,bool dontThrow=false){
            boost::shared_ptr<CapFloorTermVolSurface> surface = 
                boost::dynamic_pointer_cast<CapFloorTermVolSurface>(parVolSurface);
            boost::shared_ptr<IborIndex> idx =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new OptionletStripper1Ptr(new OptionletStripper1(surface,
                                                                    idx,
                                                                    switchStrikes,
                                                                    accuracy,
                                                                    maxIter,
                                                                    discount,
                                                                    type,
                                                                    displacement,
                                                                    dontThrow));
        }
SWIGINTERN Matrix const &OptionletStripper1Ptr_capFloorPrices(OptionletStripper1Ptr const *self){
            return boost::dynamic_pointer_cast<OptionletStripper1>(*self)
                ->capFloorPrices();
        }
SWIGINTERN Matrix const &OptionletStripper1Ptr_capFloorVolatilities(OptionletStripper1Ptr const *self){
            return boost::dynamic_pointer_cast<OptionletStripper1>(*self)
                ->capFloorVolatilities();
        }
SWIGINTERN Matrix const &OptionletStripper1Ptr_optionletPrices(OptionletStripper1Ptr const *self){
            return boost::dynamic_pointer_cast<OptionletStripper1>(*self)
                ->optionletPrices();
        }
SWIGINTERN Rate OptionletStripper1Ptr_switchStrike(OptionletStripper1Ptr const *self){
            return boost::dynamic_pointer_cast<OptionletStripper1>(*self)
                ->switchStrike();
        }

using QuantLib::StrippedOptionletAdapter;
typedef boost::shared_ptr<OptionletVolatilityStructure>
   StrippedOptionletAdapterPtr;

SWIGINTERN StrippedOptionletAdapterPtr *new_StrippedOptionletAdapterPtr(boost::shared_ptr< StrippedOptionletBase > const &stripper){
            return new StrippedOptionletAdapterPtr(
                new StrippedOptionletAdapter(stripper));
        }

using QuantLib::Actual365Fixed;
using QuantLib::Swaption;
using QuantLib::NonstandardSwaption;
using QuantLib::Settlement;
using QuantLib::FloatFloatSwaption;
typedef boost::shared_ptr<Instrument> SwaptionPtr;
typedef boost::shared_ptr<Instrument> NonstandardSwaptionPtr;
typedef boost::shared_ptr<Instrument> FloatFloatSwaptionPtr;

SWIGINTERN SwaptionPtr *new_SwaptionPtr__SWIG_0(VanillaSwapPtr const &simpleSwap,boost::shared_ptr< Exercise > const &exercise,Settlement::Type type=Settlement::Physical){
            boost::shared_ptr<VanillaSwap> swap =
                 boost::dynamic_pointer_cast<VanillaSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,type));
        }

using QuantLib::BasketGeneratingEngine;

SWIGINTERN NonstandardSwaptionPtr *new_NonstandardSwaptionPtr__SWIG_0(NonstandardSwapPtr const &nonstandardSwap,boost::shared_ptr< Exercise > const &exercise,Settlement::Type type=Settlement::Physical){
            boost::shared_ptr<NonstandardSwap> swap =
                 boost::dynamic_pointer_cast<NonstandardSwap>(nonstandardSwap);
            QL_REQUIRE(swap, "nonstandard swap required");
            return new NonstandardSwaptionPtr(new NonstandardSwaption(swap,exercise,type));
        }
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelper > > NonstandardSwaptionPtr_calibrationBasket(NonstandardSwaptionPtr *self,boost::shared_ptr< Index > standardSwapBase,boost::shared_ptr< SwaptionVolatilityStructure > swaptionVolatility,std::string typeStr){

            BasketGeneratingEngine::CalibrationBasketType type;
            if(typeStr == "Naive")
                type = BasketGeneratingEngine::Naive;
            else if(typeStr == "MaturityStrikeByDeltaGamma")
                type = BasketGeneratingEngine::MaturityStrikeByDeltaGamma;
            else
                QL_FAIL("type " << typeStr << "unknown.");
            boost::shared_ptr<SwapIndex> swapIndex =
                boost::dynamic_pointer_cast<SwapIndex>(standardSwapBase);
            return boost::dynamic_pointer_cast<NonstandardSwaption>(*self)->
                calibrationBasket(swapIndex, swaptionVolatility, type);
        }
SWIGINTERN FloatFloatSwaptionPtr *new_FloatFloatSwaptionPtr(FloatFloatSwapPtr const &simpleSwap,boost::shared_ptr< Exercise > const &exercise){
            boost::shared_ptr<FloatFloatSwap> swap =
                 boost::dynamic_pointer_cast<FloatFloatSwap>(simpleSwap);
            QL_REQUIRE(swap, "floatfloat swap required");
            return new FloatFloatSwaptionPtr(new FloatFloatSwaption(swap,exercise));
        }
SWIGINTERN std::vector< boost::shared_ptr< CalibrationHelper > > FloatFloatSwaptionPtr_calibrationBasket(FloatFloatSwaptionPtr *self,boost::shared_ptr< Index > standardSwapBase,boost::shared_ptr< SwaptionVolatilityStructure > swaptionVolatility,std::string typeStr){

            BasketGeneratingEngine::CalibrationBasketType type;
            if(typeStr == "Naive")
                type = BasketGeneratingEngine::Naive;
            else if(typeStr == "MaturityStrikeByDeltaGamma")
                type = BasketGeneratingEngine::MaturityStrikeByDeltaGamma;
            else
                QL_FAIL("type " << typeStr << "unknown.");
            boost::shared_ptr<SwapIndex> swapIndex =
                boost::dynamic_pointer_cast<SwapIndex>(standardSwapBase);
            return boost::dynamic_pointer_cast<FloatFloatSwaption>(*self)->
                calibrationBasket(swapIndex, swaptionVolatility, type);
        }
SWIGINTERN Real FloatFloatSwaptionPtr_underlyingValue(FloatFloatSwaptionPtr *self){
            return boost::dynamic_pointer_cast<FloatFloatSwaption>(*self)->result<Real>("underlyingValue");
        }

using QuantLib::BlackSwaptionEngine;
using QuantLib::BachelierSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> BachelierSwaptionEnginePtr;

SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr__SWIG_0(Handle< YieldTermStructure > const &discountCurve,Handle< Quote > const &vol,DayCounter const &dc=Actual365Fixed(),Real displacement=0.0){
            return new BlackSwaptionEnginePtr(
                          new BlackSwaptionEngine(discountCurve, vol, dc, displacement));
        }
SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr__SWIG_3(Handle< YieldTermStructure > const &discountCurve,Handle< SwaptionVolatilityStructure > const &v){
            return new BlackSwaptionEnginePtr(
                                   new BlackSwaptionEngine(discountCurve, v));
        }
SWIGINTERN Real BlackSwaptionEnginePtr_vega(BlackSwaptionEnginePtr *self){
                return boost::dynamic_pointer_cast<Swaption>(*self)->result<Real>("vega");
        }
SWIGINTERN BachelierSwaptionEnginePtr *new_BachelierSwaptionEnginePtr__SWIG_0(Handle< YieldTermStructure > const &discountCurve,Handle< Quote > const &vol,DayCounter const &dc=Actual365Fixed()){
            return new BlackSwaptionEnginePtr(
                          new BachelierSwaptionEngine(discountCurve, vol, dc));
        }
SWIGINTERN BachelierSwaptionEnginePtr *new_BachelierSwaptionEnginePtr__SWIG_2(Handle< YieldTermStructure > const &discountCurve,Handle< SwaptionVolatilityStructure > const &v){
            return new BlackSwaptionEnginePtr(
                                   new BachelierSwaptionEngine(discountCurve, v));
        }


void enableTracing() { 
    QL_TRACE_ENABLE;
}

void disableTracing() {
    QL_TRACE_DISABLE;
}



using QuantLib::ConstantEstimator;
using QuantLib::SimpleLocalEstimator;
using QuantLib::GarmanKlassSigma1;
using QuantLib::ParkinsonSigma;
using QuantLib::GarmanKlassSigma3;
using QuantLib::GarmanKlassSigma4;
using QuantLib::GarmanKlassSigma5;
using QuantLib::GarmanKlassSigma6;


using QuantLib::InterpolatedZeroCurve;


typedef boost::shared_ptr<YieldTermStructure> ZeroCurvePtr;

SWIGINTERN ZeroCurvePtr *new_ZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),Linear const &i=Linear(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new ZeroCurvePtr(
                new InterpolatedZeroCurve<Linear>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &ZeroCurvePtr_times(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &ZeroCurvePtr_data(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &ZeroCurvePtr_dates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &ZeroCurvePtr_zeroRates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > ZeroCurvePtr_nodes(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> LogLinearZeroCurvePtr;

SWIGINTERN LogLinearZeroCurvePtr *new_LogLinearZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),LogLinear const &i=LogLinear(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new LogLinearZeroCurvePtr(
                new InterpolatedZeroCurve<LogLinear>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &LogLinearZeroCurvePtr_times(LogLinearZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<LogLinear> LogLinearZeroCurve;
            return boost::dynamic_pointer_cast<LogLinearZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &LogLinearZeroCurvePtr_data(LogLinearZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<LogLinear> LogLinearZeroCurve;
            return boost::dynamic_pointer_cast<LogLinearZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &LogLinearZeroCurvePtr_dates(LogLinearZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<LogLinear> LogLinearZeroCurve;
            return boost::dynamic_pointer_cast<LogLinearZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &LogLinearZeroCurvePtr_zeroRates(LogLinearZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<LogLinear> LogLinearZeroCurve;
            return boost::dynamic_pointer_cast<LogLinearZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > LogLinearZeroCurvePtr_nodes(LogLinearZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<LogLinear> LogLinearZeroCurve;
            return boost::dynamic_pointer_cast<LogLinearZeroCurve>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> CubicZeroCurvePtr;

SWIGINTERN CubicZeroCurvePtr *new_CubicZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),Cubic const &i=Cubic(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new CubicZeroCurvePtr(
                new InterpolatedZeroCurve<Cubic>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &CubicZeroCurvePtr_times(CubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Cubic> CubicZeroCurve;
            return boost::dynamic_pointer_cast<CubicZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &CubicZeroCurvePtr_data(CubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Cubic> CubicZeroCurve;
            return boost::dynamic_pointer_cast<CubicZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &CubicZeroCurvePtr_dates(CubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Cubic> CubicZeroCurve;
            return boost::dynamic_pointer_cast<CubicZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &CubicZeroCurvePtr_zeroRates(CubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Cubic> CubicZeroCurve;
            return boost::dynamic_pointer_cast<CubicZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > CubicZeroCurvePtr_nodes(CubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Cubic> CubicZeroCurve;
            return boost::dynamic_pointer_cast<CubicZeroCurve>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> LogCubicZeroCurvePtr;

SWIGINTERN LogCubicZeroCurvePtr *new_LogCubicZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),DefaultLogCubic const &i=DefaultLogCubic(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new LogCubicZeroCurvePtr(
                new InterpolatedZeroCurve<DefaultLogCubic>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &LogCubicZeroCurvePtr_times(LogCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<DefaultLogCubic> LogCubicZeroCurve;
            return boost::dynamic_pointer_cast<LogCubicZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &LogCubicZeroCurvePtr_data(LogCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<DefaultLogCubic> LogCubicZeroCurve;
            return boost::dynamic_pointer_cast<LogCubicZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &LogCubicZeroCurvePtr_dates(LogCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<DefaultLogCubic> LogCubicZeroCurve;
            return boost::dynamic_pointer_cast<LogCubicZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &LogCubicZeroCurvePtr_zeroRates(LogCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<DefaultLogCubic> LogCubicZeroCurve;
            return boost::dynamic_pointer_cast<LogCubicZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > LogCubicZeroCurvePtr_nodes(LogCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<DefaultLogCubic> LogCubicZeroCurve;
            return boost::dynamic_pointer_cast<LogCubicZeroCurve>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> ForwardFlatZeroCurvePtr;

SWIGINTERN ForwardFlatZeroCurvePtr *new_ForwardFlatZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),ForwardFlat const &i=ForwardFlat(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new ForwardFlatZeroCurvePtr(
                new InterpolatedZeroCurve<ForwardFlat>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &ForwardFlatZeroCurvePtr_times(ForwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<ForwardFlat> ForwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<ForwardFlatZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &ForwardFlatZeroCurvePtr_data(ForwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<ForwardFlat> ForwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<ForwardFlatZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &ForwardFlatZeroCurvePtr_dates(ForwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<ForwardFlat> ForwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<ForwardFlatZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &ForwardFlatZeroCurvePtr_zeroRates(ForwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<ForwardFlat> ForwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<ForwardFlatZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > ForwardFlatZeroCurvePtr_nodes(ForwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<ForwardFlat> ForwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<ForwardFlatZeroCurve>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> BackwardFlatZeroCurvePtr;

SWIGINTERN BackwardFlatZeroCurvePtr *new_BackwardFlatZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),BackwardFlat const &i=BackwardFlat(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new BackwardFlatZeroCurvePtr(
                new InterpolatedZeroCurve<BackwardFlat>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &BackwardFlatZeroCurvePtr_times(BackwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<BackwardFlat> BackwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<BackwardFlatZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &BackwardFlatZeroCurvePtr_data(BackwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<BackwardFlat> BackwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<BackwardFlatZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &BackwardFlatZeroCurvePtr_dates(BackwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<BackwardFlat> BackwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<BackwardFlatZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &BackwardFlatZeroCurvePtr_zeroRates(BackwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<BackwardFlat> BackwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<BackwardFlatZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > BackwardFlatZeroCurvePtr_nodes(BackwardFlatZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<BackwardFlat> BackwardFlatZeroCurve;
            return boost::dynamic_pointer_cast<BackwardFlatZeroCurve>(*self)->nodes();
        }

typedef boost::shared_ptr<YieldTermStructure> MonotonicCubicZeroCurvePtr;

SWIGINTERN MonotonicCubicZeroCurvePtr *new_MonotonicCubicZeroCurvePtr__SWIG_0(std::vector< Date > const &dates,std::vector< Rate > const &yields,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),MonotonicCubic const &i=MonotonicCubic(),Compounding compounding=Continuous,Frequency frequency=Annual){
            return new MonotonicCubicZeroCurvePtr(
                new InterpolatedZeroCurve<MonotonicCubic>(dates,yields,
                                                        dayCounter,
                                                        calendar,i,
                                                        compounding,
                                                        frequency));
        }
SWIGINTERN std::vector< Time > const &MonotonicCubicZeroCurvePtr_times(MonotonicCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<MonotonicCubic> MonotonicCubicZeroCurve;
            return boost::dynamic_pointer_cast<MonotonicCubicZeroCurve>(*self)->times();
        }
SWIGINTERN std::vector< Real > const &MonotonicCubicZeroCurvePtr_data(MonotonicCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<MonotonicCubic> MonotonicCubicZeroCurve;
            return boost::dynamic_pointer_cast<MonotonicCubicZeroCurve>(*self)->data();
        }
SWIGINTERN std::vector< Date > const &MonotonicCubicZeroCurvePtr_dates(MonotonicCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<MonotonicCubic> MonotonicCubicZeroCurve;
            return boost::dynamic_pointer_cast<MonotonicCubicZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector< Rate > const &MonotonicCubicZeroCurvePtr_zeroRates(MonotonicCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<MonotonicCubic> MonotonicCubicZeroCurve;
            return boost::dynamic_pointer_cast<MonotonicCubicZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector< std::pair< Date,Rate > > MonotonicCubicZeroCurvePtr_nodes(MonotonicCubicZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<MonotonicCubic> MonotonicCubicZeroCurve;
            return boost::dynamic_pointer_cast<MonotonicCubicZeroCurve>(*self)->nodes();
        }

    ZeroCurvePtr as_zerocurve(const boost::shared_ptr<YieldTermStructure> & curve) {
        return boost::dynamic_pointer_cast<QuantLib::ZeroCurve>(curve);
    }


using QuantLib::Forward;
typedef boost::shared_ptr<Instrument> ForwardPtr;

SWIGINTERN Real ForwardPtr_forwardValue(ForwardPtr *self){
                return boost::dynamic_pointer_cast<Forward>(*self)
                    -> forwardValue();
            }
SWIGINTERN InterestRate ForwardPtr_impliedYield(ForwardPtr *self,Real underlyingSpotValue,Real forwardValue,Date settlementDate,Compounding compoundingConvention,DayCounter dayCounter){
                    return boost::dynamic_pointer_cast<Forward>(*self)
                        -> impliedYield(underlyingSpotValue, forwardValue,
                                        settlementDate, compoundingConvention, 
                                        dayCounter);
                }

using QuantLib::FixedRateBondForward;
using QuantLib::FixedRateBond;
using QuantLib::BusinessDayConvention;
using QuantLib::Position;
typedef boost::shared_ptr<Instrument> FixedRateBondForwardPtr;

SWIGINTERN FixedRateBondForwardPtr *new_FixedRateBondForwardPtr__SWIG_0(Date const &valueDate,Date const &maturityDate,Position::Type type,Real strike,Natural settlementDays,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention businessDayConvention,FixedRateBondPtr const &fixedBond,Handle< YieldTermStructure > const &discountCurve=Handle< YieldTermStructure >(),Handle< YieldTermStructure > const &incomeDiscountCurve=Handle< YieldTermStructure >()){
                const boost::shared_ptr<FixedRateBond>& fixedCouponBond = 
                    boost::dynamic_pointer_cast<FixedRateBond>(fixedBond);
                return new FixedRateBondForwardPtr(
                       new FixedRateBondForward(
                            valueDate, maturityDate, type, strike,
                            settlementDays, dayCounter, calendar,
                            businessDayConvention, fixedCouponBond,
                            discountCurve,  incomeDiscountCurve));
            }
SWIGINTERN Real FixedRateBondForwardPtr_forwardPrice(FixedRateBondForwardPtr *self){
                return boost::dynamic_pointer_cast<FixedRateBondForward>(*self)
                    -> forwardPrice();
            }
SWIGINTERN Real FixedRateBondForwardPtr_cleanForwardPrice(FixedRateBondForwardPtr *self){
                return boost::dynamic_pointer_cast<FixedRateBondForward>(*self)
                    -> cleanForwardPrice();
            }
SWIGINTERN Real FixedRateBondForwardPtr_spotIncome(FixedRateBondForwardPtr *self,Handle< YieldTermStructure > const &incomeDiscountCurve){
                return boost::dynamic_pointer_cast<FixedRateBondForward>(*self)
                    -> spotIncome(incomeDiscountCurve);
            }
SWIGINTERN Real FixedRateBondForwardPtr_spotValue(FixedRateBondForwardPtr *self){
                return boost::dynamic_pointer_cast<FixedRateBondForward>(*self)
                    -> spotValue();
            }


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "quantlib_wrap.h"

SwigDirector_UnaryFunctionDelegate::SwigDirector_UnaryFunctionDelegate(JNIEnv *jenv) : UnaryFunctionDelegate(), Swig::Director(jenv) {
}

SwigDirector_UnaryFunctionDelegate::~SwigDirector_UnaryFunctionDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Real SwigDirector_UnaryFunctionDelegate::value(Real x) const {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jx  ;
  
  if (!swig_override[0]) {
    return UnaryFunctionDelegate::value(x);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jx = (jdouble) x;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[0], swigjobj, jx);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in UnaryFunctionDelegate::value ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_UnaryFunctionDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "value", "(D)D", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/UnaryFunctionDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_CostFunctionDelegate::SwigDirector_CostFunctionDelegate(JNIEnv *jenv) : CostFunctionDelegate(), Swig::Director(jenv) {
}

SwigDirector_CostFunctionDelegate::~SwigDirector_CostFunctionDelegate() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Real SwigDirector_CostFunctionDelegate::value(Array const &x) const {
  Real c_result = SwigValueInit< Real >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jx = 0 ;
  
  if (!swig_override[0]) {
    return CostFunctionDelegate::value(x);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jx = (Array *) &x; 
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[1], swigjobj, jx);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Real)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CostFunctionDelegate::value ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Array SwigDirector_CostFunctionDelegate::values(Array const &x) const {
  Array c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jx = 0 ;
  Array *argp ;
  
  if (!swig_override[1]) {
    return CostFunctionDelegate::values(x);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Array **)&jx = (Array *) &x; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_QuantLibJNI, Swig::director_method_ids[2], swigjobj, jx);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    argp = *(Array **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Array");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CostFunctionDelegate::values ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CostFunctionDelegate::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "value", "(Lorg/quantlib/Array;)D", NULL 
    },
    {
      "values", "(Lorg/quantlib/Array;)Lorg/quantlib/Array;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/quantlib/CostFunctionDelegate");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Period *)new Period();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  {
    try {
      result = (Period *)new Period(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Frequency arg1 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Frequency)jarg1; 
  {
    try {
      result = (Period *)new Period(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (Integer)((Period const *)arg1)->length();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1units(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  TimeUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (TimeUnit)((Period const *)arg1)->units();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Frequency result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (Frequency)((Period const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Period *)new_Period__SWIG_3((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = Period___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1repr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = Period___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Period(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Period *arg1 = (Period *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< Period > *)new std::vector< Period >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< Period >::size_type arg1 ;
  std::vector< Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< Period >::size_type)jarg1; 
  {
    try {
      result = (std::vector< Period > *)new std::vector< Period >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      result = ((std::vector< Period > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      result = ((std::vector< Period > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = (std::vector< Period >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< Period > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  std::vector< Period >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = *(std::vector< Period >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Period >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< Period >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  std::vector< Period >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Period >::value_type *) &std_vector_Sl_Period_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Period >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  int arg2 ;
  std::vector< Period >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Period > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< Period >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Period >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__set(arg1,arg2,(Period const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Period > *arg1 = (std::vector< Period > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Period > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Date *)new Date();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  {
    try {
      result = (Date *)new Date(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Millisecond arg7 ;
  Microsecond arg8 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  arg7 = (Millisecond)jarg7; 
  arg8 = (Microsecond)jarg8; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Millisecond arg7 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  arg7 = (Millisecond)jarg7; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Hour arg4 ;
  Minute arg5 ;
  Second arg6 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  arg4 = (Hour)jarg4; 
  arg5 = (Minute)jarg5; 
  arg6 = (Second)jarg6; 
  {
    try {
      result = (Date *)new_Date__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  BigInteger arg1 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (BigInteger)jarg1; 
  {
    try {
      result = (Date *)new Date(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Weekday result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Weekday)((Date const *)arg1)->weekday();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfMonth();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfYear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfYear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1month(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Month result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Month)((Date const *)arg1)->month();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1year(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Year result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Year)((Date const *)arg1)->year();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1hours(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Hour result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Hour)Date_hours(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1minutes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Minute result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Minute)Date_minutes(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1seconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Second result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Second)Date_seconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1milliseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Millisecond result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Millisecond)Date_milliseconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1microseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Microsecond result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Microsecond)Date_microseconds(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Date_1fractionOfDay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Time)Date_fractionOfDay((Date const *)arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Date_1fractionOfSecond(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Time)Date_fractionOfSecond((Date const *)arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1serialNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (BigInteger)((Date const *)arg1)->serialNumber();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isLeap(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  Year arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Year)jarg1; 
  {
    try {
      result = (bool)Date::isLeap(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1minDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::minDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1maxDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1todaysDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::todaysDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1localDateTime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date_localDateTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1universalDateTime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date_universalDateTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1endOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = Date::endOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Date::isEndOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nextWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Weekday arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = Date::nextWeekday((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nthWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Size arg1 ;
  Weekday arg2 ;
  Month arg3 ;
  Year arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Weekday)jarg2; 
  arg3 = (Month)jarg3; 
  arg4 = (Year)jarg4; 
  {
    try {
      result = Date::nthWeekday(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator +(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator -(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1; 
  arg2 = *(Period **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator +((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1; 
  arg2 = *(Period **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator -((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string arg2 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Date *)new_Date__SWIG_6((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekdayNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Integer)Date_weekdayNumber(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1ISO(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date_ISO(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Date(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Date *arg1 = (Date *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parseFormatted(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = DateParser::parseFormatted((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parseISO(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = DateParser::parseISO((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parse(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = DateParser_parse((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  DateParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (DateParser *)new DateParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DateParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DateParser *arg1 = (DateParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DateParser **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodParser_1parse(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Period result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = PeriodParser::parse((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = new Period((const Period &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  PeriodParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (PeriodParser *)new PeriodParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(PeriodParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PeriodParser *arg1 = (PeriodParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PeriodParser **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< Date > *)new std::vector< Date >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< Date >::size_type arg1 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< Date >::size_type)jarg1; 
  {
    try {
      result = (std::vector< Date > *)new std::vector< Date >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      result = ((std::vector< Date > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      result = ((std::vector< Date > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = (std::vector< Date >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< Date > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  std::vector< Date >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = *(std::vector< Date >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< Date >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  std::vector< Date >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Date >::value_type *) &std_vector_Sl_Date_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  int arg2 ;
  std::vector< Date >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Date > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< Date >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__set(arg1,arg2,(Date const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Date > *arg1 = (std::vector< Date > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Date > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1F_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::F;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1G_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::G;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1H_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::H;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1J_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::J;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1K_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::K;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1M_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::M;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1N_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::N;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1Q_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::Q;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1U_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::U;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1V_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::V;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1X_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::X;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1Z_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::Z;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMcode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMcode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1date_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = IMM::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = IMM::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IMM(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  IMM *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (IMM *)new IMM();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(IMM **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IMM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  IMM *arg1 = (IMM *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(IMM **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1F_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::F;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1G_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::G;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1H_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::H;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1J_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::J;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1K_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::K;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1M_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::M;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1N_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::N;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1Q_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::Q;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1U_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::U;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1V_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::V;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1X_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::X;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_ASX_1Z_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ASX::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (ASX::Month)ASX::Z;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)ASX::isASXdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)ASX::isASXdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXcode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)ASX::isASXcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_ASX_1isASXcode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (bool)ASX::isASXcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1date_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = ASX::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = ASX::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextDate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = ASX::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = ASX::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_ASX_1nextCode_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = ASX::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ASX(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ASX *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (ASX *)new ASX();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ASX **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ASX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ASX *arg1 = (ASX *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ASX **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< int > *)new std::vector< int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< int >::size_type arg1 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< int >::size_type)jarg1; 
  {
    try {
      result = (std::vector< int > *)new std::vector< int >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      result = ((std::vector< int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      result = ((std::vector< int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = (std::vector< int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< int > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector< int >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< int >::value_type *) &std_vector_Sl_int_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__set(arg1,arg2,(int const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IntVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< unsigned int > *)new std::vector< unsigned int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnsignedIntVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< unsigned int >::size_type arg1 ;
  std::vector< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< unsigned int >::size_type)jarg1; 
  {
    try {
      result = (std::vector< unsigned int > *)new std::vector< unsigned int >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      result = ((std::vector< unsigned int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      result = ((std::vector< unsigned int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = (std::vector< unsigned int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< unsigned int > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  std::vector< unsigned int >::value_type *arg2 = 0 ;
  std::vector< unsigned int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  temp2 = (std::vector< unsigned int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector< unsigned int >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  std::vector< unsigned int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type *) &std_vector_Sl_unsigned_SS_int_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnsignedIntVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  int arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_unsigned_SS_int_Sg__set(arg1,arg2,(unsigned int const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnsignedIntVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< unsigned int > *arg1 = (std::vector< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< unsigned int > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< double > *)new std::vector< double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< double >::size_type arg1 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< double >::size_type)jarg1; 
  {
    try {
      result = (std::vector< double > *)new std::vector< double >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      result = ((std::vector< double > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      result = ((std::vector< double > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = (std::vector< double >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< double > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::value_type *arg2 = 0 ;
  std::vector< double >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  temp2 = (std::vector< double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector< double >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< double >::value_type *) &std_vector_Sl_double_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__set(arg1,arg2,(double const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DoubleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::string >::size_type arg1 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::string >::size_type)jarg1; 
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::string > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::vector< std::string >::value_type arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->push_back((std::vector< std::string >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (int)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__set(arg1,arg2,(std::string const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1StrVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BoolVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BoolVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< bool >::size_type arg1 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< bool >::size_type)jarg1; 
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      result = ((std::vector< bool > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      result = ((std::vector< bool > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = (std::vector< bool >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< bool > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::value_type *arg2 = 0 ;
  std::vector< bool >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector< bool >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (bool)std_vector_Sl_bool_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BoolVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__set(arg1,arg2,(bool const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BoolVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  Date arg1 ;
  double arg2 ;
  Date *argp1 ;
  std::pair< Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(Date **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Date,double > *arg1 = 0 ;
  std::pair< Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< Date,double > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::pair< Date,double > *)new std::pair< Date,double >((std::pair< Date,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair< Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  Date *arg2 = (Date *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  arg2 = *(Date **)&jarg2; 
  if (arg1) (arg1)->first = *arg2;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  result = (Date *)& ((arg1)->first);
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  result = (double) ((arg1)->second);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NodePair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< Date,double > *arg1 = (std::pair< Date,double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< Date,double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::pair< Date,double > > *)new std::vector< std::pair< Date,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > >::size_type arg1 ;
  std::vector< std::pair< Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::pair< Date,double > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< std::pair< Date,double > > *)new std::vector< std::pair< Date,double > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::pair< Date,double > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::pair< Date,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = (std::vector< std::pair< Date,double > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::pair< Date,double > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  std::vector< std::pair< Date,double > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = *(std::vector< std::pair< Date,double > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< Date,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< std::pair< Date,double > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< Date,double > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::pair< Date,double > >::value_type *) &std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::pair< Date,double > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  int arg2 ;
  std::vector< std::pair< Date,double > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< std::pair< Date,double > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::pair< Date,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__set(arg1,arg2,(std::pair< Date,double > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NodeVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::pair< Date,double > > *arg1 = (std::vector< std::pair< Date,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::pair< Date,double > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI__1Exercise_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      result = (Exercise::Type)((Exercise const *)arg1)->type();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI__1Exercise_1dates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      result = (std::vector< Date > *) &((Exercise const *)arg1)->dates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI__1Exercise_1lastDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      result = ((Exercise const *)arg1)->lastDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1_1Exercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Exercise *arg1 = (Exercise *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  Exercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      result = (Exercise *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Exercise **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Exercise_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1American_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  enum Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  result = (enum Exercise::Type)Exercise::American;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1Bermudan_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  enum Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  result = (enum Exercise::Type)Exercise::Bermudan;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1European_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  enum Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  result = (enum Exercise::Type)Exercise::European;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1exerciseType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      result = (Exercise::Type)boost_shared_ptr_Sl_Exercise_Sg__exerciseType(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Exercise(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr< Exercise > *)new boost::shared_ptr< Exercise >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr< Exercise > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Exercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      result = (Exercise::Type)(*arg1)->type();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1dates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  std::vector< Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      result = (std::vector< Date > *) &(*arg1)->dates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1lastDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > *arg1 = (boost::shared_ptr< Exercise > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  {
    try {
      result = (*arg1)->lastDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EuropeanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  EuropeanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (EuropeanExercisePtr *)new_EuropeanExercisePtr((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(EuropeanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EuropeanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  EuropeanExercisePtr *arg1 = (EuropeanExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(EuropeanExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AmericanExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  AmericanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (AmericanExercisePtr *)new_AmericanExercisePtr__SWIG_0((Date const &)*arg1,(Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(AmericanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AmericanExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  AmericanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (AmericanExercisePtr *)new_AmericanExercisePtr__SWIG_0((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(AmericanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1AmericanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AmericanExercisePtr *arg1 = (AmericanExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AmericanExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BermudanExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = 0 ;
  bool arg2 ;
  BermudanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date > const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (BermudanExercisePtr *)new_BermudanExercisePtr__SWIG_0((std::vector< Date > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BermudanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BermudanExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Date > *arg1 = 0 ;
  BermudanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Date > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Date > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BermudanExercisePtr *)new_BermudanExercisePtr__SWIG_0((std::vector< Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BermudanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BermudanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BermudanExercisePtr *arg1 = (BermudanExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BermudanExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > arg1 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  Calendar *arg4 = 0 ;
  BusinessDayConvention arg5 ;
  boost::shared_ptr< Exercise > const *argp1 ;
  std::vector< Real > const *argp2 ;
  RebatedExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  argp1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::shared_ptr< Exercise > const");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  arg4 = *(Calendar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (RebatedExercisePtr *)new_RebatedExercisePtr__SWIG_0(arg1,arg2,arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RebatedExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > arg1 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  Calendar *arg4 = 0 ;
  boost::shared_ptr< Exercise > const *argp1 ;
  std::vector< Real > const *argp2 ;
  RebatedExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  argp1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::shared_ptr< Exercise > const");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  arg4 = *(Calendar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RebatedExercisePtr *)new_RebatedExercisePtr__SWIG_0(arg1,arg2,arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RebatedExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > arg1 ;
  std::vector< Real > arg2 ;
  Natural arg3 ;
  boost::shared_ptr< Exercise > const *argp1 ;
  std::vector< Real > const *argp2 ;
  RebatedExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::shared_ptr< Exercise > const");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (Natural)jarg3; 
  {
    try {
      result = (RebatedExercisePtr *)new_RebatedExercisePtr__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RebatedExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RebatedExercise_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Exercise > arg1 ;
  std::vector< Real > arg2 ;
  boost::shared_ptr< Exercise > const *argp1 ;
  std::vector< Real > const *argp2 ;
  RebatedExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(boost::shared_ptr< Exercise > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::shared_ptr< Exercise > const");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(std::vector< Real > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< Real > const");
    return 0;
  }
  arg2 = *argp2; 
  {
    try {
      result = (RebatedExercisePtr *)new_RebatedExercisePtr__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RebatedExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RebatedExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RebatedExercisePtr *arg1 = (RebatedExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RebatedExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Observable_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Observable > *arg1 = (boost::shared_ptr< Observable > *) 0 ;
  Observable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Observable > **)&jarg1; 
  {
    try {
      result = (Observable *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Observable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Observable_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr< Observable > *arg1 = (boost::shared_ptr< Observable > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Observable > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Observable(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr< Observable > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr< Observable > *)new boost::shared_ptr< Observable >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr< Observable > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Observable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr< Observable > *arg1 = (boost::shared_ptr< Observable > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr< Observable > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Array *)new Array();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  Size arg1 ;
  Real arg2 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Array *)new Array(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  Size arg1 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  {
    try {
      result = (Array *)new Array(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Array *)new Array((Array const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Array_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      result = ((Array const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Array_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      result = Array___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Array_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Real)Array_get(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Array_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      Array_set(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Array(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Array *arg1 = (Array *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1xSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->xSize();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1ySize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->ySize();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Size arg2 ;
  DefaultLexicographicalView *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array & reference is null");
    return 0;
  } 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (DefaultLexicographicalView *)new_DefaultLexicographicalView(*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DefaultLexicographicalView **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = DefaultLexicographicalView___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Matrix *)new Matrix();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  Size arg1 ;
  Size arg2 ;
  Real arg3 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  Size arg1 ;
  Size arg2 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Matrix *)new Matrix((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1rows(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->rows();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1columns(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->columns();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = Matrix___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  {
    try {
      result = (Real)Matrix_get(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jdouble jarg4) {
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      Matrix_set(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Matrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Matrix *arg1 = (Matrix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SalvagingAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SalvagingAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SalvagingAlgorithm **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_transpose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = transpose((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_outerProduct(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_pseudoSqrt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  SalvagingAlgorithm::Type arg2 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  arg2 = (SalvagingAlgorithm::Type)jarg2; 
  {
    try {
      result = pseudoSqrt((Matrix const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  SVD *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SVD *)new SVD((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SVD **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1U(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = (Matrix *) &((SVD const *)arg1)->U();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1V(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = (Matrix *) &((SVD const *)arg1)->V();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1S(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = ((SVD const *)arg1)->S();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((const Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1singularValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = (Array *) &((SVD const *)arg1)->singularValues();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SVD *arg1 = (SVD *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnaryFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  UnaryFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  {
    try {
      result = (UnaryFunction *)new UnaryFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(UnaryFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunction_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  UnaryFunction *arg1 = (UnaryFunction *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunction **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunction const *)arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnaryFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  UnaryFunction *arg1 = (UnaryFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(UnaryFunction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnaryFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunctionDelegate const *)arg1)->value(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1valueSwigExplicitUnaryFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  UnaryFunctionDelegate *arg1 = (UnaryFunctionDelegate *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(UnaryFunctionDelegate **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)((UnaryFunctionDelegate const *)arg1)->UnaryFunctionDelegate::value(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnaryFunctionDelegate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  UnaryFunctionDelegate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (UnaryFunctionDelegate *)new SwigDirector_UnaryFunctionDelegate(jenv);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(UnaryFunctionDelegate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  UnaryFunctionDelegate *obj = *((UnaryFunctionDelegate **)&objarg);
  (void)jcls;
  SwigDirector_UnaryFunctionDelegate *director = dynamic_cast<SwigDirector_UnaryFunctionDelegate *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_UnaryFunctionDelegate_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  UnaryFunctionDelegate *obj = *((UnaryFunctionDelegate **)&objarg);
  SwigDirector_UnaryFunctionDelegate *director = dynamic_cast<SwigDirector_UnaryFunctionDelegate *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JavaCostFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  JavaCostFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  {
    try {
      result = (JavaCostFunction *)new JavaCostFunction(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(JavaCostFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JavaCostFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  JavaCostFunction *arg1 = (JavaCostFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(JavaCostFunction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_JavaCostFunction_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  JavaCostFunction *arg1 = (JavaCostFunction *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(JavaCostFunction **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((JavaCostFunction const *)arg1)->value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_JavaCostFunction_1values(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  JavaCostFunction *arg1 = (JavaCostFunction *) 0 ;
  Array *arg2 = 0 ;
  SwigValueWrapper< Disposable< Array > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(JavaCostFunction **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((JavaCostFunction const *)arg1)->values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Disposable< Array > **)&jresult = new Disposable< Array >((const Disposable< Array > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CostFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((CostFunctionDelegate const *)arg1)->value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1valueSwigExplicitCostFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((CostFunctionDelegate const *)arg1)->CostFunctionDelegate::value((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1values(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((CostFunctionDelegate const *)arg1)->values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1valuesSwigExplicitCostFunctionDelegate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  CostFunctionDelegate *arg1 = (CostFunctionDelegate *) 0 ;
  Array *arg2 = 0 ;
  Array result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CostFunctionDelegate **)&jarg1; 
  arg2 = *(Array **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((CostFunctionDelegate const *)arg1)->CostFunctionDelegate::values((Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = new Array((const Array &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CostFunctionDelegate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CostFunctionDelegate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (CostFunctionDelegate *)new SwigDirector_CostFunctionDelegate(jenv);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(CostFunctionDelegate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  CostFunctionDelegate *obj = *((CostFunctionDelegate **)&objarg);
  (void)jcls;
  SwigDirector_CostFunctionDelegate *director = dynamic_cast<SwigDirector_CostFunctionDelegate *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_CostFunctionDelegate_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  CostFunctionDelegate *obj = *((CostFunctionDelegate **)&objarg);
  SwigDirector_CostFunctionDelegate *director = dynamic_cast<SwigDirector_CostFunctionDelegate *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Quote_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Quote > *arg1 = (boost::shared_ptr< Quote > *) 0 ;
  Quote *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1; 
  {
    try {
      result = (Quote *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Quote **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Quote_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr< Quote > *arg1 = (boost::shared_ptr< Quote > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Quote_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Quote > *arg1 = (boost::shared_ptr< Quote > *) 0 ;
  boost::shared_ptr< Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr< Observable > **)&jresult = new boost::shared_ptr< Observable >((const boost::shared_ptr< Observable > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Quote(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr< Quote > *)new boost::shared_ptr< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Quote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr< Quote > *arg1 = (boost::shared_ptr< Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Quote_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr< Quote > *arg1 = (boost::shared_ptr< Quote > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Quote > *arg1 = 0 ;
  Handle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr< Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Handle< Quote > *)new Handle< Quote >((boost::shared_ptr< Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle< Quote > *)new Handle< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  boost::shared_ptr< Quote > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr< Quote > **)&jresult = new boost::shared_ptr< Quote >((const boost::shared_ptr< Quote > &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  boost::shared_ptr< Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = Handle_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr< Observable > **)&jresult = new boost::shared_ptr< Observable >((const boost::shared_ptr< Observable > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle< Quote > *arg1 = (Handle< Quote > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle< Quote > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr< Quote > *arg1 = 0 ;
  RelinkableHandle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr< Quote > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr< Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RelinkableHandle< Quote > *)new RelinkableHandle< Quote >((boost::shared_ptr< Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RelinkableHandle< Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (RelinkableHandle< Quote > *)new RelinkableHandle< Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle< Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  boost::shared_ptr< Quote > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RelinkableHandle< Quote > **)&jarg1; 
  arg2 = *(boost::shared_ptr< Quote > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr< Quote > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr< Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RelinkableHandle< Quote > *arg1 = (RelinkableHandle< Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RelinkableHandle< Quote > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleQuote(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  Real arg1 ;
  SimpleQuotePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  {
    try {
      result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SimpleQuotePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_SimpleQuote_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  Real arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SimpleQuotePtr **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      SimpleQuotePtr_setValue(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleQuote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SimpleQuotePtr **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< boost::shared_ptr< Quote > > *)new std::vector< boost::shared_ptr< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< boost::shared_ptr< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type arg1 ;
  std::vector< boost::shared_ptr< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< boost::shared_ptr< Quote > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< boost::shared_ptr< Quote > > *)new std::vector< boost::shared_ptr< Quote > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< boost::shared_ptr< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< boost::shared_ptr< Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< boost::shared_ptr< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< boost::shared_ptr< Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  std::vector< boost::shared_ptr< Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  arg2 = *(std::vector< boost::shared_ptr< Quote > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< boost::shared_ptr< Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< boost::shared_ptr< Quote > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< boost::shared_ptr< Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  int arg2 ;
  std::vector< boost::shared_ptr< Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< boost::shared_ptr< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(arg1,arg2,(boost::shared_ptr< Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< Quote > > *arg1 = (std::vector< boost::shared_ptr< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVectorVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)new std::vector< std::vector< boost::shared_ptr< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVectorVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type arg1 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< std::vector< boost::shared_ptr< Quote > > > *)new std::vector< std::vector< boost::shared_ptr< Quote > > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< boost::shared_ptr< Quote > > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< boost::shared_ptr< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = (std::vector< std::vector< boost::shared_ptr< Quote > > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< boost::shared_ptr< Quote > > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVectorVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< boost::shared_ptr< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Sg__set(arg1,arg2,(std::vector< boost::shared_ptr< Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteVectorVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< boost::shared_ptr< Quote > > > *arg1 = (std::vector< std::vector< boost::shared_ptr< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< boost::shared_ptr< Quote > > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< Handle< Quote > > *)new std::vector< Handle< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > >::size_type arg1 ;
  std::vector< Handle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< Handle< Quote > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< Handle< Quote > > *)new std::vector< Handle< Quote > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< Handle< Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< Handle< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = (std::vector< Handle< Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< Handle< Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  std::vector< Handle< Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = *(std::vector< Handle< Quote > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< Handle< Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< Handle< Quote > >::value_type *) &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< Handle< Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< Handle< Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< Handle< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Handle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(arg1,arg2,(Handle< Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Handle< Quote > > *arg1 = (std::vector< Handle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Handle< Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVectorVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< Handle< Quote > > > *)new std::vector< std::vector< Handle< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVectorVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type arg1 ;
  std::vector< std::vector< Handle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::vector< Handle< Quote > > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< std::vector< Handle< Quote > > > *)new std::vector< std::vector< Handle< Quote > > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< Handle< Quote > > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< Handle< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = (std::vector< std::vector< Handle< Quote > > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< Handle< Quote > > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Handle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< std::vector< Handle< Quote > > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< Handle< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVectorVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< Handle< Quote > > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< std::vector< Handle< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Handle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Sg__set(arg1,arg2,(std::vector< Handle< Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandleVectorVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< Handle< Quote > > > *arg1 = (std::vector< std::vector< Handle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< Handle< Quote > > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< RelinkableHandle< Quote > > *)new std::vector< RelinkableHandle< Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type arg1 ;
  std::vector< RelinkableHandle< Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< RelinkableHandle< Quote > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< RelinkableHandle< Quote > > *)new std::vector< RelinkableHandle< Quote > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< RelinkableHandle< Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector< RelinkableHandle< Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = (std::vector< RelinkableHandle< Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< RelinkableHandle< Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  std::vector< RelinkableHandle< Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = *(std::vector< RelinkableHandle< Quote > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< RelinkableHandle< Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< RelinkableHandle< Quote > >::value_type *) &std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< RelinkableHandle< Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  int arg2 ;
  std::vector< RelinkableHandle< Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< RelinkableHandle< Quote > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RelinkableHandle< Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__set(arg1,arg2,(RelinkableHandle< Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< RelinkableHandle< Quote > > *arg1 = (std::vector< RelinkableHandle< Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< RelinkableHandle< Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVectorVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new std::vector< std::vector< RelinkableHandle< Quote > > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVectorVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type arg1 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > >::size_type)jarg1; 
  {
    try {
      result = (std::vector< std::vector< RelinkableHandle< Quote > > > *)new std::vector< std::vector< RelinkableHandle< Quote > > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = (std::vector< std::vector< RelinkableHandle< Quote > > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< RelinkableHandle< Quote > > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *) &std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVectorVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  int arg2 ;
  std::vector< std::vector< RelinkableHandle< Quote > > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< std::vector< RelinkableHandle< Quote > > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< RelinkableHandle< Quote > > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__Sg__set(arg1,arg2,(std::vector< RelinkableHandle< Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandleVectorVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< RelinkableHandle< Quote > > > *arg1 = (std::vector< std::vector< RelinkableHandle< Quote > > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< RelinkableHandle< Quote > > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isWeekend(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Weekday arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = (bool)(arg1)->isWeekend(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1endOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->endOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isBusinessDay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1addHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->addHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1removeHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->removeHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  bool arg6 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  bool arg5 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((const Date &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  bool arg5 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      result = (arg1)->name();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      result = Calendar___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Calendar *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Calendar___eq__(arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Calendar *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Calendar___ne__(arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Calendar *arg1 = (Calendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Argentina_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Argentina::Market arg1 ;
  QuantLib::Argentina *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Argentina::Market)jarg1; 
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Argentina **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Argentina_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Argentina *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Argentina **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Argentina(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Argentina *arg1 = (QuantLib::Argentina *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Argentina **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Australia(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Australia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Australia *)new QuantLib::Australia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Australia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Australia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Australia *arg1 = (QuantLib::Australia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Australia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Brazil_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Brazil::Market arg1 ;
  QuantLib::Brazil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Brazil::Market)jarg1; 
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Brazil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Brazil_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Brazil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Brazil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Brazil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Brazil *arg1 = (QuantLib::Brazil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Brazil **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Canada_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Canada::Market arg1 ;
  QuantLib::Canada *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Canada::Market)jarg1; 
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Canada **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Canada_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Canada *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Canada **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Canada(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Canada *arg1 = (QuantLib::Canada *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Canada **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1China_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::China::Market arg1 ;
  QuantLib::China *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::China::Market)jarg1; 
  {
    try {
      result = (QuantLib::China *)new QuantLib::China(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::China **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1China_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::China *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::China *)new QuantLib::China();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::China **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1China(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::China *arg1 = (QuantLib::China *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::China **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CzechRepublic_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::CzechRepublic::Market arg1 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::CzechRepublic::Market)jarg1; 
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CzechRepublic **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CzechRepublic_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CzechRepublic **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CzechRepublic(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CzechRepublic *arg1 = (QuantLib::CzechRepublic *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CzechRepublic **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Denmark(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Denmark *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Denmark *)new QuantLib::Denmark();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Denmark **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Denmark(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Denmark *arg1 = (QuantLib::Denmark *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Denmark **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Finland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Finland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Finland *)new QuantLib::Finland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Finland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Finland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Finland *arg1 = (QuantLib::Finland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Finland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Germany::Market arg1 ;
  QuantLib::Germany *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Germany::Market)jarg1; 
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Germany **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Germany *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Germany **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Germany(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Germany **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::HongKong::Market arg1 ;
  QuantLib::HongKong *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::HongKong::Market)jarg1; 
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HongKong **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::HongKong *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HongKong **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HongKong(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::HongKong **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Hungary(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Hungary *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Hungary *)new QuantLib::Hungary();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Hungary **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Hungary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Hungary *arg1 = (QuantLib::Hungary *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Hungary **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Iceland_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Iceland::Market arg1 ;
  QuantLib::Iceland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Iceland::Market)jarg1; 
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Iceland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Iceland_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Iceland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Iceland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Iceland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Iceland *arg1 = (QuantLib::Iceland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Iceland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1India_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::India::Market arg1 ;
  QuantLib::India *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::India::Market)jarg1; 
  {
    try {
      result = (QuantLib::India *)new QuantLib::India(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::India **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1India_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::India *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::India *)new QuantLib::India();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::India **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1India(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::India *arg1 = (QuantLib::India *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::India **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Indonesia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Indonesia::Market arg1 ;
  QuantLib::Indonesia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Indonesia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Indonesia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Indonesia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Indonesia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Indonesia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Indonesia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Indonesia *arg1 = (QuantLib::Indonesia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Indonesia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Israel_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Israel::Market arg1 ;
  QuantLib::Israel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Israel::Market)jarg1; 
  {
    try {
      result = (QuantLib::Israel *)new QuantLib::Israel(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Israel **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Israel_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Israel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Israel *)new QuantLib::Israel();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Israel **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Israel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Israel *arg1 = (QuantLib::Israel *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Israel **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Italy::Market arg1 ;
  QuantLib::Italy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Italy::Market)jarg1; 
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Italy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Italy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Italy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Italy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Italy **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Japan(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Japan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Japan *)new QuantLib::Japan();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Japan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Japan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Japan *arg1 = (QuantLib::Japan *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Japan **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Mexico_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Mexico::Market arg1 ;
  QuantLib::Mexico *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Mexico::Market)jarg1; 
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Mexico **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Mexico_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Mexico *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Mexico **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Mexico(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Mexico *arg1 = (QuantLib::Mexico *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Mexico **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NewZealand(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NewZealand *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NewZealand *)new QuantLib::NewZealand();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NewZealand **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NewZealand(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NewZealand *arg1 = (QuantLib::NewZealand *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NewZealand **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Norway(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Norway *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Norway *)new QuantLib::Norway();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Norway **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Norway(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Norway *arg1 = (QuantLib::Norway *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Norway **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Poland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Poland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Poland *)new QuantLib::Poland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Poland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Poland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Poland *arg1 = (QuantLib::Poland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Poland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Russia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Russia::Market arg1 ;
  QuantLib::Russia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Russia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Russia *)new QuantLib::Russia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Russia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Russia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Russia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Russia *)new QuantLib::Russia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Russia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Russia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Russia *arg1 = (QuantLib::Russia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Russia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Romania(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Romania *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Romania *)new QuantLib::Romania();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Romania **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Romania(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Romania *arg1 = (QuantLib::Romania *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Romania **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SaudiArabia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::SaudiArabia::Market arg1 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::SaudiArabia::Market)jarg1; 
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SaudiArabia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SaudiArabia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SaudiArabia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SaudiArabia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SaudiArabia *arg1 = (QuantLib::SaudiArabia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SaudiArabia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Singapore::Market arg1 ;
  QuantLib::Singapore *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Singapore::Market)jarg1; 
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Singapore **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Singapore *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Singapore **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Singapore(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Singapore **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Slovakia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Slovakia::Market arg1 ;
  QuantLib::Slovakia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Slovakia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Slovakia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Slovakia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Slovakia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Slovakia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Slovakia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Slovakia *arg1 = (QuantLib::Slovakia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Slovakia **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthAfrica(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SouthAfrica *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SouthAfrica *)new QuantLib::SouthAfrica();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthAfrica **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SouthAfrica(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SouthAfrica *arg1 = (QuantLib::SouthAfrica *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SouthAfrica **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthKorea_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::SouthKorea::Market arg1 ;
  QuantLib::SouthKorea *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::SouthKorea::Market)jarg1; 
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthKorea **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthKorea_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SouthKorea *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthKorea **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SouthKorea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SouthKorea *arg1 = (QuantLib::SouthKorea *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SouthKorea **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Sweden(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Sweden *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Sweden *)new QuantLib::Sweden();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Sweden **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Sweden(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Sweden *arg1 = (QuantLib::Sweden *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Sweden **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Switzerland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Switzerland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Switzerland *)new QuantLib::Switzerland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Switzerland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Switzerland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Switzerland *arg1 = (QuantLib::Switzerland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Switzerland **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Taiwan_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Taiwan::Market arg1 ;
  QuantLib::Taiwan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Taiwan::Market)jarg1; 
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Taiwan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Taiwan_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Taiwan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Taiwan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Taiwan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Taiwan **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TARGET(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::TARGET *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::TARGET *)new QuantLib::TARGET();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::TARGET **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TARGET(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::TARGET **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Turkey(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Turkey *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Turkey *)new QuantLib::Turkey();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Turkey **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Turkey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Turkey *arg1 = (QuantLib::Turkey *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Turkey **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Ukraine_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Ukraine::Market arg1 ;
  QuantLib::Ukraine *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Ukraine::Market)jarg1; 
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Ukraine **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Ukraine_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Ukraine *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Ukraine **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Ukraine(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Ukraine *arg1 = (QuantLib::Ukraine *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Ukraine **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedKingdom_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::UnitedKingdom::Market arg1 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::UnitedKingdom::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedKingdom **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedKingdom_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedKingdom **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnitedKingdom(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::UnitedKingdom **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedStates_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::UnitedStates::Market arg1 ;
  QuantLib::UnitedStates *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::UnitedStates::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedStates **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedStates_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::UnitedStates *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedStates **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnitedStates(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::UnitedStates **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NullCalendar(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NullCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NullCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NullCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NullCalendar **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1WeekendsOnly(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::WeekendsOnly *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::WeekendsOnly *)new QuantLib::WeekendsOnly();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::WeekendsOnly **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1WeekendsOnly(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::WeekendsOnly *arg1 = (QuantLib::WeekendsOnly *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::WeekendsOnly **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  JointCalendarRule arg3 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = (JointCalendarRule)jarg3; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  JointCalendarRule arg4 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg4 = (JointCalendarRule)jarg4; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  JointCalendarRule arg5 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Calendar **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg4 = *(Calendar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg5 = (JointCalendarRule)jarg5; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Calendar **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg4 = *(Calendar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JointCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::JointCalendar **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BespokeCalendar(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  QuantLib::BespokeCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (QuantLib::BespokeCalendar *)new QuantLib::BespokeCalendar((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::BespokeCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BespokeCalendar_1addWeekend(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  QuantLib::BespokeCalendar *arg1 = (QuantLib::BespokeCalendar *) 0 ;
  Weekday arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(QuantLib::BespokeCalendar **)&jarg1; 
  arg2 = (Weekday)jarg2; 
  {
    try {
      (arg1)->addWeekend(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BespokeCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::BespokeCalendar *arg1 = (QuantLib::BespokeCalendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::BespokeCalendar **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_nullInt(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (int)nullInt();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_nullDouble(JNIEnv *jenv, jclass jcls) {
  jdouble jresult = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (double)nullDouble();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1dayCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BigInteger)((DayCounter const *)arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jdouble jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)((DayCounter const *)arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jdouble jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)((DayCounter const *)arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)((DayCounter const *)arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DayCounter **)&jarg1; 
  {
    try {
      result = ((DayCounter const *)arg1)->name();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DayCounter **)&jarg1; 
  {
    try {
      result = DayCounter___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  DayCounter *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)DayCounter___eq__(arg1,(DayCounter const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  DayCounter *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)DayCounter___ne__(arg1,(DayCounter const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DayCounter *arg1 = (DayCounter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DayCounter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual360(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Actual360 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Actual360 *)new QuantLib::Actual360();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Actual360 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Actual360(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Actual360 **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual365Fixed_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Actual365Fixed::Convention arg1 ;
  QuantLib::Actual365Fixed *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Actual365Fixed::Convention)jarg1; 
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Actual365Fixed **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual365Fixed_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Actual365Fixed *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Actual365Fixed **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Actual365Fixed(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Actual365Fixed **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Thirty360_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Thirty360::Convention arg1 ;
  QuantLib::Thirty360 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Thirty360::Convention)jarg1; 
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Thirty360 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Thirty360_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Thirty360 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Thirty360 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Thirty360(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Thirty360 **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  QuantLib::ActualActual::Convention arg1 ;
  Schedule *arg2 = 0 ;
  QuantLib::ActualActual *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (QuantLib::ActualActual::Convention)jarg1; 
  arg2 = *(Schedule **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Schedule const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1,(Schedule const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ActualActual **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::ActualActual::Convention arg1 ;
  QuantLib::ActualActual *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::ActualActual::Convention)jarg1; 
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ActualActual **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ActualActual *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ActualActual **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ActualActual(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ActualActual **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1OneDayCounter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::OneDayCounter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::OneDayCounter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1OneDayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::OneDayCounter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleDayCounter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SimpleDayCounter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SimpleDayCounter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleDayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SimpleDayCounter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Business252_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SwigValueWrapper< Calendar > arg1 ;
  Calendar *argp1 ;
  QuantLib::Business252 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(Calendar **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Calendar");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (QuantLib::Business252 *)new QuantLib::Business252(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Business252 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Business252_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Business252 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Business252 *)new QuantLib::Business252();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Business252 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Business252(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Business252 *arg1 = (QuantLib::Business252 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Business252 **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Actual365NoLeap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Actual365NoLeap();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((const DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  InterestRate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (InterestRate *)new InterestRate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Rate)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1rate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Rate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = (Rate)((InterestRate const *)arg1)->rate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = ((InterestRate const *)arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((const DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compounding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Compounding result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = (Compounding)((InterestRate const *)arg1)->compounding();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Frequency result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = (Frequency)((InterestRate const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  Real arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Time arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Real)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = (Time)jarg5; 
  {
    try {
      result = InterestRate::impliedRate(arg1,(DayCounter const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_) {
  jlong jresult = 0 ;
  Real arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Date *arg5 = 0 ;
  Date *arg6 = 0 ;
  Date *arg7 = 0 ;
  Date *arg8 = 0 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = (Real)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg6 = *(Date **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg7 = *(Date **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg8 = *(Date **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = InterestRate::impliedRate(arg1,(DayCounter const &)*arg2,arg3,arg4,(Date const &)*arg5,(Date const &)*arg6,(Date const &)*arg7,(Date const &)*arg8);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  Real arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Date *arg5 = 0 ;
  Date *arg6 = 0 ;
  Date *arg7 = 0 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = (Real)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg6 = *(Date **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg7 = *(Date **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = InterestRate::impliedRate(arg1,(DayCounter const &)*arg2,arg3,arg4,(Date const &)*arg5,(Date const &)*arg6,(Date const &)*arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  Real arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Date *arg5 = 0 ;
  Date *arg6 = 0 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = (Real)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg6 = *(Date **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = InterestRate::impliedRate(arg1,(DayCounter const &)*arg2,arg3,arg4,(Date const &)*arg5,(Date const &)*arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Compounding arg2 ;
  Frequency arg3 ;
  Time arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Compounding)jarg2; 
  arg3 = (Frequency)jarg3; 
  arg4 = (Time)jarg4; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Date *arg5 = 0 ;
  Date *arg6 = 0 ;
  Date *arg7 = 0 ;
  Date *arg8 = 0 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg6 = *(Date **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg7 = *(Date **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg8 = *(Date **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((DayCounter const &)*arg2,arg3,arg4,(Date const &)*arg5,(Date const &)*arg6,(Date const &)*arg7,(Date const &)*arg8);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Date *arg5 = 0 ;
  Date *arg6 = 0 ;
  Date *arg7 = 0 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg6 = *(Date **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg7 = *(Date **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((DayCounter const &)*arg2,arg3,arg4,(Date const &)*arg5,(Date const &)*arg6,(Date const &)*arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  Date *arg5 = 0 ;
  Date *arg6 = 0 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = *(Date **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg6 = *(Date **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((DayCounter const &)*arg2,arg3,arg4,(Date const &)*arg5,(Date const &)*arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((const InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = InterestRate___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1InterestRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InterestRate *arg1 = (InterestRate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRateVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< InterestRate > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< InterestRate > *)new std::vector< InterestRate >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< InterestRate > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRateVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< InterestRate >::size_type arg1 ;
  std::vector< InterestRate > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< InterestRate >::size_type)jarg1; 
  {
    try {
      result = (std::vector< InterestRate > *)new std::vector< InterestRate >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< InterestRate > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  std::vector< InterestRate >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  {
    try {
      result = ((std::vector< InterestRate > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  std::vector< InterestRate >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  {
    try {
      result = ((std::vector< InterestRate > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  std::vector< InterestRate >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  arg2 = (std::vector< InterestRate >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< InterestRate > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  std::vector< InterestRate >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  arg2 = *(std::vector< InterestRate >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< InterestRate >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< InterestRate >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  int arg2 ;
  std::vector< InterestRate >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< InterestRate >::value_type *) &std_vector_Sl_InterestRate_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector< InterestRate >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_InterestRateVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< InterestRate > *arg1 = (std::vector< InterestRate > *) 0 ;
  int arg2 ;
  std::vector< InterestRate >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< InterestRate > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< InterestRate >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< InterestRate >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_InterestRate_Sg__set(arg1,arg2,(InterestRate const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.