/* arm64-linux.shlib-init.h
   created from arm64-linux.shlib-init.bin, 7923 (0x1ef3) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2024 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2024 Laszlo Molnar
   Copyright (C) 2000-2024 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM64_LINUX_SHLIB_INIT_SIZE    7923
#define STUB_ARM64_LINUX_SHLIB_INIT_ADLER32 0xb3122fa3
#define STUB_ARM64_LINUX_SHLIB_INIT_CRC32   0xb5f30aee

unsigned char stub_arm64_linux_shlib_init[7923] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,183,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,248, 25,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */ 224,  7,180,169,226,  3,  1,169,254, 23,  0,249,  0,  0,  0,148,
/* 0x0050 */ 254, 15, 31,248,226, 15,191,169,  7, 64, 33,139,  5,  0,128, 18,
/* 0x0060 */   4,  0,176, 82, 45,  0,  0, 20,227, 19,193,168,  0,  0,  7,203,
/* 0x0070 */  66,  0,  3,203,130,  0,  0,185,229,  3,  0,170,224,  3,  3,170,
/* 0x0080 */  97,  0,  2,139, 35,  0, 59,213, 99,  1,224, 55, 98, 76, 80,211,
/* 0x0090 */ 100,  0,128,146,132, 32,194,154,  2,  0,  4,138, 95,  0,  1,235,
/* 0x00a0 */ 162,  0,  0, 84, 34,123, 11,213, 66,  0,  4,203, 63,  0,  2,235,
/* 0x00b0 */ 168,255,255, 84,159, 59,  3,213, 99,  1,232, 55, 99, 12, 64,146,
/* 0x00c0 */  98,  0,128,146, 66, 32,195,154,  0,  0,  2,138, 63,  0,  0,235,
/* 0x00d0 */ 169,  0,  0, 84, 32,117, 11,213,  0,  0,  2,203, 63,  0,  0,235,
/* 0x00e0 */ 168,255,255, 84,159, 59,  3,213,223, 63,  3,213,224,  3,  5,170,
/* 0x00f0 */ 254,  7, 65,248,192,  3, 95,214,132,  0,  4, 43, 68,  0,  0, 52,
/* 0x0100 */ 192,  3, 95,214,  4, 68, 64,184,132,  0,  4, 58,192,  3, 95,214,
/* 0x0110 */   3, 20, 64, 56, 67, 20,  0, 56,248,255,255,151,162,255,255, 84,
/* 0x0120 */  33,  0,128, 82,  4,  0,  0, 20, 33,  4,  0, 81,243,255,255,151,
/* 0x0130 */  33,  0,  1, 26,241,255,255,151, 33,  0,  1, 26,239,255,255,151,
/* 0x0140 */  67,255,255, 84, 35, 12,  0,113,  1,  0,128, 82, 35,  1,  0, 84,
/* 0x0150 */   5, 20, 64, 56,165, 32,  3, 42,229,  3, 37, 42,101,248,255, 52,
/* 0x0160 */ 191,  0,  0,114,165,124,  1, 19,161,  1,  0, 84,  3,  0,  0, 20,
/* 0x0170 */ 226,255,255,151, 66,  1,  0, 84, 33,  0,128, 82,223,255,255,151,
/* 0x0180 */ 226,  0,  0, 84,221,255,255,151, 33,  0,  1, 26,219,255,255,151,
/* 0x0190 */ 163,255,255, 84, 33, 16,  0, 17,  4,  0,  0, 20,215,255,255,151,
/* 0x01a0 */  33,  0,  1, 26, 33,  8,  0, 17,191,  0, 20, 49, 33, 36,129, 26,
/* 0x01b0 */  67, 64, 33,139, 99,240, 95, 56, 67,200,101, 56, 67, 20,  0, 56,
/* 0x01c0 */  33,  4,  0,113,161,255,255, 84,212,255,255, 23,226, 15,190,169,
/* 0x01d0 */ 254, 11,  0,249,  7, 64, 33,139,  5,  0,128, 18,  4,  0,176, 82,
/* 0x01e0 */  45,  0,  0, 20,227, 19,193,168,  0,  0,  7,203, 66,  0,  3,203,
/* 0x01f0 */ 130,  0,  0,185,229,  3,  0,170,224,  3,  3,170, 97,  0,  2,139,
/* 0x0200 */  35,  0, 59,213, 99,  1,224, 55, 98, 76, 80,211,100,  0,128,146,
/* 0x0210 */ 132, 32,194,154,  2,  0,  4,138, 95,  0,  1,235,162,  0,  0, 84,
/* 0x0220 */  34,123, 11,213, 66,  0,  4,203, 63,  0,  2,235,168,255,255, 84,
/* 0x0230 */ 159, 59,  3,213, 99,  1,232, 55, 99, 12, 64,146, 98,  0,128,146,
/* 0x0240 */  66, 32,195,154,  0,  0,  2,138, 63,  0,  0,235,169,  0,  0, 84,
/* 0x0250 */  32,117, 11,213,  0,  0,  2,203, 63,  0,  0,235,168,255,255, 84,
/* 0x0260 */ 159, 59,  3,213,223, 63,  3,213,224,  3,  5,170,254,  7, 65,248,
/* 0x0270 */ 192,  3, 95,214,132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,
/* 0x0280 */   4, 68, 64,184,132,  0,  4, 58,192,  3, 95,214,  3, 20, 64, 56,
/* 0x0290 */  67, 20,  0, 56,248,255,255,151,162,255,255, 84, 33,  0,128, 82,
/* 0x02a0 */   4,  0,  0, 20, 33,  4,  0, 81,243,255,255,151, 33,  0,  1, 58,
/* 0x02b0 */ 241,255,255,151, 33,  0,  1, 58,239,255,255,151, 67,255,255, 84,
/* 0x02c0 */  35, 12,  0,113,  1,  0,128, 82, 35,  1,  0, 84,  5, 20, 64, 56,
/* 0x02d0 */ 165, 32,  3, 42,229,  3, 37, 42,101,248,255, 52,163,  0,  1, 83,
/* 0x02e0 */ 165,124,  1, 19, 99,  0,  3, 43,  2,  0,  0, 20,226,255,255,151,
/* 0x02f0 */  33,  0,  1, 58,224,255,255,151, 33,  0,  1, 58,225,  0,  0, 84,
/* 0x0300 */  33,  0,128, 82,220,255,255,151, 33,  0,  1, 58,218,255,255,151,
/* 0x0310 */ 163,255,255, 84, 33,  8,  0, 17, 33,  4,  0, 17,191,  0, 20, 49,
/* 0x0320 */  33, 36,129, 26, 67,  0, 64, 57, 67,200,101, 56, 67, 20,  0, 56,
/* 0x0330 */  33,  4,  0,113,161,255,255, 84,215,255,255, 23,  1, 64, 33,139,
/* 0x0340 */ 225, 11,190,169,227,123,  1,169,  5,  0,128, 18,  4,  0,176, 82,
/* 0x0350 */  52,  0,  0, 20,228,123, 65,169,225, 15,194,168,  0,  0,  1,203,
/* 0x0360 */  66,  0,  3,203,130,  0,  0,185,229,  3,  0,170,224,  3,  3,170,
/* 0x0370 */  97,  0,  2,139, 35,  0, 59,213, 99,  1,224, 55, 98, 76, 80,211,
/* 0x0380 */ 100,  0,128,146,132, 32,194,154,  2,  0,  4,138, 95,  0,  1,235,
/* 0x0390 */ 162,  0,  0, 84, 34,123, 11,213, 66,  0,  4,203, 63,  0,  2,235,
/* 0x03a0 */ 168,255,255, 84,159, 59,  3,213, 99,  1,232, 55, 99, 12, 64,146,
/* 0x03b0 */  98,  0,128,146, 66, 32,195,154,  0,  0,  2,138, 63,  0,  0,235,
/* 0x03c0 */ 169,  0,  0, 84, 32,117, 11,213,  0,  0,  2,203, 63,  0,  0,235,
/* 0x03d0 */ 168,255,255, 84,159, 59,  3,213,223, 63,  3,213,224,  3,  5,170,
/* 0x03e0 */ 192,  3, 95,214,132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,
/* 0x03f0 */   4, 68, 64,184,132,  0,  4, 58,192,  3, 95,214, 33,  0,128, 82,
/* 0x0400 */ 240,  3, 30,170,248,255,255,151, 33,  0,  1, 58,246,255,255,151,
/* 0x0410 */ 163,255,255, 84,  0,  2, 31,214,  3, 20, 64, 56, 67, 20,  0, 56,
/* 0x0420 */ 241,255,255,151,162,255,255, 84,245,255,255,151, 35, 12,  0,113,
/* 0x0430 */   1,  0,128, 82,163,  0,  0, 84,  5, 20, 64, 56,165, 32,  3, 42,
/* 0x0440 */ 229,  3, 37, 42,133,248,255, 52,231,255,255,151, 33,  0,  1, 58,
/* 0x0450 */ 229,255,255,151, 33,  0,  1, 58, 97,  0,  0, 84,232,255,255,151,
/* 0x0460 */  33,  8,  0, 17,191,  0, 52, 49, 33, 36,129, 26, 67,200,101, 56,
/* 0x0470 */  33,  4,  0,113, 67, 20,  0, 56,162,255,255, 84,233,255,255, 23,
/* 0x0480 */ 159, 56,  0,113,  1,  0,  0, 84,226, 15,190,169,253,123,  1,169,
/* 0x0490 */ 253,  3,  0,145,  8,  0, 64, 57,  7,192,128, 82,  8,125,  3, 83,
/* 0x04a0 */ 231, 32,200, 26,231,192, 57, 17,232,  3,  0,145,255, 67, 39,203,
/* 0x04b0 */ 228,  3,  0,145,159,124,129,168,159,  0,  8,235,195,255,255, 84,
/* 0x04c0 */ 255,127,191,169,230,  3,  3,170,197,  0, 64,185,228,  3,  2,170,
/* 0x04d0 */ 227, 35,  0,145, 34,  8,  0, 81,225,  3,  0,170,224,  3,  0,145,
/* 0x04e0 */  39, 20, 64, 56,231,  8,  0, 18,  7,  8,  0, 57, 39, 20, 64, 56,
/* 0x04f0 */ 232,124,  4, 83,  8,  4,  0, 57,231, 12,  0, 18,  7,  0,  0, 57,
/* 0x0500 */  35,  0,  0,148,191,  3,  0,145,229,  3,  0,170,253,123, 65,169,
/* 0x0510 */ 224,  7,194,168, 33,  0, 64,249, 33,  0,  0,139, 35,  0, 59,213,
/* 0x0520 */  99,  1,224, 55, 98, 76, 80,211,100,  0,128,146,132, 32,194,154,
/* 0x0530 */   2,  0,  4,138, 95,  0,  1,235,162,  0,  0, 84, 34,123, 11,213,
/* 0x0540 */  66,  0,  4,203, 63,  0,  2,235,168,255,255, 84,159, 59,  3,213,
/* 0x0550 */  99,  1,232, 55, 99, 12, 64,146, 98,  0,128,146, 66, 32,195,154,
/* 0x0560 */   0,  0,  2,138, 63,  0,  0,235,169,  0,  0, 84, 32,117, 11,213,
/* 0x0570 */   0,  0,  2,203, 63,  0,  0,235,168,255,255, 84,159, 59,  3,213,
/* 0x0580 */ 223, 63,  3,213,224,  3,  5,170,192,  3, 95,214,255, 67,  1,209,
/* 0x0590 */  39,  0,128, 82, 17, 16,  0,145,  9,128,128, 82,243, 83,  0,169,
/* 0x05a0 */ 245, 91,  1,169,247, 99,  2,169,249,107,  3,169,251,115,  4,169,
/* 0x05b0 */  20,  8, 64, 57, 19,  4, 64, 57, 22,  0, 64, 57,244, 32,212, 26,
/* 0x05c0 */ 127,  0,  0,185,243, 32,211, 26,223,  0,  0,185,  7,  0,128,210,
/* 0x05d0 */ 148,  6,  0, 81,  8,  4, 64, 57, 10,  1, 22, 11,104,  6,  0, 81,
/* 0x05e0 */  18,  1, 39, 30,  8, 96,128, 82,  8, 33,202, 26,  8,217, 28, 49,
/* 0x05f0 */ 160,  0,  0, 84, 41,122, 39,120,231,  4,  0,145, 31,  1,  7,107,
/* 0x0600 */ 168,255,255, 84, 34, 64, 34,139, 63,  0,  2,235, 64, 16,  0, 84,
/* 0x0610 */ 235,  3,  1,170, 40,  4,  0,145,103, 85, 64, 56, 31,  1,  2,235,
/* 0x0620 */ 160, 15,  0, 84,  9, 21, 64, 56, 31,  1, 11,235, 39, 33,  7, 42,
/* 0x0630 */  97,255,255, 84,229, 69,  0, 52,  8,  1,128, 82, 53,  0,128, 82,
/* 0x0640 */  18,  0,128, 82,  9,  0,128, 18, 20,  1, 39, 30,104,  0,128, 82,
/* 0x0650 */ 177,  2, 39, 30,247,  3, 21, 42,  7,  1, 39, 30,  8, 86,128,210,
/* 0x0660 */ 165,  2, 39, 30,252,  3, 21, 42,  3,  1,103,158,104,  1,128, 82,
/* 0x0670 */ 234,  3, 18, 42,240,  3, 18, 42,  0,  1, 39, 30,  8,176, 41,145,
/* 0x0680 */  14,224,191, 18, 15,  0,129, 82,  1,  1,103,158, 40,  1,128, 82,
/* 0x0690 */   2,  1, 39, 30,136,  2, 38, 30,  8,  1, 22, 75, 16,  1, 39, 30,
/* 0x06a0 */  72,110, 28, 83, 63,  1, 14,107, 25,  2, 20, 10, 13,125, 64,147,
/* 0x06b0 */ 173,193, 57,139,173,249,127,211,232,  0,  0, 84,127,  1,  2,235,
/* 0x06c0 */ 160, 10,  0, 84,104,  1, 64, 57, 41, 93, 24, 83,107,  5,  0,145,
/* 0x06d0 */   7, 33,  7, 42, 59,106,109,120, 40,125, 11, 83,  8,125, 27, 27,
/* 0x06e0 */ 255,  0,  8,107,130, 10,  0, 84, 73,  2, 38, 30, 19, 62,  1, 14,
/* 0x06f0 */  95, 26,  0,113, 12,  2,  9, 10, 73, 41,211, 26,140, 33,214, 26,
/* 0x0700 */ 234,  1, 27, 75, 41,  1, 12, 11,106, 23,138, 11, 42,106, 45,120,
/* 0x0710 */  41,  5,  9, 11, 41, 93,120,211, 41,217, 28,145, 58,  6,  9,139,
/* 0x0720 */ 109, 31,  0, 84, 10,  2, 28, 75, 41,  0,128, 82,153,104,106, 56,
/* 0x0730 */   7,  0,  0, 20, 91,107, 42,120, 41,121, 31, 83,232,  3, 13, 42,
/* 0x0740 */  83, 57,  0, 53, 63,253,  3,113,236,  3,  0, 84, 57,123, 31, 83,
/* 0x0750 */  31,  1, 14,107, 51,  3, 24, 18, 56,121, 31, 83,106,126, 64,147,
/* 0x0760 */  74,  1,  4,145, 74,193, 41,139, 74,249,127,211,232,  0,  0, 84,
/* 0x0770 */ 127,  1,  2,235,  8, 93, 24, 83,224,  4,  0, 84,108,  1, 64, 57,
/* 0x0780 */ 107,  5,  0,145,135, 33,  7, 42, 76,107,106,120, 13,125, 11, 83,
/* 0x0790 */ 251,  1, 12, 75,173,125, 12, 27,155, 21,155, 11,140, 21, 76, 75,
/* 0x07a0 */ 255,  0, 13,107,  8,  1, 13, 75, 99,252,255, 84, 76,107, 42,120,
/* 0x07b0 */   9,  7,  0, 17,231,  0, 13, 75,115,252,255, 53, 63,253,  3,113,
/* 0x07c0 */  77, 27,  0, 84, 42, 29,  0, 83,233,  3,  8, 42,138, 72, 48, 56,
/* 0x07d0 */  16,  6,  0, 17, 95, 38,  0,113,236, 49,  0, 84, 82, 14,  0, 81,
/* 0x07e0 */ 191,  0, 16,107,232,245,255, 84,  0,224,191, 18, 63,  1,  0,107,
/* 0x07f0 */ 136,  0,  0, 84,127,  1,  2,235,224,  0,  0, 84,107,  5,  0,145,
/* 0x0800 */  97,  1,  1,203, 97,  0,  0,185,208,  0,  0,185,  0,  0,128, 82,
/* 0x0810 */   2,  0,  0, 20, 32,  0,128, 82,243, 83, 64,169,245, 91, 65,169,
/* 0x0820 */ 247, 99, 66,169,249,107, 67,169,251,115, 68,169,255, 67,  1,145,
/* 0x0830 */ 192,  3, 95,214, 58,  1,  8, 75, 74,126, 64,147,105, 23, 91, 75,
/* 0x0840 */  95,  3, 14,107, 41,106, 45,120, 76,  1,  3,145,231,  0,  8, 75,
/* 0x0850 */ 140,249,127,211,232,  0,  0, 84,127,  1,  2,235,192,253,255, 84,
/* 0x0860 */ 104,  1, 64, 57, 90, 95, 24, 83,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0870 */  40,106,108,120, 74,127, 11, 83, 74,125,  8, 27,255,  0, 10,107,
/* 0x0880 */ 130, 25,  0, 84,237,  0, 38, 30,233,  1,  8, 75, 95, 30,  0,113,
/* 0x0890 */  53,  2, 38, 30,  8, 21,137, 11,241,  2, 39, 30, 40,106, 44,120,
/* 0x08a0 */ 242,179,141, 26, 12,160, 25,145,247,  3, 28, 42, 95,  1, 14,107,
/* 0x08b0 */ 232,  0,  0, 84,127,  1,  2,235,224,250,255, 84,104,  1, 64, 57,
/* 0x08c0 */  74, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42,141,  1, 64,121,
/* 0x08d0 */  73,125, 11, 83, 41,125, 13, 27,255,  0,  9,107, 98, 31,  0, 84,
/* 0x08e0 */  40,115, 29, 83,115,  0,128, 82,234,  1, 13, 75,  8,125, 64,147,
/* 0x08f0 */   8,  9,  0,145,173, 21,138, 11,228,  3, 39, 30,141,  1,  0,121,
/* 0x0900 */ 102,  2, 39, 30,153,  5,  8,139,218,  0, 38, 30, 44,  0,128, 82,
/* 0x0910 */   6,  0,  0, 20, 13,  3,  0,121, 90,  7,  0,113,140,121, 31, 83,
/* 0x0920 */ 233,  3,  8, 42, 32,  3,  0, 84, 63,  1, 14,107,147,121, 31, 83,
/* 0x0930 */  56,199, 44,139,232,  0,  0, 84,127,  1,  2,235, 41, 93, 24, 83,
/* 0x0940 */ 160,246,255, 84,104,  1, 64, 57,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0950 */   8,  3, 64,121, 42,125, 11, 83,237,  1,  8, 75, 27, 21, 72, 75,
/* 0x0960 */  13, 21,141, 11, 72,125,  8, 27,255,  0,  8,107, 41,  1,  8, 75,
/* 0x0970 */  35,253,255, 84, 27,  3,  0,121, 90,  7,  0,113,231,  0,  8, 75,
/* 0x0980 */ 108,  6,  0, 17, 33,253,255, 84,166, 68,166, 46,138,  0, 38, 30,
/* 0x0990 */  95, 14,  0,113,200,  0, 38, 30, 72,  1,  8, 75,  8,  1, 12, 11,
/* 0x09a0 */   6,  1, 39, 30,236, 22,  0, 84,234,  0, 38, 30, 31, 13,  0,113,
/* 0x09b0 */ 220,  0,128, 82, 10,209,138, 26, 40,  0,128, 82, 74,101, 26, 83,
/* 0x09c0 */  74,125, 64,147, 74,193,  6,145, 91,249,127,211,  6,  0,  0, 20,
/* 0x09d0 */  44,106, 57,120,156,  7,  0,113,  8,121, 31, 83,233,  3, 10, 42,
/* 0x09e0 */  32,  3,  0, 84, 63,  1, 14,107, 19,121, 31, 83,121,199, 40,139,
/* 0x09f0 */ 232,  0,  0, 84,127,  1,  2,235, 41, 93, 24, 83,192,240,255, 84,
/* 0x0a00 */ 106,  1, 64, 57,107,  5,  0,145, 71, 33,  7, 42, 42,106,121,120,
/* 0x0a10 */  45,125, 11, 83,236,  1, 10, 75, 90, 21, 74, 75, 76, 21,140, 11,
/* 0x0a20 */ 170,125, 10, 27,255,  0, 10,107, 41,  1, 10, 75, 35,253,255, 84,
/* 0x0a30 */  58,106, 57,120,156,  7,  0,113,231,  0, 10, 75,104,  6,  0, 17,
/* 0x0a40 */  33,253,255, 84, 10,  1,  1, 81, 95, 13,  0,113, 45, 17,  0, 84,
/* 0x0a50 */  95, 53,  0,113, 72,  1,  0, 18, 77,125,  1, 19, 12,  1, 31, 50,
/* 0x0a60 */ 140, 32,  0, 84,104,  0,102,158,187,  5,  0, 81,152, 33,219, 26,
/* 0x0a70 */   8,193, 42,203,  8, 65, 56,139, 40,  6,  8,139,  8,  9,  0,209,
/* 0x0a80 */  19,  1,103,158, 40,  0,128, 82,252,  3,  8, 42,  7,  0,  0, 20,
/* 0x0a90 */  83,  3,  0,121,  8,121, 31, 83,233,  3, 10, 42,123,  7,  0,113,
/* 0x0aa0 */ 156,123, 31, 83,128, 14,  0, 84,106,  2,102,158, 63,  1, 14,107,
/* 0x0ab0 */  25,121, 31, 83, 90,197, 40,139,232,  0,  0, 84,127,  1,  2,235,
/* 0x0ac0 */  41, 93, 24, 83,128,234,255, 84,106,  1, 64, 57,107,  5,  0,145,
/* 0x0ad0 */  71, 33,  7, 42, 74,  3, 64,121, 45,125, 11, 83,243,  1, 10, 75,
/* 0x0ae0 */  76, 21, 74, 75, 83, 21,147, 11,170,125, 10, 27,255,  0, 10,107,
/* 0x0af0 */  41,  1, 10, 75,227,252,255, 84, 76,  3,  0,121, 24,  3, 28, 42,
/* 0x0b00 */ 231,  0, 10, 75, 40,  7,  0, 17,229,255,255, 23, 41,  0,128, 82,
/* 0x0b10 */   6,  0,  0, 20, 41,121, 31, 83, 74,107, 56,120, 63,253,  3,113,
/* 0x0b20 */ 232,  3, 12, 42, 44,  3,  0, 84, 31,  1, 14,107, 51,121, 31, 83,
/* 0x0b30 */  56,125,127,147,232,  0,  0, 84,127,  1,  2,235,  8, 93, 24, 83,
/* 0x0b40 */ 160,230,255, 84,106,  1, 64, 57,107,  5,  0,145, 71, 33,  7, 42,
/* 0x0b50 */  74,107,120,120, 12,125, 11, 83,237,  1, 10, 75,140,125, 10, 27,
/* 0x0b60 */  89, 21, 74, 75, 74, 21,141, 11,255,  0, 12,107,  8,  1, 12, 75,
/* 0x0b70 */  35,253,255, 84,105,  6,  0, 17, 89,107, 56,120, 63,253,  3,113,
/* 0x0b80 */ 231,  0, 12, 75, 45,253,255, 84, 42, 29,  0, 83, 95, 14,  0,113,
/* 0x0b90 */ 138, 72, 48, 56,233,  3,  8, 42, 16,  6,  0, 17,204,225,255, 84,
/* 0x0ba0 */ 191,  0, 16,107, 18,  0,128, 82,200,215,255, 84, 15,255,255, 23,
/* 0x0bb0 */  73,  3, 10, 75,  8, 21, 72, 75, 63,  1, 14,107, 40,106, 44,120,
/* 0x0bc0 */ 231,  0, 10, 75,154, 97,  0,145,232,  0,  0, 84,127,  1,  2,235,
/* 0x0bd0 */  32,226,255, 84,104,  1, 64, 57, 41, 93, 24, 83,107,  5,  0,145,
/* 0x0be0 */   7, 33,  7, 42, 40,106,122,120, 42,125, 11, 83, 74,125,  8, 27,
/* 0x0bf0 */ 255,  0, 10,107, 66, 10,  0, 84,233,  1,  8, 75, 95,  1, 14,107,
/* 0x0c00 */ 173,129,  7,145,  8, 21,137, 11, 40,106, 58,120,232,  0,  0, 84,
/* 0x0c10 */ 127,  1,  2,235,  0,224,255, 84,104,  1, 64, 57, 74, 93, 24, 83,
/* 0x0c20 */ 107,  5,  0,145,  7, 33,  7, 42, 40,106,109,120, 73,125, 11, 83,
/* 0x0c30 */  41,125,  8, 27,255,  0,  9,107,226, 16,  0, 84,234,  1,  8, 75,
/* 0x0c40 */   8, 21,138, 11, 40,106, 45,120,112,222,255, 52, 74,  0, 38, 30,
/* 0x0c50 */   8,  2, 28, 75, 12,  0, 38, 30, 95, 30,  0,113, 82,177,140, 26,
/* 0x0c60 */ 138,104,104, 56,138, 72, 48, 56, 16,  6,  0, 17,221,254,255, 23,
/* 0x0c70 */ 248,  3, 10, 42, 28,  7,  0, 49,128,219,255, 84, 82, 30,  0, 17,
/* 0x0c80 */ 200,  0, 38, 30,159,  3, 16,107, 12,  9,  0, 17, 72,220,255, 84,
/* 0x0c90 */ 232,  3, 16, 42,  2,  0,  0, 20, 76,218,255, 52, 10,  2, 28, 75,
/* 0x0ca0 */  16,  6,  0, 17, 31,  2,  5,107,140,  5,  0, 81,138,104,106, 56,
/* 0x0cb0 */ 138, 72, 40, 56,232,  3, 16, 42,  3,255,255, 84,191,  0, 16,107,
/* 0x0cc0 */   8,207,255, 84,201,254,255, 23, 74,  1,  9, 75,173, 21, 77, 75,
/* 0x0cd0 */  95,  1, 14,107,141,  1,  0,121,231,  0,  9, 75,232,  0,  0, 84,
/* 0x0ce0 */ 127,  1,  2,235,128,217,255, 84,104,  1, 64, 57, 74, 93, 24, 83,
/* 0x0cf0 */ 107,  5,  0,145,  7, 33,  7, 42,141,  5, 64,121, 73,125, 11, 83,
/* 0x0d00 */  41,125, 13, 27,255,  0,  9,107, 34,  7,  0, 84, 40,115, 29, 83,
/* 0x0d10 */  19,  1,128, 82,234,  1, 13, 75,  8,125, 64,147,100,  2, 39, 30,
/* 0x0d20 */   8,  9,  2,145,115,  0,128, 82,173, 21,138, 11,153,  5,  8,139,
/* 0x0d30 */ 141,  5,  0,121,102,  2, 39, 30,244,254,255, 23, 41,  1, 10, 75,
/* 0x0d40 */   8, 21, 72, 75, 63,  1, 14,107, 40,106, 58,120,231,  0, 10, 75,
/* 0x0d50 */ 154,193,  0,145,232,  0,  0, 84,127,  1,  2,235,192,213,255, 84,
/* 0x0d60 */ 104,  1, 64, 57, 41, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0d70 */  45,106,122,120, 40,125, 11, 83, 10,125, 13, 27,255,  0, 10,107,
/* 0x0d80 */  35,  5,  0, 84, 41,  1, 10, 75,173, 21, 77, 75, 63,  1, 14,107,
/* 0x0d90 */  45,106, 58,120,231,  0, 10, 75,140, 33,  1,145,232,  0,  0, 84,
/* 0x0da0 */ 127,  1,  2,235,128,211,255, 84,104,  1, 64, 57, 41, 93, 24, 83,
/* 0x0db0 */ 107,  5,  0,145,  7, 33,  7, 42, 45,106,108,120, 40,125, 11, 83,
/* 0x0dc0 */  10,125, 13, 27,255,  0, 10,107,  2,  8,  0, 84,232,  1, 13, 75,
/* 0x0dd0 */ 233,  3, 28, 42, 60,  2, 38, 30,173, 21,136, 11, 45,106, 44,120,
/* 0x0de0 */ 241,  2, 39, 30,247,  3,  9, 42, 21,  0,  0, 20,  8,  2,128, 82,
/* 0x0df0 */ 231,  0,  9, 75,173, 21, 77, 75,153, 17,  8,145,  4,  1, 39, 30,
/* 0x0e00 */   8,  1,128, 82,141,  5,  0,121, 73,  1,  9, 75,  6,  1, 39, 30,
/* 0x0e10 */ 190,254,255, 23,191,  0, 16,107, 82, 26,  0, 81, 40,196,255, 84,
/* 0x0e20 */ 114,254,255, 23,232,  1, 13, 75,233,  3, 28, 42,252,  3, 23, 42,
/* 0x0e30 */ 247,  3,  9, 42,173, 21,136, 11, 45,106, 58,120,136,  2, 38, 30,
/* 0x0e40 */  95, 30,  0,113,  9,  0, 38, 30, 44,  0,102,158, 18,177,137, 26,
/* 0x0e50 */ 151,254,255, 23,  8, 21, 72, 75, 74,  1,  9, 75,231,  0,  9, 75,
/* 0x0e60 */  40,106, 45,120,246,255,255, 23,232,  3, 13, 42, 84,254,255, 23,
/* 0x0e70 */ 170, 21,  0, 81, 63,  1, 14,107,140,121, 31, 83,232,  0,  0, 84,
/* 0x0e80 */ 127,  1,  2,235, 41, 93, 24, 83, 96,204,255, 84,104,  1, 64, 57,
/* 0x0e90 */ 107,  5,  0,145,  7, 33,  7, 42, 41,125,  1, 83,255,  0,  9,107,
/* 0x0ea0 */  99,  0,  0, 84,231,  0,  9, 75,140,  1,  0, 50, 74,  5,  0,113,
/* 0x0eb0 */  33,254,255, 84,  8, 32, 25,145,152,109, 28, 83,155,  0,128, 82,
/* 0x0ec0 */  19,  1,103,158,240,254,255, 23,232,  3, 28, 42,231,  0, 10, 75,
/* 0x0ed0 */ 173, 21, 77, 75,252,  3, 21, 42, 45,106, 44,120, 42,  1, 10, 75,
/* 0x0ee0 */  53,  2, 38, 30,241,  2, 39, 30,247,  3,  8, 42,212,255,255, 23,
/* 0x0ef0 */ 240,  3,  5, 42,227, 19,189,169,229, 27,  1,169,254, 19,  0,249,
/* 0x0f00 */ 232,  3,  1,170, 45, 64, 34,139,233,  3,  4,170,142, 64, 37,139,
/* 0x0f10 */  11, 16,  0,145,  6,  0, 64, 57,  5,  4, 64, 57,  4,  8, 64, 57,
/* 0x0f20 */ 174,  0,  6, 11,  7,  0,128, 18,229, 32,197, 26,229,  3, 37, 42,
/* 0x0f30 */ 228, 32,196, 26,228,  3, 36, 42, 35,  0,128, 82, 34,  0,128, 82,
/* 0x0f40 */  33,  0,128, 82, 32,  0,128, 82,  6,  0,128, 82,230, 31,  0,185,
/* 0x0f50 */   2, 96,128, 82,192,230,128, 82, 66, 32,206, 26, 66,  0,  0, 11,
/* 0x0f60 */   0,128,128,210,225,  3, 11,170,  0, 64,  0,170,  0,128,  0,170,
/* 0x0f70 */  32,132,  0,248, 66, 16,  0,113,204,255,255, 84,  0, 21,  0,145,
/* 0x0f80 */ 232,  0,  0,148, 31,  0,  8,235,193,255,255, 84,227, 67, 66,248,
/* 0x0f90 */ 226, 19, 64,185, 36,  1,  3,203,128,  0,  2, 10,224, 47,  0,185,
/* 0x0fa0 */   0, 16,  6, 11, 97,  1,  0,145,226,  0,  0,148,161,  5,  0, 84,
/* 0x0fb0 */ 227, 23, 64,185,226, 27, 64,185, 99,  0,  4, 10,224,115, 64, 57,
/* 0x0fc0 */  99, 32,194, 26,226,  3,  2, 75, 66, 32,  0, 17,  2, 36,194, 26,
/* 0x0fd0 */  99,  0,  2, 11,106,177, 57,145, 99,  4,  3, 11,227,  3,  3, 42,
/* 0x0fe0 */  32,  0,128, 82, 74, 37,  3,139,223, 28,  0,113, 35,  2,  0, 84,
/* 0x0ff0 */ 227,125, 64,147,227,  3,  3,203, 37,105, 99, 56,165,120, 31, 83,
/* 0x1000 */  65,  1,  8,145,164,  0, 24, 18,227,  3,  4, 42, 33,  4,  3,139,
/* 0x1010 */ 202,  0,  0,148,  3,  0,  0, 18,130,124,  8, 83,127,  0,  2,107,
/* 0x1020 */ 193,  0,  0, 84, 31,  0,  4,113,163,254,255, 84,  5,  0,  0, 20,
/* 0x1030 */ 225,  3, 10,170,193,  0,  0,148, 31,  0,  4,113,163,255,255, 84,
/* 0x1040 */  98,  0,128, 82,195,  0,128, 82,223, 40,  0,113, 67, 48,131, 26,
/* 0x1050 */ 223, 16,  0,113,195, 48,131, 26,198,  0,  3, 75, 34,  0,  0, 20,
/* 0x1060 */  97,  1,  6,145,178,  0,  0,148,129,  1,  0, 84,227, 11, 64,185,
/* 0x1070 */ 226,  7, 64,185,227, 15,  0,185,226, 11,  0,185,239,  7,  0,185,
/* 0x1080 */   3,  0,128, 82,223, 28,  0,113,102,  0,128, 82,102, 48,134, 26,
/* 0x1090 */ 106,145, 25,145, 42,  0,  0, 20, 97, 97,  6,145,164,  0,  0,148,
/* 0x10a0 */  97,  2,  0, 84,227, 47, 64,185, 97,129,  7,145, 96, 16,  6, 11,
/* 0x10b0 */ 160,  0,  0,148,161,  3,  0, 84, 35,  1,128, 82,223, 28,  0,113,
/* 0x10c0 */ 102,  1,128, 82,102, 48,134, 26,227, 67, 66,248, 36,  1,  3,203,
/* 0x10d0 */ 159,  0, 15,107,131, 17,  0, 84,227,125, 64,147,227,  3,  3,203,
/* 0x10e0 */  32,105, 99, 56, 32, 21,  0, 56,121,  0,  0, 20, 97,193,  6,145,
/* 0x10f0 */ 143,  0,  0,148,228,  7, 64,185, 64,  1,  0, 84, 97, 33,  7,145,
/* 0x1100 */ 139,  0,  0,148,228, 11, 64,185,128,  0,  0, 84,227, 11, 64,185,
/* 0x1110 */ 228, 15, 64,185,227, 15,  0,185,227,  7, 64,185,227, 11,  0,185,
/* 0x1120 */ 239,  7,  0,185,239,  3,  4, 42,  3,  1,128, 82,223, 28,  0,113,
/* 0x1130 */ 102,  1,128, 82,102, 48,134, 26,106,161, 41,145, 65,  1,  0,145,
/* 0x1140 */ 125,  0,  0,148,  1,  1,  0, 84,227, 47, 64,185, 69, 17,  0,145,
/* 0x1150 */ 227,  3,  3, 42,  2,  0,128, 82,165, 16,  3,139,  4,  1,128, 82,
/* 0x1160 */  14,  0,  0, 20, 65,  9,  0,145,115,  0,  0,148,  1,  1,  0, 84,
/* 0x1170 */ 227, 47, 64,185, 69, 17,  4,145,227,  3,  3, 42,  2,  1,128, 82,
/* 0x1180 */ 165, 16,  3,139,  4,  1,128, 82,  4,  0,  0, 20, 69, 17,  8,145,
/* 0x1190 */   2,  2,128, 82,  4, 32,128, 82,226, 55,  0,185, 32,  0,128, 82,
/* 0x11a0 */ 225,  3,  5,170,101,  0,  0,148,  3,  0,  4,107,163,255,255, 84,
/* 0x11b0 */ 229, 55, 64,185,165,  0,  3, 11,229, 55,  0,185,223, 16,  0,113,
/* 0x11c0 */ 194,  6,  0, 84,198, 28,  0, 17, 99,  0,128, 82,191, 16,  0,113,
/* 0x11d0 */ 101, 32,133, 26,227,  3,  5, 42,101, 29,  3,139,165,128, 13,145,
/* 0x11e0 */  32,  0,128, 82,  4,  8,128, 82,225,  3,  5,170, 83,  0,  0,148,
/* 0x11f0 */   3,  0,  4,107,163,255,255, 84,227, 47,  0,185,127, 16,  0,113,
/* 0x1200 */  99,  4,  0, 84,100,124,  1, 83,132,  4,  0, 81,111,  0,  0, 18,
/* 0x1210 */ 239,  1, 31, 50,127, 56,  0,113,226,  0,  0, 84,239, 33,196, 26,
/* 0x1220 */ 106,121, 21,145,227,  1,  3, 75,227,  3,  3, 42, 74,  5,  3,139,
/* 0x1230 */  12,  0,  0, 20,132, 16,  0, 81, 53,  0,  0,148,231,124,  1, 83,
/* 0x1240 */ 131,  1,  7,107,108, 32,140, 26,239,  1, 15, 26,132,  4,  0,113,
/* 0x1250 */  65,255,255, 84,106, 17, 25,145,239,109, 28, 83,132,  0,128, 82,
/* 0x1260 */  37,  0,128, 82, 32,  0,128, 82,225,  3, 10,170, 51,  0,  0,148,
/* 0x1270 */  31,  0,  0,114, 64,  0,  0, 84,239,  1,  5, 42,165,120, 31, 83,
/* 0x1280 */ 132,  4,  0,113, 33,255,255, 84,  2,  0,  0, 20,239, 47, 64,185,
/* 0x1290 */ 239,  5,  0, 49,229, 55, 64,185,227, 67, 66,248,165,  8,  0, 17,
/* 0x12a0 */  35,  1,  3,203,255,  1,  3,107,232,  2,  0, 84,227,125, 64,147,
/* 0x12b0 */ 227,  3,  3,203, 32,105, 99, 56, 32, 21,  0, 56, 63,  1, 14,235,
/* 0x12c0 */ 194,  0,  0, 84,165,  4,  0,113, 97,255,255, 84,224,115,  0, 57,
/* 0x12d0 */  63,  1, 14,235,195,229,255, 84, 13,  0,  0,148,  0,  0,128, 82,
/* 0x12e0 */ 226, 19, 64,249,  3,  1,  2,203,226, 31, 64,249, 67,  0,  0,185,
/* 0x12f0 */ 226, 67, 66,248, 35,  1,  2,203,226, 55, 64,249, 67,  0,  0,185,
/* 0x1300 */ 255,243,  0,145, 32,  0,128, 82,246,255,255, 23,227,124, 24, 83,
/* 0x1310 */ 195,  0,  0, 53, 31,  1, 13,235,231, 92, 24, 83, 66,255,255, 84,
/* 0x1320 */   3, 21, 64, 56,108, 32, 12, 42,192,  3, 95,214,224,  3,  6, 42,
/* 0x1330 */  33, 68, 32,139,  0,  0,128, 82, 33, 68, 32,139,227,124, 24, 83,
/* 0x1340 */ 241,  3, 30,170, 94,  0,  0, 16, 99,254,255, 52, 35,  0, 64,121,
/* 0x1350 */ 226,124, 11, 83, 98,124,  2, 27,159,  1,  2,107,  2,  1,  0, 84,
/* 0x1360 */ 231,  3,  2, 42,  2,  0,129, 82, 66,  0,  3, 75,  0,  0,  0, 58,
/* 0x1370 */  99, 20, 66, 11, 35,  0,  0,121, 32,  2, 95,214,140,  1,  2, 75,
/* 0x1380 */ 231,  0,  2, 75, 99, 20, 67, 75,  0,  0,  0, 58, 35,  0,  0,121,
/* 0x1390 */  32,  2, 95,214,194,  3,128, 82,225,  0,  0, 16, 64,  0,128, 82,
/* 0x13a0 */   8,  8,128, 82,  1,  0,  0,212,224, 15,128, 82,168, 11,128, 82,
/* 0x13b0 */   1,  0,  0,212, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82,
/* 0x13c0 */  79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100, 46,
/* 0x13d0 */  10,  0, 67,132, 64,248,227,255,255,181,  3,  0,130,210, 64,  4,
/* 0x13e0 */ 193,168, 96,  0,  0,180, 31, 24,  0,241,161,255,255, 84, 33,  0,
/* 0x13f0 */ 131,154,225,  3,  1,203,225,255,129,146,225, 19,  0,249,226,  3,
/* 0x1400 */  30,170, 65,144,  0,209, 36, 68, 64,184,134,  0,  0, 18,131,  0,
/* 0x1410 */  38, 10,229,  3,  1,170, 36, 68, 64,184,165,  0,  4,203, 36, 68,
/* 0x1420 */  64,184,132, 48,  6,139,132,  0,  5,139,228, 15,  0,249, 36, 68,
/* 0x1430 */  64,184,132,  0,  5,139,228, 27,  0,249, 36, 68, 64,184,128,  0,
/* 0x1440 */   5,139, 97,  0,  5,139, 36,  4, 64,185, 33, 48,  0,145, 33,  0,
/* 0x1450 */   4,139,229, 35, 64,185, 36, 68, 64,184,  5,  0, 37, 10,165, 12,
/* 0x1460 */   0, 17,165,116, 30, 18,132,  0,  5, 11,  0, 64, 37,203,224,147,
/* 0x1470 */   4,169,  0, 64, 37,139,132,  0,  5, 75, 16,  0,  0,148, 99, 28,
/* 0x1480 */   0, 18,127, 72,  1,113,129,  1,  0, 84, 33,252, 66,211, 65,  1,
/* 0x1490 */   0,180, 33,  4,  0,209,  2,120, 97,184, 67,120, 26, 83,127, 20,
/* 0x14a0 */   0,113,129,  0,  0, 84, 67,  0,  1, 75, 98,100,  0, 51,  2,120,
/* 0x14b0 */  33,184,  1,255,255,181,192,  3, 95,214,165,124,  2, 83,254,151,
/* 0x14c0 */   5,169, 35, 20, 64, 57, 38, 24, 64, 57,224,147,  6,169,230,143,
/* 0x14d0 */   7,169, 36, 68, 64,184,229,  3,  4, 42, 36, 68, 64,184,226,147,
/* 0x14e0 */   8,169,227,195,  1,145,225,151,  9,169,224,143, 10,169,165, 12,
/* 0x14f0 */   0,145,227, 99, 64,185, 98,  8, 69,139,227, 71, 64,249, 99,  0,
/* 0x1500 */   0,148,227, 47, 64,249, 97,  0,  0,148, 53,  0,  0,148,  5,  0,
/* 0x1510 */ 128,210,  4,  0,128,146, 67,  6,128,210, 98,  0,128,210,224,135,
/* 0x1520 */  68,169,230,  3,  0,170,200, 27,128, 82,  1,  0,  0,212, 31,  0,
/* 0x1530 */   6,235, 64,  0,  0, 84,  0,  0, 32,212,229, 99, 64,185,225, 31,
/* 0x1540 */  64,249, 29,  0,  0,148,228, 71, 64,249,224,135, 73,169,226,143,
/* 0x1550 */  74,169,128,  0, 63,214,  4,  0,  0,148,  1,  0,  0,212,224,  7,
/* 0x1560 */ 204,168, 96,  0, 31,214,228, 27, 64,249,192,  7, 64,169,128,  0,
/* 0x1570 */   0,249,129,  8,  0,185,228, 47, 64,249,226,143, 71,169,224,135,
/* 0x1580 */  70,169, 67,  0,  0,180,128,  0, 63,214,224,135, 68,169,162,  0,
/* 0x1590 */ 128,210, 72, 28,128, 82,  1,  0,  0,212,254,147, 66,169,224,135,
/* 0x15a0 */  67,169,232, 26,128, 82,226, 15, 65,169,128,  0, 31,214, 37,192,
/* 0x15b0 */  95,184,165, 92,  0, 18,133,  0,  0, 54, 35, 68, 64,184,165,  4,
/* 0x15c0 */   0, 81,  3, 68,  0,184,165,  0,  0, 52, 34, 12,193, 40,165,  8,
/* 0x15d0 */   0, 81,  2, 12,129, 40,165,255,255, 53,192,  3, 95,214,254, 95,
/* 0x15e0 */   0,249,227,  3, 30,170, 41,  0,  0,148, 65,244,126,211,  5,  0,
/* 0x15f0 */ 128,210,  4,  0,128,146, 67,  4,128,210, 98,  0,128,210,225, 35,
/* 0x1600 */   0,249,  0,  0,128,210,200, 27,128, 82,  1,  0,  0,212, 31,  4,
/* 0x1610 */  64,177, 67,  0,  0, 84,  0,  0, 32,212,224, 31,  0,249,225, 39,
/* 0x1620 */  64,249,229, 99, 64,185,228,255,255,151,225,151, 73,169,224, 79,
/* 0x1630 */   0,249,165, 12,  0, 17,165,124,  2, 83,223,255,255,151,226,  3,
/* 0x1640 */   0,170,225, 71, 64,249,224, 71,  0,249,217,255,255,151,225, 47,
/* 0x1650 */  64,249,224, 47,  0,249,214,255,255,151,225, 95, 64,249,224, 95,
/* 0x1660 */   0,249,211,255,255,151,224,135, 67,169,162,  0,128,210, 72, 28,
/* 0x1670 */ 128, 82,  1,  0,  0,212, 31,  4, 64,177, 67,  0,  0, 84,  0,  0,
/* 0x1680 */  32,212,254, 95, 64,249,192,  3, 31,214, 99,192, 95,184, 99, 92,
/* 0x1690 */   0, 18, 66,  0,  3,139,192,  3, 95,214,102,105,108,101, 32,102,
/* 0x16a0 */ 111,114,109, 97,116, 32,101,108,102, 54, 52, 45,108,105,116,116,
/* 0x16b0 */ 108,101, 97, 97,114, 99,104, 54, 52, 10, 10, 83,101, 99,116,105,
/* 0x16c0 */ 111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32,
/* 0x16d0 */  32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32,
/* 0x16e0 */  32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x16f0 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1700 */  32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,
/* 0x1710 */ 108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69,
/* 0x1720 */  76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32, 48, 49, 48,
/* 0x1730 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x1740 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x1750 */  78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x1760 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 48, 32, 32, 50, 42, 42, 48,
/* 0x1770 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 78,
/* 0x1780 */  82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 32, 32,
/* 0x1790 */  48, 32, 32, 48, 32, 32, 48, 53, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x17a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 78, 82,
/* 0x17b0 */  86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 55, 99,
/* 0x17c0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 48, 32, 32, 50, 42, 42,
/* 0x17d0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x17e0 */  78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x17f0 */  55, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 99, 32, 32,
/* 0x1800 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1810 */  32, 53, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1820 */  32, 48, 49, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 51,
/* 0x1830 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1840 */  83, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x1850 */  32, 32, 32, 32, 48, 49, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1860 */  48, 52, 56, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1870 */  69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1880 */  67, 50, 48, 32, 32, 32, 32, 48, 57, 54, 56, 32, 32, 48, 32, 32,
/* 0x1890 */  48, 32, 32, 48, 53, 56, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x18a0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77, 65,
/* 0x18b0 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 52, 97, 48, 32, 32,
/* 0x18c0 */  48, 32, 32, 48, 32, 32, 48,101,102, 52, 32, 32, 50, 42, 42, 48,
/* 0x18d0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76,
/* 0x18e0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 32, 32,
/* 0x18f0 */  48, 32, 32, 48, 32, 32, 48, 49, 51, 57, 52, 32, 32, 50, 42, 42,
/* 0x1900 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32,
/* 0x1910 */  69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1920 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 57, 52, 32, 32,
/* 0x1930 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1940 */  49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32, 32, 32, 32,
/* 0x1950 */  32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,100, 50, 32,
/* 0x1960 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1970 */  32, 49, 50, 32, 69, 76, 70, 77, 65, 74, 78, 90, 32, 32, 32, 32,
/* 0x1980 */  32, 32, 48, 50, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,
/* 0x1990 */ 100, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x19a0 */  84, 83, 10, 32, 49, 51, 32, 65, 78, 68, 77, 65, 74, 78, 90, 32,
/* 0x19b0 */  32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x19c0 */  49, 51,102, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x19d0 */  69, 78, 84, 83, 10, 32, 49, 52, 32, 69, 76, 70, 77, 65, 75, 78,
/* 0x19e0 */  90, 32, 32, 32, 32, 32, 32, 48, 50, 97, 48, 32, 32, 48, 32, 32,
/* 0x19f0 */  48, 32, 32, 48, 49, 51,102, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a00 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32,
/* 0x1a10 */  84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a20 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1a30 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77,
/* 0x1a40 */  65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1a60 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77,
/* 0x1a70 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a80 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76,
/* 0x1a90 */  70, 77, 65, 73, 78, 88, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1aa0 */  88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72,
/* 0x1ac0 */  69, 65, 68, 32, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48,
/* 0x1ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ae0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x1af0 */  32, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x1b00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1b10 */  32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82, 86,
/* 0x1b20 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b30 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x1b40 */  68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1b50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1b60 */ 100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50, 66,
/* 0x1b70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b80 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69,
/* 0x1b90 */  76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x1ba0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bb0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x1bc0 */  68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1bd0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1be0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1bf0 */  95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1c00 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c10 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70,
/* 0x1c20 */  77, 65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89,
/* 0x1c30 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c40 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 74,
/* 0x1c50 */  78, 90, 32, 48, 32, 69, 76, 70, 77, 65, 74, 78, 90, 10, 48, 48,
/* 0x1c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1c70 */  32, 32, 32, 32,100, 32, 32, 65, 78, 68, 77, 65, 74, 78, 90, 32,
/* 0x1c80 */  48, 32, 65, 78, 68, 77, 65, 74, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1ca0 */  32,100, 32, 32, 69, 76, 70, 77, 65, 75, 78, 90, 32, 48, 32, 69,
/* 0x1cb0 */  76, 70, 77, 65, 75, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1cd0 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 95,115,116, 97,
/* 0x1ce0 */ 114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50,
/* 0x1d00 */  69, 32, 48, 49, 55, 99, 32,117, 99,108, 95,110,114,118, 50,101,
/* 0x1d10 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 51, 50, 10, 48,
/* 0x1d20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1d30 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 68, 32, 48, 49,
/* 0x1d40 */  55, 48, 32,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x1d50 */ 111,109,112,114,101,115,115, 95, 51, 50, 10, 48, 48, 48, 48, 48,
/* 0x1d60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1d70 */  32, 32, 70, 32, 78, 82, 86, 50, 66, 32, 48, 49, 52, 52, 32,117,
/* 0x1d80 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x1d90 */ 101,115,115, 95, 51, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1db0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76,122,109,
/* 0x1dc0 */  97, 68,101, 99,111,100,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1de0 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32,101,110,100, 95,
/* 0x1df0 */ 100,101, 99,111,109,112,114,101,115,115, 10, 10, 82, 69, 76, 79,
/* 0x1e00 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x1e10 */  79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79,
/* 0x1e20 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e30 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e40 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e50 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 65, 82, 67, 72,
/* 0x1e60 */  54, 52, 95, 67, 65, 76, 76, 50, 54, 32, 32, 69, 76, 70, 77, 65,
/* 0x1e70 */  73, 78, 90, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1e80 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x1e90 */  65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x1ea0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1eb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1ec0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 52, 32, 82, 95, 65, 65, 82, 67, 72, 54, 52, 95, 67, 79,
/* 0x1ee0 */  78, 68, 66, 82, 49, 57, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1ef0 */  51, 48, 10
};
