#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import os
import time
import pygtk
pygtk.require("2.0")
import gtk.gdk
import gobject

from winswitch.consts import APPLICATION_NAME
from winswitch.util.paths import ANIM_DIR
from winswitch.globals import OSX
from winswitch.ui import icons
from winswitch.ui.tray_util import BaseTray


class StatusIconTray(BaseTray):

	def __init__(self, popup_menu, activate_menu, exit_cb, ask_quit, default_icon_name):
		BaseTray.__init__(self, popup_menu, activate_menu, exit_cb, ask_quit, default_icon_name)

	def setup_widget(self):
		self.slog()
		self.tray_widget = gtk.StatusIcon()
		self.tray_widget.set_tooltip(APPLICATION_NAME)
		self.tray_widget.connect('popup-menu', self.popup_menu)
		self.tray_widget.connect('activate', self.activate_menu)
		self.set_icon(self.default_icon_name)

	def close(self):
		if self.tray_widget:
			self.tray_widget.set_visible(False)
			self.tray_widget = None

	def ready(self):
		self.tray_widget.set_visible(True)

	def set_icon(self, icon_name):
		icon = icons.get(icon_name)
		self.tray_widget.set_from_pixbuf(icon)

	def request_attention(self, message, delay):
		TRAY_ANIMATE = True			# instead of blinking
		if TRAY_ANIMATE:
			self.animate_status_icon(message, delay)
		else:
			self.blink_status_icon(message, delay)

	def blink_status_icon(self, message, delay):
		self.tray_widget.set_blinking(True)
		gobject.timeout_add(int(delay*1000), self.unblink_status_icon)
		return	False

	def unblink_status_icon(self):
		self.tray_widget.set_blinking(False)
		return	False


	def position_menu(self, menu, tray_widget):
		if OSX:
			""" Seems to work better on OSX by passing None - uses current mouse position """
			return	None
		try:
			position = gtk.status_icon_position_menu(menu, self.tray_widget)
			return	BaseTray.validate_position(self, menu, position)
		except Exception, e:
			self.serr(None, e, menu)
		return	None



	def animate_status_icon(self, message, timeout=20):
		ANIM_STEP_DELAY=200

		def load_animation():
			if self.tray_widget_notify_images is not None:
				return
			self.tray_widget_notify_images = []
			for i in range(9):
				filename = os.path.join(ANIM_DIR, "winswitch-starred%s.png" % (i+1))
				if os.path.exists(filename):
					img = gtk.gdk.pixbuf_new_from_file(filename)
					img.full_path_to_icon_file = filename
					self.tray_widget_notify_images.append(img)
			self.slog("loaded %s images from %s" % (len(self.tray_widget_notify_images), ANIM_DIR))

		def animate(step):
			l = len(self.tray_widget_notify_images)
			index = step % (2*l-1)
			if index>=l:
				index = 2*l -1 - index
			#self.sdebug("l=%s, index=%s" % (l, index), step)
			now = time.time()
			if now<self.tray_widget_animate_until:
				self.tray_widget.set_from_pixbuf(self.tray_widget_notify_images[index])
				gobject.timeout_add(ANIM_STEP_DELAY, animate, step+1)
			else:
				self.set_icon(self.default_icon_name)

		def trayicon_notify_end(counter):
			""" Clear the tooltip, but only if we are the last notification to make use of it """
			self.sdebug("current counter=%s" % self.tray_widget_notify_counter, counter)
			if counter == self.tray_widget_notify_counter:
				self.tray_widget.set_tooltip(APPLICATION_NAME)

		self.tray_widget_notify_counter += 1
		counter = self.tray_widget_notify_counter
		if message:
			self.tray_widget.set_tooltip("%s\n%s" % (APPLICATION_NAME, message))
		else:
			self.tray_widget.set_tooltip(APPLICATION_NAME)
		gobject.timeout_add(int(timeout*1000), trayicon_notify_end, counter)
		load_animation()
		if len(self.tray_widget_notify_images)>0:
			now = time.time()
			start_it = now>=self.tray_widget_animate_until
			self.slog("now=%s, tray_widget_animate_until=%s" % (now, self.tray_widget_animate_until), message, timeout)
			self.tray_widget_animate_until = now+timeout
			if start_it:
				animate(0)
