#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 6>, 400> jacobi_theta_data = {{
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(3.2885959156198046956373565724956688068534e-02), SC_(-2.2416718090563708825527631664766447369533e+00), SC_(2.2416730256716428176498936630325268412281e+00), SC_(8.6501687817251432893648387652790053208630e-02) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(5.5831988474209441900045409328023422992062e-02), SC_(-1.9691670545730865185370026051380898653342e+00), SC_(1.9692070146804315897834982290548176926129e+00), SC_(1.8728278171412944095194972294679425185365e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(6.1414517194706514196626094660315415501479e-02), SC_(-1.9073573818152337347920026599518799545677e+00), SC_(1.9074397029476183499308029984882511761375e+00), SC_(2.1897663035281409511640466400290764283829e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(8.4145606747747875706412202717886523741067e-02), SC_(-1.6199525737027658037878996227105298327933e+00), SC_(1.6216382399667330034766713511913243280071e+00), SC_(4.1180679330462040958324052300483030623371e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(8.9974872037641809899114670882385487978310e-02), SC_(-1.4948280057918640281547902919992903030933e+00), SC_(1.5000473265750476128317440143673362216076e+00), SC_(5.1467354741397891494638231908572839845465e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(9.1690758183633167841811240684147212274744e-02), SC_(-1.3253829252665879780800332116214769334757e+00), SC_(1.3451047394314855351133469239572153244678e+00), SC_(6.5836831869245427680960986308150766818528e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(9.0196440355619018889228716087108355076037e-02), SC_(-1.2537410275781201841590060208091665028950e+00), SC_(1.2857950607472095909819956705437694951374e+00), SC_(7.1585263374832302977228457724224595932690e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(6.5877232809985905681764619134801086230341e-02), SC_(-8.4541004713259912838041915549137324261762e-01), SC_(1.0635948798051944732048239426082454938934e+00), SC_(9.3640920626489599747404227419818655818329e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(6.5843024946382135530921273524011201797333e-02), SC_(-8.4495631716962738405779450206308182590358e-01), SC_(1.0634595414471609505348672963192811042462e+00), SC_(9.3654450995432086454672201528973484675506e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(5.7717402457827552130506520458926747827065e-02), SC_(-7.3869742783791038117941437934053766799270e-01), SC_(1.0371674808910674395048549485514017159826e+00), SC_(9.6283299588492950587203513753732975338901e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(4.3382185219962659123384493028114502587781e-02), SC_(-5.5453006027422481538616511141963584513263e-01), SC_(1.0118177162202877813354243461741329409210e+00), SC_(9.8818228865282976953190323495768627669719e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(4.2022677150864693639214706106242554258389e-02), SC_(-5.3713514503810660443759327951192629043962e-01), SC_(1.0104035384590398675130815571225838402607e+00), SC_(9.8959646446778732507698856099061363554844e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(3.7602545611832097928051600960332852576056e-02), SC_(-4.8060586328526795964620529919138719384821e-01), SC_(1.0066685390881391928580890886073198867059e+00), SC_(9.9333146140593908217654878598148057492365e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(3.7157356157057774254146348528034331540937e-02), SC_(-4.7491386186047605336495192882655608771272e-01), SC_(1.0063582204164079590214459763047191130700e+00), SC_(9.9364177999192579272821357131004366585243e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(3.4669293496880933573913973796766377221594e-02), SC_(-4.4310583233589327796733318164596230304260e-01), SC_(1.0048185184419865146698247683731072232283e+00), SC_(9.9518148169270092444326671454923222356603e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(3.4269674493132122042104988732264751057251e-02), SC_(-4.3799741759362342540558356798192376397563e-01), SC_(1.0046001368516167395772083209713542961695e+00), SC_(9.9539986326026417406727253414204725647095e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(3.4118954296499040189528020840058110228868e-02), SC_(-4.3607075353491976987733384704372494896805e-01), SC_(1.0045197322883877810757800087423430817192e+00), SC_(9.9548026781587368895570806333888285193359e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(3.4056153222157931904248573342730647957311e-02), SC_(-4.3526796792144445779854041542761157145315e-01), SC_(1.0044865429698043837327880338227974626757e+00), SC_(9.9551345713142820070531172057902884449025e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(3.2795600559509299554238288287266474520164e-02), SC_(-4.1915475739250961854397536490612733958572e-01), SC_(1.0038582012197738610159379154069365034703e+00), SC_(9.9614179883558823208000122028308835467598e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(3.2611717401368608560226578350702144470825e-02), SC_(-4.1680430305278540963672957062261370260009e-01), SC_(1.0037723878277962279347696844063471461102e+00), SC_(9.9622761222280235400179541749559509865075e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-6.9676853953032381244877372361276859265833e-02), SC_(-2.1742880296700880641378638549557311881085e+00), SC_(2.1742903337996054679352276490976794472551e+00), SC_(1.0429228242216249027210077880725313508125e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-1.1535719738182461019719051252071974536393e-01), SC_(-1.9235293961360632224820892506863158635906e+00), SC_(1.9235905656343136619049504876148897791741e+00), SC_(2.0928717318774198825798484556769369833088e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.2635606006211526599393189133213144552846e-01), SC_(-1.8658821428950401443604145995458179840698e+00), SC_(1.8660028810074116923960226415367933524933e+00), SC_(2.4134071780300068649120025619519327491542e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.7073301400235555436898762012301610560970e-01), SC_(-1.5943378570131547445128235218495685582267e+00), SC_(1.5964292250840093437662989986717842943046e+00), SC_(4.3197035975376943991056461366142957045398e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-1.8190450172600248007541912663061189329094e-01), SC_(-1.4743415382434155511176429567081690793979e+00), SC_(1.4804680749326598915746552573628936838561e+00), SC_(5.3203204217740411884133203721898526466513e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-1.8480392459732740055543915197923581287778e-01), SC_(-1.3101212425899176980652377630798437311952e+00), SC_(1.3319726015184572938123653999752144911655e+00), SC_(6.7097651919854720751533622326405618291680e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-1.8164564889940919584594762321826678234933e-01), SC_(-1.2401321367224119949259298157673037404433e+00), SC_(1.2749895020493837716763882331848463726145e+00), SC_(7.2640962511757515582157310777022082156911e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-1.3246258568705527992211615576017298058888e-01), SC_(-8.3743545401533823531663790430500265498361e-01), SC_(1.0612109917512709375781295169244701713145e+00), SC_(9.3879247790386561583883622379999064947649e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-1.3239375881014655157772587188263018492868e-01), SC_(-8.3698627647842741248597884484034588564926e-01), SC_(1.0610807280962611731979716026543372826837e+00), SC_(9.3892271212029174466583508938869642523974e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-1.1604932787313472262372052163118333717661e-01), SC_(-7.3176635108630629644306636069888832789020e-01), SC_(1.0357743463550976342229037664925377339235e+00), SC_(9.6422605849559022961364190753251083632592e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-8.7224207683535554113287784850157950558384e-02), SC_(-5.4933993228145764731195546461730437273983e-01), SC_(1.0113747655797527788528860145495129630519e+00), SC_(9.8862523855821768348144342164147409054536e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-8.4490730814468820010723822599677937278912e-02), SC_(-5.3210814209271451763108098996476942969166e-01), SC_(1.0100135939870993647805628127464053793266e+00), SC_(9.8998640849819353958187285746302860345875e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-7.5603529589824223493793039662986816850983e-02), SC_(-4.7610848910259253445426140056414334146921e-01), SC_(1.0064185895975358726720008714824337215412e+00), SC_(9.9358141082200691217433377814640273722659e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-7.4708427701638229443998430123216167944731e-02), SC_(-4.7046978790332388429864217046816597084144e-01), SC_(1.0061199022616371000288254867133191226320e+00), SC_(9.9388009808509637928433380895692034379079e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-6.9705916375482701082280646757898724193655e-02), SC_(-4.3895954984627461602882569445920348316658e-01), SC_(1.0046379112460061575235741827372786441206e+00), SC_(9.9536208886836265030422606968365669324474e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-6.8902441621096209562870934973072666084946e-02), SC_(-4.3389895310038263230276048357410242920558e-01), SC_(1.0044277150121370456245412530982408343091e+00), SC_(9.9557228508286577569616361340888122471534e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-6.8599403369089294855997739969130536471752e-02), SC_(-4.3199032338645380135375585492512352774591e-01), SC_(1.0043503241645036599869455358699721945301e+00), SC_(9.9564967592402916912017636521145645320973e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-6.8473135446507010543494025919642828982783e-02), SC_(-4.3119505209695623239971510541478368818257e-01), SC_(1.0043183788445501225325357032936252817910e+00), SC_(9.9568162124141075156049052526605245801640e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-6.5938667856032805499247953082639466279535e-02), SC_(-4.1523265838400988098451372863518061943789e-01), SC_(1.0037135885347991840554425975715737922150e+00), SC_(9.9628641151221111347436480987777782966621e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-6.5568952497981488574466097832940398530291e-02), SC_(-4.1290420275596585095673395612028777682163e-01), SC_(1.0036309915913907956383436936638691404650e+00), SC_(9.9636900845157460285737793522060407676557e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-1.0638124256040449522259464034480143699687e-01), SC_(-2.0839514985288259310740565295492424084695e+00), SC_(2.0839558026423675763831595653354870910202e+00), SC_(1.2980363891774324439110618936460778126902e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-1.7049865099987792267730709322475468291487e-01), SC_(-1.8618246337229031927995835312739933943865e+00), SC_(1.8619205858385442093235450053842179174263e+00), SC_(2.4008155347217191851084263398550522889137e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.8571910380134416398456036857916714119148e-01), SC_(-1.8097047546393151131110178736917818008416e+00), SC_(1.8098871857898295077646042246594644892592e+00), SC_(2.7251598072852339587994209011284928293062e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-2.4633897832788700386327974982707008703909e-01), SC_(-1.5593643243887396638493765503019746112799e+00), SC_(1.5620599962672167004834007175358813569852e+00), SC_(4.5974175845707997595867502970177778756781e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-2.6118453981003000041489363092064349843461e-01), SC_(-1.4462720595319897223486648056537220973423e+00), SC_(1.4537201945268860467137013839853152671969e+00), SC_(5.5587588286753552867205362345249713136055e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-2.6424067019114790962633510954852273540602e-01), SC_(-1.2891144929895939986617882287184684317098e+00), SC_(1.3140021770065402325964153782318227519816e+00), SC_(6.8826180113127887392731536598283018106079e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-2.5943956282720049402054893750677009247457e-01), SC_(-1.2213686904484515426893737796789651339889e+00), SC_(1.2601971734750615594009189797290879626099e+00), SC_(7.4087690711491610649149820681298518882551e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-1.8878956567519166004513773387574370846947e-01), SC_(-8.2639204425528085671355741732273647904376e-01), SC_(1.0579458740210507414129773499466612213543e+00), SC_(9.4205678956044801196042392214867387481805e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-1.8869138679375539622398712684155527733590e-01), SC_(-8.2594915845073138151521885317788371054166e-01), SC_(1.0578225608657991493755731555963898529971e+00), SC_(9.4218008011631619696162723904199888269708e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-1.6538542013400175221396832958690244866121e-01), SC_(-7.2216632402491545130272107870423759074292e-01), SC_(1.0338662158250433764582773722516415265089e+00), SC_(9.6613409497034103828041799145683991519336e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-1.2430185093146893760355624399635885738140e-01), SC_(-5.4215064094117685462946476926592682923095e-01), SC_(1.0107680699775672671549359834651416412459e+00), SC_(9.8923193319906589437886204952316526289425e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-1.2040631756004077369722484289172173455479e-01), SC_(-5.2514479448651597050906053975372662456524e-01), SC_(1.0094794992654835745559867695016535530230e+00), SC_(9.9052050264242367804162484206217923791607e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-1.0774113822733007521331577004138945862086e-01), SC_(-4.6987875047171643254229997645086947143533e-01), SC_(1.0060762416076869922967614433728797009767e+00), SC_(9.9392375871438720691665651968289487514588e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-1.0646553453064198323590650217611419248097e-01), SC_(-4.6431387878055053549769517951725365075621e-01), SC_(1.0057934853479370452215052524211167662068e+00), SC_(9.9420651491824297675449094908523977991764e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-9.9336508027551039212166457013883805524981e-02), SC_(-4.3321613331366535446906205217511050527905e-01), SC_(1.0043905392245361449819492921559990694994e+00), SC_(9.9560946086326239077316719016673261572394e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-9.8191486967994655385389562100293240910888e-02), SC_(-4.2822177310736525193534702623638378741878e-01), SC_(1.0041915542171019831458486808786584584716e+00), SC_(9.9580844585582969082177424425373311207023e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-9.7759631372978600405867813659006659728060e-02), SC_(-4.2633812423087437295282405411808632962213e-01), SC_(1.0041182911613344165398969193346263074153e+00), SC_(9.9588170890663038006414550704348518098824e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-9.7579688735659049827250483638661548188955e-02), SC_(-4.2555326164580684609426800006924870771518e-01), SC_(1.0040880497073444116704346117766544104332e+00), SC_(9.9591195035864594899644540760866825887746e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-9.3967857122242949310122478156445867248716e-02), SC_(-4.0979977699967490799854151344265689536513e-01), SC_(1.0035155170678095605464157060368522757711e+00), SC_(9.9648448296827925918443210832467095744532e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-9.3440981680104441583727144047948091946664e-02), SC_(-4.0750179369136666668790599318965934897930e-01), SC_(1.0034373255932874610006898332903053207462e+00), SC_(9.9656267443969617455262656635316288310748e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-5.6459998137303752741228686116780358974679e-01), SC_(-1.1394794505261451683930377730857892250385e+00), SC_(1.1396580761972697575442651695814122962722e+00), SC_(5.6606301801837000766466276630864147301542e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-6.7938091735056937117796374949709060102571e-01), SC_(-1.1702691826279466121316148050004648943860e+00), SC_(1.1719131449030409142339547507078133688152e+00), SC_(6.8764898891682920407497776228804166050132e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-7.0156589356703896371273737359361422602828e-01), SC_(-1.1706000803760578985501922839949225430942e+00), SC_(1.1731933440114082790405111888967410228055e+00), SC_(7.1335229088312356448608581575261558683226e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-7.6886298840213560999699156957222142195451e-01), SC_(-1.1332419953265361185493780488214417076350e+00), SC_(1.1503479387131120226422093107314758409612e+00), SC_(8.1963478037919507730845818576705759319952e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-7.7199158614585533737886676382727721865587e-01), SC_(-1.0937409122154308922611153327066427373951e+00), SC_(1.1281024977942080562616284023607523121832e+00), SC_(8.5868534639252563758735091205269602016770e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-7.4381565691064907634392981360597679682925e-01), SC_(-1.0147457152656329101948054723145757721486e+00), SC_(1.0923286639171711686080865616028014430666e+00), SC_(9.0455422572944300280201632097574490571312e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-7.2072969417331544065039744710415173786776e-01), SC_(-9.7280813597837363305496456856365394632576e-01), SC_(1.0771804888288763771612114372622644844421e+00), SC_(9.2134068605711776746893917193235408606706e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-5.1094719546089222120682382389412668568022e-01), SC_(-6.7476345376516384997476961825188308994541e-01), SC_(1.0173864171237379544862884105977827907055e+00), SC_(9.8260991558048334349943626916473307564653e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-5.1067863352262715702649291085274872138748e-01), SC_(-6.7440557133441569345008973457779945466796e-01), SC_(1.0173494317232784345862221992022390330021e+00), SC_(9.8264693209642531012831206885282864788518e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-4.4721961755911039937418334668587552730110e-01), SC_(-5.9016826224391379269878846019254981809186e-01), SC_(1.0101624610551876063947969123094089123777e+00), SC_(9.8983711103276921501744438033752970488360e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-3.3599049462074533672245472364546024455333e-01), SC_(-4.4323358869677941550314337271197962352105e-01), SC_(1.0032313267057894015457530407857518130198e+00), SC_(9.9676866892053050297750735080557834044501e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-3.2545748478322722326634067878353498658816e-01), SC_(-4.2933486635219768096653210014595937639351e-01), SC_(1.0028446478543118854457208173398369481808e+00), SC_(9.9715534951882641842037286655958417954800e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-2.9121759353018037354952399772886717947795e-01), SC_(-3.8415973088055194795907000080149503829928e-01), SC_(1.0018233847936228535222522923632536542974e+00), SC_(9.9817661476293610600010334094722644879716e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-2.8776934056733135607169156082920381303127e-01), SC_(-3.7961054270929597224971297812683938760233e-01), SC_(1.0017385341097276702260946758031054133497e+00), SC_(9.9826146552378800352961755914300504964060e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-2.6849855902212934644768339808830056781376e-01), SC_(-3.5418782970557727337058017789443973951865e-01), SC_(1.0013175320721342133779219981751295464048e+00), SC_(9.9868246780698223201650156364985875692868e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-2.6540348334532799322556931556404377377596e-01), SC_(-3.5010478486306881507284843550803246357291e-01), SC_(1.0012578197963338816920258374635809565517e+00), SC_(9.9874218010325168751232760970400875851933e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-2.6423615077525781297412296056691129942615e-01), SC_(-3.4856483711899275626345554552290399029489e-01), SC_(1.0012358347034218933772492296460440494830e+00), SC_(9.9876416520300221573936688288865838557137e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-2.6374975534666121228066013232753275352725e-01), SC_(-3.4792318400143769123764512939767506202490e-01), SC_(1.0012267597177629735703949752300430623975e+00), SC_(9.9877324019137959585279037710671048132547e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-2.5398684601416770118571864760112753137444e-01), SC_(-3.3504404123200282279743553634531367097200e-01), SC_(1.0010549516530982477163979307546817291199e+00), SC_(9.9894504829721362510625882158930536927874e-01) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-2.5256269468781599040860755299035245117528e-01), SC_(-3.3316532680001879419449156678619308796036e-01), SC_(1.0010314876172459636758861438484270475394e+00), SC_(9.9896851233734121622173075324717675350887e-01) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-1.1099486633310848454193205882118612295522e+00), SC_(-5.8580614292057868203821335800510062254381e-01), SC_(5.8714431093316500978864300871870435248688e-01), SC_(1.1101460126914049341655550878365943325513e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-1.1468299491100726230902598132323424139448e+00), SC_(-6.9920681298498024889782256956393953201604e-01), SC_(7.0692728799544938470544431027776424222910e-01), SC_(1.1486047198750129374599815935159816541472e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.1485657213476911733041692905727352697660e+00), SC_(-7.2088447706048285417908624366236486163066e-01), SC_(7.3193762482178194824770717747692481512720e-01), SC_(1.1513519127069315420200515677126205678911e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.1173777076582380719618425646677885049059e+00), SC_(-7.8525341291026277763400452869307307298288e-01), SC_(8.3373364926983776484814934195603418927283e-01), SC_(1.1353874945232715250442289967376703716839e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-1.0801803703016443707725059703708334985352e+00), SC_(-7.8698264269011866370985611423816162810818e-01), SC_(8.7033201745697994348675391534319434486711e-01), SC_(1.1160766022485788396996120658228780445992e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-1.0037588038206136536113280295621443396134e+00), SC_(-7.5694597116476060338612770673937116731901e-01), SC_(9.1275891185267987844912148863633732770350e-01), SC_(1.0840345083106188225781954120245827559532e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-9.6271562557972492341929623786595043053893e-01), SC_(-7.3309978995434970763456830073350909537988e-01), SC_(9.2816590970426070714688657684172009871548e-01), SC_(1.0703128189080610369388267758384238266759e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-6.6839664728596267247524498492130064653587e-01), SC_(-5.1921307969038623039104536257399081544231e-01), SC_(9.8413768472712067932043588072656011661557e-01), SC_(1.0158585427158098662169401604948733932752e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-6.6804228150298952028370194107143758100229e-01), SC_(-5.1894006423696413873365106816390798682469e-01), SC_(9.8417145059377348377238922660732070498037e-01), SC_(1.0158248088577378682576911625168022579771e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-5.8461860508461565730782340275558963886910e-01), SC_(-4.5443979877705343072464169062471541096144e-01), SC_(9.9073005015690709499214745033591647291172e-01), SC_(1.0092695096488187007465336874665114008958e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-4.3907226551549335871006685821158563333309e-01), SC_(-3.4140976782919703713585558013464360690884e-01), SC_(9.9705259015131614204025655011518353308452e-01), SC_(1.0029474053494673345619601686567871054159e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-4.2530419462947904749777567835771548476197e-01), SC_(-3.3070674210006251345968093211731611938560e-01), SC_(9.9740529509119967302649876379025045258645e-01), SC_(1.0025947022065406074870617639447644059997e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-3.8055346641485921509557996050322700572898e-01), SC_(-2.9591437106103546974402036853583342906805e-01), SC_(9.9833682680845699035596716517839562875562e-01), SC_(1.0016631727353740139890707975299846983314e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-3.7604700181900230490063312826139851515659e-01), SC_(-2.9241049006056612340339801795588622687441e-01), SC_(9.9841422214645130146273537599695237503571e-01), SC_(1.0015857774765452826015888521271456625038e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-3.5086301440399255605989071017516004482951e-01), SC_(-2.7282885188180160378132502409508688051306e-01), SC_(9.9879823300272790475051175557492483340009e-01), SC_(1.0012017668729188562343737653900923746578e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-3.4681830640242773169222066876023476904691e-01), SC_(-2.6968385267717466260774774800935883111140e-01), SC_(9.9885269866855329698127903841844570809634e-01), SC_(1.0011473012281501069346604034283987399142e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-3.4529281742408853248999359152686840110285e-01), SC_(-2.6849769122847977433062749058604493899762e-01), SC_(9.9887275204396391514715197290986850893407e-01), SC_(1.0011272478597743132409722896964258765372e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-3.4465718883367952588653815686816161102309e-01), SC_(-2.6800345035101148324471328549024423318948e-01), SC_(9.9888102965701593331365772293137706148108e-01), SC_(1.0011189702495187825318291776449515826126e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-3.3189896522956501172696375614317194241226e-01), SC_(-2.5808307062053128535513932063269400179945e-01), SC_(9.9903774181517063568034529298031668340368e-01), SC_(1.0009622581337150537315994594743630410873e+00) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-3.3003788901660454246222343605658746159351e-01), SC_(-2.5663594895994623248933167857450206982734e-01), SC_(9.9905914418344704733714350891093539583464e-01), SC_(1.0009408557698366620063809486683656621746e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-2.1193415741784341753933681152131334150425e+00), SC_(-9.2609407109310057758319510384660791654595e-02), SC_(1.1957425572718550787137454507271513222545e-01), SC_(2.1193450113223070894990724837030065193729e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-1.8860708746818283792467711373614148470697e+00), SC_(-1.5030238894844616166512987923810413181619e-01), SC_(2.2783519943909582329301864839870904867036e-01), SC_(1.8861522565574176616827922671601348701965e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.8317930724474696525719882210268187078550e+00), SC_(-1.6407478043321016925867018505235473586615e-01), SC_(2.6013480866556581983617606316427336649776e-01), SC_(1.8319498292644191314724925083424605636771e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.5731545585375798470923275366966916774945e+00), SC_(-2.1921158672359828421319531822840265231685e-01), SC_(4.4875819101680800713666426133005365215261e-01), SC_(1.5756047555225357550478940804298292902037e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-1.4573536654256625410807401815794885855615e+00), SC_(-2.3286660932768402268806945567950151158357e-01), SC_(5.4645447223913931141803186543737596385712e-01), SC_(1.4642689157532264796267144520728108227587e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-1.2974211807772661458848938489680426796241e+00), SC_(-2.3597934861222075394481943051608472853341e-01), SC_(6.8143648540661838667503243573820842368227e-01), SC_(1.3210934562084168129551876895662995105491e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-1.2287927099829413724325127440712619126419e+00), SC_(-2.3179210378238515367541015060749773689888e-01), SC_(7.3516512662963458764838211295496143738254e-01), SC_(1.2660351328324654094700062763774763353643e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-8.3076823038046542624445223005575351150130e-01), SC_(-1.6881299320218168254212845947951498758500e-01), SC_(9.4076825463934264152232317469329298164336e-01), SC_(1.0592347218495043806267014187785574731338e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-8.3032285308099054262974556700793573519023e-01), SC_(-1.6872523294556757906802962199760158424348e-01), SC_(9.4089428611115369271426956854012632562163e-01), SC_(1.0591086651234209551509888677712678567806e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-7.2597077449828139497469067081061088903117e-01), SC_(-1.4788938793820421532370625393826740030636e-01), SC_(9.6538092926253999774054790874216669810650e-01), SC_(1.0346194180438952847513163555031497313305e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-5.4499980989150922110398133725887513546257e-01), SC_(-1.1115344410549033939119810711240567752348e-01), SC_(9.8899245066093195436800923685609733372988e-01), SC_(1.0110075528888798988872219088101500134429e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-5.2790442231443731365746681500447357657887e-01), SC_(-1.0767000735118896629558323342699159108811e-01), SC_(9.9030967793404997804225632060054097405915e-01), SC_(1.0096903241979909079480240222964075665331e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-4.7234764716235216693611710016378800237474e-01), SC_(-9.6344585301463734792759010329354518289229e-02), SC_(9.9378862262484840453823189170516358011998e-01), SC_(1.0062113777350618374877778435459301705816e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-4.6675351646141423280902153586305388721222e-01), SC_(-9.5203915304384405317293178720843135680827e-02), SC_(9.9407766734722244527390885739178509980939e-01), SC_(1.0059223329502273857458936506893695924858e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-4.3549229769180730869617690665550538882085e-01), SC_(-8.8828992480934950715918214116705725030864e-02), SC_(9.9551181491670611775588953778393374056979e-01), SC_(1.0044881851814066535568296619246706278075e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-4.3047168749545003754901034762415729943426e-01), SC_(-8.7805090140446963159100059447788716325950e-02), SC_(9.9571522535113108489491506870133152645843e-01), SC_(1.0042847747303683226737606299283024030077e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-4.2857813854069086021134015526735159077528e-01), SC_(-8.7418915574249800799570725827148302542221e-02), SC_(9.9579011777795784175562901768923400938657e-01), SC_(1.0042098822979911987286742428332839944638e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-4.2778915091377878866136806353977213549015e-01), SC_(-8.7258006988114183419885544560681963108668e-02), SC_(9.9582103180225416496312265685974272175967e-01), SC_(1.0041789682714884904156848013270487836019e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-4.1195287410324549826075884035694231267906e-01), SC_(-8.4028228421972861557488159088253002540585e-02), SC_(9.9640629758269020206684416436192243015030e-01), SC_(1.0035937024576381939222914579343631180250e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-4.0964281438840631589110327986510768676159e-01), SC_(-8.3557084792427060415730284706941514262965e-02), SC_(9.9648622803870082061319386429566362657602e-01), SC_(1.0035137719981576060595541585432324623537e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-2.2592668168652580345705696602577773928041e+00), SC_(1.5020589267477120291917747892444905740677e-02), SC_(8.2021655213919030939145947814731444461455e-02), SC_(2.2592677969475654828487628626293666968905e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-1.9810308515502356136765909888890684209707e+00), SC_(2.5672649327786719349327802931908787217757e-02), SC_(1.8166690639963481668066105651105660356374e-01), SC_(1.9810658609625683105924428402327126337117e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.9181290215950843071238736986674140668991e+00), SC_(2.8271142190309515887003780582758427318824e-02), SC_(2.1325679470794883475071813449868884992729e-01), SC_(1.9182022633999159680593956839865239078491e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.6265772081273363484552124864796029580954e+00), SC_(3.8876440423327696736729835626471929947056e-02), SC_(4.0661623301895801527949353390086748314045e-01), SC_(1.6281627713199839008541794035022291434658e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-1.5001166574314822955518497623439862184446e+00), SC_(4.1608603812502466030404718477773474164703e-02), SC_(5.1019866490374361926474218278643498582144e-01), SC_(1.5051093570457485127386358140947726080534e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-1.3293133153685046412867915086260975312438e+00), SC_(4.2435965480632057059100031562718194703226e-02), SC_(6.5511467277171071747732773165257521046120e-01), SC_(1.3484969096438493085395633939059536249709e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-1.2572426507574213753362014096706882939467e+00), SC_(4.1753079265518347015779639598688700807897e-02), SC_(7.1312772975465029223166604545035824004296e-01), SC_(1.2885856836848751371229670030495664146682e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-8.4745718458805868437013378953137540023717e-01), SC_(3.0507710740106173572196053235356219304502e-02), SC_(9.3579387913065935422150231831893213202189e-01), SC_(1.0642103699139461666736573916720543424477e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-8.4700228474529759816606791920767887685665e-01), SC_(3.0491871680771982680993083882367768494531e-02), SC_(9.3593049167437877676161454162113134100522e-01), SC_(1.0640737213188469764379791735274353782896e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-7.4047651912623588598836946240183688515419e-01), SC_(2.6729247794083719497463578994988758836330e-02), SC_(9.6247332586576277619028161954457723344126e-01), SC_(1.0375271699266326081095165167054609530303e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-5.5586222008704358399258051366502245184471e-01), SC_(2.0090651873472709503838011262115569472109e-02), SC_(9.8806792487951787754236569532843244462391e-01), SC_(1.0119320801879658863489328895138662498920e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-5.3842543378871195768270810980037822112912e-01), SC_(1.9461055341686516341363789716745884385702e-02), SC_(9.8949578610565693012872346650917179562939e-01), SC_(1.0105042169379079179069992579998956256349e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-4.8176020875092134293561169067601504931636e-01), SC_(1.7414060677318433708726133537238406200412e-02), SC_(9.9326692779056065485727303485201566103553e-01), SC_(1.0067330727232241267931977705386793932787e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-4.7605452653943267066647842743421674927971e-01), SC_(1.7207889971614284124080093728207897826797e-02), SC_(9.9358024942941566692307934997987452263368e-01), SC_(1.0064197509952046373566593959042979110897e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-4.4417006193993529854087906872758671554910e-01), SC_(1.6055648191358300339861459139495160546773e-02), SC_(9.9513485132157183187768914251156145417561e-01), SC_(1.0048651488184876687974405732460623257256e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-4.3904937363718251842464066719556237636610e-01), SC_(1.5870581351399763192026077639956988657246e-02), SC_(9.9535534623844252795290327337285409703257e-01), SC_(1.0046446538779008000018724965319505741112e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-4.3711808066176438543459584213044591231262e-01), SC_(1.5800781587253593264497209148101264901618e-02), SC_(9.9543652889504460209732201823832662499605e-01), SC_(1.0045634712133753777346788260340179184631e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-4.3631336632980643547461957135631035275720e-01), SC_(1.5771697891939254689372924050336191052883e-02), SC_(9.9547003939438429558098728277122702169589e-01), SC_(1.0045299607108859903626632291649334474662e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-4.2016144534458532871359183330870049714536e-01), SC_(1.5187925486476839532172878678281079187799e-02), SC_(9.9610446176544899025697158353255669347906e-01), SC_(1.0038955382921212417290755982191162012875e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-4.1780534455633604439597112587796617306519e-01), SC_(1.5102767658361882317565599993926426972762e-02), SC_(9.9619110559672627281429658912056542795003e-01), SC_(1.0038088944558904534934509546258493659459e+00) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9508075714111328125000000000000000000000e-01), SC_(2.1493217083772344464824081688872635038751e-01), SC_(1.7997488131824039493983732655153598081215e+00), SC_(1.7997658913186768776568572254420267968007e+00), SC_(2.2432542220698775316388173913834673761107e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(2.5397360324859619140625000000000000000000e-01), SC_(3.1339020834199407988928676406849848934771e-01), SC_(1.6634338426931306502355954843602296276127e+00), SC_(1.6637053670248903099929166880251265732025e+00), SC_(3.4788098492459454305839468451303034312159e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(2.7095401287078857421875000000000000000000e-01), SC_(3.3567406838638032147531305541305495790225e-01), SC_(1.6282522222042080800649916327146235474166e+00), SC_(1.6287323558813846453145854931605684726137e+00), SC_(3.8063196799675675784239032106585396466453e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(3.7676393985748291015625000000000000000000e-01), SC_(4.2031565062497376641760904635487003078673e-01), SC_(1.4440367038225191749567757537540972131844e+00), SC_(1.4491978790827680585572754548968653793626e+00), SC_(5.5328089752527200302721538991718582300475e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(4.4206809997558593750000000000000000000000e-01), SC_(4.3874818036528167738844190821967943423297e-01), SC_(1.3528687976172046838480445633523505711178e+00), SC_(1.3654351699768325516001718660929687750917e+00), SC_(6.3565587678381974028212593654796399320926e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(5.5699634552001953125000000000000000000000e-01), SC_(4.3788322639685367307759592961564604275138e-01), SC_(1.2183830458220910616873203527480408370267e+00), SC_(1.2544375276401233502368425959098387317296e+00), SC_(7.4581988044849217096842000606642256574102e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(6.1633396148681640625000000000000000000000e-01), SC_(4.2837776613634241833985412721443549341582e-01), SC_(1.1579172967004989996559667549140278027490e+00), SC_(1.2111195513288654073989716455243648257619e+00), SC_(7.8900256868176109349489406901655657552116e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.0937628746032714843750000000000000000000e+00), SC_(3.0953221441489916975565708853613144101162e-01), SC_(7.8863016079024901737533241856815122427020e-01), SC_(1.0470989880175553523932365224971984204145e+00), SC_(9.5290131482433968605833571081616599499535e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.0944409370422363281250000000000000000000e+00), SC_(3.0937078238698384062307151111640319064842e-01), SC_(7.8820868090095740233670648824234253925482e-01), SC_(1.0469987637657555871084750502602676292151e+00), SC_(9.5300153650665167674691054692696181475664e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.2647185325622558593750000000000000000000e+00), SC_(2.7109711674680596478792059459611331789834e-01), SC_(6.8932530906913217496719900044317327155679e-01), SC_(1.0275272356744505122110434516986890390286e+00), SC_(9.7247279966213041441539050090206730421522e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.6294469833374023437500000000000000000000e+00), SC_(2.0373172949707335136180735380180788442679e-01), SC_(5.1755142586724278667968480951539349010550e-01), SC_(1.0087525672732968526423022020115251004218e+00), SC_(9.9124743308787760623238691330302432891108e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.6700167655944824218750000000000000000000e+00), SC_(1.9734638365181118244464524275125896278599e-01), SC_(5.0131855229212305794268081255551002856740e-01), SC_(1.0077051838032199081446555511237158936808e+00), SC_(9.9229481641370390222296016032585981719323e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.8115835189819335937500000000000000000000e+00), SC_(1.7658713746446325333572603324649231389129e-01), SC_(4.4856244221855779107445766441750956188061e-01), SC_(1.0049389276895338010971303345840869531819e+00), SC_(9.9506107234708515007009823525158455818016e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+00), SC_(1.7449636907173677866471652982164545954188e-01), SC_(4.4325017867244305649595902271002777186279e-01), SC_(1.0047090960396510403215179456063141463159e+00), SC_(9.9529090399061289652979116753430681934581e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9150133132934570312500000000000000000000e+00), SC_(1.6281169574726727803021206126266321004532e-01), SC_(4.1356380355829619894501711758115446394413e-01), SC_(1.0035687448682812995871281878583384196792e+00), SC_(9.9643125514170115259694243812197071871396e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9297766685485839843750000000000000000000e+00), SC_(1.6093498734728641152764622295452194400508e-01), SC_(4.0879607909117336665711122703000094587054e-01), SC_(1.0034070046648304591411170253207305458489e+00), SC_(9.9659299534346167172216559775269693088309e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9353895187377929687500000000000000000000e+00), SC_(1.6022716966577894228264983895269820185687e-01), SC_(4.0699790512807298499033583469243195483889e-01), SC_(1.0033474545422693240235190067680360125564e+00), SC_(9.9665254546545808653594925888906522663444e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9377355575561523437500000000000000000000e+00), SC_(1.5993224115056703945029522734566711111712e-01), SC_(4.0624865719400231699403779928111582232786e-01), SC_(1.0033228734996878339834533133294717029390e+00), SC_(9.9667712650781508863707929855905002364587e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9857625961303710937500000000000000000000e+00), SC_(1.5401241157716743181487580104811110219529e-01), SC_(3.9120998352793238445943068675043085135589e-01), SC_(1.0028575040344693622778085992301763812745e+00), SC_(9.9714249596963383732847571077512244610467e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.9929223060607910156250000000000000000000e+00), SC_(1.5314885915169828351696381687634128973863e-01), SC_(3.8901626588497438429546159762838314597700e-01), SC_(1.0027939479638348715778328009784465260477e+00), SC_(9.9720605203991527712266651542530509757340e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9508075714111328125000000000000000000000e-01), SC_(2.1734699361453139274813959153205806265726e-01), SC_(1.7937614326063671366860228194886205494638e+00), SC_(1.7937789335264292533795790135518657860777e+00), SC_(2.2657971303248482700332355227054935984629e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(2.5397360324859619140625000000000000000000e-01), SC_(3.1631327616449302201957142568064544029357e-01), SC_(1.6591788032210488259576046642380910529228e+00), SC_(1.6594554498643515208825777005948910742964e+00), SC_(3.5035038267043681938088157981640204363681e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(2.7095401287078857421875000000000000000000e-01), SC_(3.3868822624306009769272857749569629711441e-01), SC_(1.6243457452704761739406958703914317129477e+00), SC_(1.6248343407602308401090069962068865934742e+00), SC_(3.8309160747329433206537130863763292878729e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(3.7676393985748291015625000000000000000000e-01), SC_(4.2357878439574800675600220769654638753578e-01), SC_(1.4415113831867745744353806150480349246263e+00), SC_(1.4467356745382624342729167145642663100352e+00), SC_(5.5536255357822811239209410423100059875318e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(4.4206809997558593750000000000000000000000e-01), SC_(4.4200664834011768109071572858398029452987e-01), SC_(1.3508084368327528722974809809098035673584e+00), SC_(1.3635012834078968758153465182202709727390e+00), SC_(6.3742226438802639740689096940899800242673e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(5.5699634552001953125000000000000000000000e-01), SC_(4.4100523185620562331014493540259565593407e-01), SC_(1.2168079296066882483698174230283088718532e+00), SC_(1.2531283983346588145032655616282876912509e+00), SC_(7.4708949215056624977547642458591859916519e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(6.1633396148681640625000000000000000000000e-01), SC_(4.3139800575441820172417200898227652090762e-01), SC_(1.1564994476216010097527651648179023850429e+00), SC_(1.2100400931493429467995973332906834032525e+00), SC_(7.9006327884864292975191081736033410143598e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.0937628746032714843750000000000000000000e+00), SC_(3.1166632912799502441430672429485202073288e-01), SC_(7.8777897907914652092351580136054274183670e-01), SC_(1.0468601699273382367644810858048253690703e+00), SC_(9.5314008642190059751847001603416133523411e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.0944409370422363281250000000000000000000e+00), SC_(3.1150377385264279536494176289397305201358e-01), SC_(7.8735797980456404500099269405995582160061e-01), SC_(1.0467604540111803509936223622252568916418e+00), SC_(9.5323980016304159823088852548452617748872e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.2647185325622558593750000000000000000000e+00), SC_(2.7296484896227018483900282086832263678463e-01), SC_(6.8858479129824510988677999686001047813825e-01), SC_(1.0273876677794653586005843882581830983661e+00), SC_(9.7261236213220066896992963805518417124717e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.6294469833374023437500000000000000000000e+00), SC_(2.0513486112184390018267853340691999773508e-01), SC_(5.1699665865930631098350672081439158832125e-01), SC_(1.0087081910349581163221763919152484243227e+00), SC_(9.9129180927076840017302292875564204565046e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.6700167655944824218750000000000000000000e+00), SC_(1.9870552655166132162535193762583441689415e-01), SC_(5.0078121513133031122788474522863560503222e-01), SC_(1.0076661178930037365201332581470045632998e+00), SC_(9.9233388229061766654138863835162761216710e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.8115835189819335937500000000000000000000e+00), SC_(1.7780328795419204597756906520689370119851e-01), SC_(4.4808170587931513473527171007699654900447e-01), SC_(1.0049138869309962940829946299565615240892e+00), SC_(9.9508611310000087114553800548857983442859e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+00), SC_(1.7569811915021988385345920529224457759974e-01), SC_(4.4277513902974720064679305516370103791050e-01), SC_(1.0046852205463119294793204663957565960969e+00), SC_(9.9531477947930585096343119811240761882828e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9150133132934570312500000000000000000000e+00), SC_(1.6393296854798844616485695395265112566398e-01), SC_(4.1312059288046148298754918008060887027619e-01), SC_(1.0035506510474955821637378323400890484367e+00), SC_(9.9644934896095435181505072707323331512557e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9297766685485839843750000000000000000000e+00), SC_(1.6204333475455383948696729951687176573273e-01), SC_(4.0835797951493277313703238215103444140812e-01), SC_(1.0033897308798531309151815758183184505519e+00), SC_(9.9661026912716598192865685708194451356807e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9353895187377929687500000000000000000000e+00), SC_(1.6133064215993997642321391023543754597302e-01), SC_(4.0656173318990631512045475240199200917264e-01), SC_(1.0033304826811869851603347583545508656486e+00), SC_(9.9666951732535410392784498414476001191989e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9377355575561523437500000000000000000000e+00), SC_(1.6103368240268458915323667123386531518665e-01), SC_(4.0581328844119438696365069369209417247598e-01), SC_(1.0033060262664611875477921930615060502446e+00), SC_(9.9669397373988987726297928298000535126698e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9857625961303710937500000000000000000000e+00), SC_(1.5507308186515370204169718159860320193530e-01), SC_(3.9079073532255761878561323571460291750516e-01), SC_(1.0028430162616606880094374865382859058922e+00), SC_(9.9715698374181258340078981908124372361642e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.9929223060607910156250000000000000000000e+00), SC_(1.5420358203617030189209425237224000222430e-01), SC_(3.8859936910575598467432427933384898373952e-01), SC_(1.0027797824253805088367892403969030288904e+00), SC_(9.9722021757779391247227803253561151383232e-01) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(1.4763099703183838076395508825488977879671e+00), SC_(3.6147386353922083088666582616470579414212e-01), SC_(3.6529404008840420387764181273079195447209e-01), SC_(1.4763669388293150536160077439525254944022e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(1.4284259066781334661878643222478465392555e+00), SC_(4.7812299863505651293382744713794370295712e-01), SC_(4.9540427299417228575304687310272641892818e-01), SC_(1.4291094752443810860307424129926971367525e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(1.4114718127785286367640644555932597202534e+00), SC_(5.0288714967875321395537988498706406279407e-01), SC_(5.2640986810196713368241274513324413960768e-01), SC_(1.4126112854841976598695666662162624027942e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(1.3008510640627298586064703843805238937239e+00), SC_(5.9006842393192870228056057865106406167397e-01), SC_(6.7351895547484199735846029902895138571833e-01), SC_(1.3103485593136455769113664254096276551774e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(1.2349405348055671968827279700473958766205e+00), SC_(6.0467355656345899629070715261550835607994e-01), SC_(7.3706416083772902599001841418956378423101e-01), SC_(1.2558351070486145329293309177269009374061e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(1.1271356194560256317564501342021149478992e+00), SC_(5.9360679990059718427138536606484578299869e-01), SC_(8.1838168347178569316347774498203292143842e-01), SC_(1.1799430590131281155175579922553943408586e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(1.0754255069601692828342872685178553163676e+00), SC_(5.7814431976551250805949234363895258794661e-01), SC_(8.4956721372625740979299812128508674398649e-01), SC_(1.1496380075839141611138834133105378917448e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(7.3856910744714572417947693132628214749538e-01), SC_(4.1409651042107809161648793759350126863720e-01), SC_(9.6651780274558866652562422939447439452125e-01), SC_(1.0334802263056451945481188227790362369415e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(7.3817575732221985567953809470918646548279e-01), SC_(4.1387976955702385905590514959782058036014e-01), SC_(9.6658905673904436537927987275657880906334e-01), SC_(1.0334089890348716672163273480540146414453e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(6.4575425003870907100008224944579493333349e-01), SC_(3.6257252025716444998414894926821955609977e-01), SC_(9.8043157542313692264788335472896157357423e-01), SC_(1.0195681946001269720001240908917264657256e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(4.8490314894534139822599215519053667038048e-01), SC_(2.7243955084022223376536843729521394736445e-01), SC_(9.9377804996936277795268996861707049247649e-01), SC_(1.0062219476800497843693788454790746840130e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(4.6969588035747264686873328413687413426089e-01), SC_(2.6389987019656677083658508919326657750655e-01), SC_(9.9452260524936885628051416223523634271025e-01), SC_(1.0054773933388525113875177337078133757380e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(4.2027047740495122167454359512209626071342e-01), SC_(2.3613810241473256043873698961238854438878e-01), SC_(9.9648905788575307952742586271371205899332e-01), SC_(1.0035109418759242913951578107768468460031e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(4.1529345368257377136364788152019822222352e-01), SC_(2.3334215621511885969697007657108072476988e-01), SC_(9.9665243863073836912054138109401422840197e-01), SC_(1.0033475611722985621203606192651905280610e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(3.8748018368581163381202143345051081883695e-01), SC_(2.1771662918039338724780981041082069426929e-01), SC_(9.9746308162322202873684645578370337333034e-01), SC_(1.0025369183118104019222711531184661963909e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(3.8301324672736512809189860560352516579194e-01), SC_(2.1520699105825745873369158898178228920377e-01), SC_(9.9757805809880331997740249144282022217471e-01), SC_(1.0024219418472300216394359179638328511061e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(3.8132851418348187241393722534349396393781e-01), SC_(2.1426045943942070461895268638152086675201e-01), SC_(9.9762039057421396421185396130895108363129e-01), SC_(1.0023796093754946773032207414620825022368e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(3.8062653370916760700415715971053517275234e-01), SC_(2.1386606547033460350469402467025446159845e-01), SC_(9.9763786453286271877881773837980021629945e-01), SC_(1.0023621354183069300589132942913563840423e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(3.6653655826456302151318777880015642261120e-01), SC_(2.0594977936327602164400435493273338676432e-01), SC_(9.9796868234516979320852790585531168675875e-01), SC_(1.0020313176281258559941659143433130616586e+00) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(3.6448122320522164776511603296929693657598e-01), SC_(2.0479499795136594748473331448182239561222e-01), SC_(9.9801386253353086428271329052297588371990e-01), SC_(1.0019861374420625028333254206183507334831e+00) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(5.2320361329218878797580112369427988023860e-01), SC_(-1.1998200090128389050404854109336282550117e+00), SC_(1.1999657993272586089706604254087608824966e+00), SC_(5.2495332286646265775962917518480275526299e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(6.4012629323003780329121469371792178192283e-01), SC_(-1.2177193931839142552449466040168063463296e+00), SC_(1.2191258931509307273112464094628599318786e+00), SC_(6.4961255070316317777174581536969668339057e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(6.6319520704068574044775228801013113830503e-01), SC_(-1.2151168032911263236865471799516112880572e+00), SC_(1.2173573124568634324871321053271030226087e+00), SC_(6.7660218532309928963859066924852626637369e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(7.3584183740895082480040707359518603380263e-01), SC_(-1.1649997995267473054665246331423324743622e+00), SC_(1.1804027694196674966906572978601494041105e+00), SC_(7.9154167363814454443607775532635998306495e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(7.4162054599795761188213584694623492275498e-01), SC_(-1.1207805428644532063626712928693315606437e+00), SC_(1.1522183817283594575925765359267065521255e+00), SC_(8.3543291998734372564979375916629978608247e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(7.1705198473994140001456502359696558030288e-01), SC_(-1.0365494692332315835743401826366349500424e+00), SC_(1.1089373837022789377551888428635921463848e+00), SC_(8.8814921931756981220944946789148567691311e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(6.9546805570358185566230478317424671605653e-01), SC_(-9.9280461139813219533594000851272380756908e-01), SC_(1.0909283605091772197087934258174790345450e+00), SC_(9.0768946044282371380340823043784074434375e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(4.9399738274139993847290769282879546391410e-01), SC_(-6.8732986631658579444895209005080518722591e-01), SC_(1.0204436654941834800134697899239008694579e+00), SC_(9.7955290687983150596584764262461938346689e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(4.9373793712407659381139054779796292092672e-01), SC_(-6.8696503125250358503482860858474439850850e-01), SC_(1.0204001737253642213367814929966517650835e+00), SC_(9.7959642773063449500946753674719518879470e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(4.3241193670868246950455030146447110431484e-01), SC_(-6.0112025180077171357598181789415859258516e-01), SC_(1.0119492334751084860974504956317902050989e+00), SC_(9.8805036657830225392909314581683633408748e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(3.2487549165973582409799729700561776105071e-01), SC_(-4.5144520956876945533824260867311926881306e-01), SC_(1.0037994453958298289776121886857276190847e+00), SC_(9.9620055051632439854405199545823036201265e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(3.1469116815394004568305415385708533941042e-01), SC_(-4.3728865647425102571411893196797085151151e-01), SC_(1.0033447820973186190125029469485466890041e+00), SC_(9.9665521544749370264501542252555648521862e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(2.8158438868269873799678517433671817006527e-01), SC_(-3.9127600645686547687272839096955709226021e-01), SC_(1.0021439646315181979989922005294717263816e+00), SC_(9.9785603495402108629053623205615146518231e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(2.7825022806440573212642034558541905125110e-01), SC_(-3.8664250989904246992309614415547576896027e-01), SC_(1.0020441958508136958663653054775908561509e+00), SC_(9.9795580380665292926091581275525400768730e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(2.5961701277975487769898833774401234680286e-01), SC_(-3.6074871138009218217662237841127152503170e-01), SC_(1.0015491749901357189732935928707241651489e+00), SC_(9.9845082489688086274524290344241098410124e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(2.5662433059984771382037581440906909251525e-01), SC_(-3.5659001544772521335610921480540030963531e-01), SC_(1.0014789643526779760201202658833668886294e+00), SC_(9.9852103555347000520778908787495158622068e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(2.5549561621495342482078978658415102308377e-01), SC_(-3.5502153586285965047506419408328717928461e-01), SC_(1.0014531139331083876608267409053997966573e+00), SC_(9.9854688597943121249211059166287403829853e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(2.5502531187071528411389275121342814957528e-01), SC_(-3.5436799439957684961005138500677432350605e-01), SC_(1.0014424434216152783450867550845151578926e+00), SC_(9.9855755649346512182734718579076020941065e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(2.4558537616432771075205244097726672800071e-01), SC_(-3.4125023924321062472685773649864914924389e-01), SC_(1.0012404287864137155335017658967748748040e+00), SC_(9.9875957116714543918512236576105188437407e-01) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(2.4420833732787343352275676909311677779310e-01), SC_(-3.3933671898320244805833270690824024991690e-01), SC_(1.0012128394027349320651137124131629071277e+00), SC_(9.9878716055482012440464604789037635467121e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(3.0136316339429490716732943390558885430973e-01), SC_(-1.5993587641847940032326724763138915877065e+00), SC_(1.5993955794993634193249339741703303991854e+00), SC_(3.0672168410442765631656313600306542690723e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(4.1325951352714001055511825971552874309226e-01), SC_(-1.5191308887158827072488329992462763587413e+00), SC_(1.5196198694817007596871741588568885065654e+00), SC_(4.3567039639868387889820668683424599637582e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(4.3764314133433789761211730452409603575867e-01), SC_(-1.4953972528201973947665056071848853409115e+00), SC_(1.4962298334158886411541193442497334804748e+00), SC_(4.6765524321397443421806673431368587130029e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(5.2636464370965676750773245393762837513302e-01), SC_(-1.3570518075007858863418487261035419790317e+00), SC_(1.3646507970832195068975431622020727013616e+00), SC_(6.2579532897676821875434144239377233440711e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(5.4325417624625818278833353812498366716490e-01), SC_(-1.2815031390881155642247001965728965605785e+00), SC_(1.2988317872253149027625251597508852713277e+00), SC_(6.9696306894807546111772845217473342340337e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(5.3674737575852462936163592173805416308793e-01), SC_(-1.1634343601210243896143252665957553405485e+00), SC_(1.2092413380661383099798431432840783293709e+00), SC_(7.8976655324266987266910353889869288323701e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(5.2367636974452327687678674716735164180950e-01), SC_(-1.1083282093555269634725691811758740729531e+00), SC_(1.1738320667067413800842562717631722620123e+00), SC_(8.2569725530038331750499838864511222713112e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(3.7637948294216478069287177567089693109074e-01), SC_(-7.5866796703385250569050971184434645618512e-01), SC_(1.0388434984184894573241186094650806249586e+00), SC_(9.6115533436072186558530320548627240147526e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(3.7618276070241902066799091044658813521658e-01), SC_(-7.5826335625147473217641205207272350406416e-01), SC_(1.0387608459324443411402711935624580849147e+00), SC_(9.6123799675015087909783038270436280833268e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(3.2958600454037044984444919933171632943021e-01), SC_(-6.6325194284575895108887631663732264106447e-01), SC_(1.0227026055038471681593889668240805541042e+00), SC_(9.7729725830102087002329179698533275143472e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(2.4766638795021577765057373741719986353761e-01), SC_(-4.9801594039957362488411020190045487558749e-01), SC_(1.0072185520046447358382667558862310837549e+00), SC_(9.9278144660330765237337873865123637862168e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(2.3990354966178542483894355197385430905767e-01), SC_(-4.8239678851600051698453556803619920905380e-01), SC_(1.0063547380238167844073590643699305307167e+00), SC_(9.9364526114011005276957870511399144909705e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(2.1466673378996675533424496940497456791492e-01), SC_(-4.3163371296974279227758409721952128740675e-01), SC_(1.0040733088571877862602665694662678114386e+00), SC_(9.9592669100167453839757698466981293854587e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(2.1212505166116023229104405375400180264363e-01), SC_(-4.2652204732807696432591547133979368963572e-01), SC_(1.0038837585539157300539520738345269242058e+00), SC_(9.9611624132944024935710813750516477085812e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(1.9792045246800390193681098664564028742204e-01), SC_(-3.9795647723150731623153522444513186541800e-01), SC_(1.0029432705204832153358684083476284891695e+00), SC_(9.9705672944104216836395670438951437455731e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(1.9563902373739438544653449829474388654872e-01), SC_(-3.9336873325612307159218106586870555970120e-01), SC_(1.0028098776386637277460912037642170485842e+00), SC_(9.9719012232937653456693690325095437831259e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(1.9477856279755063370813370984043528388472e-01), SC_(-3.9163843852762037505640341850843887009401e-01), SC_(1.0027607645405381039851566382784350695452e+00), SC_(9.9723923542967871741430985049790912041058e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(1.9442003206741085297400876891153681118701e-01), SC_(-3.9091747372015614473179144591493916702618e-01), SC_(1.0027404916828912380319419391679843937999e+00), SC_(9.9725950828819081038342239622816213791166e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(1.8722358585429549691930986176087774331966e-01), SC_(-3.7644646556142444107357930397578803814135e-01), SC_(1.0023566849774110497918196854038614392752e+00), SC_(9.9764331500677429589841712464522081268121e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(1.8617380932248371298543156563508211207284e-01), SC_(-3.7433555073939891070591278048235404349651e-01), SC_(1.0023042680312472904956588457142962065539e+00), SC_(9.9769573195429879280534083095472818194827e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-4.4694040187817584048110831842840376776419e-02), SC_(-2.2239154715776719951111951535093166961794e+00), SC_(2.2239169457976082488710447766009580548119e+00), SC_(9.1091215006293634899458922029146754779591e-02) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-7.5372065455868998777353826110329269735343e-02), SC_(-1.9571724580362299319372464634240851846347e+00), SC_(1.9572176522016711515559451753340729010328e+00), SC_(1.9300396598146614969758817153117415250497e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-8.2815456702105001627531655467072717597148e-02), SC_(-1.8964627698006763685070463454748352308031e+00), SC_(1.8965546402415569038902044510397662807032e+00), SC_(2.2479858195250271450596978705671523829589e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.1305169476214728430296524833327769138859e-01), SC_(-1.6132407284524018490818770183167421472306e+00), SC_(1.6150298075166020595774014413083891551841e+00), SC_(4.1707585449860537704427343712887359660262e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-1.2076905423693873487800461665057503844349e-01), SC_(-1.4894656936870447841073744677038066518398e+00), SC_(1.4949179356551978375263935847292832199727e+00), SC_(5.1921341342231457463003839277087016507019e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-1.2297284061554984661180647500042879271082e-01), SC_(-1.3213938425430458046806125996118913417774e+00), SC_(1.3416661659006298226589683984419887481690e+00), SC_(6.6166780714260163106611289180845877999790e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-1.2094315250605287226844839018463791749112e-01), SC_(-1.2501858106294037207384819333409166699296e+00), SC_(1.2829660258190207085439171515098390254840e+00), SC_(7.1861568368194279026557058594133916143484e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-8.8297766764935175184819830019117122724978e-02), SC_(-8.4332958619623773418668343153799161303122e-01), SC_(1.0629708471985665651183769636290657034786e+00), SC_(9.3703307523723769726025507902598955332291e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-8.8251909079630898977314861298094637644437e-02), SC_(-8.4287704463711580045341642112085455762044e-01), SC_(1.0628368372575222463844647371128298049246e+00), SC_(9.3716705189804235691111410172290142720801e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-7.7359807853242760765397508619250988537355e-02), SC_(-7.3688930598500539330543473665064507437850e-01), SC_(1.0368027992919815695133217997074703825824e+00), SC_(9.6319765839063268442260276252656456288710e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-5.8145665777724158033322823548014901860264e-02), SC_(-5.5317613797160620270089759521676243828555e-01), SC_(1.0117017648266266068045093562918434182443e+00), SC_(9.8829823985133787659464346107883416215073e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-5.6323491933537409053442318952370340236469e-02), SC_(-5.3582377720422836604237830639037655586367e-01), SC_(1.0103014625149814811735862135290024346406e+00), SC_(9.8969854029463546589684549405068152488715e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-5.0399121314678153756868495532817623631181e-02), SC_(-4.7943265849688655067740137375746379444049e-01), SC_(1.0066031096952226673677282326095988967804e+00), SC_(9.9339689077906932302757585415411602385851e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-4.9802427804370709846004331252740168428070e-02), SC_(-4.7375456130172714787314212523943728615708e-01), SC_(1.0062958357636301543522481589525556585467e+00), SC_(9.9370416462835111187393960765224869360107e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-4.6467645102059728830697211614754515012138e-02), SC_(-4.4202421535284787005504134312601056919195e-01), SC_(1.0047712408134330130371803989199936542085e+00), SC_(9.9522875931586061674995410536626324942684e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-4.5932030774903015812646644859303433300027e-02), SC_(-4.3692827466390666030653688386955826309843e-01), SC_(1.0045550019075944690223755299567858781874e+00), SC_(9.9544499819980596508083582236569519332853e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-4.5730018630937341725154019094542257162956e-02), SC_(-4.3500631513773503870398955110764976371458e-01), SC_(1.0044753862460811375437195353941344696663e+00), SC_(9.9552461385400498775557247437478740384463e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-4.5645845576081025863691702942095641781515e-02), SC_(-4.3420548974951924423894360051880481384606e-01), SC_(1.0044425225695904042368489110732595888447e+00), SC_(9.9555747752758813283329642307653347847363e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-4.3956311506079114062944158795441267084616e-02), SC_(-4.1813162205057442687736831975736691447280e-01), SC_(1.0038203458908950376720901448149818731051e+00), SC_(9.9617965416224997730571325055612369481836e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-4.3709850703294913786001556709944364721086e-02), SC_(-4.1578690640187912694906424822027119474846e-01), SC_(1.0037353744701357254469359428649658429626e+00), SC_(9.9626462557843654204689568140479755152437e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-7.3665406711478221058239036311645067556514e-02), SC_(-2.1652252625348965809298173153725345418624e+00), SC_(2.1652277371163144512479256679066730885444e+00), SC_(1.0676381447635026691303136947182376322149e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-1.2155658691514111625790336142632145347741e-01), SC_(-1.9173663988825023823339269815738577628148e+00), SC_(1.9174307118043255358846788904075618586780e+00), SC_(2.1230827281161287763587785724920307827592e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.3307154113108477633403521400754169699575e-01), SC_(-1.8602764573391861722438995830398713096148e+00), SC_(1.8604028313360619125196344418754188077563e+00), SC_(2.4440539905933438496000546466176726274451e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.7947212323191277828632880465846615727448e-01), SC_(-1.5908625952246787192757334626296281244028e+00), SC_(1.5930113520416764406105874501879250910655e+00), SC_(4.3471752560558948714582827039030643281368e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-1.9112253554019061171601951175356104170542e-01), SC_(-1.4715574192428039275408057430980960806175e+00), SC_(1.4778109189099176982994297931200204961896e+00), SC_(5.3439398600497100672128205014687949718901e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-1.9408802823990883824716098470131325642858e-01), SC_(-1.3080426411734662543063261417343794888950e+00), SC_(1.3301889670126252845964910915333185697442e+00), SC_(6.7269050505604091127409249318628286897937e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-1.9075024227670960177171915878223208809998e-01), SC_(-1.2382771471135440468010593838464698911081e+00), SC_(1.2735215989064908232474293753628226845952e+00), SC_(7.2784448542323052665807909745362729975722e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-1.3907251991348937919265598917918684953335e-01), SC_(-8.3634617934588048859973644698809341874040e-01), SC_(1.0608870676735214897074045005957169812195e+00), SC_(9.3911632003963535741127258718262246567884e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-1.3900025235122940275980244361110535400209e-01), SC_(-8.3589762304569448570678817250329075177634e-01), SC_(1.0607574935662983044669594873334656031575e+00), SC_(9.3924586540351859210722975028284071358366e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-1.2183939450297045551408794442726641615539e-01), SC_(-7.3081953318955965973994663423939100531005e-01), SC_(1.0355850460093881393882796013286052766365e+00), SC_(9.6441534928004203646574643200326753332274e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-9.1575804765898985381715580790667446972864e-02), SC_(-5.4863090790322617104298610885157177198074e-01), SC_(1.0113145770246142173076111200251232967419e+00), SC_(9.8868542701563082901125802193138221064471e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-8.8705948132539850261878693017174861160416e-02), SC_(-5.3142140156216440084027032967584950715010e-01), SC_(1.0099606079603577023335679512587996628074e+00), SC_(9.9003939446624065956901695384947967903404e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-7.9375354044854721368307991769031090684810e-02), SC_(-4.7549410006781716920972964195399549127212e-01), SC_(1.0063846262220657967463237833798500230265e+00), SC_(9.9361537418756875082316386945535499044639e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-7.8435595127945514107166019348726563612523e-02), SC_(-4.6986268016571255910376457486174494808165e-01), SC_(1.0060875193631732197803581893462330425264e+00), SC_(9.9391248097537154145933972100246450735372e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-7.3183507677647206760704553380248069058709e-02), SC_(-4.3839312327367294368055752045968142173872e-01), SC_(1.0046133701676977837433466081725803141463e+00), SC_(9.9538662994397000448416898153659359630492e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-7.2339947609115074215411768609701790445627e-02), SC_(-4.3333905894078957938962551496327880166840e-01), SC_(1.0044042861678850371755915955730526465927e+00), SC_(9.9559571392487412621649410739469558756723e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-7.2021790804523389648873739591085576656440e-02), SC_(-4.3143289289837834440848401756346730781258e-01), SC_(1.0043273048268043275312211531445690098033e+00), SC_(9.9567269525963764383917384313155772618033e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-7.1889223387619906165282614188831190260673e-02), SC_(-4.3063864814069849389470483812759228628913e-01), SC_(1.0042955285425724334304169482060263275007e+00), SC_(9.9570447154135832414576623103259058732942e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-6.9228311634891677997758437548354003492498e-02), SC_(-4.1469685753062988841301841676194285616541e-01), SC_(1.0036939384250170615831723375609352686734e+00), SC_(9.9630606162088300547860042116783526127213e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-6.8840151265291939907107345214871614585396e-02), SC_(-4.1237140715163690039341129394366349327161e-01), SC_(1.0036117785357121337363149416144394264318e+00), SC_(9.9638822150623856166268719623772905313734e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-3.6983584903098621595735081339227508258591e-01), SC_(-1.4601658411887726617857431247906022159048e+00), SC_(1.4602260936495611957418310878759834997162e+00), SC_(3.7348969756257398089525127340787517934286e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-4.8690934072764523532878999567662013365203e-01), SC_(-1.4163958565742827737285660834944306904727e+00), SC_(1.4171094744045463898025073998670298554393e+00), SC_(5.0360970311567810303570919573460972060835e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-5.1167320515433461570913062506462715628774e-01), SC_(-1.4003152238915775885976290724037383381203e+00), SC_(1.4015015616154246307978768752153433499715e+00), SC_(5.3445396840579342972121950450993801222232e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-5.9843150288316598867382183508090649891778e-01), SC_(-1.2933014432069542222833128353895534767225e+00), SC_(1.3030757523832012434806211126261519008366e+00), SC_(6.7998063334078563231898050050944915320652e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-6.1266327969036388255789859130557428284641e-01), SC_(-1.2286572170468492281317546037022147829039e+00), SC_(1.2500631676452046301511892396163762800503e+00), SC_(7.4247908014459492603544171446874138893711e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-6.0093494530949736804159280927064821157072e-01), SC_(-1.1222093788052333923122398152830362765569e+00), SC_(1.1760026755707905046858597014713058143493e+00), SC_(8.2223783606334722412763678164623472092655e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-5.8514514603426707501657174384989210286037e-01), SC_(-1.0709512134164155053987485427679257772905e+00), SC_(1.1463827401631408186096673593819896983403e+00), SC_(8.5278252019490080766250567310206020708663e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-4.1891673483164702277079205456311440921450e-01), SC_(-7.3582246183826704765792037168860096563888e-01), SC_(1.0327582052281002339148380861660331356430e+00), SC_(9.6723972472512015207479505075396335373809e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-4.1869742949068100597916385221215376297223e-01), SC_(-7.3543064718668749195044287022481346458166e-01), SC_(1.0326885046816798201295077050191643405190e+00), SC_(9.6730944283502824772482543184110545420663e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-3.6678735987280495923005070383083065877794e-01), SC_(-6.4336261468538630994130977871081515499295e-01), SC_(1.0191462279147434683690964731006488312642e+00), SC_(9.8085353054544071306549362960363339076717e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-2.7560464290276442580308169980067433730417e-01), SC_(-4.8311069393672027403010589027004670089718e-01), SC_(1.0060877807349109317545386844384162697568e+00), SC_(9.9391221679631563325736366247083872430536e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-2.6696570350229129554636308952267318553927e-01), SC_(-4.6795972385146218102752412884559878133543e-01), SC_(1.0053592816120379727298193292572094253126e+00), SC_(9.9464071690520008967211934036009329021531e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-2.3888132831144391615815835757000965554499e-01), SC_(-4.1871716750591161864186447892363877181250e-01), SC_(1.0034352337332188755359811518338577267374e+00), SC_(9.9656476601647578963925963873521954719344e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-2.3605289600794341669216010132421458133378e-01), SC_(-4.1375854835881154061633050884808208630890e-01), SC_(1.0032753760880429968349781172160988280545e+00), SC_(9.9672462370509076027105283961762082035474e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-2.2024582517943336330657655542466780531885e-01), SC_(-3.8604811309282995659669665442212999707444e-01), SC_(1.0024822135155348232709431983565810627320e+00), SC_(9.9751778641623108053948390625123483582968e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-2.1770703022638823217849835786239194735745e-01), SC_(-3.8159768979623871433634678690576780376431e-01), SC_(1.0023697163443460593040927153819984172693e+00), SC_(9.9763028359897387406412009554574324341464e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-2.1674950192631827142233672258636971262673e-01), SC_(-3.7991918536067733713342694880579158810382e-01), SC_(1.0023282967082615434821202988768483273472e+00), SC_(9.9767170323891848145679520327787834237717e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-2.1635052595001677258182642202402831034763e-01), SC_(-3.7921979994460850719857019234039905786591e-01), SC_(1.0023111995504985137966217630196544946788e+00), SC_(9.9768880039821597695653299444631909775663e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-2.0834227086928585714303799991409968995228e-01), SC_(-3.6518190976085580671637161852003160837730e-01), SC_(1.0019875153447833799649475088828166034755e+00), SC_(9.9801248462716959196443544952410323111144e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-2.0717407373398971379822043109628905609155e-01), SC_(-3.6313417219032570784132149578825222127836e-01), SC_(1.0019433094009598081915455722570991804466e+00), SC_(9.9805669057340640940342550527013089739442e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-4.5142466110842397513121878642152353143359e-01), SC_(-1.3138062439252177111994552928174625792128e+00), SC_(1.3139055639723193176228159167132237715324e+00), SC_(4.5385362288821773895012435633345828550863e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-5.7011438906828069193260952076127504489824e-01), SC_(-1.3058447819888320183468129786965911436045e+00), SC_(1.3068922123109877644976707339472752652197e+00), SC_(5.8231878634389896226716993733060051785314e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-5.9432957201080342574544868010859366167628e-01), SC_(-1.2974921926653296868145565400689751746840e+00), SC_(1.2991918981924174294412707672538063133352e+00), SC_(6.1130789900076506347868111362150355313368e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-6.7488300085030583037379552337948536540949e-01), SC_(-1.2227909657211594943621910376200227867351e+00), SC_(1.2354284239155424954894393387244730006710e+00), SC_(7.4089256096498160360744312591119983896227e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-6.8493864049091371202486197010712792495770e-01), SC_(-1.1696342430954640180342833996939350826142e+00), SC_(1.1962223741489782785025790618967579509554e+00), SC_(7.9335527256143636010957476257761724108902e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-6.6651245436634904904870149992254151786937e-01), SC_(-1.0755998107927164867529068670851459472798e+00), SC_(1.1391620445687826790386875607118357561967e+00), SC_(8.5837903619390905618828453376604205302632e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-6.4759295300125813488248465435108210086924e-01), SC_(-1.0285111504276504296948391455270616183572e+00), SC_(1.1159319335929287008854373333333429460138e+00), SC_(8.8290150150960761465500697380346707418541e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-4.6162310793905942785804970546623087876384e-01), SC_(-7.0960907907421124573695877256987284016295e-01), SC_(1.0259995574153868603823970505547553073846e+00), SC_(9.7399754965394588312728698677378128565368e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-4.6138101718389846456817713412281920350615e-01), SC_(-7.0923187869051252995227296134074930682617e-01), SC_(1.0259442414051481282062430704886537004876e+00), SC_(9.7405289020950051793354103616250443410594e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-4.0412137609759392532341635130609242750040e-01), SC_(-6.2053195892259902951757075454134036518602e-01), SC_(1.0151962851879643227722356312494427910489e+00), SC_(9.8480337725544158165589875516653346043616e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-3.0363718856088615365833364249378487136121e-01), SC_(-4.6599793653014686247141673201127096985355e-01), SC_(1.0048318698749207405367357913969529206519e+00), SC_(9.9516812667492033024479478495611459767366e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-2.9411906040374766485449450064825807395953e-01), SC_(-4.5138440744947064100177792954235978813452e-01), SC_(1.0042536605323495839311961402767223738069e+00), SC_(9.9574633739546174682630037887028834142194e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-2.6317729170420755576892864789309409667859e-01), SC_(-4.0388742702615976698396926866046453802031e-01), SC_(1.0027265444029636442724763752895235734784e+00), SC_(9.9727345524722977820299464007125504698522e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-2.6006113077206829301455706866571764229395e-01), SC_(-3.9910451448759575827803415740162638626992e-01), SC_(1.0025996654280226296751298722211847538662e+00), SC_(9.9740033428287776930054810159438368920196e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-2.4264614537696174125573131532153698741141e-01), SC_(-3.7237584088633651495244507752997662789157e-01), SC_(1.0019701324597243238930177488887415272400e+00), SC_(9.9802986744491719852892865581153236201330e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-2.3984911322617607447673286801686240539210e-01), SC_(-3.6808307441694652663052002433496241913065e-01), SC_(1.0018808434759773903203829683674253864640e+00), SC_(9.9811915644481111330376543802376449881318e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-2.3879418925770771737707895514386941170251e-01), SC_(-3.6646403013642764024759527891291079644900e-01), SC_(1.0018479687184394643750854806234858757868e+00), SC_(9.9815203120774359235446971849928127731820e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-2.3835463126725264340598805863152684834565e-01), SC_(-3.6578941992042974873805043154675958324956e-01), SC_(1.0018343987074515136013873900049150973684e+00), SC_(9.9816560122087598897141448997611657584492e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-2.2953182538316889914308514514305440267595e-01), SC_(-3.5224879247384010241782186888691990152154e-01), SC_(1.0015774906108508407556513692482836010070e+00), SC_(9.9842250934995289158994276007906080614606e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-2.2824480813632735530336670882969020520814e-01), SC_(-3.5027358898827664691644096162635701497902e-01), SC_(1.0015424043608579698498578023569199519355e+00), SC_(9.9845759560331832028638946520047405456774e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-4.8537116212485177711236360470966655938962e-01), SC_(-1.2583273464016870357687275526669074002606e+00), SC_(1.2584470938462560303782693928880467500303e+00), SC_(4.8744466804275024165799193853815679322579e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-6.0355532808208027901845595204207482566082e-01), SC_(-1.2631893560689228181930603896414408528551e+00), SC_(1.2643985750021126851579080942577611724858e+00), SC_(6.1436307291426347894945645874832238955220e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-6.2729509214327786322192300677137910352326e-01), SC_(-1.2576675203721337828966107837261083749322e+00), SC_(1.2596121348210016585068680870534288194758e+00), SC_(6.4244539910088407272126553108405153410377e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-7.0434902926818925787065711602707322261909e-01), SC_(-1.1950042268026294444597757266390889352577e+00), SC_(1.2089203868908054501482554344537873785284e+00), SC_(7.6516679584464389480058629479972726996215e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-7.1243899532146931113644669432746847137550e-01), SC_(-1.1462002324208451470074199660302738910392e+00), SC_(1.1750476449024894384022523664088244095113e+00), SC_(8.1354678870724126642663732172839589949485e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-6.9112942679440832631649453420838608498187e-01), SC_(-1.0569226802298606607482616118169374083493e+00), SC_(1.1246309393869133410800501451793942490995e+00), SC_(8.7267817437669511080987303152679650721756e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-6.7094000719053162067599051684292548875293e-01), SC_(-1.0114503899741717771978736165375599269648e+00), SC_(1.1039133653764522438392125566457183865196e+00), SC_(8.9481001952397169749780610888470669435887e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-4.7745158028317381801531394933549831087504e-01), SC_(-6.9898956434910854110465411682367926843123e-01), SC_(1.0233296918313620402030877483464003830694e+00), SC_(9.7666714232764621364242488386956471643256e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-4.7720101356839823215684489824360451113642e-01), SC_(-6.9861826423475348947979863141739650956958e-01), SC_(1.0232800579721756842983267160565450810947e+00), SC_(9.7671680304767929478105616107385214687134e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-4.1795448035618089514004700485220558354008e-01), SC_(-6.1128010654186841355405800289327275758670e-01), SC_(1.0136359289038732673177604362293736222867e+00), SC_(9.8636370169546507236196508504063255473384e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-3.1402242001436076643478556435450267999236e-01), SC_(-4.5906223082904282382240924590773435136933e-01), SC_(1.0043357431619685346705118738300935344598e+00), SC_(9.9566425306239498368599788757747435729114e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-3.0417854241475254792990349567174850453491e-01), SC_(-4.4466649993909345356787871865308627012871e-01), SC_(1.0038169032907034582965735252026101926855e+00), SC_(9.9618309444162386431388735179885172456727e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-2.7217813222395346704117961674608649917876e-01), SC_(-3.9787695127723388583544652333763972041801e-01), SC_(1.0024465884465294257324993282779638227467e+00), SC_(9.9755341117066430281274243229803371683784e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-2.6895537338643011943242708884518739516567e-01), SC_(-3.9316524972059391220917104191035098786453e-01), SC_(1.0023327371474536231396911692513662679300e+00), SC_(9.9766726253617399435581282133296694928896e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-2.5094469354851730147284296458662992524299e-01), SC_(-3.6683447241203583987350884468366477973478e-01), SC_(1.0017678433372040213177851762639990320634e+00), SC_(9.9823215655844167090566320523508089265836e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-2.4805199147997947162507048978573952979048e-01), SC_(-3.6260560295140228245278907097711777163089e-01), SC_(1.0016877223626326610878423014378840530095e+00), SC_(9.9831227755068326968002448794471737383740e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-2.4696098509394368519929861155451387691360e-01), SC_(-3.6101065741380506096149279876583391287250e-01), SC_(1.0016582231175181339217997364576702672339e+00), SC_(9.9834177680170125576630606953737967426858e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-2.4650639259082847416512271434050469502032e-01), SC_(-3.6034608840080847686659043197364421180537e-01), SC_(1.0016460464473131860368485285356061328758e+00), SC_(9.9835395347425295002578007654237838614025e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-2.3738181907739500851273456241160151465298e-01), SC_(-3.4700699840349333714140407301578668398616e-01), SC_(1.0014155171442107240472374780880119089534e+00), SC_(9.9858448281289535102456785605400394421064e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-2.3605078252667132960131021825139261585650e-01), SC_(-3.4506119260894534389278339715331380969824e-01), SC_(1.0013840334778987072932648592820898627530e+00), SC_(9.9861596648289808246504489160341314307086e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-5.0004280776440253718618405971350731412794e-01), SC_(-1.2352376884554060551327532055634991162255e+00), SC_(1.2353671089960745616607688728570440794319e+00), SC_(5.0198268884533811969095625671221469197088e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-6.1782119501604097634435514274054525974501e-01), SC_(-1.2453060561228292747757824076943681049542e+00), SC_(1.2465896107119366408519987804453075672032e+00), SC_(6.2808984662646964266946355738852553326468e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-6.4131745843813424112802624799538466941059e-01), SC_(-1.2409446875004097865810453460685988474246e+00), SC_(1.2430011254251051885778334934266970217963e+00), SC_(6.5575829662235853495766649809563484319842e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-7.1672153385169661081848018371563230562818e-01), SC_(-1.1832519630904498800037175818153127457112e+00), SC_(1.1977369296397025972613684501258263763677e+00), SC_(7.7547757524060304612508186556685893930865e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-7.2392907283279098638801954228267702358712e-01), SC_(-1.1362582006479490063696398843503650806479e+00), SC_(1.1661010539633130204849961879703794659468e+00), SC_(8.2210926845919401550121138341158167047952e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-7.0136067611392451621530337840017757991279e-01), SC_(-1.0489685876699920552006190094469615980628e+00), SC_(1.1184841239976545956078395354364461447041e+00), SC_(8.7873436737671625632079550034136629875356e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-6.8062791506254032892377867046301068698853e-01), SC_(-1.0041751632820645122917580928090440249829e+00), SC_(1.0988280460260470482302472573131795716340e+00), SC_(8.9985234563701074671078953260346260481481e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-4.8399700727871367964065597483944958439347e-01), SC_(-6.9444682655270149020062883525132269929236e-01), SC_(1.0221996191307370225322700009438332359764e+00), SC_(9.7779710841058098260908137391560618732591e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-4.8374293045457638960986726072758039388138e-01), SC_(-6.9407804691379252548120981291663888615720e-01), SC_(1.0221523903245716021618022118086934265867e+00), SC_(9.7784436498219997468340619538471614014544e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-4.2367408564237407809977157309572602294984e-01), SC_(-6.0732194330365194717860004763142984803099e-01), SC_(1.0129754755813910237058013397328935257572e+00), SC_(9.8702414257744716917300761531919917547506e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-3.1831618283883790611070983613994027619245e-01), SC_(-4.5609480383415931990142932516058595483510e-01), SC_(1.0041257470293307063046969028735920395664e+00), SC_(9.9587424906787871873471857580514270767057e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-3.0833761853279519574578397696374690114541e-01), SC_(-4.4179225334853825577643439365936275076151e-01), SC_(1.0036320365419694553595179415789128795279e+00), SC_(9.9636796111398826317616140424308791855308e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-2.7589950397734854227924156895854668573360e-01), SC_(-3.9530537087165773973219216632324399700487e-01), SC_(1.0023280911597602187705259808035135306896e+00), SC_(9.9767190844454154186425120265244674638676e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-2.7263267186435607829468383786318235110868e-01), SC_(-3.9062413644887359163996633045065861284843e-01), SC_(1.0022197541002936453951507927106804207037e+00), SC_(9.9778024557267933316900741928708450413060e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-2.5437570122193975417520310968957391161897e-01), SC_(-3.6446359714341169447520311494505687449460e-01), SC_(1.0016822201822811660967148202480080709118e+00), SC_(9.9831777970985013128136843000058693186130e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-2.5144344442047399545477081989008261782284e-01), SC_(-3.6026206580846757393018277078387870401119e-01), SC_(1.0016059797617233660741601235818305144232e+00), SC_(9.9839402014867325975483440486798592073645e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-2.5033751976529668752571869882737003956094e-01), SC_(-3.5867743084482471672526609475816693348316e-01), SC_(1.0015779092737184089387280684250661980276e+00), SC_(9.9842209064278048969793537981718192793496e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-2.4987671124689957250807280778225179108938e-01), SC_(-3.5801715793093088881067507790522539881194e-01), SC_(1.0015663223645039396641963696872980615868e+00), SC_(9.9843367755442073795750426046312864122786e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-2.4062737213442940736154574007056206477034e-01), SC_(-3.4476429523856983038630565414394991297947e-01), SC_(1.0013469584443345824500511861276478445683e+00), SC_(9.9865304151132693137769021235722753987639e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-2.3927813585681630698564802074864646519221e-01), SC_(-3.4283106718878900006783656184463593037052e-01), SC_(1.0013169996478537476863534389983176447149e+00), SC_(9.9868300031162277496530103819324337501291e-01) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-8.6168741734255249788782056171892181671619e-01), SC_(-7.9350873172246820112097544770165433868690e-01), SC_(7.9410480094592119763367227925897637698104e-01), SC_(8.6215304620506175458391818401988742841909e-01) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-9.4329949889950780627563600791016795948774e-01), SC_(-8.8503484212770630460507028535285740646709e-01), SC_(8.8918316658463047921008960758822884822492e-01), SC_(9.4673103166538871980091657818532317084166e-01) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-9.5587816624041561612212201319835649358384e-01), SC_(-9.0021748451698322468136438835449206104128e-01), SC_(9.0639227723803894874795359952430646324093e-01), SC_(9.6104710997752775984088603604191026013464e-01) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-9.7405098137956966366019164195281518373091e-01), SC_(-9.3090540905284268981653070365161724814996e-01), SC_(9.6280411744669257705290996669920966925550e-01), SC_(1.0021229750880347774882576136559511302918e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-9.5595174860335116002161021084726640251265e-01), SC_(-9.1790646737794584129931423931614004694263e-01), SC_(9.7626535845962661031789478478392767480003e-01), SC_(1.0082972389680468165902036253594412161784e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-9.0141526581662473698572736637465975127772e-01), SC_(-8.6943533178647388386578571400137767077430e-01), SC_(9.8701634447668692360730396313297725852031e-01), SC_(1.0093415482607666261320188781648418921729e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-8.6817625754436069833786710926556242468914e-01), SC_(-8.3843907089159655793863927591106890637719e-01), SC_(9.8987186283805654864064430950282301091923e-01), SC_(1.0084002420671886250058957948993723096037e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-6.0796899686368094000695898980032760923432e-01), SC_(-5.8867014608568331200986647389829207232048e-01), SC_(9.9793050299406636353007646343971707866161e-01), SC_(1.0020652120486880133020437198766408096484e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-6.0764781681438684033891898585185689242130e-01), SC_(-5.8835949488673851730927662552265538162685e-01), SC_(9.9793492035518044053093205138462055107718e-01), SC_(1.0020608310436575485046155122158727113251e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-5.3192068797136105933517835755123439328505e-01), SC_(-5.1508104576146588025401088851283942997513e-01), SC_(9.9879147135711561534389017982142040292911e-01), SC_(1.0012080286600849180491312132501397947969e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-3.9954847379584239204140497347226840037374e-01), SC_(-3.8691531263046726335847661410717594035575e-01), SC_(9.9961581260053947901210810856911514409648e-01), SC_(1.0003841822891467241051112956171870336554e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-3.8702109307714927539359055436248270519963e-01), SC_(-3.7478441770187559672604517175712732064144e-01), SC_(9.9966178742775414739828679133337994671878e-01), SC_(1.0003382095029569985451038677867053206107e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-3.4630095696146303087354192275834565633614e-01), SC_(-3.3535245802498003890042050616739630142321e-01), SC_(9.9978321063914512202570728356952374551523e-01), SC_(1.0002167888427276217992043558855637495250e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-3.4220025799231226190130330946319199180353e-01), SC_(-3.3138144903969147952202677467461881461936e-01), SC_(9.9979329890559052935625979879891777511654e-01), SC_(1.0002067006662003040235350685676464685920e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-3.1928360100238278125792877943739254713544e-01), SC_(-3.0918948716690838788994532698999282522444e-01), SC_(9.9984335357921162605026893340443896146266e-01), SC_(1.0001566462795450997660544015850609096738e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-3.1560300807099974091389593977544411877551e-01), SC_(-3.0562527644033956044557870965254133349177e-01), SC_(9.9985045300942032088421198787800579949575e-01), SC_(1.0001495468732530251540996038938225646338e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-3.1421484565689592849725124429446927917245e-01), SC_(-3.0428100787117398290355028001221169484834e-01), SC_(9.9985306690419901688313409196325518495319e-01), SC_(1.0001469329864646448850160258124796611205e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-3.1363643691079966561585946042605266738271e-01), SC_(-3.0372088838651285479188313646311988928963e-01), SC_(9.9985414586512262850075673914806899954217e-01), SC_(1.0001458540287173481572972558983210907318e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-3.0202668669998854880443724840796839321372e-01), SC_(-2.9247822840233340121501129585285662841373e-01), SC_(9.9987457279855885102029902272876784978920e-01), SC_(1.0001254271433843372530615441349054975039e+00) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-3.0033313662790135454792098752307912231955e-01), SC_(-2.9083822553615016231843390600874265351013e-01), SC_(9.9987736252877582331465232838550964778948e-01), SC_(1.0001226374181627373348623065389646772440e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9508075714111328125000000000000000000000e-01), SC_(-9.2475326594248786056197436333857443434487e-01), SC_(-7.3516286509414808768521559111291568165496e-01), SC_(7.3590366632830873272417682817711853695388e-01), SC_(9.2512580234759162377770006997697710058670e-01) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(2.5397360324859619140625000000000000000000e-01), SC_(-9.9620543123356148411404638317514386579227e-01), SC_(-8.3419701069860217730134945109979481534225e-01), SC_(8.3909915439540528538303709920165833100733e-01), SC_(9.9909665251568597742885879969727763341955e-01) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(2.7095401287078857421875000000000000000000e-01), SC_(-1.0062151375397766069062966126295173287978e+00), SC_(-8.5144469591598649206463327460137420379288e-01), SC_(8.5866558655008937060249797013172885035478e-01), SC_(1.0106172323003462441584986384727296329728e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(3.7676393985748291015625000000000000000000e-01), SC_(-1.0123505106795024920296320094948878724255e+00), SC_(-8.9235480403196409856393427819653516809270e-01), SC_(9.2805175702204482907804202554213907433097e-01), SC_(1.0373631230253164665685138450423765844385e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(4.4206809997558593750000000000000000000000e-01), SC_(-9.8946311973823827752244934509220827481057e-01), SC_(-8.8363846611919580642794923016554891399140e-01), SC_(9.4786239927720961170852248809537829920345e-01), SC_(1.0369148990869950612690639733134359786758e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(5.5699634552001953125000000000000000000000e-01), SC_(-9.2933133791581800477787226550792939315690e-01), SC_(-8.4036294053948407020184941187677967579914e-01), SC_(9.6717090287501109285246362026377919539609e-01), SC_(1.0292376437188232459525962856565168103115e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(6.1633396148681640625000000000000000000000e-01), SC_(-8.9405827382334184437944289777171623517103e-01), SC_(-8.1132459239968057975596621507841167992231e-01), SC_(9.7339251168005165930157234863249162389499e-01), SC_(1.0249036245191225026844293766040747246519e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.0937628746032714843750000000000000000000e+00), SC_(-6.2465306433878293386624267838859976879170e-01), SC_(-5.7095361498177640883477785708605457625398e-01), SC_(9.9425039421824665157477918404226742537784e-01), SC_(1.0057453804190209454805524015466640989121e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.0944409370422363281250000000000000000000e+00), SC_(-6.2432275539078015912366439002962356663024e-01), SC_(-5.7065260114243142054667650581126521173159e-01), SC_(9.9426264239910515435137016198249782333940e-01), SC_(1.0057331680886113469587678914883103661573e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.2647185325622558593750000000000000000000e+00), SC_(-5.4647513988222851648970047560537568695071e-01), SC_(-4.9961826756989275963566711430589346703337e-01), SC_(9.9664059417289417755890853185461179531283e-01), SC_(1.0033589127979887019373372871288028649467e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.6294469833374023437500000000000000000000e+00), SC_(-4.1046601255143676056236240039336468350996e-01), SC_(-3.7531373790529854209968532694531602723708e-01), SC_(9.9893191761660311302896264332941392046949e-01), SC_(1.0010680773441565327553677270614030856394e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.6700167655944824218750000000000000000000e+00), SC_(-3.9759595901933272538373795286360576115334e-01), SC_(-3.6354691998638366914780478027601677517144e-01), SC_(9.9905973130977840321621379015762080532177e-01), SC_(1.0009402656636199306510692280192887341216e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.8115835189819335937500000000000000000000e+00), SC_(-3.5576253175673553936931531559899035630814e-01), SC_(-3.2529789176589439916509086730960614810952e-01), SC_(9.9939730008643814291314111402626066756878e-01), SC_(1.0006026994026406335155786210455208620459e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+00), SC_(-3.5154975257250477867240228196964260076942e-01), SC_(-3.2144597997706691338916452792182803805272e-01), SC_(9.9942534659431846698812678356395804244135e-01), SC_(1.0005746529834278323107818983648336172323e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9150133132934570312500000000000000000000e+00), SC_(-3.2800680809283234167460434145390215181920e-01), SC_(-2.9991952805082158783947927443290703354177e-01), SC_(9.9956450432237925778110273675945071284632e-01), SC_(1.0004354955383418573367018517600950617758e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9297766685485839843750000000000000000000e+00), SC_(-3.2422563745789585673174212089414039932554e-01), SC_(-2.9646219550654719653088685518533492145700e-01), SC_(9.9958424156688669130322435201404334734424e-01), SC_(1.0004157583174184154341575365572364586118e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9353895187377929687500000000000000000000e+00), SC_(-3.2279954195082593435591690109354951011919e-01), SC_(-2.9515823636280271293907323903556961701978e-01), SC_(9.9959150850015315417104051480218148703959e-01), SC_(1.0004084913920311402383954240071152079780e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9377355575561523437500000000000000000000e+00), SC_(-3.2220532761842476549822075234965099428122e-01), SC_(-2.9461491262568127138266335266295643721228e-01), SC_(9.9959450813785042353568584773024480267625e-01), SC_(1.0004054917574660100744119536190964431421e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9857625961303710937500000000000000000000e+00), SC_(-3.1027833867098246032637913484360374944976e-01), SC_(-2.8370936683958984581605751220805482637047e-01), SC_(9.9965129741527285205012528287247680186108e-01), SC_(1.0003487025274777812537548475233986215433e+00) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.9929223060607910156250000000000000000000e+00), SC_(-3.0853851330676095143472321816953183496398e-01), SC_(-2.8211853871310206559884290554627299979024e-01), SC_(9.9965905319479616393898607125655416044135e-01), SC_(1.0003409467528803668856304375077198026475e+00) }
   }};
//#undef SC_

