# Downloading Noto Sans CJK

Noto Sans CJK is available in multiple formats which have different uses. Each of
these font formats used below has the capability to display both horizontal
and vertical forms where appropriate. Any of the fonts that support
Japanese will also be able to support proportional kana.

### Variable OTCs

Select this deployment format if you want all five languages and all weights, along with the half-width (Mono) variations, and your system supports both variable fonts and OTCs.

Variable OTC [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTC/NotoSansCJK-VF.otf.ttc) | [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTC/NotoSansCJK-VF.ttf.ttc)

Variable Mono OTC [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTC/NotoSansMonoCJK-VF.otf.ttc) | [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTC/NotoSansMonoCJK-VF.ttf.ttc)

**Note**: There are no Region-specific Variable OTCs as the file size would be larger than the 
Language-specific OTC, defeating the benefits of file size. 

### Language-specific Variable Fonts

Select this deployment format if your system supports variable fonts and you prefer to use only one language, 
but also want full character coverage or the ability to language-tag text to use glyphs that are appropriate 
for the other languages (this requires an app that supports language tagging and the OpenType 'locl' GSUB feature). 
Font resources that include "Mono" in their names use half-width glyphs for ASCII by default.

#### OTF
- Variable Simplified Chinese (简体中文) 
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/NotoSansCJKsc-VF.otf)
  - [Mono OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Mono/NotoSansMonoCJKsc-VF.otf)

- Variable Traditional Chinese — Taiwan (繁體中文—臺灣)
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/NotoSansCJKtc-VF.otf) 
  - [Mono OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Mono/NotoSansMonoCJKtc-VF.otf)

- Variable Traditional Chinese — Hong Kong (繁體中文—香港)
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/NotoSansCJKhk-VF.otf)
  - [Mono OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Mono/NotoSansMonoCJKhk-VF.otf)

- Variable Japanese (日本語)
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/NotoSansCJKjp-VF.otf)
  - [Mono OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Mono/NotoSansMonoCJKjp-VF.otf)

- Variable Korean (한국어)
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/NotoSansCJKkr-VF.otf)
  - [Mono OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Mono/NotoSansMonoCJKkr-VF.otf)

#### TTF

- Variable Simplified Chinese (简体中文) 
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/NotoSansCJKsc-VF.ttf)
  - [Mono TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Mono/NotoSansMonoCJKsc-VF.ttf)

- Variable Traditional Chinese — Taiwan (繁體中文—臺灣)
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/NotoSansCJKtc-VF.ttf) 
  - [Mono TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Mono/NotoSansMonoCJKtc-VF.ttf)

- Variable Traditional Chinese — Hong Kong (繁體中文—香港)
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/NotoSansCJKhk-VF.ttf)
  - [Mono TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Mono/NotoSansMonoCJKhk-VF.ttf)

- Variable Japanese (日本語)
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/NotoSansCJKjp-VF.ttf)
  - [Mono TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Mono/NotoSansMonoCJKjp-VF.ttf)

- Variable Korean (한국어)
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/NotoSansCJKkr-VF.ttf)
  - [Mono TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Mono/NotoSansMonoCJKkr-VF.ttf)
        

### Region-specific Subset Variable Fonts

Select this deployment format if your system support variable fonts and you need only the glyphs for characters for a particular region.

#### OTF

- Subset Variable Simplified Chinese (简体中文) 
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Subset/NotoSansSC-VF.otf)

- Subset Variable Traditional Chinese — Taiwan (繁體中文—臺灣) 
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Subset/NotoSansTC-VF.otf)

- Subset Variable Traditional Chinese — Hong Kong (繁體中文—香港) 
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Subset/NotoSansHK-VF.otf)

- Subset Variable Japanese (日本語) 
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Subset/NotoSansJP-VF.otf)

- Subset Variable Korean (한국어) 
  - [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/OTF/Subset/NotoSansKR-VF.otf)

#### TTF
- Subset Variable Simplified Chinese (简体中文)
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Subset/NotoSansSC-VF.ttf)

- Subset Variable Traditional Chinese — Taiwan (繁體中文—臺灣) 
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Subset/NotoSansTC-VF.ttf)

- Subset Variable Traditional Chinese — Hong Kong (繁體中文—香港) 
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Subset/NotoSansHK-VF.ttf)

- Subset Variable Japanese (日本語) 
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Subset/NotoSansJP-VF.ttf)

- Subset Variable Korean (한국어) 
  - [TTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/Variable/TTF/Subset/NotoSansKR-VF.ttf)

### Super OTC

Select this deployment format if you want all five languages and all seven weights, along with the half-width (Mono) variations that are provided only for the Regular and Bold weights, in a single and easy-to-manage font resource that includes 45 fonts. Changing languages is accomplished by either selecting the font of the desired language or by language-tagging the text. A limited number of apps support language tagging and the corresponding OpenType 'locl' (*Localized Forms*) GSUB feature, such as [Adobe InDesign CC](https://www.adobe.com/products/indesign.html) and modern browsers.

[Super OTC](https://github.com/googlefonts/noto-cjk/raw/main/Sans/SuperOTC/NotoSansCJK.ttc.zip)

**Special Note**: This deployment format requires macOS (OS X) Version 10.8 (aka *Mountain Lion*) or later, iOS 7 or later, Windows 10 Version 1703 (aka *Creators Update*) or later, a flavor of Linux that uses *fontconfig* and FreeType Version 2.5.0.1 or greater, or Adobe CS6 apps or later.

### OTCs

Select this deployment format if you want all five languages and particular weights, or if your environment does not support the Super OTC. Changing languages is accomplished the same way as the Super OTC. If you need particular weights, download individual font resources from the [OTC](https://github.com/googlefonts/noto-cjk/raw/main/Sans/OTC) folder, otherwise click both of the links below:

[Static OTCs](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/03_NotoSansCJK-OTC.zip)

**Note**: The Regular and Bold weights include 10 fonts due to the addition of the half-width (Monospace) variations.

**Special Note**: This deployment format requires macOS (OS X) Version 10.8 (aka *Mountain Lion*) or later, iOS 7 or later, Windows 10 Version 1607 (aka *Anniversary Update*) or later, a flavor of Linux that uses *fontconfig* and FreeType Version 2.5.0.1 or greater, or Adobe CS6 apps or later.

### Language-specific OTFs

Select this deployment format if you prefer to use only one language, but also want full character coverage or the ability to language-tag text to use glyphs that are appropriate for the other languages (like the Super OTC and OTCs, this requires an app that supports language tagging and the OpenType 'locl' GSUB feature). Font resources that include "Mono" in their names use half-width glyphs for ASCII by default. If you need only specific weights, download individual font resources from the [OTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/OTF) folder, otherwise click on the appropriate links below:

[Simplified Chinese (简体中文)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/08_NotoSansCJKsc.zip) | [Mono Regular + Mono Bold](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/13_NotoSansMonoCJKsc.zip)

[Traditional Chinese — Taiwan (繁體中文—臺灣)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/09_NotoSansCJKtc.zip) | [Mono Regular + Mono Bold](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/14_NotoSansMonoCJKtc.zip)

[Traditional Chinese — Hong Kong (繁體中文—香港)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/10_NotoSansCJKhk.zip) | [Mono Regular + Mono Bold](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/15_NotoSansMonoCJKhk.zip)

[Japanese (日本語)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/06_NotoSansCJKjp.zip) | [Mono Regular + Mono Bold](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/11_NotoSansMonoCJKjp.zip)

[Korean (한국어)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/07_NotoSansCJKkr.zip) | [Mono Regular + Mono Bold](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/12_NotoSansMonoCJKkr.zip)

### Region-specific Subset OTFs

Select this deployment format if you need only the glyphs for characters for a particular region, **or if you are not sure which deployment format to choose**.

Each ZIP file contains seven font resources, one for each of the seven weights. If you need specific weights, download individual font resources from the [SubsetOTF](https://github.com/googlefonts/noto-cjk/raw/main/Sans/SubsetOTF) folder, otherwise click on the appropriate links below:

[China (中国)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/18_NotoSansSC.zip)

[Taiwan (臺灣)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/19_NotoSansTC.zip)

[Hong Kong (香港)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/20_NotoSansHK.zip)

[Japan (日本)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/16_NotoSansJP.zip)

[Korea (한국)](https://github.com/googlefonts/noto-cjk/releases/download/Sans2.004/17_NotoSansKR.zip)

## Getting Involved

[Open or respond to an issue](https://github.com/googlefonts/noto-cjk/issues/).
