# NMake Makefile portion for displaying config info

GTK_SUPPORT = yes
CAIRO_SUPPORT = yes
BUILT_TOOLS = gsf.exe gsf-vba-dump.exe
BUILT_LIBRARIES = libgsf libgsf-win32

!if "$(NO_CAIRO)" == "1"
CAIRO_SUPPORT = no
!endif

!if "$(NO_GTK)" == "1"
GTK_SUPPORT = no
!endif

!if "$(INTROSPECTION)" == "1"
BUILD_INTROSPECTION = yes
!else
BUILD_INTROSPECTION = no
!endif

!if "$(CFG)" == "release"
BUILD_TYPE = release
!else
BUILD_TYPE = debug
!endif

build-info-gjs:
	@echo.
	@echo =====================
	@echo Configuration for GJS
	@echo =====================
	@echo GTK+ support: $(GTK_SUPPORT)
	@echo Cairo support: $(CAIRO_SUPPORT)

all-build-info: build-info-gjs
	@echo.
	@echo ----------------
	@echo Other build info
	@echo ----------------
	@echo Build Type: $(BUILD_TYPE)
	@echo Introspection: $(BUILD_INTROSPECTION)

help:
	@echo.
	@echo ========================
	@echo Building gjs Using NMake
	@echo ========================
	@echo nmake /f Makefile.vc CFG=[release^|debug] ^<PREFIX=PATH^> OPTION=1 ...
	@echo.
	@echo Where:
	@echo ------
	@echo CFG: Required, use CFG=release for an optimized build and CFG=debug
	@echo for a debug build.  PDB files are generated for all builds.
	@echo.
	@echo PREFIX: Optional, the path where dependent libraries and tools may be
	@echo found, default is ^$(srcrootdir)\..\vs^$(short_vs_ver)\^$(platform),
	@echo where ^$(short_vs_ver) is 12 for VS 2013, 14 for VS 2015 and so on; and
	@echo ^$(platform) is Win32 for 32-bit builds and x64 for x64 builds.
	@echo.
	@echo OPTION: Optional, may be any of the following, use OPTION=1 to enable;
	@echo multiple OPTION's may be used.  If no OPTION is specified, a default
	@echo GJS is built with GTK+ and Cairo support, without the introspection
	@echo files (this means the default build will depend on the GTK+-3.x libraries
	@echo and the cairo/cairo-gobject libraries respectively).
	@echo ======
	@echo NO_CAIRO:
	@echo Disable Cairo support.
	@echo.
	@echo NO_GTK:
	@echo Disable GTK support.  For introspection, you will then only need the .pc
	@echo files and .gir/.typelib files for Gio-2.0 and its dependencies; otherwise
	@echo the gtk+-3.0.pc and Gtk-3.0.gir/Gtk-3.0.typelib files are required.
	@echo.
	@echo INTROSPECTION:
	@echo Enable the build of introspection files requires the GNOME
	@echo gobject-introspection libraries and tools.  You will need
	@echo to ensure Python interpreter (that was used to build the
	@echo gobject-introspection tools) can be found by setting PKG_CONFIG_PATH
	@echo beforehand, and passing in PYTHON=^$(PATH_TO_PYTHON_INTERPRETOR)
	@echo respectively, if python.exe is not already in your PATH.
	@echo.
	@echo LIBTOOL_DLL_NAME:
	@echo Use a libtool-style DLL name to mimic the DLL file naming generated by
	@echo MinGW/autotools builds.  Please note that this does not enable one to use
	@echo this build with MinGW builds.
	@echo ======
	@echo A 'clean' target is supported to remove all generated files, intermediate
	@echo object files and binaries for the specified configuration.
	@echo.
	@echo An 'install' target is supported to copy the build (DLLs, utility programs,
	@echo LIBs, along with the introspection files if applicable) to appropriate
	@echo locations under ^$(PREFIX).
	@echo ======
	@echo.
