/*
 * Copyright (c) 2010-2011 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef INITVALS_9485_H
#define INITVALS_9485_H

static __unused const u32 ar9485_1_1_mac_core[][2] = {
	/*  Addr       allmodes */
	{0x00000008, 0x00000000},
	{0x00000030, 0x00020085},
	{0x00000034, 0x00000005},
	{0x00000040, 0x00000000},
	{0x00000044, 0x00000000},
	{0x00000048, 0x00000008},
	{0x0000004c, 0x00000010},
	{0x00000050, 0x00000000},
	{0x00001040, 0x002ffc0f},
	{0x00001044, 0x002ffc0f},
	{0x00001048, 0x002ffc0f},
	{0x0000104c, 0x002ffc0f},
	{0x00001050, 0x002ffc0f},
	{0x00001054, 0x002ffc0f},
	{0x00001058, 0x002ffc0f},
	{0x0000105c, 0x002ffc0f},
	{0x00001060, 0x002ffc0f},
	{0x00001064, 0x002ffc0f},
	{0x000010f0, 0x00000100},
	{0x00001270, 0x00000000},
	{0x000012b0, 0x00000000},
	{0x000012f0, 0x00000000},
	{0x0000143c, 0x00000000},
	{0x0000147c, 0x00000000},
	{0x00008000, 0x00000000},
	{0x00008004, 0x00000000},
	{0x00008008, 0x00000000},
	{0x0000800c, 0x00000000},
	{0x00008018, 0x00000000},
	{0x00008020, 0x00000000},
	{0x00008038, 0x00000000},
	{0x0000803c, 0x00000000},
	{0x00008040, 0x00000000},
	{0x00008044, 0x00000000},
	{0x00008048, 0x00000000},
	{0x0000804c, 0xffffffff},
	{0x00008054, 0x00000000},
	{0x00008058, 0x00000000},
	{0x0000805c, 0x000fc78f},
	{0x00008060, 0x0000000f},
	{0x00008064, 0x00000000},
	{0x00008070, 0x00000310},
	{0x00008074, 0x00000020},
	{0x00008078, 0x00000000},
	{0x0000809c, 0x0000000f},
	{0x000080a0, 0x00000000},
	{0x000080a4, 0x02ff0000},
	{0x000080a8, 0x0e070605},
	{0x000080ac, 0x0000000d},
	{0x000080b0, 0x00000000},
	{0x000080b4, 0x00000000},
	{0x000080b8, 0x00000000},
	{0x000080bc, 0x00000000},
	{0x000080c0, 0x2a800000},
	{0x000080c4, 0x06900168},
	{0x000080c8, 0x13881c22},
	{0x000080cc, 0x01f40000},
	{0x000080d0, 0x00252500},
	{0x000080d4, 0x00a00000},
	{0x000080d8, 0x00400000},
	{0x000080dc, 0x00000000},
	{0x000080e0, 0xffffffff},
	{0x000080e4, 0x0000ffff},
	{0x000080e8, 0x3f3f3f3f},
	{0x000080ec, 0x00000000},
	{0x000080f0, 0x00000000},
	{0x000080f4, 0x00000000},
	{0x000080fc, 0x00020000},
	{0x00008100, 0x00000000},
	{0x00008108, 0x00000052},
	{0x0000810c, 0x00000000},
	{0x00008110, 0x00000000},
	{0x00008114, 0x000007ff},
	{0x00008118, 0x000000aa},
	{0x0000811c, 0x00003210},
	{0x00008124, 0x00000000},
	{0x00008128, 0x00000000},
	{0x0000812c, 0x00000000},
	{0x00008130, 0x00000000},
	{0x00008134, 0x00000000},
	{0x00008138, 0x00000000},
	{0x0000813c, 0x0000ffff},
	{0x00008144, 0xffffffff},
	{0x00008168, 0x00000000},
	{0x0000816c, 0x00000000},
	{0x00008170, 0x18486200},
	{0x00008174, 0x33332210},
	{0x00008178, 0x00000000},
	{0x0000817c, 0x00020000},
	{0x000081c0, 0x00000000},
	{0x000081c4, 0x33332210},
	{0x000081d4, 0x00000000},
	{0x000081ec, 0x00000000},
	{0x000081f0, 0x00000000},
	{0x000081f4, 0x00000000},
	{0x000081f8, 0x00000000},
	{0x000081fc, 0x00000000},
	{0x00008240, 0x00100000},
	{0x00008244, 0x0010f400},
	{0x00008248, 0x00000800},
	{0x0000824c, 0x0001e800},
	{0x00008250, 0x00000000},
	{0x00008254, 0x00000000},
	{0x00008258, 0x00000000},
	{0x0000825c, 0x40000000},
	{0x00008260, 0x00080922},
	{0x00008264, 0x9ca00010},
	{0x00008268, 0xffffffff},
	{0x0000826c, 0x0000ffff},
	{0x00008270, 0x00000000},
	{0x00008274, 0x40000000},
	{0x00008278, 0x003e4180},
	{0x0000827c, 0x00000004},
	{0x00008284, 0x0000002c},
	{0x00008288, 0x0000002c},
	{0x0000828c, 0x000000ff},
	{0x00008294, 0x00000000},
	{0x00008298, 0x00000000},
	{0x0000829c, 0x00000000},
	{0x00008300, 0x00000140},
	{0x00008314, 0x00000000},
	{0x0000831c, 0x0000010d},
	{0x00008328, 0x00000000},
	{0x0000832c, 0x00000007},
	{0x00008330, 0x00000302},
	{0x00008334, 0x00000700},
	{0x00008338, 0x00ff0000},
	{0x0000833c, 0x02400000},
	{0x00008340, 0x000107ff},
	{0x00008344, 0xa248105b},
	{0x00008348, 0x008f0000},
	{0x0000835c, 0x00000000},
	{0x00008360, 0xffffffff},
	{0x00008364, 0xffffffff},
	{0x00008368, 0x00000000},
	{0x00008370, 0x00000000},
	{0x00008374, 0x000000ff},
	{0x00008378, 0x00000000},
	{0x0000837c, 0x00000000},
	{0x00008380, 0xffffffff},
	{0x00008384, 0xffffffff},
	{0x00008390, 0xffffffff},
	{0x00008394, 0xffffffff},
	{0x00008398, 0x00000000},
	{0x0000839c, 0x00000000},
	{0x000083a0, 0x00000000},
	{0x000083a4, 0x0000fa14},
	{0x000083a8, 0x000f0c00},
	{0x000083ac, 0x33332210},
	{0x000083b0, 0x33332210},
	{0x000083b4, 0x33332210},
	{0x000083b8, 0x33332210},
	{0x000083bc, 0x00000000},
	{0x000083c0, 0x00000000},
	{0x000083c4, 0x00000000},
	{0x000083c8, 0x00000000},
	{0x000083cc, 0x00000200},
	{0x000083d0, 0x000301ff},
};

static __unused const u32 ar9485_1_1_baseband_core[][2] = {
	/* Addr       allmodes */
	{0x00009800, 0xafe68e30},
	{0x00009804, 0xfd14e000},
	{0x00009808, 0x9c0a8f6b},
	{0x0000980c, 0x04800000},
	{0x00009814, 0x9280c00a},
	{0x00009818, 0x00000000},
	{0x0000981c, 0x00020028},
	{0x00009834, 0x5f3ca3de},
	{0x00009838, 0x0108ecff},
	{0x0000983c, 0x14750600},
	{0x00009880, 0x201fff00},
	{0x00009884, 0x00001042},
	{0x000098a4, 0x00200400},
	{0x000098b0, 0x52440bbe},
	{0x000098d0, 0x004b6a8e},
	{0x000098d4, 0x00000820},
	{0x000098dc, 0x00000000},
	{0x000098f0, 0x00000000},
	{0x000098f4, 0x00000000},
	{0x00009c04, 0x00000000},
	{0x00009c08, 0x03200000},
	{0x00009c0c, 0x00000000},
	{0x00009c10, 0x00000000},
	{0x00009c14, 0x00046384},
	{0x00009c18, 0x05b6b440},
	{0x00009c1c, 0x00b6b440},
	{0x00009d00, 0xc080a333},
	{0x00009d04, 0x40206c10},
	{0x00009d08, 0x009c4060},
	{0x00009d0c, 0x1883800a},
	{0x00009d10, 0x01834061},
	{0x00009d14, 0x00c00400},
	{0x00009d18, 0x00000000},
	{0x00009d1c, 0x00000000},
	{0x00009e08, 0x0038233c},
	{0x00009e24, 0x9927b515},
	{0x00009e28, 0x12ef0200},
	{0x00009e30, 0x06336f77},
	{0x00009e34, 0x6af6532f},
	{0x00009e38, 0x0cc80c00},
	{0x00009e40, 0x0d261820},
	{0x00009e4c, 0x00001004},
	{0x00009e50, 0x00ff03f1},
	{0x00009fc0, 0x80be4788},
	{0x00009fc4, 0x0001efb5},
	{0x00009fcc, 0x40000014},
	{0x0000a20c, 0x00000000},
	{0x0000a210, 0x00000000},
	{0x0000a220, 0x00000000},
	{0x0000a224, 0x00000000},
	{0x0000a228, 0x10002310},
	{0x0000a23c, 0x00000000},
	{0x0000a244, 0x0c000000},
	{0x0000a2a0, 0x00000001},
	{0x0000a2c0, 0x00000001},
	{0x0000a2c8, 0x00000000},
	{0x0000a2cc, 0x18c43433},
	{0x0000a2d4, 0x00000000},
	{0x0000a2dc, 0x00000000},
	{0x0000a2e0, 0x00000000},
	{0x0000a2e4, 0x00000000},
	{0x0000a2e8, 0x00000000},
	{0x0000a2ec, 0x00000000},
	{0x0000a2f0, 0x00000000},
	{0x0000a2f4, 0x00000000},
	{0x0000a2f8, 0x00000000},
	{0x0000a344, 0x00000000},
	{0x0000a34c, 0x00000000},
	{0x0000a350, 0x0000a000},
	{0x0000a364, 0x00000000},
	{0x0000a370, 0x00000000},
	{0x0000a390, 0x00000001},
	{0x0000a394, 0x00000444},
	{0x0000a398, 0x001f0e0f},
	{0x0000a39c, 0x0075393f},
	{0x0000a3a0, 0xb79f6427},
	{0x0000a3a4, 0x000000ff},
	{0x0000a3a8, 0x3b3b3b3b},
	{0x0000a3ac, 0x2f2f2f2f},
	{0x0000a3c0, 0x20202020},
	{0x0000a3c4, 0x22222220},
	{0x0000a3c8, 0x20200020},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3d8, 0x20202020},
	{0x0000a3dc, 0x20202020},
	{0x0000a3e0, 0x20202020},
	{0x0000a3e4, 0x20202020},
	{0x0000a3e8, 0x20202020},
	{0x0000a3ec, 0x20202020},
	{0x0000a3f0, 0x00000000},
	{0x0000a3f4, 0x00000006},
	{0x0000a3f8, 0x0cdbd380},
	{0x0000a3fc, 0x000f0f01},
	{0x0000a400, 0x8fa91f01},
	{0x0000a404, 0x00000000},
	{0x0000a408, 0x0e79e5c6},
	{0x0000a40c, 0x00820820},
	{0x0000a414, 0x1ce739cf},
	{0x0000a418, 0x2d0019ce},
	{0x0000a41c, 0x1ce739ce},
	{0x0000a420, 0x000001ce},
	{0x0000a424, 0x1ce739ce},
	{0x0000a428, 0x000001ce},
	{0x0000a42c, 0x1ce739ce},
	{0x0000a430, 0x1ce739ce},
	{0x0000a434, 0x00000000},
	{0x0000a438, 0x00001801},
	{0x0000a43c, 0x00000000},
	{0x0000a440, 0x00000000},
	{0x0000a444, 0x00000000},
	{0x0000a448, 0x04000000},
	{0x0000a44c, 0x00000001},
	{0x0000a450, 0x00010000},
	{0x0000a5c4, 0xbfad9d74},
	{0x0000a5c8, 0x0048060a},
	{0x0000a5cc, 0x00000637},
	{0x0000a760, 0x03020100},
	{0x0000a764, 0x09080504},
	{0x0000a768, 0x0d0c0b0a},
	{0x0000a76c, 0x13121110},
	{0x0000a770, 0x31301514},
	{0x0000a774, 0x35343332},
	{0x0000a778, 0x00000036},
	{0x0000a780, 0x00000838},
	{0x0000a7c0, 0x00000000},
	{0x0000a7c4, 0xfffffffc},
	{0x0000a7c8, 0x00000000},
	{0x0000a7cc, 0x00000000},
	{0x0000a7d0, 0x00000000},
	{0x0000a7d4, 0x00000004},
	{0x0000a7dc, 0x00000000},
};

static __unused const u32 ar9485Common_1_1[][2] = {
	/*  Addr      allmodes */
	{0x00007010, 0x00000022},
	{0x00007020, 0x00000000},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
};

static __unused const u32 ar9485_1_1_baseband_postamble[][5] = {
	/* Addr       5G_HT20        5G_HT40       2G_HT40       2G_HT20 */
	{0x00009810, 0xd00a8005, 0xd00a8005, 0xd00a8005, 0xd00a8005},
	{0x00009820, 0x206a002e, 0x206a002e, 0x206a002e, 0x206a002e},
	{0x00009824, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0},
	{0x00009828, 0x06903081, 0x06903081, 0x06903881, 0x06903881},
	{0x0000982c, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
	{0x00009830, 0x0000059c, 0x0000059c, 0x0000059c, 0x0000059c},
	{0x00009c00, 0x00000044, 0x00000044, 0x00000044, 0x00000044},
	{0x00009e00, 0x0372161e, 0x0372161e, 0x037216a0, 0x037216a0},
	{0x00009e04, 0x00182020, 0x00182020, 0x00182020, 0x00182020},
	{0x00009e0c, 0x6c4000e2, 0x6d4000e2, 0x6d4000e2, 0x6c4000e2},
	{0x00009e10, 0x7ec88d2e, 0x7ec88d2e, 0x7ec80d2e, 0x7ec80d2e},
	{0x00009e14, 0x31395d5e, 0x3139605e, 0x3139605e, 0x31395d5e},
	{0x00009e18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009e1c, 0x0001cf9c, 0x0001cf9c, 0x00021f9c, 0x00021f9c},
	{0x00009e20, 0x000003b5, 0x000003b5, 0x000003ce, 0x000003ce},
	{0x00009e2c, 0x0000001c, 0x0000001c, 0x00000021, 0x00000021},
	{0x00009e3c, 0xcf946220, 0xcf946220, 0xcf946222, 0xcf946222},
	{0x00009e44, 0x02321e27, 0x02321e27, 0x02282324, 0x02282324},
	{0x00009e48, 0x5030201a, 0x5030201a, 0x50302010, 0x50302010},
	{0x00009fc8, 0x0003f000, 0x0003f000, 0x0001a000, 0x0001a000},
	{0x0000a204, 0x01303fc0, 0x01303fc4, 0x01303fc4, 0x01303fc0},
	{0x0000a208, 0x00000104, 0x00000104, 0x00000004, 0x00000004},
	{0x0000a230, 0x0000400a, 0x00004014, 0x00004016, 0x0000400b},
	{0x0000a234, 0x10000fff, 0x10000fff, 0x10000fff, 0x10000fff},
	{0x0000a238, 0xffb81018, 0xffb81018, 0xffb81018, 0xffb81018},
	{0x0000a250, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a254, 0x000007d0, 0x00000fa0, 0x00001130, 0x00000898},
	{0x0000a258, 0x02020002, 0x02020002, 0x02020002, 0x02020002},
	{0x0000a25c, 0x01000e0e, 0x01000e0e, 0x01000e0e, 0x01000e0e},
	{0x0000a260, 0x3a021501, 0x3a021501, 0x3a021501, 0x3a021501},
	{0x0000a264, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e},
	{0x0000a280, 0x00000007, 0x00000007, 0x0000000b, 0x0000000b},
	{0x0000a284, 0x00000000, 0x00000000, 0x000002a0, 0x000002a0},
	{0x0000a288, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a28c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a2c4, 0x00158d18, 0x00158d18, 0x00158d18, 0x00158d18},
	{0x0000a2d0, 0x00071981, 0x00071981, 0x00071982, 0x00071982},
	{0x0000a2d8, 0xf999a83a, 0xf999a83a, 0xf999a83a, 0xf999a83a},
	{0x0000a358, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000be04, 0x00802020, 0x00802020, 0x00802020, 0x00802020},
	{0x0000be18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
};

static __unused const u32 ar9485Modes_high_ob_db_tx_gain_1_1[][5] = {
	/* Addr        5G_HT20       5G_HT40       2G_HT40       2G_HT20 */
	{0x000098bc, 0x00000002, 0x00000002, 0x00000002, 0x00000002},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d8, 0x000050d8},
	{0x0000a458, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a500, 0x00022200, 0x00022200, 0x00000000, 0x00000000},
	{0x0000a504, 0x05062002, 0x05062002, 0x04000002, 0x04000002},
	{0x0000a508, 0x0c002e00, 0x0c002e00, 0x08000004, 0x08000004},
	{0x0000a50c, 0x11062202, 0x11062202, 0x0d000200, 0x0d000200},
	{0x0000a510, 0x17022e00, 0x17022e00, 0x11000202, 0x11000202},
	{0x0000a514, 0x1d000ec2, 0x1d000ec2, 0x15000400, 0x15000400},
	{0x0000a518, 0x25020ec0, 0x25020ec0, 0x19000402, 0x19000402},
	{0x0000a51c, 0x2b020ec3, 0x2b020ec3, 0x1d000404, 0x1d000404},
	{0x0000a520, 0x2f001f04, 0x2f001f04, 0x21000603, 0x21000603},
	{0x0000a524, 0x35001fc4, 0x35001fc4, 0x25000605, 0x25000605},
	{0x0000a528, 0x3c022f04, 0x3c022f04, 0x2a000a03, 0x2a000a03},
	{0x0000a52c, 0x41023e85, 0x41023e85, 0x2c000a04, 0x2c000a04},
	{0x0000a530, 0x48023ec6, 0x48023ec6, 0x34000e20, 0x34000e20},
	{0x0000a534, 0x4d023f01, 0x4d023f01, 0x35000e21, 0x35000e21},
	{0x0000a538, 0x53023f4b, 0x53023f4b, 0x43000e62, 0x43000e62},
	{0x0000a53c, 0x5a027f09, 0x5a027f09, 0x45000e63, 0x45000e63},
	{0x0000a540, 0x5f027fc9, 0x5f027fc9, 0x49000e65, 0x49000e65},
	{0x0000a544, 0x6502feca, 0x6502feca, 0x4b000e66, 0x4b000e66},
	{0x0000a548, 0x6b02ff4a, 0x6b02ff4a, 0x4d001645, 0x4d001645},
	{0x0000a54c, 0x7203feca, 0x7203feca, 0x51001865, 0x51001865},
	{0x0000a550, 0x7703ff0b, 0x7703ff0b, 0x55001a86, 0x55001a86},
	{0x0000a554, 0x7d06ffcb, 0x7d06ffcb, 0x57001ce9, 0x57001ce9},
	{0x0000a558, 0x8407ff0b, 0x8407ff0b, 0x5a001ceb, 0x5a001ceb},
	{0x0000a55c, 0x8907ffcb, 0x8907ffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a560, 0x900fff0b, 0x900fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a564, 0x960fffcb, 0x960fffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a568, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a56c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a570, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a574, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a578, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a57c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000b500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b504, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b508, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b50c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b510, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b514, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b518, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b51c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b520, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b524, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b528, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b52c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b530, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b534, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b538, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b53c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b540, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b544, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b548, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b54c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b550, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b554, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b558, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b55c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b560, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b564, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b568, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b56c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b570, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b574, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b578, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b57c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00016044, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db},
	{0x00016048, 0x6c924260, 0x6c924260, 0x6c924260, 0x6c924260},
};

static __unused const u32 ar9485_modes_lowest_ob_db_tx_gain_1_1[][5] = {
	/* Addr        5G_HT20       5G_HT40       2G_HT40       2G_HT20  */
	{0x000098bc, 0x00000002, 0x00000002, 0x00000002, 0x00000002},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d8, 0x000050d8},
	{0x0000a458, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a500, 0x00022200, 0x00022200, 0x00000000, 0x00000000},
	{0x0000a504, 0x05062002, 0x05062002, 0x04000002, 0x04000002},
	{0x0000a508, 0x0c002e00, 0x0c002e00, 0x08000004, 0x08000004},
	{0x0000a50c, 0x11062202, 0x11062202, 0x0d000200, 0x0d000200},
	{0x0000a510, 0x17022e00, 0x17022e00, 0x11000202, 0x11000202},
	{0x0000a514, 0x1d000ec2, 0x1d000ec2, 0x15000400, 0x15000400},
	{0x0000a518, 0x25020ec0, 0x25020ec0, 0x19000402, 0x19000402},
	{0x0000a51c, 0x2b020ec3, 0x2b020ec3, 0x1d000404, 0x1d000404},
	{0x0000a520, 0x2f001f04, 0x2f001f04, 0x21000603, 0x21000603},
	{0x0000a524, 0x35001fc4, 0x35001fc4, 0x25000605, 0x25000605},
	{0x0000a528, 0x3c022f04, 0x3c022f04, 0x2a000a03, 0x2a000a03},
	{0x0000a52c, 0x41023e85, 0x41023e85, 0x2c000a04, 0x2c000a04},
	{0x0000a530, 0x48023ec6, 0x48023ec6, 0x34000e20, 0x34000e20},
	{0x0000a534, 0x4d023f01, 0x4d023f01, 0x35000e21, 0x35000e21},
	{0x0000a538, 0x53023f4b, 0x53023f4b, 0x43000e62, 0x43000e62},
	{0x0000a53c, 0x5a027f09, 0x5a027f09, 0x45000e63, 0x45000e63},
	{0x0000a540, 0x5f027fc9, 0x5f027fc9, 0x49000e65, 0x49000e65},
	{0x0000a544, 0x6502feca, 0x6502feca, 0x4b000e66, 0x4b000e66},
	{0x0000a548, 0x6b02ff4a, 0x6b02ff4a, 0x4d001645, 0x4d001645},
	{0x0000a54c, 0x7203feca, 0x7203feca, 0x51001865, 0x51001865},
	{0x0000a550, 0x7703ff0b, 0x7703ff0b, 0x55001a86, 0x55001a86},
	{0x0000a554, 0x7d06ffcb, 0x7d06ffcb, 0x57001ce9, 0x57001ce9},
	{0x0000a558, 0x8407ff0b, 0x8407ff0b, 0x5a001ceb, 0x5a001ceb},
	{0x0000a55c, 0x8907ffcb, 0x8907ffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a560, 0x900fff0b, 0x900fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a564, 0x960fffcb, 0x960fffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a568, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a56c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a570, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a574, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a578, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a57c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000b500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b504, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b508, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b50c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b510, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b514, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b518, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b51c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b520, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b524, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b528, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b52c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b530, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b534, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b538, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b53c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b540, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b544, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b548, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b54c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b550, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b554, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b558, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b55c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b560, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b564, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b568, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b56c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b570, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b574, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b578, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b57c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00016044, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db},
	{0x00016048, 0x6c924260, 0x6c924260, 0x6c924260, 0x6c924260},
};

static __unused const u32 ar9485_1_1_radio_postamble[][2] = {
	/* Addr        allmodes */
	{0x0001609c, 0x0b283f31},
	{0x000160ac, 0x24611800},
	{0x000160b0, 0x03284f3e},
	{0x0001610c, 0x00170000},
	{0x00016140, 0x10804008},
};

static __unused const u32 ar9485_1_1_mac_postamble[][5] = {
	/* Addr        5G_HT20       5G_HT40       2G_HT40       2G_HT20 */
	{0x00001030, 0x00000230, 0x00000460, 0x000002c0, 0x00000160},
	{0x00001070, 0x00000168, 0x000002d0, 0x00000318, 0x0000018c},
	{0x000010b0, 0x00000e60, 0x00001cc0, 0x00007c70, 0x00003e38},
	{0x00008014, 0x03e803e8, 0x07d007d0, 0x10801600, 0x08400b00},
	{0x0000801c, 0x128d8027, 0x128d804f, 0x12e00057, 0x12e0002b},
	{0x00008120, 0x08f04800, 0x08f04800, 0x08f04810, 0x08f04810},
	{0x000081d0, 0x00003210, 0x00003210, 0x0000320a, 0x0000320a},
	{0x00008318, 0x00003e80, 0x00007d00, 0x00006880, 0x00003440},
};

static __unused const u32 ar9485_1_1_radio_core[][2] = {
	/* Addr        allmodes */
	{0x00016000, 0x36db6db6},
	{0x00016004, 0x6db6db40},
	{0x00016008, 0x73800000},
	{0x0001600c, 0x00000000},
	{0x00016040, 0x7f80fff8},
	{0x0001604c, 0x000f0278},
	{0x00016050, 0x4db6db8c},
	{0x00016054, 0x6db60000},
	{0x00016080, 0x00080000},
	{0x00016084, 0x0e48048c},
	{0x00016088, 0x14214514},
	{0x0001608c, 0x119f081e},
	{0x00016090, 0x24926490},
	{0x00016098, 0xd28b3330},
	{0x000160a0, 0xc2108ffe},
	{0x000160a4, 0x812fc370},
	{0x000160a8, 0x423c8000},
	{0x000160b4, 0x92480040},
	{0x000160c0, 0x006db6db},
	{0x000160c4, 0x0186db60},
	{0x000160c8, 0x6db6db6c},
	{0x000160cc, 0x6de6fbe0},
	{0x000160d0, 0xf7dfcf3c},
	{0x00016100, 0x04cb0001},
	{0x00016104, 0xfff80015},
	{0x00016108, 0x00080010},
	{0x00016144, 0x01884080},
	{0x00016148, 0x00008040},
	{0x00016240, 0x08400000},
	{0x00016244, 0x1bf90f00},
	{0x00016248, 0x00000000},
	{0x0001624c, 0x00000000},
	{0x00016280, 0x01000015},
	{0x00016284, 0x00d30000},
	{0x00016288, 0x00318000},
	{0x0001628c, 0x50000000},
	{0x00016290, 0x4b96210f},
	{0x00016380, 0x00000000},
	{0x00016384, 0x00000000},
	{0x00016388, 0x00800700},
	{0x0001638c, 0x00800700},
	{0x00016390, 0x00800700},
	{0x00016394, 0x00000000},
	{0x00016398, 0x00000000},
	{0x0001639c, 0x00000000},
	{0x000163a0, 0x00000001},
	{0x000163a4, 0x00000001},
	{0x000163a8, 0x00000000},
	{0x000163ac, 0x00000000},
	{0x000163b0, 0x00000000},
	{0x000163b4, 0x00000000},
	{0x000163b8, 0x00000000},
	{0x000163bc, 0x00000000},
	{0x000163c0, 0x000000a0},
	{0x000163c4, 0x000c0000},
	{0x000163c8, 0x14021402},
	{0x000163cc, 0x00001402},
	{0x000163d0, 0x00000000},
	{0x000163d4, 0x00000000},
	{0x00016c40, 0x13188278},
	{0x00016c44, 0x12000000},
};

static __unused const u32 ar9485_1_1_pcie_phy_pll_on_clkreq_enable_L1[][2] = {
	/* Addr        allmodes */
	{0x00018c00, 0x10052e5e},
	{0x00018c04, 0x000801d8},
	{0x00018c08, 0x0000080c},
};

static __unused const u32 ar9485Modes_high_power_tx_gain_1_1[][5] = {
	/* Addr        5G_HT20       5G_HT40       2G_HT40       2G_HT20 */
	{0x000098bc, 0x00000002, 0x00000002, 0x00000002, 0x00000002},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d8, 0x000050d8},
	{0x0000a458, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a500, 0x00022200, 0x00022200, 0x00000000, 0x00000000},
	{0x0000a504, 0x05062002, 0x05062002, 0x04000002, 0x04000002},
	{0x0000a508, 0x0c002e00, 0x0c002e00, 0x08000004, 0x08000004},
	{0x0000a50c, 0x11062202, 0x11062202, 0x0d000200, 0x0d000200},
	{0x0000a510, 0x17022e00, 0x17022e00, 0x11000202, 0x11000202},
	{0x0000a514, 0x1d000ec2, 0x1d000ec2, 0x15000400, 0x15000400},
	{0x0000a518, 0x25020ec0, 0x25020ec0, 0x19000402, 0x19000402},
	{0x0000a51c, 0x2b020ec3, 0x2b020ec3, 0x1d000404, 0x1d000404},
	{0x0000a520, 0x2f001f04, 0x2f001f04, 0x21000603, 0x21000603},
	{0x0000a524, 0x35001fc4, 0x35001fc4, 0x25000605, 0x25000605},
	{0x0000a528, 0x3c022f04, 0x3c022f04, 0x2a000a03, 0x2a000a03},
	{0x0000a52c, 0x41023e85, 0x41023e85, 0x2c000a04, 0x2c000a04},
	{0x0000a530, 0x48023ec6, 0x48023ec6, 0x34000e20, 0x34000e20},
	{0x0000a534, 0x4d023f01, 0x4d023f01, 0x35000e21, 0x35000e21},
	{0x0000a538, 0x53023f4b, 0x53023f4b, 0x43000e62, 0x43000e62},
	{0x0000a53c, 0x5a027f09, 0x5a027f09, 0x45000e63, 0x45000e63},
	{0x0000a540, 0x5f027fc9, 0x5f027fc9, 0x49000e65, 0x49000e65},
	{0x0000a544, 0x6502feca, 0x6502feca, 0x4b000e66, 0x4b000e66},
	{0x0000a548, 0x6b02ff4a, 0x6b02ff4a, 0x4d001645, 0x4d001645},
	{0x0000a54c, 0x7203feca, 0x7203feca, 0x51001865, 0x51001865},
	{0x0000a550, 0x7703ff0b, 0x7703ff0b, 0x55001a86, 0x55001a86},
	{0x0000a554, 0x7d06ffcb, 0x7d06ffcb, 0x57001ce9, 0x57001ce9},
	{0x0000a558, 0x8407ff0b, 0x8407ff0b, 0x5a001ceb, 0x5a001ceb},
	{0x0000a55c, 0x8907ffcb, 0x8907ffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a560, 0x900fff0b, 0x900fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a564, 0x960fffcb, 0x960fffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a568, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a56c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a570, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a574, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a578, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a57c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000b500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b504, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b508, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b50c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b510, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b514, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b518, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b51c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b520, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b524, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b528, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b52c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b530, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b534, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b538, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b53c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b540, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b544, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b548, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b54c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b550, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b554, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b558, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b55c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b560, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b564, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b568, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b56c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b570, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b574, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b578, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b57c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00016044, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db},
	{0x00016048, 0x6c924260, 0x6c924260, 0x6c924260, 0x6c924260},
};

static __unused const u32 ar9485_1_1[][2] = {
	/* Addr        allmodes */
	{0x0000a580, 0x00000000},
	{0x0000a584, 0x00000000},
	{0x0000a588, 0x00000000},
	{0x0000a58c, 0x00000000},
	{0x0000a590, 0x00000000},
	{0x0000a594, 0x00000000},
	{0x0000a598, 0x00000000},
	{0x0000a59c, 0x00000000},
	{0x0000a5a0, 0x00000000},
	{0x0000a5a4, 0x00000000},
	{0x0000a5a8, 0x00000000},
	{0x0000a5ac, 0x00000000},
	{0x0000a5b0, 0x00000000},
	{0x0000a5b4, 0x00000000},
	{0x0000a5b8, 0x00000000},
	{0x0000a5bc, 0x00000000},
};

static __unused const u32 ar9485_modes_green_ob_db_tx_gain_1_1[][5] = {
	/* Addr        5G_HT20       5G_HT40       2G_HT40       2G_HT20 */
	{0x000098bc, 0x00000003, 0x00000003, 0x00000003, 0x00000003},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d8, 0x000050d8},
	{0x0000a458, 0x80000000, 0x80000000, 0x80000000, 0x80000000},
	{0x0000a500, 0x00022200, 0x00022200, 0x00000006, 0x00000006},
	{0x0000a504, 0x05062002, 0x05062002, 0x03000201, 0x03000201},
	{0x0000a508, 0x0c002e00, 0x0c002e00, 0x06000203, 0x06000203},
	{0x0000a50c, 0x11062202, 0x11062202, 0x0a000401, 0x0a000401},
	{0x0000a510, 0x17022e00, 0x17022e00, 0x0e000403, 0x0e000403},
	{0x0000a514, 0x1d000ec2, 0x1d000ec2, 0x12000405, 0x12000405},
	{0x0000a518, 0x25020ec0, 0x25020ec0, 0x15000604, 0x15000604},
	{0x0000a51c, 0x2b020ec3, 0x2b020ec3, 0x18000605, 0x18000605},
	{0x0000a520, 0x2f001f04, 0x2f001f04, 0x1c000a04, 0x1c000a04},
	{0x0000a524, 0x35001fc4, 0x35001fc4, 0x21000a06, 0x21000a06},
	{0x0000a528, 0x3c022f04, 0x3c022f04, 0x29000a24, 0x29000a24},
	{0x0000a52c, 0x41023e85, 0x41023e85, 0x2f000e21, 0x2f000e21},
	{0x0000a530, 0x48023ec6, 0x48023ec6, 0x31000e20, 0x31000e20},
	{0x0000a534, 0x4d023f01, 0x4d023f01, 0x33000e20, 0x33000e20},
	{0x0000a538, 0x53023f4b, 0x53023f4b, 0x43000e62, 0x43000e62},
	{0x0000a53c, 0x5a027f09, 0x5a027f09, 0x45000e63, 0x45000e63},
	{0x0000a540, 0x5f027fc9, 0x5f027fc9, 0x49000e65, 0x49000e65},
	{0x0000a544, 0x6502feca, 0x6502feca, 0x4b000e66, 0x4b000e66},
	{0x0000a548, 0x6b02ff4a, 0x6b02ff4a, 0x4d001645, 0x4d001645},
	{0x0000a54c, 0x7203feca, 0x7203feca, 0x51001865, 0x51001865},
	{0x0000a550, 0x7703ff0b, 0x7703ff0b, 0x55001a86, 0x55001a86},
	{0x0000a554, 0x7d06ffcb, 0x7d06ffcb, 0x57001ce9, 0x57001ce9},
	{0x0000a558, 0x8407ff0b, 0x8407ff0b, 0x5a001ceb, 0x5a001ceb},
	{0x0000a55c, 0x8907ffcb, 0x8907ffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a560, 0x900fff0b, 0x900fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a564, 0x960fffcb, 0x960fffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a568, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a56c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a570, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a574, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a578, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a57c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000b500, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b504, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b508, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b50c, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b510, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b514, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b518, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b51c, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b520, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b524, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b528, 0x0000001a, 0x0000001a, 0x0000001a, 0x0000001a},
	{0x0000b52c, 0x0000002a, 0x0000002a, 0x0000002a, 0x0000002a},
	{0x0000b530, 0x0000003a, 0x0000003a, 0x0000003a, 0x0000003a},
	{0x0000b534, 0x0000004a, 0x0000004a, 0x0000004a, 0x0000004a},
	{0x0000b538, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b53c, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b540, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b544, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b548, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b54c, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b550, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b554, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b558, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b55c, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b560, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b564, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b568, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b56c, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b570, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b574, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b578, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x0000b57c, 0x0000005b, 0x0000005b, 0x0000005b, 0x0000005b},
	{0x00016044, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db},
	{0x00016048, 0x6c924260, 0x6c924260, 0x6c924260, 0x6c924260},
};

static __unused const u32 ar9485_1_1_pcie_phy_clkreq_disable_L1[][2] = {
	/* Addr        allmodes */
	{0x00018c00, 0x10013e5e},
	{0x00018c04, 0x000801d8},
	{0x00018c08, 0x0000080c},
};

static __unused const u32 ar9485_1_1_soc_preamble[][2] = {
	/* Addr        allmodes */
	{0x00004014, 0xba280400},
	{0x00004090, 0x00aa10aa},
	{0x000040a4, 0x00a0c9c9},
	{0x00007010, 0x00000022},
	{0x00007020, 0x00000000},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
	{0x00007048, 0x00000002},
};

static __unused const u32 ar9485_1_1_baseband_core_txfir_coeff_japan_2484[][2] = {
	/* Addr        allmodes */
	{0x0000a398, 0x00000000},
	{0x0000a39c, 0x6f7f0301},
	{0x0000a3a0, 0xca9228ee},
};

static __unused const u32 ar9485Modes_low_ob_db_tx_gain_1_1[][5] = {
	/* Addr        5G_HT20       5G_HT40       2G_HT40       2G_HT20  */
	{0x000098bc, 0x00000002, 0x00000002, 0x00000002, 0x00000002},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d8, 0x000050d8},
	{0x0000a458, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a500, 0x00022200, 0x00022200, 0x00000000, 0x00000000},
	{0x0000a504, 0x05062002, 0x05062002, 0x04000002, 0x04000002},
	{0x0000a508, 0x0c002e00, 0x0c002e00, 0x08000004, 0x08000004},
	{0x0000a50c, 0x11062202, 0x11062202, 0x0d000200, 0x0d000200},
	{0x0000a510, 0x17022e00, 0x17022e00, 0x11000202, 0x11000202},
	{0x0000a514, 0x1d000ec2, 0x1d000ec2, 0x15000400, 0x15000400},
	{0x0000a518, 0x25020ec0, 0x25020ec0, 0x19000402, 0x19000402},
	{0x0000a51c, 0x2b020ec3, 0x2b020ec3, 0x1d000404, 0x1d000404},
	{0x0000a520, 0x2f001f04, 0x2f001f04, 0x21000603, 0x21000603},
	{0x0000a524, 0x35001fc4, 0x35001fc4, 0x25000605, 0x25000605},
	{0x0000a528, 0x3c022f04, 0x3c022f04, 0x2a000a03, 0x2a000a03},
	{0x0000a52c, 0x41023e85, 0x41023e85, 0x2c000a04, 0x2c000a04},
	{0x0000a530, 0x48023ec6, 0x48023ec6, 0x34000e20, 0x34000e20},
	{0x0000a534, 0x4d023f01, 0x4d023f01, 0x35000e21, 0x35000e21},
	{0x0000a538, 0x53023f4b, 0x53023f4b, 0x43000e62, 0x43000e62},
	{0x0000a53c, 0x5a027f09, 0x5a027f09, 0x45000e63, 0x45000e63},
	{0x0000a540, 0x5f027fc9, 0x5f027fc9, 0x49000e65, 0x49000e65},
	{0x0000a544, 0x6502feca, 0x6502feca, 0x4b000e66, 0x4b000e66},
	{0x0000a548, 0x6b02ff4a, 0x6b02ff4a, 0x4d001645, 0x4d001645},
	{0x0000a54c, 0x7203feca, 0x7203feca, 0x51001865, 0x51001865},
	{0x0000a550, 0x7703ff0b, 0x7703ff0b, 0x55001a86, 0x55001a86},
	{0x0000a554, 0x7d06ffcb, 0x7d06ffcb, 0x57001ce9, 0x57001ce9},
	{0x0000a558, 0x8407ff0b, 0x8407ff0b, 0x5a001ceb, 0x5a001ceb},
	{0x0000a55c, 0x8907ffcb, 0x8907ffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a560, 0x900fff0b, 0x900fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a564, 0x960fffcb, 0x960fffcb, 0x5e001eeb, 0x5e001eeb},
	{0x0000a568, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a56c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a570, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a574, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a578, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000a57c, 0x9c1fff0b, 0x9c1fff0b, 0x5e001eeb, 0x5e001eeb},
	{0x0000b500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b504, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b508, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b50c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b510, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b514, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b518, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b51c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b520, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b524, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b528, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b52c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b530, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b534, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b538, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b53c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b540, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b544, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b548, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b54c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b550, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b554, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b558, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b55c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b560, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b564, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b568, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b56c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b570, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b574, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b578, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b57c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00016044, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db, 0x05d6b2db},
	{0x00016048, 0x6c924260, 0x6c924260, 0x6c924260, 0x6c924260},
};

static __unused const u32 ar9485_fast_clock_1_1_baseband_postamble[][3] = {
	/* Addr        5G_HT2        5G_HT40  */
	{0x00009e00, 0x03721821, 0x03721821},
	{0x0000a230, 0x0000400b, 0x00004016},
	{0x0000a254, 0x00000898, 0x00001130},
};

static __unused const u32 ar9485_1_1_pcie_phy_pll_on_clkreq_disable_L1[][2] = {
	/* Addr        allmodes  */
	{0x00018c00, 0x10012e5e},
	{0x00018c04, 0x000801d8},
	{0x00018c08, 0x0000080c},
};

static __unused const u32 ar9485_common_rx_gain_1_1[][2] = {
	/* Addr        allmodes */
	{0x0000a000, 0x00010000},
	{0x0000a004, 0x00030002},
	{0x0000a008, 0x00050004},
	{0x0000a00c, 0x00810080},
	{0x0000a010, 0x01800082},
	{0x0000a014, 0x01820181},
	{0x0000a018, 0x01840183},
	{0x0000a01c, 0x01880185},
	{0x0000a020, 0x018a0189},
	{0x0000a024, 0x02850284},
	{0x0000a028, 0x02890288},
	{0x0000a02c, 0x03850384},
	{0x0000a030, 0x03890388},
	{0x0000a034, 0x038b038a},
	{0x0000a038, 0x038d038c},
	{0x0000a03c, 0x03910390},
	{0x0000a040, 0x03930392},
	{0x0000a044, 0x03950394},
	{0x0000a048, 0x00000396},
	{0x0000a04c, 0x00000000},
	{0x0000a050, 0x00000000},
	{0x0000a054, 0x00000000},
	{0x0000a058, 0x00000000},
	{0x0000a05c, 0x00000000},
	{0x0000a060, 0x00000000},
	{0x0000a064, 0x00000000},
	{0x0000a068, 0x00000000},
	{0x0000a06c, 0x00000000},
	{0x0000a070, 0x00000000},
	{0x0000a074, 0x00000000},
	{0x0000a078, 0x00000000},
	{0x0000a07c, 0x00000000},
	{0x0000a080, 0x28282828},
	{0x0000a084, 0x28282828},
	{0x0000a088, 0x28282828},
	{0x0000a08c, 0x28282828},
	{0x0000a090, 0x28282828},
	{0x0000a094, 0x21212128},
	{0x0000a098, 0x171c1c1c},
	{0x0000a09c, 0x02020212},
	{0x0000a0a0, 0x00000202},
	{0x0000a0a4, 0x00000000},
	{0x0000a0a8, 0x00000000},
	{0x0000a0ac, 0x00000000},
	{0x0000a0b0, 0x00000000},
	{0x0000a0b4, 0x00000000},
	{0x0000a0b8, 0x00000000},
	{0x0000a0bc, 0x00000000},
	{0x0000a0c0, 0x001f0000},
	{0x0000a0c4, 0x111f1100},
	{0x0000a0c8, 0x111d111e},
	{0x0000a0cc, 0x111b111c},
	{0x0000a0d0, 0x22032204},
	{0x0000a0d4, 0x22012202},
	{0x0000a0d8, 0x221f2200},
	{0x0000a0dc, 0x221d221e},
	{0x0000a0e0, 0x33013302},
	{0x0000a0e4, 0x331f3300},
	{0x0000a0e8, 0x4402331e},
	{0x0000a0ec, 0x44004401},
	{0x0000a0f0, 0x441e441f},
	{0x0000a0f4, 0x55015502},
	{0x0000a0f8, 0x551f5500},
	{0x0000a0fc, 0x6602551e},
	{0x0000a100, 0x66006601},
	{0x0000a104, 0x661e661f},
	{0x0000a108, 0x7703661d},
	{0x0000a10c, 0x77017702},
	{0x0000a110, 0x00007700},
	{0x0000a114, 0x00000000},
	{0x0000a118, 0x00000000},
	{0x0000a11c, 0x00000000},
	{0x0000a120, 0x00000000},
	{0x0000a124, 0x00000000},
	{0x0000a128, 0x00000000},
	{0x0000a12c, 0x00000000},
	{0x0000a130, 0x00000000},
	{0x0000a134, 0x00000000},
	{0x0000a138, 0x00000000},
	{0x0000a13c, 0x00000000},
	{0x0000a140, 0x001f0000},
	{0x0000a144, 0x111f1100},
	{0x0000a148, 0x111d111e},
	{0x0000a14c, 0x111b111c},
	{0x0000a150, 0x22032204},
	{0x0000a154, 0x22012202},
	{0x0000a158, 0x221f2200},
	{0x0000a15c, 0x221d221e},
	{0x0000a160, 0x33013302},
	{0x0000a164, 0x331f3300},
	{0x0000a168, 0x4402331e},
	{0x0000a16c, 0x44004401},
	{0x0000a170, 0x441e441f},
	{0x0000a174, 0x55015502},
	{0x0000a178, 0x551f5500},
	{0x0000a17c, 0x6602551e},
	{0x0000a180, 0x66006601},
	{0x0000a184, 0x661e661f},
	{0x0000a188, 0x7703661d},
	{0x0000a18c, 0x77017702},
	{0x0000a190, 0x00007700},
	{0x0000a194, 0x00000000},
	{0x0000a198, 0x00000000},
	{0x0000a19c, 0x00000000},
	{0x0000a1a0, 0x00000000},
	{0x0000a1a4, 0x00000000},
	{0x0000a1a8, 0x00000000},
	{0x0000a1ac, 0x00000000},
	{0x0000a1b0, 0x00000000},
	{0x0000a1b4, 0x00000000},
	{0x0000a1b8, 0x00000000},
	{0x0000a1bc, 0x00000000},
	{0x0000a1c0, 0x00000000},
	{0x0000a1c4, 0x00000000},
	{0x0000a1c8, 0x00000000},
	{0x0000a1cc, 0x00000000},
	{0x0000a1d0, 0x00000000},
	{0x0000a1d4, 0x00000000},
	{0x0000a1d8, 0x00000000},
	{0x0000a1dc, 0x00000000},
	{0x0000a1e0, 0x00000000},
	{0x0000a1e4, 0x00000000},
	{0x0000a1e8, 0x00000000},
	{0x0000a1ec, 0x00000000},
	{0x0000a1f0, 0x00000396},
	{0x0000a1f4, 0x00000396},
	{0x0000a1f8, 0x00000396},
	{0x0000a1fc, 0x00000296},
};

static __unused const u32 ar9485_1_1_pcie_phy_clkreq_enable_L1[][2] = {
	/* Addr        allmodes */
	{0x00018c00, 0x10053e5e},
	{0x00018c04, 0x000801d8},
	{0x00018c08, 0x0000080c},
};

static __unused const u32 ar9485Common_wo_xlna_rx_gain_1_1[][2] = {
	/* Addr        allmodes */
	{0x0000a000, 0x00060005},
	{0x0000a004, 0x00810080},
	{0x0000a008, 0x00830082},
	{0x0000a00c, 0x00850084},
	{0x0000a010, 0x01820181},
	{0x0000a014, 0x01840183},
	{0x0000a018, 0x01880185},
	{0x0000a01c, 0x018a0189},
	{0x0000a020, 0x02850284},
	{0x0000a024, 0x02890288},
	{0x0000a028, 0x028b028a},
	{0x0000a02c, 0x03850384},
	{0x0000a030, 0x03890388},
	{0x0000a034, 0x038b038a},
	{0x0000a038, 0x038d038c},
	{0x0000a03c, 0x03910390},
	{0x0000a040, 0x03930392},
	{0x0000a044, 0x03950394},
	{0x0000a048, 0x00000396},
	{0x0000a04c, 0x00000000},
	{0x0000a050, 0x00000000},
	{0x0000a054, 0x00000000},
	{0x0000a058, 0x00000000},
	{0x0000a05c, 0x00000000},
	{0x0000a060, 0x00000000},
	{0x0000a064, 0x00000000},
	{0x0000a068, 0x00000000},
	{0x0000a06c, 0x00000000},
	{0x0000a070, 0x00000000},
	{0x0000a074, 0x00000000},
	{0x0000a078, 0x00000000},
	{0x0000a07c, 0x00000000},
	{0x0000a080, 0x28282828},
	{0x0000a084, 0x28282828},
	{0x0000a088, 0x28282828},
	{0x0000a08c, 0x28282828},
	{0x0000a090, 0x28282828},
	{0x0000a094, 0x24242428},
	{0x0000a098, 0x171e1e1e},
	{0x0000a09c, 0x02020b0b},
	{0x0000a0a0, 0x02020202},
	{0x0000a0a4, 0x00000000},
	{0x0000a0a8, 0x00000000},
	{0x0000a0ac, 0x00000000},
	{0x0000a0b0, 0x00000000},
	{0x0000a0b4, 0x00000000},
	{0x0000a0b8, 0x00000000},
	{0x0000a0bc, 0x00000000},
	{0x0000a0c0, 0x22072208},
	{0x0000a0c4, 0x22052206},
	{0x0000a0c8, 0x22032204},
	{0x0000a0cc, 0x22012202},
	{0x0000a0d0, 0x221f2200},
	{0x0000a0d4, 0x221d221e},
	{0x0000a0d8, 0x33023303},
	{0x0000a0dc, 0x33003301},
	{0x0000a0e0, 0x331e331f},
	{0x0000a0e4, 0x4402331d},
	{0x0000a0e8, 0x44004401},
	{0x0000a0ec, 0x441e441f},
	{0x0000a0f0, 0x55025503},
	{0x0000a0f4, 0x55005501},
	{0x0000a0f8, 0x551e551f},
	{0x0000a0fc, 0x6602551d},
	{0x0000a100, 0x66006601},
	{0x0000a104, 0x661e661f},
	{0x0000a108, 0x7703661d},
	{0x0000a10c, 0x77017702},
	{0x0000a110, 0x00007700},
	{0x0000a114, 0x00000000},
	{0x0000a118, 0x00000000},
	{0x0000a11c, 0x00000000},
	{0x0000a120, 0x00000000},
	{0x0000a124, 0x00000000},
	{0x0000a128, 0x00000000},
	{0x0000a12c, 0x00000000},
	{0x0000a130, 0x00000000},
	{0x0000a134, 0x00000000},
	{0x0000a138, 0x00000000},
	{0x0000a13c, 0x00000000},
	{0x0000a140, 0x001f0000},
	{0x0000a144, 0x111f1100},
	{0x0000a148, 0x111d111e},
	{0x0000a14c, 0x111b111c},
	{0x0000a150, 0x22032204},
	{0x0000a154, 0x22012202},
	{0x0000a158, 0x221f2200},
	{0x0000a15c, 0x221d221e},
	{0x0000a160, 0x33013302},
	{0x0000a164, 0x331f3300},
	{0x0000a168, 0x4402331e},
	{0x0000a16c, 0x44004401},
	{0x0000a170, 0x441e441f},
	{0x0000a174, 0x55015502},
	{0x0000a178, 0x551f5500},
	{0x0000a17c, 0x6602551e},
	{0x0000a180, 0x66006601},
	{0x0000a184, 0x661e661f},
	{0x0000a188, 0x7703661d},
	{0x0000a18c, 0x77017702},
	{0x0000a190, 0x00007700},
	{0x0000a194, 0x00000000},
	{0x0000a198, 0x00000000},
	{0x0000a19c, 0x00000000},
	{0x0000a1a0, 0x00000000},
	{0x0000a1a4, 0x00000000},
	{0x0000a1a8, 0x00000000},
	{0x0000a1ac, 0x00000000},
	{0x0000a1b0, 0x00000000},
	{0x0000a1b4, 0x00000000},
	{0x0000a1b8, 0x00000000},
	{0x0000a1bc, 0x00000000},
	{0x0000a1c0, 0x00000000},
	{0x0000a1c4, 0x00000000},
	{0x0000a1c8, 0x00000000},
	{0x0000a1cc, 0x00000000},
	{0x0000a1d0, 0x00000000},
	{0x0000a1d4, 0x00000000},
	{0x0000a1d8, 0x00000000},
	{0x0000a1dc, 0x00000000},
	{0x0000a1e0, 0x00000000},
	{0x0000a1e4, 0x00000000},
	{0x0000a1e8, 0x00000000},
	{0x0000a1ec, 0x00000000},
	{0x0000a1f0, 0x00000396},
	{0x0000a1f4, 0x00000396},
	{0x0000a1f8, 0x00000396},
	{0x0000a1fc, 0x00000296},
};

#endif
