/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes.xsd;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.jena.datatypes.xsd.AbstractDateTime;
import org.apache.jena.datatypes.xsd.IllegalDateTimeFieldException;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;

public class XSDDateTime
extends AbstractDateTime {
    public static final short YEAR_MASK = 1;
    public static final short MONTH_MASK = 2;
    public static final short DAY_MASK = 4;
    public static final short TIME_MASK = 8;
    public static final short FULL_MASK = 15;
    protected short mask;

    public XSDDateTime(Object value, int mask) {
        super(value);
        this.mask = (short)mask;
    }

    public XSDDateTime(Calendar date) {
        super(XSDDateTime.convertCalendar(date));
        this.mask = (short)15;
    }

    public XSDDatatype getNarrowedDatatype() {
        switch (this.mask) {
            case 8: {
                return XSDDatatype.XSDtime;
            }
            case 2: {
                return XSDDatatype.XSDgMonth;
            }
            case 4: {
                return XSDDatatype.XSDgDay;
            }
            case 1: {
                return XSDDatatype.XSDgYear;
            }
            case 6: {
                return XSDDatatype.XSDgMonthDay;
            }
            case 3: {
                return XSDDatatype.XSDgYearMonth;
            }
            case 7: {
                return XSDDatatype.XSDdate;
            }
        }
        return XSDDatatype.XSDdateTime;
    }

    public void narrowType(XSDDatatype dt) {
        if (dt.equals(XSDDatatype.XSDtime)) {
            this.mask = (short)8;
        } else if (dt.equals(XSDDatatype.XSDgMonth)) {
            this.mask = (short)2;
        } else if (dt.equals(XSDDatatype.XSDgDay)) {
            this.mask = (short)4;
        } else if (dt.equals(XSDDatatype.XSDgYear)) {
            this.mask = 1;
        } else if (dt.equals(XSDDatatype.XSDgMonthDay)) {
            this.mask = (short)6;
        } else if (dt.equals(XSDDatatype.XSDgYearMonth)) {
            this.mask = (short)3;
        } else if (dt.equals(XSDDatatype.XSDdate)) {
            this.mask = (short)7;
        }
    }

    private static int[] convertCalendar(Calendar date) {
        int[] data = new int[9];
        Calendar cal = (Calendar)date.clone();
        cal.get(15);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        data[0] = cal.get(1);
        data[1] = cal.get(2) + 1;
        data[2] = cal.get(5);
        data[3] = cal.get(11);
        data[4] = cal.get(12);
        data[5] = cal.get(13);
        data[7] = 90;
        int ms = cal.get(14);
        if (ms == 0) {
            data[6] = 0;
            data[8] = 0;
        } else if (ms % 100 == 0) {
            data[6] = ms / 100;
            data[8] = 1;
        } else if (ms % 10 == 0) {
            data[6] = ms / 10;
            data[8] = 2;
        } else {
            data[6] = ms;
            data[8] = 3;
        }
        return data;
    }

    public Calendar asCalendar() throws IllegalDateTimeFieldException {
        TimeZone tz = this.data[7] == 90 ? TimeZone.getTimeZone("GMT") : TimeZone.getDefault();
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(this.data[0], this.data[1] - 1, this.data[2], this.data[3], this.data[4], this.data[5]);
        calendar.set(14, (int)Math.round(1000.0 * this.fractionalSeconds));
        return calendar;
    }

    public int getYears() throws IllegalDateTimeFieldException {
        if ((this.mask & 1) == 0) {
            throw new IllegalDateTimeFieldException("Year not available");
        }
        return this.data[0];
    }

    public int getMonths() throws IllegalDateTimeFieldException {
        if ((this.mask & 2) == 0) {
            throw new IllegalDateTimeFieldException("Month not available");
        }
        return this.data[1];
    }

    public int getDays() throws IllegalDateTimeFieldException {
        if ((this.mask & 4) == 0) {
            throw new IllegalDateTimeFieldException("Day not available");
        }
        return this.data[2];
    }

    public int getHours() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[3];
    }

    public int getMinutes() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[4];
    }

    public int getFullSeconds() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[5];
    }

    public double getSeconds() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return (double)this.data[5] + this.fractionalSeconds;
    }

    public double getTimePart() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return (double)(((long)this.data[3] * 60L + (long)this.data[4]) * 60L) + this.getSeconds();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if ((this.mask & 1) != 0) {
            int cy = this.data[0];
            int absCY = Math.abs(cy);
            if (absCY < 10) {
                buff.append('0');
            }
            if (absCY < 100) {
                buff.append('0');
            }
            if (absCY < 1000) {
                buff.append('0');
            }
            buff.append(this.data[0]);
        } else {
            buff.append("-");
        }
        if ((this.mask & 6) != 0) {
            buff.append("-");
            if ((this.mask & 2) != 0) {
                if (this.data[1] <= 9) {
                    buff.append('0');
                }
                buff.append(this.data[1]);
            } else {
                buff.append("-");
            }
            if ((this.mask & 4) != 0) {
                if (this.mask != 4) {
                    buff.append('-');
                }
                if (this.data[2] <= 9) {
                    buff.append('0');
                }
                buff.append(this.data[2]);
            }
        }
        if ((this.mask & 8) != 0) {
            buff.append('T');
            buff.append(this.timeLexicalForm());
        }
        if (this.data[7] != 0) {
            buff.append('Z');
        }
        return buff.toString();
    }

    public String timeLexicalForm() {
        StringBuffer buff = new StringBuffer();
        if (this.data[3] < 10) {
            buff.append("0");
        }
        buff.append(this.data[3]);
        buff.append(":");
        if (this.data[4] < 10) {
            buff.append("0");
        }
        buff.append(this.data[4]);
        buff.append(":");
        if (this.data[5] < 10) {
            buff.append("0");
        }
        buff.append(this.data[5]);
        if (this.data[6] != 0) {
            buff.append(".");
            XSDAbstractDateTimeType.appendFractionalTime(buff, this.data[6], this.data[8]);
        }
        return buff.toString();
    }
}

