/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class PickAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    private Set<AttributeKey> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public PickAttributesAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, "edit.pickAttributes");
        this.setEnabled(true);
    }

    public void setExcludedAttributes(Set<AttributeKey> set) {
        this.excludedAttributes = set;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.pickAttributes();
    }

    public void pickAttributes() {
        DrawingEditor drawingEditor = this.getEditor();
        Set<Figure> set = this.getView().getSelectedFigures();
        if (set.size() > 0) {
            Figure figure = (Figure)set.iterator().next();
            for (Map.Entry<AttributeKey, Object> entry : figure.getAttributes().entrySet()) {
                if (this.excludedAttributes.contains(entry.getKey())) continue;
                drawingEditor.setDefaultAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

