/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.AttributeLineFigure;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;

public class PmWikiScribbleTool
extends AbstractTool {
    private AttributeLineFigure fScribble;
    private int fLastX;
    private int fLastY;
    private Figure myAddedFigure;
    private final boolean freeHandMode;

    public PmWikiScribbleTool(DrawingEditor drawingEditor, boolean bl) {
        super(drawingEditor);
        this.freeHandMode = bl;
    }

    public PmWikiScribbleTool(DrawingEditor drawingEditor) {
        this(drawingEditor, false);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.freeHandMode) {
            this.deactivate();
        } else if (mouseEvent.getClickCount() >= 2) {
            this.editor().toolDone();
        }
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        if (this.fScribble != null) {
            if (!(this.freeHandMode || this.fScribble.size().width >= 4 && this.fScribble.size().height >= 4)) {
                this.getActiveDrawing().remove(this.fScribble);
                this.setUndoActivity(null);
            }
            this.fScribble = null;
        }
    }

    private void point(int n, int n2) {
        if (this.fScribble == null) {
            this.fScribble = new AttributeLineFigure(new PolyLineFigure(n, n2));
            this.setAddedFigure(this.view().add(this.fScribble));
        } else if (this.fLastX != n || this.fLastY != n2) {
            this.fScribble.addPoint(n, n2);
        }
        this.fLastX = n;
        this.fLastY = n2;
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        if (mouseEvent.getClickCount() >= 2) {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
        } else if (this.freeHandMode) {
            this.point(mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.point(n, n2);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fScribble != null) {
            if (this.freeHandMode) {
                this.point(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.point(n, n2);
            }
        }
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    private void setAddedFigure(Figure figure) {
        this.myAddedFigure = figure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }
}

