/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.util.StandardStorageFormat;

public class SerializationStorageFormat
extends StandardStorageFormat {
    protected String createFileExtension() {
        return "ser";
    }

    public String createFileDescription() {
        return "Serialization (" + this.getFileExtension() + ")";
    }

    public String store(String string, Drawing drawing) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.adjustFileName(string));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(drawing);
        objectOutputStream.close();
        return this.adjustFileName(string);
    }

    public Drawing restore(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            return (Drawing)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Could not restore drawing '" + string + "': class not found!");
        }
    }
}

