/* src/mm/tlh.h

   Copyright (C) 2008
   CACAOVM - Verein zu Foerderung der freien virtuellen Machine CACAO

   This file is part of CACAO.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.

*/


#ifndef _MM_TLH_H
#define _MM_TLH_H

#include "config.h"

#include <stddef.h>
#include <stdint.h>

typedef struct {
	uint8_t *start;
	uint8_t *end;
	uint8_t *top;
	uint8_t *base;
	unsigned overflows;
} tlh_t;

#ifdef __cplusplus
extern "C" {
#endif

void tlh_init(tlh_t *tlh);

void tlh_destroy(tlh_t *tlh);

void tlh_add_frame(tlh_t *tlh);

void tlh_remove_frame(tlh_t *tlh);

void *tlh_alloc(tlh_t *tlh, size_t size);

#ifdef __cplusplus
}
#endif

#endif

/*
 * These are local overrides for various environment variables in Emacs.
 * Please do not remove this and leave it at the end of the file, where
 * Emacs will automagically detect them.
 * ---------------------------------------------------------------------
 * Local variables:
 * mode: c
 * indent-tabs-mode: t
 * c-basic-offset: 4
 * tab-width: 4
 * End:
 * vim:noexpandtab:sw=4:ts=4:
 */
