# PySNMP SMI module. Autogenerated from smidump -f python DECNET-PHIV-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:46 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( Bits, Gauge32, Integer32, Integer32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "Integer32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString")

# Types

class InterfaceIndex(Integer32):
    pass

class PhivAddr(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(2,2)
    fixedLength = 2
    
class PhivCounter(Integer32):
    pass


# Objects

phiv = MibIdentifier((1, 3, 6, 1, 2, 1, 18))
phivSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 1))
phivSystemState = MibScalar((1, 3, 6, 1, 2, 1, 18, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,4,)).subtype(namedValues=NamedValues(("on", 1), ("off", 2), ("shut", 3), ("restricted", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivSystemState.setDescription("This represents the operational state of the executor\nnode.\nThe possible states are:\nON          Allows logical links.\nOFF         Allows no new links, terminates existing\n            links, and stops routing traffic through.\nSHUT        Allows no new logical links, does not\n            destroy existing logical links, and goes\n            to the OFF state when all logical links are\n            gone.\nRESTRICTED  Allows no new incoming logical links from\n            other nodes.\n\nNOTE: These values are incremented by one compared to\nthe standard DECnet values in order to maintain\ncompliance with RFC 1155).")
phivExecIdent = MibScalar((1, 3, 6, 1, 2, 1, 18, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivExecIdent.setDescription("This is a text string that describes the executor node\n(for example, 'Research Lab').  The string is up to 32\ncharacters of any type.")
phivManagement = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 2))
phivMgmtMgmtVers = MibScalar((1, 3, 6, 1, 2, 1, 18, 2, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivMgmtMgmtVers.setDescription("This is the read-only Network Management Version,\nconsisting of the version number, the Engineering\nChange Order (ECO) number, and the user ECO number\n(for example, 3.0.0). This parameter applies to the\nexecutor node only.")
session = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 3))
phivSessionSystemName = MibScalar((1, 3, 6, 1, 2, 1, 18, 3, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 6))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivSessionSystemName.setDescription("Name to be associated with the node identification.\nOnly one name can be assigned to a node address or a\ncircuit identification. No name should be used more than\nonce in a DECnet network. Node-name is one to six upper\ncase alphanumeric characters with at least one alpha\ncharacter. A length of 0 indicates no name.")
phivSessionInTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 3, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivSessionInTimer.setDescription("This value represents the maximum duration between the\ntime a connect is received for a process at the\nexecutor node and the time that process accepts or\nrejects it. If the connect is not accepted or rejected\nby the user within the number of seconds specified,\nSession Control rejects it for the user.  A value of 0\nindicates no timer is running.")
phivSessionOutTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 3, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivSessionOutTimer.setDescription("This value represents the duration between the time the\nexecutor requests a connect and the time that connect is\nacknowledged by the destination node. If the connect is\nnot acknowledged within the number of seconds\nspecified, Session Control returns an error.  A value of 0\nindicates no timer is running.")
end = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 4))
phivEndRemoteTable = MibTable((1, 3, 6, 1, 2, 1, 18, 4, 1))
if mibBuilder.loadTexts: phivEndRemoteTable.setDescription("Information about the state of sessions between the\nnode under study and the nodes found in the table.")
phivEndRemoteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 4, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivEndRemoteHostNodeID"))
if mibBuilder.loadTexts: phivEndRemoteEntry.setDescription("Information about a particular remote node as seen\nfrom the end communication layer.")
phivEndRemoteHostNodeID = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 1, 1, 1), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndRemoteHostNodeID.setDescription("This value is the address of the remote node to be\nevaluated.")
phivEndRemoteState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,4,)).subtype(namedValues=NamedValues(("on", 1), ("off", 2), ("shut", 3), ("restricted", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndRemoteState.setDescription("This represents the operational state of the remote node\nbeing evaluated.\nThe possible states are:\n\nON          Allows logical links.\nOFF         Allows no new links, terminates existing\n            links, and stops routing traffic through.\nSHUT        Allows no new logical links, does not\n            destroy existing logical links, and goes\n            to the OFF state when all logical links are\n            gone.\nRESTRICTED  Allows no new incoming logical links from\n            other nodes.\n\nNOTE: These values are incremented by one compared to\nthe standard DECnet values in order to maintain\ncompliance with RFC 1155.")
phivEndCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCircuitIndex.setDescription("A unique index value for each known circuit used to\ncommunicate with the remote node.  This is the same\nvalue as phivCircuitIndex.")
phivEndActiveLinks = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndActiveLinks.setDescription("This read-only parameter represents the number of active\nlogical links from the executor to the destination node.")
phivEndDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndDelay.setDescription("This read-only parameter is the average round trip\ndelay in seconds to the destination node. This\nparameter is kept on a remote node basis.")
phivEndCountTable = MibTable((1, 3, 6, 1, 2, 1, 18, 4, 2))
if mibBuilder.loadTexts: phivEndCountTable.setDescription("Information about the counters associated with each end\nsystem that is known to the entity. These counters\nreflect totals from the perspective of the executor\nnode.")
phivEndCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 4, 2, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivEndCountHostNodeID"))
if mibBuilder.loadTexts: phivEndCountEntry.setDescription("Information about a particular session between two end\nsystems.")
phivEndCountHostNodeID = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 1), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountHostNodeID.setDescription("This value is the address of the remote node to be\nevaluated.")
phivEndCountSecsLastZeroed = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 2), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountSecsLastZeroed.setDescription("This value is the number of seconds that have elapsed\nsince the counters for the node in this table row were\nlast set to zero. This counter is located in the\nnetwork management layer, but is returned with the\nend system information which follows.")
phivEndCountUsrBytesRec = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 3), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountUsrBytesRec.setDescription("Number of user bytes received from the target host.")
phivEndCountUsrBytesSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 4), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountUsrBytesSent.setDescription("Number of user bytes sent to the target host.")
phivEndUCountUsrMessRec = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 5), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndUCountUsrMessRec.setDescription("Number of user messages received from the target host.")
phivEndCountUsrMessSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 6), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountUsrMessSent.setDescription("Number of user messages sent to the target host.")
phivEndCountTotalBytesRec = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 7), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountTotalBytesRec.setDescription("Number of bytes received from the target host.")
phivEndCountTotalBytesSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 8), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountTotalBytesSent.setDescription("Number of bytes sent to the target host.")
phivEndCountTotalMessRec = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 9), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountTotalMessRec.setDescription("Number of messages received from the target host.")
phivEndCountTotalMessSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 10), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountTotalMessSent.setDescription("Number of messages sent to the target host.")
phivEndCountConnectsRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 11), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountConnectsRecd.setDescription("Number of connects received from the target host.")
phivEndCountConnectsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 12), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountConnectsSent.setDescription("Number of connects sent to the target host.")
phivEndCountReponseTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 13), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountReponseTimeouts.setDescription("Number of response timeouts.")
phivEndCountRecdConnectResErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 4, 2, 1, 14), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndCountRecdConnectResErrs.setDescription("Number of received connect resource errors.")
phivEndMaxLinks = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndMaxLinks.setDescription("This value represents the maximum active logical\nlink count allowed for the executor.")
phivEndNSPVers = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEndNSPVers.setDescription("This read-only parameter represents the version number\nof the node End Communication S/W. The format is\nversion number, ECO, and user ECO, e.g., 4.1.0")
phivEndRetransmitFactor = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndRetransmitFactor.setDescription("This value represents the maximum number of times the\nsource End Communication at the executor node will\nrestart the retransmission timer when it expires. If\nthe number is exceeded, Session Control disconnects the\nlogical link for the user.")
phivEndDelayFact = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndDelayFact.setDescription("This is the number by which to multiply one sixteenth\nof the estimated round trip delay to a node to set the\nretransmission timer to that node.")
phivEndDelayWeight = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndDelayWeight.setDescription("This number represents the weight to apply to a\ncurrent round trip delay estimate to a remote node\nwhen updating the estimated round trip delay to a node.\nOn some systems the number must be 1 less than a power\nof 2 for computational efficiency.")
phivEndInactivityTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndInactivityTimer.setDescription("This value represents the maximum duration of inactivity\n(no data in either direction) on a logical link before\nthe node checks to see if the logical link still works.\nIf no activity occurs within the minimum number of\nseconds, End Communication generates artificial\ntraffic to test the link (End Communication\nspecification).")
phivEndCountZeroCount = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("other", 1), ("reset", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndCountZeroCount.setDescription("When this value is set to 2, all of the counters in\nthe End System Counter Table are set to zero.")
phivEndMaxLinksActive = MibScalar((1, 3, 6, 1, 2, 1, 18, 4, 10), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEndMaxLinksActive.setDescription("This value represents the high water mark for the\nnumber of links that were active at any one time.")
routing = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 5))
phivRouteBroadcastRouteTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteBroadcastRouteTimer.setDescription("This value determines the maximum time in seconds\nallowed between Routing updates on Ethernet\ncircuits. When this timer expired before a routing\nupdate occurs, a routing update is forced.  With a\nstandard calculation, Routing also uses this timer\nto enforce a minimum delay between routing updates.")
phivRouteBuffSize = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteBuffSize.setDescription("This parameter value determines the maximum size of\na Routing message. It therefore determines the maximum\nsize message that can be forwarded.  This size includes\nprotocol overhead down to and including the End\nCommunication layer, plus a constant value of 6. (This\nvalue of 6 is included to provide compatibility with\nthe parameter definition in Phase III, which included\nthe Routing overhead.) It does not include Routing or\nData link overhead (except for the constant value of\n6). There is one buffer size for all circuits.\n\nNOTE: The BUFFER SIZE defines the maximum size messages\nthat the Routing layer can forward. The SEGMENT BUFFER\nSIZE (defined below) defines the maximum size messages\nthat the End Communication layer can transmit or\nreceive. The SEGMENT BUFFER SIZE is always less than\nor equal to the BUFFER SIZE. Normally the two\nparameters will be equal. They may be different to\nallow the network manager to alter buffer sizes\non all nodes without interruption of service. They both\ninclude an extra 6 bytes for compatibility with Phase\nIII.")
phivRouteRoutingVers = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteRoutingVers.setDescription("This read-only parameter identifies the executor node's\nRouting version number.  The format is version number,\nECO, and user ECO, e.g., 4.1.0")
phivRouteMaxAddr = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 1023))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxAddr.setDescription("This value represents the largest node number and,\ntherefore, number of nodes that can be known about\nby the executor node's home area.")
phivRouteMaxBdcastNonRouters = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxBdcastNonRouters.setDescription("This value represents the maximum total number of\nnonrouters the executor node can have on its Ethernet\ncircuits.")
phivRouteMaxBdcastRouters = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxBdcastRouters.setDescription("This value represents the maximum total number of\nrouters the executor node can have on its Ethernet\ncircuits.")
phivRouteMaxBuffs = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxBuffs.setDescription("This value represents the maximum number of transmit\nbuffers that Routing may use for all circuits.")
phivRouteMaxCircuits = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxCircuits.setDescription("This value represents the maximum number of Routing\ncircuits that the executor node can know about.")
phivRouteMaxCost = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 1022))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxCost.setDescription("This value represents the maximum total path cost\nallowed from the executor to any node within an area.\nThe path cost is the sum of the circuit costs along\na path between two nodes. This parameter defines the\npoint where the executor node's Routing routing\ndecision algorithm declares another node unreachable\nbecause the cost of the least costly path to the\nother node is excessive. For correct operation, this\nparameter must not be less than the maximum path cost\nof the network.")
phivRouteMaxHops = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxHops.setDescription("This value represents the maximum number of routing hops\nallowable from the executor to any other reachable node\nwithin an area. (A hop is the logical distance over a\ncircuit between two adjacent nodes.) This parameter\ndefines the point where the executor node's Routing\nrouting decision algorithm declares another node\nunreachable because the length of the shortest path\nbetween the two nodes is too long. For correct\noperation, this parameter must not be less than the\nnetwork diameter. (The network diameter is the\nreachability distance between the two nodes of the\nnetwork having the greatest reachability distance,\nwhere reachability distance is the length the shortest\npath between a given pair of nodes.)")
phivRouteMaxVisits = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxVisits.setDescription("This value represents the maximum number of nodes a\nmessage coming into the executor node can have visited.\nIf the message is not for this node and the MAXIMUM\nVISITS number is exceeded, the message is discarded.\nThe MAXIMUM VISITS parameter defines the point where\nthe packet lifetime control algorithm discards\na packet that has traversed too many nodes. For correct\noperation, this parameter must not be less than the\nmaximum path length of the network. (The maximum path\nlength is the routing distance between the two nodes of\nthe network having the greatest routing distance, where\nrouting distance is the length of the least costly\npath between a given pair of nodes.)")
phivRouteRoutingTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteRoutingTimer.setDescription("This value determines the maximum time in seconds\nallowed between Routing updates on non-Ethernet\ncircuits. When this timer expires before a routing\nupdate occurs, a routing update is forced.")
phivRouteSegBuffSize = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteSegBuffSize.setDescription("This parameter value determines the maximum size of an\nend-to-end segment. The size is a decimal integer in\nthe range 1-65535. This size is in bytes. This size\nincludes protocol overhead down to and including the\nEnd Communication layer, plus a constant value of 6.\n(This value of 6 is included to provide compatibility\nwith the BUFFER SIZE parameter definition.) It does not\ninclude Routing or Data link overhead (except for the\nconstant value of 6).")
phivRouteType = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,5,2,4,)).subtype(namedValues=NamedValues(("routing-III", 1), ("nonrouting-III", 2), ("area", 3), ("routing-IV", 4), ("nonrouting-IV", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteType.setDescription("This parameter indicates the type of the executor\nnode. The node-type is one of the following:\n\nrouting-III\nnonrouting-III\nrouting-IV\nronrouting-IV\narea\n\nA routing node has full routing capability. A\nnonrouting node contains a subset of the Routing\nrouting modules. The III and IV indicate the DNA\nphase of the node. Nonrouting nodes can deliver\nand receive packets to and from any node, but cannot\nroute packets from other nodes through to other nodes.\nAn area node routes between areas. Refer to the Routing\nspecification for details.\nFor adjacent nodes, this is a read-only parameter that\nindicates the type of the reachable adjacent node.\nNOTE: The ROUTING-III and NONROUTING-III values are\nincremented by one compared to the standard DECnet\nvalues in order to maintain compliance with RFC 1155)")
phivRouteCountAgedPktLoss = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 15), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountAgedPktLoss.setDescription("Number of aged packet losses.")
phivRouteCountNodeUnrPktLoss = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 16), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountNodeUnrPktLoss.setDescription("Number of node unreachable packet losses.")
phivRouteCountOutRngePktLoss = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 17), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountOutRngePktLoss.setDescription("Number of node out-of-range packet losses.")
phivRouteCountOverSzePktLoss = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 18), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountOverSzePktLoss.setDescription("Number of Oversized packet losses.")
phivRouteCountPacketFmtErr = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 19), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountPacketFmtErr.setDescription("Number of packet format errors.")
phivRouteCountPtlRteUpdtLoss = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 20), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountPtlRteUpdtLoss.setDescription("Number of partial routing update losses.")
phivRouteCountVerifReject = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 21), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteCountVerifReject.setDescription("Number of verification rejects.")
phivLevel1RouteTable = MibTable((1, 3, 6, 1, 2, 1, 18, 5, 22))
if mibBuilder.loadTexts: phivLevel1RouteTable.setDescription("Information about the currently known DECnet Phase\nIV Routes.")
phivLevel1RouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 5, 22, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivLevel1RouteNodeAddr"))
if mibBuilder.loadTexts: phivLevel1RouteEntry.setDescription("Information about the currently known DECnet Phase\nIV Routes.")
phivLevel1RouteNodeAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 5, 22, 1, 1), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLevel1RouteNodeAddr.setDescription("This value is the address of the node about which\nrouting information is contained in this level 1\nrouting table.")
phivLevel1RouteCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 5, 22, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLevel1RouteCircuitIndex.setDescription("A unique index value for each known circuit. This is\nthe index to the circuit state table and is the same\nvalue as phivCircuitIndex.")
phivLevel1RouteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 5, 22, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLevel1RouteCost.setDescription("This read-only parameter represents the total cost\nover the current path to the destination node. Cost is\na positive integer value associated with using a\ncircuit. Routing routes messages (data) along the path\nbetween two nodes with the smallest cost. COST is kept\non a remote node basis.")
phivLevel1RouteHops = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 5, 22, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLevel1RouteHops.setDescription("This read-only parameter represents the number of hops\nover to a destination node. A hop is Routing value\nrepresenting the logical distance between two nodes in\na network. HOPS is kept on a remote node basis.")
phivLevel1RouteNextNode = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 5, 22, 1, 5), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLevel1RouteNextNode.setDescription("This read-only value indicates the next node on the\ncircuit used to get to the node under scrutiny\n(next hop).")
phivRouteCountZeroCount = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("other", 1), ("reset", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteCountZeroCount.setDescription("When this value is set to 2, the following objects are\nset to Zero: phivRouteCountAgedPktLoss,\nphivRouteCountNodeUnrPktLoss,\nphivRouteCountOutRngePktLoss,\nphivRouteCountOverSzePktLoss,\nphivRouteCountPacketFmtErr,\nphivRouteCountPtlRteUpdtLoss, and\nphivRouteCountVerifReject.")
phivRouteSystemAddr = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 24), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivRouteSystemAddr.setDescription("DECnet Phase IV node address.")
phivRouteRoutingType = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 25), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,5,2,4,)).subtype(namedValues=NamedValues(("routing-III", 1), ("nonrouting-III", 2), ("area", 3), ("routing-IV", 4), ("nonrouting-IV", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteRoutingType.setDescription("This read-write parameter indicates the type of the executor\nnode. The node-type is one of the following:\n\nrouting-III\nnonrouting-III\nrouting-IV\nronrouting-IV\narea\n\nA routing node has full routing capability. A\nnonrouting node contains a subset of the Routing\nrouting modules. The III and IV indicate the DNA\nphase of the node. Nonrouting nodes can deliver\nand receive packets to and from any node, but cannot\nroute packets from other nodes through to other nodes.\nAn area node routes between areas. Refer to the Routing\nspecification for details.\n\nFor adjacent nodes, this is a read-only parameter that\nindicates the type of the reachable adjacent node.\nNOTE: The ROUTING-III and NONROUTING-III values are\nincremented by one compared to the standard DECnet\nvalues in order to maintain compliance with RFC 1155)")
phivRouteSystemAddress = MibScalar((1, 3, 6, 1, 2, 1, 18, 5, 26), PhivAddr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteSystemAddress.setDescription("DECnet Phase IV node address.")
circuit = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 6))
phivCircuitParametersTable = MibTable((1, 3, 6, 1, 2, 1, 18, 6, 1))
if mibBuilder.loadTexts: phivCircuitParametersTable.setDescription("Information about the parameters associated with all\ncircuits currently known.")
phivCircuitParametersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 6, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivCircuitIndex"))
if mibBuilder.loadTexts: phivCircuitParametersEntry.setDescription("Parameters information about all circuits currently\nknown.")
phivCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitIndex.setDescription("A unique index value for each known circuit.")
phivCircuitLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitLineIndex.setDescription("The line on which this circuit is active.  This is\nthe same as the ifIndex.")
phivCircuitCommonState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,2,3,)).subtype(namedValues=NamedValues(("on", 1), ("off", 2), ("service", 3), ("cleared", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitCommonState.setDescription("This value represents the circuit's Network Management\noperational state. NOTE: These values are incremented\nby one compared to the standard DECnet values in order\nto maintain compliance with RFC 1155.")
phivCircuitCommonSubState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(5,11,3,13,2,9,4,7,12,10,8,1,6,)).subtype(namedValues=NamedValues(("starting", 1), ("autotriggering", 10), ("synchronizing", 11), ("failed", 12), ("running", 13), ("reflecting", 2), ("looping", 3), ("loading", 4), ("dumping", 5), ("triggering", 6), ("autoservice", 7), ("autoloading", 8), ("autodumping", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCommonSubState.setDescription("This value represents the circuit's Network Management\noperational and service substate. NOTE: These values are\nincremented by one compared to the standard DECnet values\nin order to maintain compliance with RFC 1155.")
phivCircuitCommonName = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCommonName.setDescription("The name of the circuit entry in the table, for example,\nSVA-0 or in a level 2 router ASYNC-8 or ETHER-1).")
phivCircuitExecRecallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitExecRecallTimer.setDescription("This parameter represents the minimum number of\nseconds to wait before restarting the circuit.  A\nvalue of 0 indicates not timer is running.")
phivCircuitCommonType = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(2,7,5,1,15,8,3,9,14,4,6,)).subtype(namedValues=NamedValues(("ddcmp-point", 1), ("other", 14), ("fddi", 15), ("ddcmp-control", 2), ("ddcmp-tributary", 3), ("x25", 4), ("ddcmp-dmc", 5), ("ethernet", 6), ("ci", 7), ("qp2-dte20", 8), ("bisync", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCommonType.setDescription("Represents the type of the circuit. For X.25 circuits,\nthe value must be set to X25. For DDCMP and Ethernet\ncircuits it is read only and is the same value as the\nprotocol of the associated line.\nNOTE: Values 1 - 5 are incremented by one compared to the\nstandard DECnet values in order to maintain compliance\nwith RFC 1155.")
phivCircuitService = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitService.setDescription("This value indicates whether or not Network Management\nallows service operations on a circuit. The values for\nservice-control are as follows:\n\nENABLED     SERVICE state and/or service functions are\n            allowed.\n\nDISABLED    SERVICE state and/or service functions are not\n            allowed.\n\nNOTE: These values are incremented by one compared to the\nstandard DECnet values in order to maintain compliance\nwith RFC 1155.")
phivCircuitExecCost = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 25))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitExecCost.setDescription("This value represents the routing cost of the circuit.\nRouting sends messages along the path between two nodes\nhaving the smallest cost.")
phivCircuitExecHelloTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 8191))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitExecHelloTimer.setDescription("This value determines the frequency of Routing Hello\nmessages sent to the adjacent node on the circuit.")
phivCircuitCountTable = MibTable((1, 3, 6, 1, 2, 1, 18, 6, 2))
if mibBuilder.loadTexts: phivCircuitCountTable.setDescription("Information about the counters associated with all\ncircuits currently known.")
phivCircuitCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 6, 2, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivCircuitIndex"))
if mibBuilder.loadTexts: phivCircuitCountEntry.setDescription("Counter information about all circuits currently known")
phivCircuitCountSecLastZeroed = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 1), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountSecLastZeroed.setDescription("Number of seconds since the circuit counters for this\ncircuit were last zeroed.")
phivCircuitCountTermPacketsRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 2), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountTermPacketsRecd.setDescription("Number of terminating packets received on this circuit.")
phivCircuitCountOriginPackSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 3), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountOriginPackSent.setDescription("Number of originating packets sent on this circuit.")
phivCircuitCountTermCongLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 4), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountTermCongLoss.setDescription("Number of terminating congestion losses on this\ncircuit.")
phivCircuitCountCorruptLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 5), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountCorruptLoss.setDescription("Number of corruption losses on this circuit.")
phivCircuitCountTransitPksRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 6), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountTransitPksRecd.setDescription("Number of Transit packets received on this circuit.")
phivCircuitCountTransitPkSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 7), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountTransitPkSent.setDescription("Number of transit packets sent on this circuit.")
phivCircuitCountTransitCongestLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 8), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountTransitCongestLoss.setDescription("Number of transit congestion losses on this circuit.")
phivCircuitCountCircuitDown = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 9), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountCircuitDown.setDescription("Number of circuit downs on this circuit.")
phivCircuitCountInitFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 10), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountInitFailure.setDescription("Number of Initialization failures on this circuit.")
phivCircuitCountAdjDown = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 11), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountAdjDown.setDescription("This counter indicates the number of adjacency losses\nthat result from any of the following:\n     Node listener timeout\n     Invalid data received at node listener\n     Unexpected control (initialization or verification)\n         message received\n     Routing message received with a checksum error\n     Node identification from a routing message or a\n     Hello message that is not the one expected Hello\n     message received indicating that connectivity\n     became one-way\n     Adjacency idled.")
phivCircuitCountPeakAdj = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 12), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountPeakAdj.setDescription("This counter indicates the maximum number of nodes\nthat are up on the circuit.")
phivCircuitCountBytesRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 13), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountBytesRecd.setDescription("Number of bytes received on this circuit.")
phivCircuitCountBytesSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 14), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountBytesSent.setDescription("Number of bytes sent on this circuit.")
phivCircuitCountDataBlocksRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 15), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountDataBlocksRecd.setDescription("Number of data blocks received on this circuit.")
phivCircuitCountDataBlocksSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 16), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountDataBlocksSent.setDescription("Number of data blocks sent on this circuit.")
phivCircuitCountUsrBuffUnav = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 6, 2, 1, 17), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCircuitCountUsrBuffUnav.setDescription("Number of user buffer unavailable errors.")
phivCircuitOrigQueueLimit = MibScalar((1, 3, 6, 1, 2, 1, 18, 6, 3), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitOrigQueueLimit.setDescription("This parameter indicates the maximum number of\noriginating packets that may be outstanding on this\ncircuit. This does not include route-thru traffic.")
phivCircuitCountZeroCount = MibScalar((1, 3, 6, 1, 2, 1, 18, 6, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("other", 1), ("reset", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivCircuitCountZeroCount.setDescription("When this value is set to 2, all of the counters in the\nCircuit Counter Table are set to zero.")
ddcmp = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 7))
phivDDCMPCircuitParametersTable = MibTable((1, 3, 6, 1, 2, 1, 18, 7, 1))
if mibBuilder.loadTexts: phivDDCMPCircuitParametersTable.setDescription("Information about DDCMP circuit parameters.")
phivDDCMPCircuitParametersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 7, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivDDCMPCircuitIndex"))
if mibBuilder.loadTexts: phivDDCMPCircuitParametersEntry.setDescription("Parameters information about DDCMP circuits currently\nknown.")
phivDDCMPCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitIndex.setDescription("A unique index value for each known DDCMP circuit.\nThis is the same value as phivCircuitIndex.")
phivDDCMPCircuitAdjNodeAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 1, 1, 2), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitAdjNodeAddr.setDescription("The address of the adjacent node.")
phivDDCMPCircuitTributary = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitTributary.setDescription("This value represents the Data Link physical tributary\naddress of the circuit.")
phivDDCMPCircuitCountTable = MibTable((1, 3, 6, 1, 2, 1, 18, 7, 2))
if mibBuilder.loadTexts: phivDDCMPCircuitCountTable.setDescription("Information about the DDCMP counters associated with all\ncircuits currently known.")
phivDDCMPCircuitCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 7, 2, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivCircuitIndex"))
if mibBuilder.loadTexts: phivDDCMPCircuitCountEntry.setDescription("Counter information about DDCMP circuits now known")
phivDDCMPCircuitErrorsInbd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 1), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitErrorsInbd.setDescription("Number of Data errors inbound.")
phivDDCMPCircuitErrorsOutbd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 2), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitErrorsOutbd.setDescription("Number of outbound data errors.")
phivDDCMPCircuitRmteReplyTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 3), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitRmteReplyTimeouts.setDescription("Number of remote reply timeouts.")
phivDDCMPCircuitLocalReplyTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 4), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitLocalReplyTimeouts.setDescription("Number of local Reply timeouts.")
phivDDCMPCircuitRmteBuffErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 5), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitRmteBuffErrors.setDescription("Number of remote reply time out errors.")
phivDDCMPCircuitLocalBuffErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 6), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitLocalBuffErrors.setDescription("Number of local buffer errors.")
phivDDCMPCircuitSelectIntervalsElap = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 7), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitSelectIntervalsElap.setDescription("Selection intervals that have elapsed.")
phivDDCMPCircuitSelectTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPCircuitSelectTimeouts.setDescription("Number of selection timeouts.")
phivDDCMPLineCountTable = MibTable((1, 3, 6, 1, 2, 1, 18, 7, 3))
if mibBuilder.loadTexts: phivDDCMPLineCountTable.setDescription("The DDCMP Line Count Table.")
phivDDCMPLineCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 7, 3, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivDDCMPLineCountIndex"))
if mibBuilder.loadTexts: phivDDCMPLineCountEntry.setDescription("There is one entry in the table for each line.")
phivDDCMPLineCountIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 3, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPLineCountIndex.setDescription("The line on which this entry's equivalence is\neffective. The interface identified by a particular\nvalue of this index is the same interface as\nidentified by the same value of phivLineIndex.\nThis value is the ifIndex.")
phivDDCMPLineCountDataErrsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 3, 1, 2), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPLineCountDataErrsIn.setDescription("Number of data errors inbound.")
phivDDCMPLineCountRmteStationErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 3, 1, 3), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPLineCountRmteStationErrs.setDescription("Number of remote station errors.")
phivDDCMPLineCountLocalStationErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 7, 3, 1, 4), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivDDCMPLineCountLocalStationErrs.setDescription("Number of local station errors.")
control = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 8))
phivControlSchedTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 8, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(50, 65535)).clone(200)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivControlSchedTimer.setDescription("This value represents the number of milliseconds\nbetween recalculation of tributary polling priorities.")
phivControlDeadTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 8, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)).clone(10000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivControlDeadTimer.setDescription("This value represents the number of milliseconds\nbetween polls of one of the set of dead\ntributaries.")
phivControlDelayTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 8, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivControlDelayTimer.setDescription("This value represents the minimum number of\nmilliseconds to delay between polls. The delay timer\nlimits the effect of a very fast control station on\nslow tributaries.")
phivControlStreamTimer = MibScalar((1, 3, 6, 1, 2, 1, 18, 8, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)).clone(6000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivControlStreamTimer.setDescription("This value represents the number of milliseconds a\ntributary or a half duplex remote station is\nallowed to hold the line.\n\nNOTE: This parameter can also be applied to\nhalf-duplex lines of type DDCMP POINT.")
phivControlParametersTable = MibTable((1, 3, 6, 1, 2, 1, 18, 8, 5))
if mibBuilder.loadTexts: phivControlParametersTable.setDescription("Information about control circuit parameters.")
phivControlParametersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 8, 5, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivControlCircuitIndex"))
if mibBuilder.loadTexts: phivControlParametersEntry.setDescription("Parameters information about control circuits\ncurrently known.")
phivControlCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivControlCircuitIndex.setDescription("A unique index value for each known multipoint\ncontrol circuit.\nThis is the same value as phivCircuitIndex.")
phivControlBabbleTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)).clone(6000)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlBabbleTimer.setDescription("This value represents the number of milliseconds that a\nselected tributary or remote half-duplex station is\nallowed to transmit.")
phivControlMaxBuffs = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 254))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlMaxBuffs.setDescription("This value represents the maximum number of buffers the\ntributary can use from a common buffer pool. If not\nset, there is no common buffer pool and buffers are\nexplicitly supplied by the higher level. Count is a\ndecimal integer in the range 1-254.")
phivControlMaxTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255)).clone(4)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlMaxTransmits.setDescription("This value represents the maximum number of data\nmessages that can be transmitted at one time. Count\nis a decimal integer in the range 1-255.")
phivControlDyingBase = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlDyingBase.setDescription("This value represents the base priority to which a\ntributary is reset each time it has been polled. A\nseparate base can be set for each of the indicated\npolling states. Base is a decimal integer in the range\n0-255.  If not set, the defaults are: active, 255;\ninactive, 0; and dying, 0.")
phivControlDyingIncrement = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlDyingIncrement.setDescription("This value represents the increment added to the\ntributary priority each time the scheduling timer\nexpires.  If not set, the defaults are: active, 0;\ninactive, 64; and dying, 16.")
phivControlDeadThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255)).clone(8)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlDeadThreshold.setDescription("This value represents the number of times to poll the\nactive, inactive, or dying tributary before changing\nits polling state to dead because of receive timeouts.\nCount is a decimal integer in the range 0-255.")
phivControlDyingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255)).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlDyingThreshold.setDescription("This value represents the number of times to poll the\nactive or inactive tributary before changing its\npolling state to dying because of receive timeouts.\nCount is a decimal integer in the range 0-255.")
phivControlInactTreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255)).clone(8)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlInactTreshold.setDescription("This value represents the number of times to poll the\nactive tributary before changing its polling state to\ninactive because of no data response. Count is a\ndecimal integer in the range\n0-255.")
phivControlPollingState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(4,5,3,2,1,)).subtype(namedValues=NamedValues(("automatic", 1), ("active", 2), ("inactive", 3), ("dying", 4), ("dead", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlPollingState.setDescription("This value represents the state of the tributary\nrelative to the multipoint polling algorithm.  If not\nset the default is AUTOMATIC. The possible states are:\nAUTOMATIC\n\n  The tributary's state is allowed to vary according to\n  the operation of the polling algorithm.\n\nACTIVE/INACTIVE/DYING/DEAD\n\n  The tributary is locked in the specified state.\n\n NOTE: These values are incremented by one compared to\n the standard DECnet values in order to maintain\n compliance with RFC 1155.")
phivControlPollingSubState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,4,3,)).subtype(namedValues=NamedValues(("active", 1), ("inactive", 2), ("dying", 3), ("dead", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivControlPollingSubState.setDescription("This value represents the tributary's state as\ndetermined by the polling algorithm.  This applies\nonly when the polling state is AUTOMATIC and is\nread-only to Network Management.  Polling-substate is\none of ACTIVE, INACTIVE, DYING, or DEAD.  It is\ndisplayed as a tag on the polling state, for example:\nAUTOMATIC-INACTIVE.")
phivControlTransTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 8, 5, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivControlTransTimer.setDescription("This value represents the number of milliseconds to\ndelay between data message transmits. Milliseconds is\na decimal integer in the range 0-65535.")
ethernet = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 9))
phivEthLinkParametersTable = MibTable((1, 3, 6, 1, 2, 1, 18, 9, 1))
if mibBuilder.loadTexts: phivEthLinkParametersTable.setDescription("Information about ethernet link parameters.")
phivEthLinkParametersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 9, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivEthLinkIndex"))
if mibBuilder.loadTexts: phivEthLinkParametersEntry.setDescription("Parameter information about ethernet links currently\nknown.")
phivEthLinkIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 9, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEthLinkIndex.setDescription("The circuit over which this links information is\ncollected.  This is the same as phivCircuitIndex.")
phivEthDesigRouterNodeAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 9, 1, 1, 2), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEthDesigRouterNodeAddr.setDescription("This value is the address of the designated router.")
phivEthMaxRouters = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 9, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEthMaxRouters.setDescription("This parameter is the maximum number of routers (other\nthan the executor itself) allowed on the circuit by\nRouting for circuits that are owned by the executor\nnode.")
phivEthRouterPri = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 9, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 127)).clone(64)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivEthRouterPri.setDescription("This parameter is the priority that this router is to\nhave in the selection of designated router for the\ncircuit on circuits that are owned by the executor\nnode.")
phivEthHardwareAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 9, 1, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(6, 6)).setFixedLength(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivEthHardwareAddr.setDescription("This read-only parameter is the address that is\nassociated with the line device hardware as seen by\nthe DECnet Software.  This value is not the same as\nifPhysAddress.")
counters = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 10))
phivCountersCountTable = MibTable((1, 3, 6, 1, 2, 1, 18, 10, 1))
if mibBuilder.loadTexts: phivCountersCountTable.setDescription("Information about ethernet link counters.")
phivCountersCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 10, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivCountersIndex"))
if mibBuilder.loadTexts: phivCountersCountEntry.setDescription("Counter information about ethernet links currently\nknown.")
phivCountersIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersIndex.setDescription("The interface to which these counters apply.  This is\nthe same interface as identified by the same value of\nphivLineIndex. This value is the ifIndex.")
phivCountersCountBytesRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 2), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountBytesRecd.setDescription("Number of bytes received over this link.")
phivCountersCountBytesSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 3), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountBytesSent.setDescription("Number of bytes sent over this link.")
phivCountersCountDataBlocksRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 4), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountDataBlocksRecd.setDescription("Number of data blocks received over this link.")
phivCountersCountDataBlocksSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 5), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountDataBlocksSent.setDescription("Number of data blocks sent over this link.")
phivCountersCountEthUsrBuffUnav = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 6), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountEthUsrBuffUnav.setDescription("Number of user buffer unavailable errors over this\nlink.")
phivCountersCountMcastBytesRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 7), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountMcastBytesRecd.setDescription("Number of multicast bytes received over this link.")
phivCountersCountDataBlksRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 8), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountDataBlksRecd.setDescription("Number of data blocks received over this link.")
phivCountersCountDataBlksSent = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 9), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountDataBlksSent.setDescription("Number of data blocks sent over this link.")
phivCountersCountMcastBlksRecd = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 10), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountMcastBlksRecd.setDescription("Number of multicast blocks received over this link.")
phivCountersCountBlksSentDef = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 11), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountBlksSentDef.setDescription("Number of blocks sent, initially deferred over this\nlink.")
phivCountersCountBlksSentSingleCol = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 12), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountBlksSentSingleCol.setDescription("Number of blocks sent, single collision over this link.")
phivCountersCountBlksSentMultCol = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 13), PhivCounter().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountBlksSentMultCol.setDescription("Number of blocks sent, multiple collisions over this\nlink.")
phivCountersCountSendFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountSendFailure.setDescription("Number of send failures over this link.")
phivCountersCountCollDetectFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountCollDetectFailure.setDescription("Number of collision detect check failures over this\nlink.")
phivCountersCountReceiveFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountReceiveFailure.setDescription("Number of receive failures over this link.")
phivCountersCountUnrecFrameDest = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountUnrecFrameDest.setDescription("Number of unrecognized frame destinations over this\nlink.")
phivCountersCountDataOver = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountDataOver.setDescription("Number of data overruns over this link.")
phivCountersCountSysBuffUnav = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountSysBuffUnav.setDescription("Number of system buffer unavailables over this link.")
phivCountersCountUsrBuffUnav = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 10, 1, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivCountersCountUsrBuffUnav.setDescription("Number of user buffer unavailables.")
adjacency = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 11))
phivAdjTable = MibTable((1, 3, 6, 1, 2, 1, 18, 11, 1))
if mibBuilder.loadTexts: phivAdjTable.setDescription("The Adjacency Table.")
phivAdjEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 11, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivAdjCircuitIndex"))
if mibBuilder.loadTexts: phivAdjEntry.setDescription("There is one entry in the table for each adjacency.")
phivAdjCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjCircuitIndex.setDescription("A unique index value for each known circuit.")
phivAdjNodeAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 2), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeAddr.setDescription("The address of the adjacent node.")
phivAdjBlockSize = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjBlockSize.setDescription("This read-only parameter is the block size that was\nnegotiated with the adjacent Routing layer during Routing\ninitialization over a particular circuit. It includes the\nrouting header, but excludes the data link header. This\nparameter is qualified by ADJACENT NODE.")
phivAdjListenTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjListenTimer.setDescription("This value determines the maximum number of seconds\nallowed to elapse before Routing receives some message\n(either a Hello message or a user message) from the\nadjacent node on the circuit. It was agreed during\nRouting initialization with the adjacent Routing layer.\nThis parameter is qualified by ADJACENT NODE.")
phivAdjCircuitEtherServPhysAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(6, 6)).setFixedLength(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjCircuitEtherServPhysAddr.setDescription("This parameter indicates the Ethernet physical address\nof an adjacent node that is being serviced on this\ncircuit. This parameter is a qualifier for SERVICE\nSUBSTATE.")
phivAdjType = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,5,2,4,)).subtype(namedValues=NamedValues(("routing-III", 1), ("nonrouting-III", 2), ("area", 3), ("routing-IV", 4), ("nonrouting-IV", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjType.setDescription("This parameter indicates the type of adjacency.\n\nFor adjacent nodes, this is a read-only parameter that\nindicates the type of the reachable adjacent node.\nNOTE: The routing-III and nonrouting-III values are\nincremented by one compared to the standard DECnet\nvalues in order to maintain compliance with RFC 1155)")
phivAdjState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(8,3,10,4,6,9,5,2,1,7,)).subtype(namedValues=NamedValues(("initializing", 1), ("halt", 10), ("up", 2), ("run", 3), ("circuit-rejected", 4), ("data-link-start", 5), ("routing-layer-initialize", 6), ("routing-layer-verify", 7), ("routing-layer-complete", 8), ("off", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjState.setDescription("This value indicates the state of a router adjacency.\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) Ethernet, CI, or FDDI, with an\nadjacent node of type (phivAdjType) ROUTING IV or AREA,\nthis variable is the state of the Ethernet\nInitialization Layer for this adjacency, and can have\nvalues INITIALIZING or UP. (See Section 9.1.1 of\nDECnet Phase IV Routing Layer Functional Specification.)\n\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) Ethernet, CI, or FDDI, with an\nadjacent node of type (phivAdjType) NONROUTING IV,\nthis variable will always take on the value UP.\n\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) DDCMP POINT, DDCMP CONTROL,\nDDCMP TRIBUTARY, DDCMP DMC, or X.25, this variable is\nthe state of the Routing Layer Initialization Circuit\nState. (See section 7.3, ibid.)  It can have values\nbetween RUN and HALT.\n\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) OTHER, this variable may be\nused in a manner consistent with the Initialization\nLayer used on that circuit.")
phivAdjPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjPriority.setDescription("Priority assigned by the adjacent node for this\ncircuit.")
phivAdjExecListenTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjExecListenTimer.setDescription("This read-only value determines the maximum number of\nseconds allowed to elapse before Routing receives some\nmessage (either a Hello message or a user message) from\nthe adjacent node on the circuit. It was agreed during\nRouting initialization with the adjacent Routing layer.")
phivAdjNodeTable = MibTable((1, 3, 6, 1, 2, 1, 18, 11, 2))
if mibBuilder.loadTexts: phivAdjNodeTable.setDescription("The Adjacent Node Table.")
phivAdjNodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 11, 2, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivAdjNodeCircuitIndex"), (0, "DECNET-PHIV-MIB", "phivAdjAddr"))
if mibBuilder.loadTexts: phivAdjNodeEntry.setDescription("There is one entry in the table for each adjacency.")
phivAdjNodeCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeCircuitIndex.setDescription("A unique index value for each known circuit.  This\nvalue is the same as phivCircuitIndex and identifies the\ncircuit over which the adjacency is realized.")
phivAdjAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 2), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjAddr.setDescription("The address of the adjacent node.")
phivAdjNodeBlockSize = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeBlockSize.setDescription("This read-only parameter is the block size that was\nnegotiated with the adjacent Routing layer during Routing\ninitialization over a particular circuit. It includes the\nrouting header, but excludes the data link header. This\nparameter is qualified by ADJACENT NODE.")
phivAdjNodeListenTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeListenTimer.setDescription("This value determines the maximum number of seconds\nallowed to elapse before Routing receives some message\n(either a Hello message or a user message) from the\nadjacent node on the circuit. It was agreed during\nRouting initialization with the adjacent Routing layer.\nThis parameter is qualified by ADJACENT NODE.")
phivAdjNodeCircuitEtherServPhysAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(6, 6)).setFixedLength(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeCircuitEtherServPhysAddr.setDescription("This parameter indicates the Ethernet physical address\nof an adjacent node that is being serviced on this\ncircuit. This parameter is a qualifier for SERVICE\nSUBSTATE.")
phivAdjNodeType = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,5,2,4,)).subtype(namedValues=NamedValues(("routing-III", 1), ("nonrouting-III", 2), ("area", 3), ("routing-IV", 4), ("nonrouting-IV", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeType.setDescription("This parameter indicates the type of adjacency.\n\nFor adjacent nodes, this is a read-only parameter that\nindicates the type of the reachable adjacent node.\nNOTE: The routing-III and nonrouting-III values are\nincremented by one compared to the standard DECnet\nvalues in order to maintain compliance with RFC 1155)")
phivAdjNodeState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(8,3,10,4,6,9,5,2,1,7,)).subtype(namedValues=NamedValues(("initializing", 1), ("halt", 10), ("up", 2), ("run", 3), ("circuit-rejected", 4), ("data-link-start", 5), ("routing-layer-initialize", 6), ("routing-layer-verify", 7), ("routing-layer-complete", 8), ("off", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodeState.setDescription("This value indicates the state of a router adjacency.\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) Ethernet, CI, or FDDI, with an\nadjacent node of type (phivAdjNodeType) ROUTING IV or AREA,\nthis variable is the state of the Ethernet\nInitialization Layer for this adjacency, and can have\nvalues INITIALIZING or UP. (See Section 9.1.1 of\nDECnet Phase IV Routing Layer Functional Specification.)\n\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) Ethernet, CI, or FDDI, with an\nadjacent node of type (phivAdjNodeType) NONROUTING IV,\nthis variable will always take on the value UP.\n\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) DDCMP POINT, DDCMP CONTROL,\nDDCMP TRIBUTARY, DDCMP DMC, or X.25, this variable is\nthe state of the Routing Layer Initialization Circuit\nState. (See section 7.3, ibid.)  It can have values\nbetween RUN and HALT.\n\nOn adjacencies over a circuit of type\n(phivCircuitCommonType) OTHER, this variable may be\nused in a manner consistent with the Initialization\nLayer used on that circuit.")
phivAdjNodePriority = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 11, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAdjNodePriority.setDescription("Priority assigned by the adjacent node for this\ncircuit.")
line = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 12))
phivLineTable = MibTable((1, 3, 6, 1, 2, 1, 18, 12, 1))
if mibBuilder.loadTexts: phivLineTable.setDescription("The Line Table.")
phivLineEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 12, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivLineIndex"))
if mibBuilder.loadTexts: phivLineEntry.setDescription("There is one entry in the table for each line.")
phivLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineIndex.setDescription("The line on which this entry's equivalence is effective.\nThis is the same as the ifIndex.")
phivLineName = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineName.setDescription("The name of the line on this row of the table.")
phivLineState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,2,3,)).subtype(namedValues=NamedValues(("on", 1), ("off", 2), ("service", 3), ("cleared", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineState.setDescription("This value represents Network Management operational\nstate.\nNOTE that these values are incremented by one compared to\nthe standard DECnet values.")
phivLineSubstate = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(10,5,11,3,13,2,8,4,9,12,7,1,6,)).subtype(namedValues=NamedValues(("starting", 1), ("auto-triggering", 10), ("synchronizing", 11), ("failed", 12), ("running", 13), ("reflecting", 2), ("looping", 3), ("loading", 4), ("dumping", 5), ("triggering", 6), ("auto-service", 7), ("auto-loading", 8), ("auto-dumping", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineSubstate.setDescription("This value represents the line's read-only Network\nManagement substate.\nNOTE that these values are incremented by one compared to\nthe standard DECnet values.")
phivLineService = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,4,)).subtype(namedValues=NamedValues(("starting", 1), ("reflecting", 2), ("looping", 3), ("other", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineService.setDescription("This value represents the line's read-only Network\nManagement service.\nNOTE that these values are incremented by one compared to\nthe standard DECnet values and OTHER is a new addition.")
phivLineDevice = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 6), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineDevice.setDescription("This value represents the Physical Link device to be\nused on the line.")
phivLineReceiveBuffs = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineReceiveBuffs.setDescription("This value represents the number of receive buffers\nreserved for the line. It is a decimal number in\nthe range 0-65535.  0 is supported for those vendors\nthat do not reserve buffers on a per line basis and\nuse a pool of buffers that can be used by any line.")
phivLineProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,8,4,6,1,9,15,5,3,14,7,)).subtype(namedValues=NamedValues(("ddcmp-point", 1), ("other", 14), ("fddi", 15), ("ddcmp-control", 2), ("ddcmp-tributary", 3), ("reserved", 4), ("ddcmp-dmc", 5), ("olapb", 6), ("ethernet", 7), ("ci", 8), ("qp2", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineProtocol.setDescription("This value represents the protocol used on the line\ndevice.  Note that these values are incremented by\none compared to the standard DECnet values.")
phivLineServiceTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineServiceTimer.setDescription("This value represents the amount of time in\nmilliseconds allowed to elapse before a Data Link\nreceive request completes while doing service\noperations.")
phivLineMaxBlock = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 12, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivLineMaxBlock.setDescription("This value represents the Data Link maximum block\nsize on the line.")
nonBroadcastLine = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 14))
phivNonBroadcastTable = MibTable((1, 3, 6, 1, 2, 1, 18, 14, 1))
if mibBuilder.loadTexts: phivNonBroadcastTable.setDescription("The Non Broadcast Table.")
phivNonBroadcastEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 14, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivNonBroadcastIndex"))
if mibBuilder.loadTexts: phivNonBroadcastEntry.setDescription("There is one entry in the table for each\nNon Broadcast line.")
phivNonBroadcastIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 14, 1, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivNonBroadcastIndex.setDescription("The Non Broadcast line on which this entry's\nequivalence is effective.  This is the same value\nas the ifIndex.")
phivNonBroadcastController = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 14, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("normal", 1), ("loopback", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivNonBroadcastController.setDescription("This value represents the Physical Link hardware\ncontroller mode for the line device. The values\nfor controller-mode are:\n\nNORMAL  For normal controller operating mode.\n\nLOOPBACK For software controllable loopback of the\ncontroller. On those devices that can support this\nmode, it causes all transmitted messages to be looped\nback from within the controller itself. This is\naccomplished without any manual intervention other\nthan the setting of this parameter value.\n\nOTHER indicates function is not supported\nNote that these values are incremented by one compared to\nthe standard DECnet values.")
phivNonBroadcastDuplex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 14, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("full", 1), ("half", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivNonBroadcastDuplex.setDescription("This value represents the Physical Link hardware\nduplex mode of the line device. The possible modes\nare:\n\nFULL   Full-duplex\nHALF   Half-duplex\n\nNote that these values are incremented by one compared to\nthe standard DECnet values.")
phivNonBroadcastClock = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 14, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("external", 1), ("internal", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivNonBroadcastClock.setDescription("This value represents the Physical Link hardware clock\nmode for the line device. The values for clock-mode are:\nINTERNAL For software controllable loopback use of\nthe clock. On those devices that can support this\nmode, it causes the device to supply a clock signal\nsuch that a transmitted messages can be looped\nback from outside the device. This may require manual\nintervention other than the setting of this parameter\nvalue. For example, the operator may have to connect\na loopback plug in place of the normal line.\n\nEXTERNAL For normal clock operating mode, where the\nclock signal is supplied externally to the controller.\nNote that these values are incremented by one compared to\nthe standard DECnet values.")
phivNonBroadcastRetransmitTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 14, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)).clone(3000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivNonBroadcastRetransmitTimer.setDescription("This value represents number of milliseconds before\nthe Data Link retransmits a block on the line. On\nhalf-duplex lines, this parameter is the select timer.")
area = MibIdentifier((1, 3, 6, 1, 2, 1, 18, 15))
phivAreaTable = MibTable((1, 3, 6, 1, 2, 1, 18, 15, 1))
if mibBuilder.loadTexts: phivAreaTable.setDescription("Table of information kept on all areas known to\nthis unit.")
phivAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 18, 15, 1, 1)).setIndexNames((0, "DECNET-PHIV-MIB", "phivAreaNum"))
if mibBuilder.loadTexts: phivAreaEntry.setDescription("The area routing information.")
phivAreaNum = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 15, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAreaNum.setDescription("This value indicates the area number of this entry.")
phivAreaState = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 15, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(5,4,)).subtype(namedValues=NamedValues(("reachable", 4), ("unreachable", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAreaState.setDescription("This value indicates the state of the area")
phivAreaCost = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 15, 1, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAreaCost.setDescription("The total cost over the current path to the\ndestination area. Cost is a value associated with\nusing a circuit. Routing routes messages (data)\nalong the path between 2 areas with the smallest\ncost.")
phivAreaHops = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 15, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAreaHops.setDescription("The number of hops to a destination area. A hop is\nthe routing value representing the logical distance\nbetween two areas in network.")
phivAreaNextNode = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 15, 1, 1, 5), PhivAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAreaNextNode.setDescription("The next node on the circuit used to get to the\narea under scrutiny.")
phivAreaCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 18, 15, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: phivAreaCircuitIndex.setDescription("A unique index value for each known circuit.")
phivAreaMaxCost = MibScalar((1, 3, 6, 1, 2, 1, 18, 15, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 1022))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivAreaMaxCost.setDescription("This value represents the maximum total path cost\nallowed from the executor to any other level 2 routing\nnode. The AREA MAXIMUM COST number is decimal in the\nrange 1-1022. This parameter is only applicable if\nthe executor node is of type AREA.")
phivAreaMaxHops = MibScalar((1, 3, 6, 1, 2, 1, 18, 15, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivAreaMaxHops.setDescription("This value represents the maximum number of routing hops\nallowable from the executor to any other level 2\nrouting node.  This parameter is only applicable if the\nexecutor node is of type AREA.")
phivRouteMaxArea = MibScalar((1, 3, 6, 1, 2, 1, 18, 15, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: phivRouteMaxArea.setDescription("This value represents the largest area number and,\ntherefore, number of areas that can be known about\nby the executor node's Routing. This parameter is only\napplicable if the executor node is of type AREA.")

# Augmentions

# Exports

# Types
mibBuilder.exportSymbols("DECNET-PHIV-MIB", InterfaceIndex=InterfaceIndex, PhivAddr=PhivAddr, PhivCounter=PhivCounter)

# Objects
mibBuilder.exportSymbols("DECNET-PHIV-MIB", phiv=phiv, phivSystem=phivSystem, phivSystemState=phivSystemState, phivExecIdent=phivExecIdent, phivManagement=phivManagement, phivMgmtMgmtVers=phivMgmtMgmtVers, session=session, phivSessionSystemName=phivSessionSystemName, phivSessionInTimer=phivSessionInTimer, phivSessionOutTimer=phivSessionOutTimer, end=end, phivEndRemoteTable=phivEndRemoteTable, phivEndRemoteEntry=phivEndRemoteEntry, phivEndRemoteHostNodeID=phivEndRemoteHostNodeID, phivEndRemoteState=phivEndRemoteState, phivEndCircuitIndex=phivEndCircuitIndex, phivEndActiveLinks=phivEndActiveLinks, phivEndDelay=phivEndDelay, phivEndCountTable=phivEndCountTable, phivEndCountEntry=phivEndCountEntry, phivEndCountHostNodeID=phivEndCountHostNodeID, phivEndCountSecsLastZeroed=phivEndCountSecsLastZeroed, phivEndCountUsrBytesRec=phivEndCountUsrBytesRec, phivEndCountUsrBytesSent=phivEndCountUsrBytesSent, phivEndUCountUsrMessRec=phivEndUCountUsrMessRec, phivEndCountUsrMessSent=phivEndCountUsrMessSent, phivEndCountTotalBytesRec=phivEndCountTotalBytesRec, phivEndCountTotalBytesSent=phivEndCountTotalBytesSent, phivEndCountTotalMessRec=phivEndCountTotalMessRec, phivEndCountTotalMessSent=phivEndCountTotalMessSent, phivEndCountConnectsRecd=phivEndCountConnectsRecd, phivEndCountConnectsSent=phivEndCountConnectsSent, phivEndCountReponseTimeouts=phivEndCountReponseTimeouts, phivEndCountRecdConnectResErrs=phivEndCountRecdConnectResErrs, phivEndMaxLinks=phivEndMaxLinks, phivEndNSPVers=phivEndNSPVers, phivEndRetransmitFactor=phivEndRetransmitFactor, phivEndDelayFact=phivEndDelayFact, phivEndDelayWeight=phivEndDelayWeight, phivEndInactivityTimer=phivEndInactivityTimer, phivEndCountZeroCount=phivEndCountZeroCount, phivEndMaxLinksActive=phivEndMaxLinksActive, routing=routing, phivRouteBroadcastRouteTimer=phivRouteBroadcastRouteTimer, phivRouteBuffSize=phivRouteBuffSize, phivRouteRoutingVers=phivRouteRoutingVers, phivRouteMaxAddr=phivRouteMaxAddr, phivRouteMaxBdcastNonRouters=phivRouteMaxBdcastNonRouters, phivRouteMaxBdcastRouters=phivRouteMaxBdcastRouters, phivRouteMaxBuffs=phivRouteMaxBuffs, phivRouteMaxCircuits=phivRouteMaxCircuits, phivRouteMaxCost=phivRouteMaxCost, phivRouteMaxHops=phivRouteMaxHops, phivRouteMaxVisits=phivRouteMaxVisits, phivRouteRoutingTimer=phivRouteRoutingTimer, phivRouteSegBuffSize=phivRouteSegBuffSize, phivRouteType=phivRouteType, phivRouteCountAgedPktLoss=phivRouteCountAgedPktLoss, phivRouteCountNodeUnrPktLoss=phivRouteCountNodeUnrPktLoss, phivRouteCountOutRngePktLoss=phivRouteCountOutRngePktLoss, phivRouteCountOverSzePktLoss=phivRouteCountOverSzePktLoss, phivRouteCountPacketFmtErr=phivRouteCountPacketFmtErr, phivRouteCountPtlRteUpdtLoss=phivRouteCountPtlRteUpdtLoss, phivRouteCountVerifReject=phivRouteCountVerifReject, phivLevel1RouteTable=phivLevel1RouteTable, phivLevel1RouteEntry=phivLevel1RouteEntry, phivLevel1RouteNodeAddr=phivLevel1RouteNodeAddr, phivLevel1RouteCircuitIndex=phivLevel1RouteCircuitIndex, phivLevel1RouteCost=phivLevel1RouteCost, phivLevel1RouteHops=phivLevel1RouteHops, phivLevel1RouteNextNode=phivLevel1RouteNextNode, phivRouteCountZeroCount=phivRouteCountZeroCount, phivRouteSystemAddr=phivRouteSystemAddr, phivRouteRoutingType=phivRouteRoutingType, phivRouteSystemAddress=phivRouteSystemAddress, circuit=circuit, phivCircuitParametersTable=phivCircuitParametersTable, phivCircuitParametersEntry=phivCircuitParametersEntry, phivCircuitIndex=phivCircuitIndex, phivCircuitLineIndex=phivCircuitLineIndex, phivCircuitCommonState=phivCircuitCommonState, phivCircuitCommonSubState=phivCircuitCommonSubState, phivCircuitCommonName=phivCircuitCommonName, phivCircuitExecRecallTimer=phivCircuitExecRecallTimer, phivCircuitCommonType=phivCircuitCommonType, phivCircuitService=phivCircuitService, phivCircuitExecCost=phivCircuitExecCost, phivCircuitExecHelloTimer=phivCircuitExecHelloTimer, phivCircuitCountTable=phivCircuitCountTable, phivCircuitCountEntry=phivCircuitCountEntry, phivCircuitCountSecLastZeroed=phivCircuitCountSecLastZeroed, phivCircuitCountTermPacketsRecd=phivCircuitCountTermPacketsRecd, phivCircuitCountOriginPackSent=phivCircuitCountOriginPackSent, phivCircuitCountTermCongLoss=phivCircuitCountTermCongLoss, phivCircuitCountCorruptLoss=phivCircuitCountCorruptLoss, phivCircuitCountTransitPksRecd=phivCircuitCountTransitPksRecd, phivCircuitCountTransitPkSent=phivCircuitCountTransitPkSent, phivCircuitCountTransitCongestLoss=phivCircuitCountTransitCongestLoss, phivCircuitCountCircuitDown=phivCircuitCountCircuitDown, phivCircuitCountInitFailure=phivCircuitCountInitFailure, phivCircuitCountAdjDown=phivCircuitCountAdjDown, phivCircuitCountPeakAdj=phivCircuitCountPeakAdj, phivCircuitCountBytesRecd=phivCircuitCountBytesRecd, phivCircuitCountBytesSent=phivCircuitCountBytesSent, phivCircuitCountDataBlocksRecd=phivCircuitCountDataBlocksRecd, phivCircuitCountDataBlocksSent=phivCircuitCountDataBlocksSent, phivCircuitCountUsrBuffUnav=phivCircuitCountUsrBuffUnav, phivCircuitOrigQueueLimit=phivCircuitOrigQueueLimit, phivCircuitCountZeroCount=phivCircuitCountZeroCount, ddcmp=ddcmp, phivDDCMPCircuitParametersTable=phivDDCMPCircuitParametersTable, phivDDCMPCircuitParametersEntry=phivDDCMPCircuitParametersEntry, phivDDCMPCircuitIndex=phivDDCMPCircuitIndex, phivDDCMPCircuitAdjNodeAddr=phivDDCMPCircuitAdjNodeAddr, phivDDCMPCircuitTributary=phivDDCMPCircuitTributary, phivDDCMPCircuitCountTable=phivDDCMPCircuitCountTable, phivDDCMPCircuitCountEntry=phivDDCMPCircuitCountEntry, phivDDCMPCircuitErrorsInbd=phivDDCMPCircuitErrorsInbd, phivDDCMPCircuitErrorsOutbd=phivDDCMPCircuitErrorsOutbd, phivDDCMPCircuitRmteReplyTimeouts=phivDDCMPCircuitRmteReplyTimeouts, phivDDCMPCircuitLocalReplyTimeouts=phivDDCMPCircuitLocalReplyTimeouts, phivDDCMPCircuitRmteBuffErrors=phivDDCMPCircuitRmteBuffErrors, phivDDCMPCircuitLocalBuffErrors=phivDDCMPCircuitLocalBuffErrors, phivDDCMPCircuitSelectIntervalsElap=phivDDCMPCircuitSelectIntervalsElap, phivDDCMPCircuitSelectTimeouts=phivDDCMPCircuitSelectTimeouts, phivDDCMPLineCountTable=phivDDCMPLineCountTable)
mibBuilder.exportSymbols("DECNET-PHIV-MIB", phivDDCMPLineCountEntry=phivDDCMPLineCountEntry, phivDDCMPLineCountIndex=phivDDCMPLineCountIndex, phivDDCMPLineCountDataErrsIn=phivDDCMPLineCountDataErrsIn, phivDDCMPLineCountRmteStationErrs=phivDDCMPLineCountRmteStationErrs, phivDDCMPLineCountLocalStationErrs=phivDDCMPLineCountLocalStationErrs, control=control, phivControlSchedTimer=phivControlSchedTimer, phivControlDeadTimer=phivControlDeadTimer, phivControlDelayTimer=phivControlDelayTimer, phivControlStreamTimer=phivControlStreamTimer, phivControlParametersTable=phivControlParametersTable, phivControlParametersEntry=phivControlParametersEntry, phivControlCircuitIndex=phivControlCircuitIndex, phivControlBabbleTimer=phivControlBabbleTimer, phivControlMaxBuffs=phivControlMaxBuffs, phivControlMaxTransmits=phivControlMaxTransmits, phivControlDyingBase=phivControlDyingBase, phivControlDyingIncrement=phivControlDyingIncrement, phivControlDeadThreshold=phivControlDeadThreshold, phivControlDyingThreshold=phivControlDyingThreshold, phivControlInactTreshold=phivControlInactTreshold, phivControlPollingState=phivControlPollingState, phivControlPollingSubState=phivControlPollingSubState, phivControlTransTimer=phivControlTransTimer, ethernet=ethernet, phivEthLinkParametersTable=phivEthLinkParametersTable, phivEthLinkParametersEntry=phivEthLinkParametersEntry, phivEthLinkIndex=phivEthLinkIndex, phivEthDesigRouterNodeAddr=phivEthDesigRouterNodeAddr, phivEthMaxRouters=phivEthMaxRouters, phivEthRouterPri=phivEthRouterPri, phivEthHardwareAddr=phivEthHardwareAddr, counters=counters, phivCountersCountTable=phivCountersCountTable, phivCountersCountEntry=phivCountersCountEntry, phivCountersIndex=phivCountersIndex, phivCountersCountBytesRecd=phivCountersCountBytesRecd, phivCountersCountBytesSent=phivCountersCountBytesSent, phivCountersCountDataBlocksRecd=phivCountersCountDataBlocksRecd, phivCountersCountDataBlocksSent=phivCountersCountDataBlocksSent, phivCountersCountEthUsrBuffUnav=phivCountersCountEthUsrBuffUnav, phivCountersCountMcastBytesRecd=phivCountersCountMcastBytesRecd, phivCountersCountDataBlksRecd=phivCountersCountDataBlksRecd, phivCountersCountDataBlksSent=phivCountersCountDataBlksSent, phivCountersCountMcastBlksRecd=phivCountersCountMcastBlksRecd, phivCountersCountBlksSentDef=phivCountersCountBlksSentDef, phivCountersCountBlksSentSingleCol=phivCountersCountBlksSentSingleCol, phivCountersCountBlksSentMultCol=phivCountersCountBlksSentMultCol, phivCountersCountSendFailure=phivCountersCountSendFailure, phivCountersCountCollDetectFailure=phivCountersCountCollDetectFailure, phivCountersCountReceiveFailure=phivCountersCountReceiveFailure, phivCountersCountUnrecFrameDest=phivCountersCountUnrecFrameDest, phivCountersCountDataOver=phivCountersCountDataOver, phivCountersCountSysBuffUnav=phivCountersCountSysBuffUnav, phivCountersCountUsrBuffUnav=phivCountersCountUsrBuffUnav, adjacency=adjacency, phivAdjTable=phivAdjTable, phivAdjEntry=phivAdjEntry, phivAdjCircuitIndex=phivAdjCircuitIndex, phivAdjNodeAddr=phivAdjNodeAddr, phivAdjBlockSize=phivAdjBlockSize, phivAdjListenTimer=phivAdjListenTimer, phivAdjCircuitEtherServPhysAddr=phivAdjCircuitEtherServPhysAddr, phivAdjType=phivAdjType, phivAdjState=phivAdjState, phivAdjPriority=phivAdjPriority, phivAdjExecListenTimer=phivAdjExecListenTimer, phivAdjNodeTable=phivAdjNodeTable, phivAdjNodeEntry=phivAdjNodeEntry, phivAdjNodeCircuitIndex=phivAdjNodeCircuitIndex, phivAdjAddr=phivAdjAddr, phivAdjNodeBlockSize=phivAdjNodeBlockSize, phivAdjNodeListenTimer=phivAdjNodeListenTimer, phivAdjNodeCircuitEtherServPhysAddr=phivAdjNodeCircuitEtherServPhysAddr, phivAdjNodeType=phivAdjNodeType, phivAdjNodeState=phivAdjNodeState, phivAdjNodePriority=phivAdjNodePriority, line=line, phivLineTable=phivLineTable, phivLineEntry=phivLineEntry, phivLineIndex=phivLineIndex, phivLineName=phivLineName, phivLineState=phivLineState, phivLineSubstate=phivLineSubstate, phivLineService=phivLineService, phivLineDevice=phivLineDevice, phivLineReceiveBuffs=phivLineReceiveBuffs, phivLineProtocol=phivLineProtocol, phivLineServiceTimer=phivLineServiceTimer, phivLineMaxBlock=phivLineMaxBlock, nonBroadcastLine=nonBroadcastLine, phivNonBroadcastTable=phivNonBroadcastTable, phivNonBroadcastEntry=phivNonBroadcastEntry, phivNonBroadcastIndex=phivNonBroadcastIndex, phivNonBroadcastController=phivNonBroadcastController, phivNonBroadcastDuplex=phivNonBroadcastDuplex, phivNonBroadcastClock=phivNonBroadcastClock, phivNonBroadcastRetransmitTimer=phivNonBroadcastRetransmitTimer, area=area, phivAreaTable=phivAreaTable, phivAreaEntry=phivAreaEntry, phivAreaNum=phivAreaNum, phivAreaState=phivAreaState, phivAreaCost=phivAreaCost, phivAreaHops=phivAreaHops, phivAreaNextNode=phivAreaNextNode, phivAreaCircuitIndex=phivAreaCircuitIndex, phivAreaMaxCost=phivAreaMaxCost, phivAreaMaxHops=phivAreaMaxHops, phivRouteMaxArea=phivRouteMaxArea)

