// File is generated by JavaScriptCore/inspector/scripts/CodeGeneratorInspector.py

// Copyright (c) 2013 Apple Inc. All Rights Reserved.
// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


#include "config.h"
#include "InspectorJSFrontendDispatchers.h"

#if ENABLE(INSPECTOR)

#include <wtf/text/CString.h>
#include <wtf/text/WTFString.h>

namespace Inspector {

void InspectorDebuggerFrontendDispatcher::globalObjectCleared()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.globalObjectCleared"));

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorDebuggerFrontendDispatcher::scriptParsed(const Inspector::TypeBuilder::Debugger::ScriptId& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, const bool* const isContentScript, const String* const sourceMapURL, const bool* const hasSourceURL)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.scriptParsed"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString(ASCIILiteral("scriptId"), scriptId);
    paramsObject->setString(ASCIILiteral("url"), url);
    paramsObject->setNumber(ASCIILiteral("startLine"), startLine);
    paramsObject->setNumber(ASCIILiteral("startColumn"), startColumn);
    paramsObject->setNumber(ASCIILiteral("endLine"), endLine);
    paramsObject->setNumber(ASCIILiteral("endColumn"), endColumn);
    if (isContentScript)
        paramsObject->setBoolean(ASCIILiteral("isContentScript"), *isContentScript);
    if (sourceMapURL)
        paramsObject->setString(ASCIILiteral("sourceMapURL"), *sourceMapURL);
    if (hasSourceURL)
        paramsObject->setBoolean(ASCIILiteral("hasSourceURL"), *hasSourceURL);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorDebuggerFrontendDispatcher::scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.scriptFailedToParse"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString(ASCIILiteral("url"), url);
    paramsObject->setString(ASCIILiteral("scriptSource"), scriptSource);
    paramsObject->setNumber(ASCIILiteral("startLine"), startLine);
    paramsObject->setNumber(ASCIILiteral("errorLine"), errorLine);
    paramsObject->setString(ASCIILiteral("errorMessage"), errorMessage);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorDebuggerFrontendDispatcher::breakpointResolved(const Inspector::TypeBuilder::Debugger::BreakpointId& breakpointId, PassRefPtr<Inspector::TypeBuilder::Debugger::Location> location)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.breakpointResolved"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString(ASCIILiteral("breakpointId"), breakpointId);
    paramsObject->setValue(ASCIILiteral("location"), location);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorDebuggerFrontendDispatcher::paused(PassRefPtr<Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::CallFrame> > callFrames, Reason::Enum reason, PassRefPtr<Inspector::InspectorObject> data)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.paused"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue(ASCIILiteral("callFrames"), callFrames);
    paramsObject->setString(ASCIILiteral("reason"), Inspector::TypeBuilder::getJSEnumConstantValue(reason));
    if (data)
        paramsObject->setValue(ASCIILiteral("data"), data);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorDebuggerFrontendDispatcher::resumed()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.resumed"));

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorDebuggerFrontendDispatcher::didSampleProbe(PassRefPtr<Inspector::TypeBuilder::Debugger::ProbeSample> sample)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Debugger.didSampleProbe"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue(ASCIILiteral("sample"), sample);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorInspectorFrontendDispatcher::evaluateForTestInFrontend(int testCallId, const String& script)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Inspector.evaluateForTestInFrontend"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber(ASCIILiteral("testCallId"), testCallId);
    paramsObject->setString(ASCIILiteral("script"), script);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorInspectorFrontendDispatcher::inspect(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> object, PassRefPtr<Inspector::InspectorObject> hints)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Inspector.inspect"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue(ASCIILiteral("object"), object);
    paramsObject->setValue(ASCIILiteral("hints"), hints);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorInspectorFrontendDispatcher::detached(const String& reason)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Inspector.detached"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString(ASCIILiteral("reason"), reason);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorInspectorFrontendDispatcher::targetCrashed()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Inspector.targetCrashed"));

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorRuntimeFrontendDispatcher::executionContextCreated(PassRefPtr<Inspector::TypeBuilder::Runtime::ExecutionContextDescription> context)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString(ASCIILiteral("method"), ASCIILiteral("Runtime.executionContextCreated"));
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue(ASCIILiteral("context"), context);
    jsonMessage->setObject(ASCIILiteral("params"), paramsObject);

    m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}


} // namespace Inspector

#endif // ENABLE(INSPECTOR)
