/*  Last edited: Jun 13 17:16 2001 (rmd) */
/*
 * This software has been created by Genome Research Limited (GRL). 
 * GRL hereby grants permission to use, copy, modify and distribute 
 * this software and its documentation for non-commercial purposes 
 * without fee at the user's own risk on the basis set out below.
 * GRL neither undertakes nor accepts any duty whether contractual or 
 * otherwise in connection with the software, its use or the use of 
 * any derivative, and makes no representations or warranties, express
 * or implied, concerning the software, its suitability, fitness for
 * a particular purpose or non-infringement.
 * In no event shall the authors of the software or GRL be 
 * responsible or liable for any loss or damage whatsoever arising in
 * any way directly or indirectly out of the use of this software or 
 *  its derivatives, even if advised of the possibility of such damage.
 * Our software can be freely distributed under the conditions set 
 * out above, and must contain this copyright notice.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <seq_util.h>

void regerr(int errno);

#define INIT   register char *sp = instring;
#define GETC() (*sp++)
#define PEEKC()     (*sp)
#define UNGETC(c)   (--sp)
#define RETURN(c)   return
#define ERROR(c)    regerr(c)
#define REGEXP_BUF_SIZE 100000

#include<regexp.h>

void regerr(int errno)
{
  fprintf(stderr,"\n! ERROR in regexp, code %d\n",errno);
  exit(1);
}

char *next_regexp_match(char *instring, SEQUENCE *seq, int *len)
{
  static SEQUENCE *last_seq=NULL;
  static char *last_instring=NULL, *loc;
  static char expbuf[REGEXP_BUF_SIZE];
  extern char *loc1, *loc2;

  if ( instring != last_instring )
    {
      loc = seq->s;
      last_instring = instring;
      last_seq = seq;
      compile( instring, expbuf, expbuf+REGEXP_BUF_SIZE, '\0');
    }
  
  if ( seq != last_seq )
    {
      loc = seq->s;
      last_seq = seq;
    }

  if ( step( loc, expbuf ) )
    {
      *len = loc2-loc1;
      loc = loc1+1;
      return loc1;
    }
  else
    {
      last_seq = NULL;
      return NULL;
    }
}

char *next_match(char *string, SEQUENCE *seq)
{
  return (char*)strstr( seq->s, string );
}
