/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    private static final String ACCESS_KEY_PROPERTY = "aws.accessKeyId";
    private static final String SECRET_KEY_PROPERTY = "aws.secretKey";

    @Override
    public AWSCredentials getCredentials() {
        if (System.getProperty(ACCESS_KEY_PROPERTY) != null && System.getProperty(SECRET_KEY_PROPERTY) != null) {
            return new BasicAWSCredentials(System.getProperty(ACCESS_KEY_PROPERTY), System.getProperty(SECRET_KEY_PROPERTY));
        }
        throw new AmazonClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

