/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.config;

import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class DefaultConfigurator {
    public static final String ENV_AWS_CREDENTIAL_FILE = "AWS_CREDENTIAL_FILE";
    public static final String ENV_AWS_IAM_URL = "AWS_IAM_URL";
    public static final String ENV_CLIENT_CONFIG_FILE = "CLIENT_CONFIG_FILE";
    private static DefaultConfigurator INSTANCE_;
    private static final String LOGGING_LEVEL_KEY = "log4j.logger.com.amazonaws.services.auth.identity.cli";
    private static final String ROOT_LOGGING_LEVEL_KEY = "log4j.rootLogger";
    private static final String DEFAULT_END_POINT = "https://iam.amazonaws.com/";
    private static final String DEFAULT_PATH = "/";
    private Properties loggerProperties_;

    private DefaultConfigurator() {
    }

    public static DefaultConfigurator getInstance() {
        if (INSTANCE_ == null) {
            INSTANCE_ = new DefaultConfigurator();
        }
        return INSTANCE_;
    }

    public void enableLogging() {
        this.loggerProperties_ = new Properties();
        this.loggerProperties_.put(ROOT_LOGGING_LEVEL_KEY, "WARN, A1");
        this.loggerProperties_.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        this.loggerProperties_.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        this.loggerProperties_.put(LOGGING_LEVEL_KEY, "INFO");
        PropertyConfigurator.configure((Properties)this.loggerProperties_);
    }

    public void enableDebugLogging() {
        this.loggerProperties_.put(LOGGING_LEVEL_KEY, "DEBUG");
        this.loggerProperties_.put(ROOT_LOGGING_LEVEL_KEY, "DEBUG, A1");
        PropertyConfigurator.configure((Properties)this.loggerProperties_);
    }

    public final String getEndPointURL() {
        String endPoint = System.getenv(ENV_AWS_IAM_URL);
        if (endPoint == null) {
            endPoint = DEFAULT_END_POINT;
        }
        return endPoint;
    }

    public final String getDefaultPath() {
        return DEFAULT_PATH;
    }
}

