/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSlider;
import org.fest.swing.annotation.RunsInCurrentThread;

public final class JSliderLocation {
    private static final Map<Integer, JSliderLocationStrategy> LOCATIONS = new HashMap<Integer, JSliderLocationStrategy>();

    @RunsInCurrentThread
    public Point pointAt(JSlider slider, int value) {
        return LOCATIONS.get(slider.getOrientation()).locationForValue(slider, value);
    }

    static {
        LOCATIONS.put(0, new JSliderHorizontalLocation());
        LOCATIONS.put(1, new JSliderVerticalLocation());
    }

    private static abstract class JSliderLocationStrategy {
        private JSliderLocationStrategy() {
        }

        @RunsInCurrentThread
        final Point locationForValue(JSlider slider, int value) {
            Point center = new Point(slider.getWidth() / 2, slider.getHeight() / 2);
            int max = this.max(slider, slider.getInsets());
            int coordinate = (int)(this.percent(slider, value) * (float)max);
            if (!slider.getInverted()) {
                coordinate = max - coordinate;
            }
            return this.update(center, coordinate);
        }

        @RunsInCurrentThread
        abstract int max(JSlider var1, Insets var2);

        @RunsInCurrentThread
        abstract Point update(Point var1, int var2);

        @RunsInCurrentThread
        private float percent(JSlider slider, int value) {
            int minimum = slider.getMinimum();
            int range = slider.getMaximum() - minimum;
            return (float)(value - minimum) / (float)range;
        }
    }

    private static class JSliderVerticalLocation
    extends JSliderLocationStrategy {
        private JSliderVerticalLocation() {
        }

        @RunsInCurrentThread
        int max(JSlider slider, Insets insets) {
            return slider.getHeight() - insets.top - insets.bottom - 1;
        }

        @RunsInCurrentThread
        Point update(Point center, int coordinate) {
            return new Point(center.x, coordinate);
        }
    }

    private static class JSliderHorizontalLocation
    extends JSliderLocationStrategy {
        private JSliderHorizontalLocation() {
        }

        @RunsInCurrentThread
        int max(JSlider slider, Insets insets) {
            return slider.getWidth() - insets.left - insets.right - 1;
        }

        @RunsInCurrentThread
        Point update(Point center, int coordinate) {
            return new Point(coordinate, center.y);
        }
    }
}

