#!/bin/bash

################################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_RecordLogCapabilities.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_RecordLogCapabilities provider module";
Name = "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesModule";
Location = "cmpiOpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_RecordLogCapabilities provider";
Name = "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesProvider";
ProviderModuleName = "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_RecordLogCapabilities provider capabilities";
ProviderModuleName = "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesModule";
ProviderName = "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesProvider";
ClassName = "OpenDRIM_RecordLogCapabilities";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "InstanceID", "ElementName", "ElementNameEditSupported", "MaxElementNameLen", "RequestedStatesSupported", "ElementNameMask", "StateAwareness"};
SupportedMethods = {"CreateGoalSettings"};
CapabilityID = "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_RecordLogCapabilities.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_RecordLogCapabilities]   
   provider: OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesProvider
   location: cmpiOpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilitiesProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_RecordLogCapabilities.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_RecordLogCapabilities-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_RecordLogCapabilities.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
