#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Torin's Passage
# send your bug reports to contact@dotslashplay.it
###

script_version=20240615.2

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='torins-passage'
GAME_NAME='Torinʼs Passage'

ARCHIVE_BASE_0_NAME='setup_torins_passage_2.0.0.7.exe'
ARCHIVE_BASE_0_MD5='a7398abdb6964bf6a6446248f138d05e'
ARCHIVE_BASE_0_SIZE='350000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.7'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/torins_passage'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_MAIN_FILES='
movie
patches
version
resource.cfg
install.txt
*.000
*.aud
*.drv
*.err
*.exe
*.hlp
*.scr
*.sfx
*.shp'
CONTENT_DOC_MAIN_FILES='
torin.txt
*.pdf'

USER_PERSISTENT_FILES='
version
resource.cfg
TORIN.PRF
AUTOSAVE.*
TORINSG.*'

APP_MAIN_EXE='sierrah.exe'
APP_MAIN_OPTIONS='resource.cfg'
APP_MAIN_ICON='torinhr.ico'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

## Ignore a harmless warning from convert.
content_inclusion_icons 2>/dev/null
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
