#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cinders
# send your bug reports to contact@dotslashplay.it
###

script_version=20241106.3

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='cinders'
GAME_NAME='Cinders'

ARCHIVE_BASE_HUMBLE_0_NAME='Cinders_windows_1403727643.exe'
ARCHIVE_BASE_HUMBLE_0_MD5='4014b54d5db0e2622b2eccc55abb829d'
ARCHIVE_BASE_HUMBLE_0_TYPE='innosetup'
ARCHIVE_BASE_HUMBLE_0_SIZE='105905'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble.1403727643'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/cinders'

ARCHIVE_BASE_GOG_0_NAME='setup_cinders_1.2.7_(27636).exe'
ARCHIVE_BASE_GOG_0_MD5='511b82f5b2b9ca06636fe424980ff1bf'
ARCHIVE_BASE_GOG_0_TYPE='innosetup'
ARCHIVE_BASE_GOG_0_SIZE='280000'
ARCHIVE_BASE_GOG_0_VERSION='1.2.7-gog27636'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/cinders'

CONTENT_PATH_DEFAULT_HUMBLE='app'
CONTENT_PATH_DEFAULT_GOG='.'
CONTENT_GAME_BIN_FILES='
cinders.exe'
## TODO: Check if the Steam libraries are required
CONTENT_GAME0_BIN_FILES_HUMBLE='
msvcr100.dll
msvcr120.dll
ogg.dll
openal32.dll
steam_api.dll
steamcaster.dll
vorbis.dll
vorbisfile.dll
wrap_oal.dll'
CONTENT_GAME_DATA_FILES_HUMBLE='
images
music
sound'
CONTENT_GAME_DATA_FILES_GOG='
data.win
*.ogg'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Cinders'
## TODO: Check if it is required with current WINE
WINE_VIRTUAL_DESKTOP='auto'
## Work around audio issues
## TODO: Check if it is required with current WINE
WINE_WINETRICKS_VERBS='dsound'

APP_MAIN_EXE='cinders.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
