#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# 1365
# send your bug reports to contact@dotslashplay.it
###

script_version=20230104.1

GAME_ID='1365-game'
GAME_NAME='1365'

ARCHIVE_BASE_0='1365 Linux 1.0'
ARCHIVE_BASE_0_MD5='8cb8fb11a2df4af72154f2909238c09c'
ARCHIVE_BASE_0_TYPE='file'
ARCHIVE_BASE_0_SIZE='32000'
ARCHIVE_BASE_0_VERSION='1.0.0-itch1'
ARCHIVE_BASE_0_URL='https://shadybug.itch.io/1365'

APP_MAIN_EXE='1365 Linux 1.0'

PKG_MAIN_ARCH='32'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
ld-linux-x86-64.so.2
libasound.so.2
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libpulse-simple.so.0
libpulse.so.0
libX11.so.6
libXcursor.so.1
libXinerama.so.1
libXi.so.6
libXrandr.so.2'

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Include icons from optional archive

ARCHIVE_OPTIONAL_ICONS='1356_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='f820888c924fed091c5d64d9aaa2d467'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/1365/'

CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
256x256
512x512'

archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS'

if [ -n "$ARCHIVE_ICONS" ]; then
	archive_extraction 'ARCHIVE_ICONS'
	content_inclusion 'ICONS' 'PKG_MAIN' "$(path_icons)"
	rm --recursive "${PLAYIT_WORKDIR}/gamedata"
fi

# Include game data

package_path=$(package_path 'PKG_MAIN')
path_game_data=$(path_game_data)
application_exe=$(application_exe 'APP_MAIN')
mkdir --parents "${package_path}${path_game_data}"
cp "$SOURCE_ARCHIVE" "${package_path}${path_game_data}/${application_exe}"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
