#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2021 Anna Lea
set -o errexit

###
# Finding Paradise
# send your bug reports to contact@dotslashplay.it
###

script_version=20240504.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='finding-paradise'
GAME_NAME='Finding Paradise'

ARCHIVE_BASE_1_NAME='finding_paradise_gog_3_lang_26461.sh'
ARCHIVE_BASE_1_MD5='d5f8adf528d95845893b0d23dac449d6'
ARCHIVE_BASE_1_SIZE='320000'
ARCHIVE_BASE_1_VERSION='3-gog26461'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/finding_paradise'

ARCHIVE_BASE_0_NAME='finding_paradise_gog_3_lang_25982.sh'
ARCHIVE_BASE_0_MD5='dbfe49910afb07109803ee24c796c868'
ARCHIVE_BASE_0_SIZE='310000'
ARCHIVE_BASE_0_VERSION='3-gog25982'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_FILES='
libruby.so.2.1'
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/lib64"
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_FILES='
FindingParadise.amd64'
CONTENT_GAME_BIN32_FILES='
FindingParadise.x86'
CONTENT_FONT_DATA_PATH="${CONTENT_PATH_DEFAULT}/Fonts"
CONTENT_FONT_DATA_FILES='
OpenSans.ttf'
CONTENT_GAME_DATA_FILES='
mkxp
mkxp.conf
Audio.dat
Finding Paradise.ini
icon.png
Finding Paradise.rgssad'

APP_MAIN_EXE_BIN64='FindingParadise.amd64'
APP_MAIN_EXE_BIN32='FindingParadise.x86'
APP_MAIN_ICON='icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libcrypt.so.1
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libopenal.so.1
libphysfs.so.1
libpixman-1.so.0
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_ttf-2.0.so.0
libSDL_sound-1.0.so.1
libsigc-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
