#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Disco Elysium
###

script_version=20231018.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='disco-elysium'
GAME_NAME='Disco Elysium'

ARCHIVE_BASE_2_NAME='setup_disco_elysium_a0a062e7_(64bit)_(63158).exe'
ARCHIVE_BASE_2_MD5='1d9cab4e4952a588a5a8af30ac7dd7aa'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_PART1_NAME='setup_disco_elysium_a0a062e7_(64bit)_(63158)-1.bin'
ARCHIVE_BASE_2_PART1_MD5='fbe7a581843d47681ba0f2aa1696a58c'
ARCHIVE_BASE_2_PART2_NAME='setup_disco_elysium_a0a062e7_(64bit)_(63158)-2.bin'
ARCHIVE_BASE_2_PART2_MD5='8925592fc18c4565e262fd4e3008e9fc'
ARCHIVE_BASE_2_PART3_NAME='setup_disco_elysium_a0a062e7_(64bit)_(63158)-3.bin'
ARCHIVE_BASE_2_PART3_MD5='ddbda58eb8c570662689721246b4f081'
ARCHIVE_BASE_2_SIZE='10000000'
ARCHIVE_BASE_2_VERSION='1.0.a0a062e7-gog63158'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/disco_elysium'

ARCHIVE_BASE_1_NAME='setup_disco_elysium_3c54ad81_(64bit)_(60250).exe'
ARCHIVE_BASE_1_MD5='c915229dfa223b16f4399475589ff346'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_disco_elysium_3c54ad81_(64bit)_(60250)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='a6d13f109f26f17a2f1a9d06f519ba1f'
ARCHIVE_BASE_1_PART2_NAME='setup_disco_elysium_3c54ad81_(64bit)_(60250)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='816a2fed25591f9f26b094f9ead7a1af'
ARCHIVE_BASE_1_PART3_NAME='setup_disco_elysium_3c54ad81_(64bit)_(60250)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='a12113e41085154d94209cd076ce5057'
ARCHIVE_BASE_1_SIZE='10000000'
ARCHIVE_BASE_1_VERSION='1.0.3c54ad81-gog60250'

ARCHIVE_BASE_0_NAME='setup_disco_elysium_ee8d3b39_(64bit)_(58288).exe'
ARCHIVE_BASE_0_MD5='6b196bb79102de695bbc45904342b8ad'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_disco_elysium_ee8d3b39_(64bit)_(58288)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='120e95e8fef4537283705b5510af6d86'
ARCHIVE_BASE_0_PART2_NAME='setup_disco_elysium_ee8d3b39_(64bit)_(58288)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='82c73e068dc3b18893e11a45bf74242e'
ARCHIVE_BASE_0_PART3_NAME='setup_disco_elysium_ee8d3b39_(64bit)_(58288)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='20d337ae2de345628b5e4a6b9a2f55c7'
ARCHIVE_BASE_0_SIZE='10000000'
ARCHIVE_BASE_0_VERSION='1.0.ee8d3b39-gog58288'

UNITY3D_NAME='disco elysium'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_STREAMINGASSETS_FILES="
${UNITY3D_NAME}_data/streamingassets"

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/ZAUM Studio/Disco Elysium'

PACKAGES_LIST='PKG_BIN PKG_DATA_STREAMINGASSETS PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_STREAMINGASSETS_ID="${PKG_DATA_ID}-streamingassets"
PKG_DATA_STREAMINGASSETS_DESCRIPTION="$PKG_DATA_DESCRIPTION - streamingassets"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_STREAMINGASSETS_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
