!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_sig_noppm
!! NAME
!! calc_sig_noppm
!!
!! FUNCTION
!! Calculating contributions to self-energy operator without a plasmon pole model
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (FB, GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  nomega= total number of frequencies where evaluate $\Sigma_c$ matrix elements
!!  nomegae=number of frequencies where $\epsilon^{-1}$ has been evaluated 
!!  nomegaei= number of imaginary frequencies for $\epsilon^{-1}$ (non zero)
!!  nomegaer= number of real frequencies for $\epsilon^{-1}$
!!  npwc= number of G vectors
!!  theta_mu_minus_e0i=
!!  omegame0i(nomega)= contains $\omega-\epsilon_{k-q,b1,\sigma}$
!!  epsm1q(npwc,npwc,nomegae)=symmetrized inverse dielectric matrix 
!!  omega(nomegae)=frequencies for $\epsilon^{-1}$
!!  rhotwgp(npwc)=oscillator matrix elements: $\langle k-q,b1,\sigma|e^{-i(q+G)r} |k,b2,\sigma \rangle$
!!
!! OUTPUT
!! ket(npwc,nomega)= 
!!
!! NOTES
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      cgemv,spline,splint
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine calc_sig_noppm(npwc,nomega,nomegae,nomegaer,nomegaei,rhotwgp,&
&                     omega,epsm1q,omegame0i,theta_mu_minus_e0i,ket)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,nomegae,nomegaei,nomegaer,npwc
 real(dp),intent(in) :: theta_mu_minus_e0i
!arrays
 real(dp),intent(in) :: omegame0i(nomega)
 complex,intent(in) :: epsm1q(npwc,npwc,nomegae),omega(nomegae),rhotwgp(npwc)
 complex,intent(inout) :: ket(npwc,nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,io,ios
 real(dp) :: omg1,omg2,rt_imag,rt_real
 complex :: ct,domegaleft,domegaright,fact
 complex,external :: cdotc
!arrays
 real(dp) :: omegame0i_tmp(nomega),rtmp(nomegaer),tmp_x(2),tmp_y(2)
 real(dp) :: work(nomegaer)
 complex :: epsrho(npwc,nomegae),epsrho_imag(npwc,nomegaei+1)
 complex :: omega_imag(nomegaei+1)

!*************************************************************************

#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'CGEMV' :: cgemv
#endif

!DEBUG
!write(6,*)' calc_sig_noppm : enter '
!ENDDEBUG

 !Avoid divergences
 omegame0i_tmp(:)=omegame0i(:)
 do ios=1,nomega
  if(abs(omegame0i_tmp(ios))<1.d-6) omegame0i_tmp(ios)=1.d-6
 end do

 !calculation of the numerators: \sum_{G''} (\epsilon^{-1}_{G G''}(\omega)-\delta_{G G''} \rho(G'')
 do io=1,nomegae
  call cgemv('N',npwc,npwc,(1.,0.),epsm1q(:,:,io),npwc,rhotwgp,1,(0.,0.),epsrho(:,io),1)
 end do

 epsrho_imag(:,1)=epsrho(:,1)
 omega_imag(1)=omega(1)
 epsrho_imag(:,2:nomegaei+1)=epsrho(:,nomegaer+1:nomegae)
 omega_imag(2:nomegaei+1)=omega(nomegaer+1:nomegae)

 do io=1,nomegaei+1
  if(io==1) then
   domegaleft = omega_imag(io)
   domegaright=(omega_imag(io+1)-omega_imag(io  )) *half
  elseif(io==nomegaei+1) then
   domegaleft = (omega_imag(io  )-omega_imag(io-1)) *half
   domegaright= (omega_imag(io  )-omega_imag(io-1)) *half
  else
   domegaleft = (omega_imag(io  )-omega_imag(io-1)) *half
   domegaright= (omega_imag(io+1)-omega_imag(io  )) *half
  end if

  do ios=1,nomega

   omg2=-aimag(omega_imag(io)+domegaright)/real(omegame0i_tmp(ios))
   omg1=-aimag(omega_imag(io)-domegaleft )/real(omegame0i_tmp(ios))
   fact=atan(omg2)-atan(omg1)
   ket(:,ios)=ket(:,ios)+epsrho_imag(:,io)*fact

  end do !ios
 end do !io

 ket(:,:)=ket(:,:)/pi

 do ios=1,nomega
  do ig=1,npwc
   call spline(dble(omega(1:nomegaer)),dble(epsrho(ig,1:nomegaer)),nomegaer,&
&              zero,zero,rtmp,work)
   ! BEGIN WRAPPED CALL (YP)
   tmp_x(1) = abs(omegame0i_tmp(ios))
   call splint(nomegaer,dble(omega(1:nomegaer)),dble(epsrho(ig,1:nomegaer)),&
&              rtmp,1,tmp_x,tmp_y)
   rt_real = tmp_y(1)
   ! END WRAPPED CALL (YP)
   call spline(dble(omega(1:nomegaer)),dble(aimag(epsrho(ig,1:nomegaer))),nomegaer,&
&              zero,zero,rtmp,work)
   ! BEGIN WRAPPED CALL (YP)
   tmp_x(1) = abs(omegame0i_tmp(ios))
   call splint(nomegaer,dble(omega(1:nomegaer)),dble(aimag(epsrho(ig,1:nomegaer))),&
&              rtmp,1,tmp_x,tmp_y)
   rt_imag = tmp_y(1)
   ! END WRAPPED CALL (YP)

   ct=cmplx(rt_real,rt_imag)

   if(omegame0i_tmp(ios)>tol12) then
    ket(ig,ios)=ket(ig,ios)+ct*(1.-theta_mu_minus_e0i)
   end if
   if(omegame0i_tmp(ios)<-tol12) then
    ket(ig,ios)=ket(ig,ios)-ct*theta_mu_minus_e0i
   end if

  end do !ig
 end do !ios

!DEBUG
! write(*,*) npwc,ket(:)
! stop
!ENDDEBUG

end subroutine calc_sig_noppm
!!***
