!{\src2tex{textfont=tt}}
!!****f* ABINIT/identk
!! NAME
!! identk
!!
!! FUNCTION
!! Identify k-points in whole BZ and also the q-points by which they differ
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  irottb(nr,nop)=rotation table for r-points (see surot.F90)
!!  kibz(3,nkibz)=coordinates of k-points in IBZ
!!  ninv=if 2, inversion is considered; if 1, inversion is not considered
!!  nkibz= number of k points in IBZ
!!  nkbzmx= maximum number of k points in BZ
!!  nop= number of symmetry operations
!!  nr= number of FFT grid points
!!  op(3,3,nop)= symmetry operation matrices in reciprocal space
!!
!! OUTPUT
!!  kbz(3,nkbzmx)= k-points in whole BZ
!!  ktab(nkbzmx)= table giving for each k-point in the BZ (kBZ), the corresponding 
!!   irreducible point (kIBZ), where kBZ= (IR) kIBZ and I is the inversion or the identity operation
!!  ktabr(nr,nkbzmx)= index of R**-1 r in the FFT array where kBZ=(IR) kIBZ 
!!  ktabi(nkbzmx)= for each k-point in the BZ defines whether inversion has to be 
!!   considered in the relation kBZ=(IR) kIBZ (1 => only R; -1 => -R)  
!!  ktabo(nkbzmx)= the symmetry operation R that takes kIBZ to each kBZ
!!  nkbz= no. of k-points in whole BZ
!!  wtk(nkibz)= weight for each k-point in IBZ for symmetric quantities:
!!       no. of distinct k''s in whole BZ/(ninv*nop)
!!
!! PARENTS
!!      mrgscr,screening,sigma
!!
!! CHILDREN
!!      dosym
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine identk(kibz,nkibz,nkbzmx,nr,nop,ninv,irottb,op,kbz,ktab,ktabr,&
& ktabi,ktabo,nkbz,wtk)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => identk
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ninv,nkbzmx,nkibz,nop,nr
 integer,intent(out) :: nkbz
!arrays
 integer,intent(in) :: irottb(nr,nop)
 integer,intent(out) :: ktab(nkbzmx),ktabi(nkbzmx),ktabo(nkbzmx)
 integer,intent(out) :: ktabr(nr,nkbzmx)
 real(dp),intent(in) :: kibz(3,nkibz),op(3,3,nop)
 real(dp),intent(out) :: kbz(3,nkbzmx),wtk(nkibz)

!Local variables ------------------------------
!scalars
 integer :: ii,iinv,ik,ikbz,ikibz,ikp,iold,iop,ir,jj
 character(len=500) :: message
!arrays
 real(dp) :: knew(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: icmpk2
#endif
!End of the abilint section

 write(message,'(a)')' identifying k-points'
 call wrtout(6,message,'COLL')

 !zero no. of k-points found
 nkbz=0

 !loop over k-points in IBZ
 do ikibz=1,nkibz
  wtk(ikibz)=0.0

  !loop over symmetry operations R and inversions I
  do iinv=1,ninv
   do iop=1,nop
    !form RIk
    call dosym(op(1,1,iop),iinv,kibz(1,ikibz),knew(1))
    !check whether it has already been found (to within a RL vector)
    iold=0
    do ikbz=1,nkbz
     iold=iold+icmpk2(knew,kbz(1,ikbz))
    end do

    if(iold==0) then
     nkbz=nkbz+1
     wtk(ikibz)=wtk(ikibz)+1.0
     if(nkbz>nkbzmx) then
      write(message,'(3a,i6,2a)')&
&      ' identk: ERROR',ch10, &
&      ' nkbzmx too small, nkbzmx = ',nkbzmx,ch10,      &
&      ' increase nkbzmx!'
      call wrtout(6,message,'COLL')
      call leave_new('COLL')
     end if
     kbz(1,nkbz)=knew(1)
     kbz(2,nkbz)=knew(2)
     kbz(3,nkbz)=knew(3)
     ktab(nkbz)=ikibz
     ktabo(nkbz)=iop
     ktabi(nkbz)=3-2*iinv
     do ir=1,nr
      !we want u(R**-1 r).  IROTTB contains the r-point-no. of R**-1 r.
      ktabr(ir,nkbz)=irottb(ir,iop)
     end do
    end if
   end do 
  end do 

  wtk(ikibz)=wtk(ikibz)/(ninv*nop)
 end do 

 !print out results
 write(6,'(a,i3,/,a,10x,a,/,(i3,3f12.6,3x,f12.6))')&
& ' number of k-points in irreducible wedge (IBZ) ',nkibz,&
& ' k-points [reciprocal lattice units]','weights',&
& (jj,(kibz(ii,jj),ii=1,3),wtk(jj),jj=1,nkibz)
 write(6,'(a,i3,a,/,a,i5,a)')&
& ' together with the',nop,' symmetry operations and inversion',&
& ' have yielded',nkbz,' k-points in Brillouin Zone (BZ):'
 do ik=1,nkbz-3,4
  write(6,'(i5,3(3f6.3,1x),3f6.3)') ik,((kbz(ii,ikp),ii=1,3),ikp=ik,ik+3)
 end do
 if((nkbz/4)*4/=nkbz) then
   write(6,'(i5,3(3f6.3,1x),3f6.3)')&
&   (nkbz/4*4)+1,((kbz(ii,ik),ii=1,3),ik=(nkbz/4)*4+1,nkbz)
 end if

 !write(6,'(a,/,(i3,f12.6))') ' weights for k-points in IBZ:',&
 !& (ii,wtk(ii),ii,1,nkibz)
 write(*,*)

end subroutine identk
!!***
