!{\src2tex{textfont=tt}}
!!****f* ABINIT/scpdt
!! NAME
!! scpdt
!!
!! FUNCTION
!! Compute scalar product of two vectors u and v in reciprocal space
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  u(3),v(3)=the two vectors
!!
!! OUTPUT
!!  function scpdt=scalar product of u and v in reciprocal space
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function scpdt(u,v,b1,b2,b3)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: scpdt
!arrays
 real(dp),intent(in) :: b1(3),b2(3),b3(3),u(3),v(3)

!Local variables-------------------------------

! *************************************************************************
! scpdt=0.0
! do i=1, 3
!   scpdt=scpdt+(u(1)*b1(i)+u(2)*b2(i)+u(3)*b3(i))*
!&                  (v(1)*b1(i)+v(2)*b2(i)+v(3)*b3(i))
! end do
 scpdt=&
& (u(1)*b1(1)+u(2)*b2(1)+u(3)*b3(1))*(v(1)*b1(1)+v(2)*b2(1)+v(3)*b3(1))+&
& (u(1)*b1(2)+u(2)*b2(2)+u(3)*b3(2))*(v(1)*b1(2)+v(2)*b2(2)+v(3)*b3(2))+&
& (u(1)*b1(3)+u(2)*b2(3)+u(3)*b3(3))*(v(1)*b1(3)+v(2)*b2(3)+v(3)*b3(3))

 end function scpdt
!!***
