# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################
import gtk
from APTonCD.core import constants
from APTonCD.core.gui import processEvents

class ProgressStepText(gtk.Label):
    def __init__(self, label  = ''):
        gtk.Label.__init__(self)
        self.text = label
        self.set_text(label)
        #self.set_justify(gtk.JUSTIFY_LEFT)
        self.set_alignment(xalign=0, yalign=0.5)
        self.set_use_markup(True)

    def set_current(self):
        self.set_markup('<b>%s</b>' % self.text)
    
    def set_done(self):
        self.set_text(self.text)
    
    def set_current_text(self, text):
        self.set_markup('<b>%s</b>' % text)
        
class ProgressStepImage(gtk.HBox):
    """
        this class will show a disk percent filled image.
    """
    def __init__(self):
        gtk.HBox.__init__(self)
        
        self.arrow = gtk.Arrow(gtk.ARROW_RIGHT, gtk.SHADOW_OUT)
        self.pack_start(self.arrow, expand = True, fill = True)

        self.image = gtk.Image()
        self.image.set_from_stock(gtk.STOCK_YES, gtk.ICON_SIZE_MENU)
        self.pack_start(self.image, expand = True, fill = True)
    
    def set_started(self):
        self.arrow.hide()
        self.image.hide()
        
    def set_current(self):
        """
            Defines the current process.
        """
        self.arrow.show()
        self.image.hide()
    
    def set_done(self):
        """
            Defines that process is done.
        """
        self.arrow.hide()
        self.image.show()

class ProgressSteps(gtk.HBox):
    """
        this class will mimic a collection of steps showing steps states.
    """
    def __init__(self, steps):
        gtk.HBox.__init__(self)
        self.steps_text = []
        self.steps_image = []
        
        self.main_space = gtk.Label('        ')
        self.main_space.set_justify(gtk.JUSTIFY_LEFT)
        
        self.pack_start(self.main_space, expand = False, fill = False)
        
        self.table = gtk.Table(rows = len(steps)+1, columns = 2, homogeneous = False)
        self.table.set_row_spacings(6)
        self.table.set_col_spacings(6)
        
        
        for n in range(len(steps)):
            text = ProgressStepText(steps[n])
            image = ProgressStepImage()
            
            self.steps_text.append(text)
            self.steps_image.append(image)
            
            self.table.attach(child = image, left_attach = 0, right_attach = 1, top_attach = n, bottom_attach= n+1, xoptions = gtk.FILL , yoptions = gtk.FILL)
            self.table.attach(child = text, left_attach = 1, right_attach = 2, top_attach = n, bottom_attach= n+1, xoptions = gtk.FILL, yoptions = gtk.FILL)
        
        
        text = ProgressStepText('  ')
        image = ProgressStepImage()
        
        self.steps_text.append(text)
        self.steps_image.append(image)
        
        self.table.attach(child = image, left_attach = 0, right_attach = 1, top_attach = len(steps), bottom_attach= len(steps)+1, xoptions = gtk.FILL , yoptions = gtk.FILL)
        self.table.attach(child = text, left_attach = 1, right_attach = 2, top_attach = len(steps), bottom_attach= len(steps)+1, xoptions = gtk.FILL, yoptions = gtk.FILL)
            
        self.pack_start(self.table, expand = True, fill = True)
        self.show_all()
        
        for n in range(len(self.steps_text)):
            self.steps_image[n].set_started()

    def set_current(self, indx):

        self.steps_text[indx].set_current()
        self.steps_image[indx].set_current()
        processEvents()
    
    def set_current_text(self, indx, text):
        self.steps_text[indx].set_current_text(text)
        
    def set_done(self, indx):
        self.steps_text[indx].set_done()
        self.steps_image[indx].set_done()
        processEvents()
        
