% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Id.R
\docType{class}
\name{Id-class}
\alias{Id-class}
\alias{Id}
\title{Refer to a table nested in a hierarchy (e.g. within a schema)}
\usage{
Id(...)
}
\arguments{
\item{...}{Components of the hierarchy, e.g. \code{schema}, \code{table},
or \code{cluster}, \code{catalog}, \code{schema}, \code{table},
depending on the database backend.
For more on these concepts, see
\url{https://stackoverflow.com/questions/7022755/}}
}
\description{
Objects of class \code{Id} have a single slot \code{name}, which is a named
character vector.
The \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}} method converts \code{Id} objects to strings.
Support for \code{Id} objects depends on the database backend.
They can be used in the following methods as \code{name} or \code{table} argument:
\itemize{
\item \code{\link[=dbCreateTable]{dbCreateTable()}}
\item \code{\link[=dbAppendTable]{dbAppendTable()}}
\item \code{\link[=dbReadTable]{dbReadTable()}}
\item \code{\link[=dbWriteTable]{dbWriteTable()}}
\item \code{\link[=dbExistsTable]{dbExistsTable()}}
\item \code{\link[=dbRemoveTable]{dbRemoveTable()}}
}

Objects of this class are also returned from \code{\link[=dbListObjects]{dbListObjects()}}.
}
\examples{
# Identifies a table in a specific schema:
Id(schema = "dbo", table = "Customer")

# Identifies a table in a specific cluster, catalog, and schema:
Id(cluster = "mycluster", catalog = "mycatalog", schema = "myschema", table = "mytable")

# Create a SQL expression for an identifier:
dbQuoteIdentifier(ANSI(), Id(schema = "nycflights13", table = "flights"))

# Write a table in a specific schema:
\dontrun{
dbWriteTable(con, Id(schema = "myschema", table = "mytable"), data.frame(a = 1))
}
}
