/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class adChatSystemMessage {
    public static int USER_ENTER = 0;
    public static int USER_LEAVE = 1;
    public static int USER_LIST = 2;
    private int type;
    private Vector list = null;
    private boolean valid = true;

    public adChatSystemMessage() {
        this.list = new Vector();
    }

    public adChatSystemMessage(String string) {
        if (!adChatSimpleXMLParser.containTag(string, "system")) {
            this.valid = false;
            return;
        }
        if (adChatSimpleXMLParser.containTag(string, "user_enter")) {
            this.type = USER_ENTER;
        } else if (adChatSimpleXMLParser.containTag(string, "user_leave")) {
            this.type = USER_LEAVE;
        } else if (adChatSimpleXMLParser.containTag(string, "user_list")) {
            this.type = USER_LIST;
        } else {
            this.valid = false;
            return;
        }
        this.list = new Vector();
        boolean bl = false;
        while (!bl) {
            String string2 = adChatSimpleXMLParser.getTag(string, "user_id");
            String string3 = adChatSimpleXMLParser.getTag(string, "user_name");
            if (string2 == null || string3 == null) {
                bl = true;
                continue;
            }
            adChatClientInfo adChatClientInfo2 = new adChatClientInfo();
            adChatClientInfo2.user_id = string2;
            adChatClientInfo2.user_name = string3;
            this.list.addElement(adChatClientInfo2);
            if (this.type == USER_LIST) {
                string = adChatSimpleXMLParser.removeTag(string, "user");
                continue;
            }
            bl = true;
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public Vector getList() {
        return this.list;
    }

    public int getListCount() {
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    public String getUserName(int n) {
        if (n >= 0 && n < this.list.size()) {
            return ((adChatClientInfo)this.list.elementAt((int)n)).user_name;
        }
        return null;
    }

    public String getUserId(int n) {
        if (n >= 0 && n < this.list.size()) {
            return ((adChatClientInfo)this.list.elementAt((int)n)).user_id;
        }
        return null;
    }

    public void appendUser(String string, String string2) {
        adChatClientInfo adChatClientInfo2 = new adChatClientInfo();
        adChatClientInfo2.user_id = string;
        adChatClientInfo2.user_name = string2;
        this.list.addElement(adChatClientInfo2);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String buildXML() {
        return this.toString();
    }

    public String toString() {
        if (this.type == USER_ENTER) {
            return adChatSystemMessage.buildUserEnterMsg(this.getUserId(0), this.getUserName(0));
        }
        if (this.type == USER_LEAVE) {
            return adChatSystemMessage.buildUserLeaveMsg(this.getUserId(0), this.getUserName(0));
        }
        if (this.type == USER_LIST) {
            return adChatSystemMessage.buildUserList(this.list);
        }
        return null;
    }

    public static String buildUserEnterMsg(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("<system>");
        stringBuffer.append("<user_enter>");
        if (string != null) {
            stringBuffer.append("<user_id>").append(string).append("</user_id>");
        }
        if (string2 != null) {
            stringBuffer.append("<user_name>").append(string2).append("</user_name>");
        }
        stringBuffer.append("</user_enter>");
        stringBuffer.append("</system>");
        return stringBuffer.toString();
    }

    public static String buildUserLeaveMsg(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("<system>");
        stringBuffer.append("<user_leave>");
        if (string != null) {
            stringBuffer.append("<user_id>").append(string).append("</user_id>");
        }
        if (string2 != null) {
            stringBuffer.append("<user_name>").append(string2).append("</user_name>");
        }
        stringBuffer.append("</user_leave>");
        stringBuffer.append("</system>");
        return stringBuffer.toString();
    }

    public static String buildUserList(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("<system><user_list>");
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("<user>");
            stringBuffer.append("<user_id>").append(((adChatClientInfo)vector.elementAt((int)i)).user_id).append("</user_id>");
            stringBuffer.append("<user_name>").append(((adChatClientInfo)vector.elementAt((int)i)).user_name).append("</user_name>");
            stringBuffer.append("</user>");
        }
        stringBuffer.append("</user_list></system>");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "<system><user_list>";
        string = string + "<user><user_id>1</user_id><user_name>A</user_name></user>";
        string = string + "</user_list></system>";
        adChatSystemMessage adChatSystemMessage2 = new adChatSystemMessage(string);
        for (int i = 0; i < adChatSystemMessage2.getListCount(); ++i) {
            System.out.println("User_Id(" + i + ") = " + adChatSystemMessage2.getUserId(i));
            System.out.println("User_Name(" + i + ") = " + adChatSystemMessage2.getUserName(i));
        }
    }
}

