/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class Graph
extends ApplicationFrame {
    public Graph(String title) throws IOException {
        super(title);
        XYDataset dataset = this.createDataset("color.dat");
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public Graph(String title, String fileName) throws IOException {
        super(title);
        XYDataset dataset = this.createDataset(fileName);
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
        this.pack();
        RefineryUtilities.centerFrameOnScreen(this);
        this.setVisible(true);
    }

    public Graph(String title, Double[][] arrayData) throws IOException {
        super(title);
        XYDataset dataset = this.createDataset(arrayData);
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
        this.pack();
        RefineryUtilities.centerFrameOnScreen(this);
        this.setVisible(true);
    }

    public XYDataset createDataset(String dataFileName) throws IOException {
        byte[] buffer;
        XYSeries series2;
        XYSeries series1;
        block20: {
            series1 = new XYSeries((Comparable)((Object)"First"));
            series2 = new XYSeries((Comparable)((Object)"Second"));
            buffer = new byte[(int)new File(dataFileName).length()];
            BufferedInputStream f = null;
            try {
                f = new BufferedInputStream(new FileInputStream(dataFileName));
                f.read(buffer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (f != null) {
                    try {
                        f.close();
                    }
                    catch (IOException iOException) {}
                }
                break block20;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (f == null) break block20;
            try {
                f.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String data = new String(buffer);
        data = data.replace("\t", " ");
        String[] lambda_val = data.split("\n");
        Double[][] colorData = new Double[lambda_val.length][2];
        try {
            int i = 0;
            while (i < lambda_val.length) {
                String[] lambda_color = lambda_val[i].split(" ");
                colorData[i][0] = Double.parseDouble(lambda_color[0]);
                colorData[i][1] = Double.parseDouble(lambda_color[1]);
                series2.add(colorData[i][0], (Number)colorData[i][1]);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("FILENAME: " + dataFileName);
            e.printStackTrace();
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        return dataset;
    }

    public XYDataset createDataset(Double[][] dataArray) {
        XYSeries series1 = new XYSeries((Comparable)((Object)"First"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Second"));
        int i = 0;
        while (i < dataArray.length) {
            series2.add(dataArray[i][0], (Number)dataArray[i][1]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart("Line Chart Demo 6", "X", "Y", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        plot.setRenderer(renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    public static void main(String[] args) throws IOException {
        Graph demo = new Graph("Line Chart Demo 6");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

