/*
 * $Id: faum-dev.h,v 1.8 2011-01-21 19:09:26 sand Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __FAUM_DEV_INCLUDED
#define __FAUM_DEV_INCLUDED

#if defined(DARWIN)
#include <sys/ioctl.h>
#else
#include <linux/ioctl.h>
#endif

struct faum_dev_info {
	struct {
		uint32_t base; /* with attributes */
		unsigned long size;
	} region[7];
};

#if defined(DARWIN)
#define FAUM_DEV_CREATE		0x00
#define FAUM_DEV_DESTROY	0x01
#else
#define FAUM_DEV_CREATE		_IOWR('F', 0x00, struct faum_dev_info)
#define FAUM_DEV_DESTROY	_IOWR('F', 0x01, struct faum_dev_info)
#endif

struct faum_dev_param {
	uint32_t addr;
	uint32_t data;
	unsigned int bs;
	int irq;
};

#if defined(DARWIN)
#define FAUM_DEV_C0R		0x02
#define FAUM_DEV_C0W		0x03
#define FAUM_DEV_MEMR		0x04
#define FAUM_DEV_MEMW		0x05
#define FAUM_DEV_IOR		0x06
#define FAUM_DEV_IOW		0x07
#else
#define FAUM_DEV_C0R		_IOWR('F', 0x10, struct faum_dev_param)
#define FAUM_DEV_C0W		_IOWR('F', 0x11, struct faum_dev_param)
#define FAUM_DEV_MEMR		_IOWR('F', 0x12, struct faum_dev_param)
#define FAUM_DEV_MEMW		_IOWR('F', 0x13, struct faum_dev_param)
#define FAUM_DEV_IOR		_IOWR('F', 0x14, struct faum_dev_param)
#define FAUM_DEV_IOW		_IOWR('F', 0x15, struct faum_dev_param)
#endif

#endif /* __FAUM_DEV_INCLUDED */
