#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Removes marks from selected text")

    def run(self):
        self.env["runtime"]["CursorManager"].clear_marks()
        self.env["runtime"]["OutputManager"].present_text(
            _("Remove marks"), interrupt=True
        )

    def set_callback(self, callback):
        pass
