/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MDBParser;

public class ZeissLSMReader
extends BaseTiffReader {
    private static final int ZEISS_ID = 34412;

    public ZeissLSMReader() {
        super("Zeiss Laser-Scanning Microscopy", "lsm");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block[0] != 73) {
            return false;
        }
        if (block[1] != 73) {
            return false;
        }
        if (block[2] != 42) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        int ifdlocation = DataTools.bytesToInt(block, 4, true);
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, true);
        for (int i = 0; i < ifdnumber; ++i) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return true;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, true);
            if (ifdtag != 34412) continue;
            return true;
        }
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.ifds = TiffTools.getIFDs(this.in);
        TiffTools.getSamples(this.ifds[2 * no], this.in, buf);
        return this.swapIfRequired(buf);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        if (2 * no + 1 < this.ifds.length) {
            return TiffTools.getImage(this.ifds[2 * no + 1], this.in);
        }
        return super.openThumbImage(no);
    }

    protected void initMetadata() {
        block68: {
            Hashtable ifd = this.ifds[0];
            try {
                int i;
                boolean little = TiffTools.isLittleEndian(ifd);
                this.in.order(little);
                super.initMetadata();
                short[] s = TiffTools.getIFDShortArray(ifd, 34412, true);
                byte[] cz = new byte[s.length];
                for (int i2 = 0; i2 < s.length; ++i2) {
                    cz[i2] = (byte)s[i2];
                    if (cz[i2] >= 0) continue;
                    int n = i2;
                    cz[n] = (byte)(cz[n] + 1);
                }
                RandomAccessStream ras = new RandomAccessStream(cz);
                ras.order(little);
                this.put("MagicNumber", ras.readInt());
                this.put("StructureSize", ras.readInt());
                this.put("DimensionX", ras.readInt());
                this.put("DimensionY", ras.readInt());
                this.core.sizeZ[0] = ras.readInt();
                int c = ras.readInt();
                this.core.sizeT[0] = ras.readInt();
                if (c > this.core.sizeC[0] || c != 1) {
                    this.core.sizeC[0] = c;
                }
                if (this.core.sizeC[0] == 0) {
                    this.core.sizeC[0] = this.core.sizeC[0] + 1;
                }
                while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeC[0] * this.core.sizeT[0]) {
                    if (this.core.sizeZ[0] > this.core.sizeT[0]) {
                        this.core.sizeZ[0] = this.core.sizeZ[0] + 1;
                        continue;
                    }
                    this.core.sizeT[0] = this.core.sizeT[0] + 1;
                }
                while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * this.getEffectiveSizeC()) {
                    this.core.imageCount[0] = this.core.imageCount[0] - 1;
                }
                this.put("DimensionZ", this.core.sizeZ[0]);
                this.put("DimensionChannels", this.core.sizeC[0]);
                this.put("DimensionTime", this.core.sizeT[0]);
                int dataType = ras.readInt();
                switch (dataType) {
                    case 1: {
                        this.put("DataType", "8 bit unsigned integer");
                        this.core.pixelType[0] = 1;
                        break;
                    }
                    case 2: {
                        this.put("DataType", "12 bit unsigned integer");
                        this.core.pixelType[0] = 3;
                        break;
                    }
                    case 5: {
                        this.put("DataType", "32 bit float");
                        this.core.pixelType[0] = 6;
                        break;
                    }
                    case 0: {
                        this.put("DataType", "varying data types");
                        this.core.pixelType[0] = -1;
                        break;
                    }
                    default: {
                        this.put("DataType", "8 bit unsigned integer");
                        this.core.pixelType[0] = -1;
                    }
                }
                if (this.core.pixelType[0] == -1) {
                    int[] bps = TiffTools.getBitsPerSample(ifd);
                    switch (bps[0]) {
                        case 16: {
                            this.core.pixelType[0] = 3;
                            break;
                        }
                        case 32: {
                            this.core.pixelType[0] = 6;
                            break;
                        }
                        default: {
                            this.core.pixelType[0] = 1;
                        }
                    }
                }
                this.put("ThumbnailX", ras.readInt());
                this.put("ThumbnailY", ras.readInt());
                this.put("VoxelSizeX", ras.readDouble());
                this.put("VoxelSizeY", ras.readDouble());
                this.put("VoxelSizeZ", ras.readDouble());
                this.put("OriginX", ras.readDouble());
                this.put("OriginY", ras.readDouble());
                this.put("OriginZ", ras.readDouble());
                short scanType = ras.readShort();
                switch (scanType) {
                    case 0: {
                        this.put("ScanType", "x-y-z scan");
                        this.core.currentOrder[0] = "XYZCT";
                        break;
                    }
                    case 1: {
                        this.put("ScanType", "z scan (x-z plane)");
                        this.core.currentOrder[0] = "XYZCT";
                        break;
                    }
                    case 2: {
                        this.put("ScanType", "line scan");
                        this.core.currentOrder[0] = "XYZCT";
                        break;
                    }
                    case 3: {
                        this.put("ScanType", "time series x-y");
                        this.core.currentOrder[0] = "XYTCZ";
                        break;
                    }
                    case 4: {
                        this.put("ScanType", "time series x-z");
                        this.core.currentOrder[0] = "XYZTC";
                        break;
                    }
                    case 5: {
                        this.put("ScanType", "time series 'Mean of ROIs'");
                        this.core.currentOrder[0] = "XYTCZ";
                        break;
                    }
                    case 6: {
                        this.put("ScanType", "time series x-y-z");
                        this.core.currentOrder[0] = "XYZTC";
                        break;
                    }
                    case 7: {
                        this.put("ScanType", "spline scan");
                        this.core.currentOrder[0] = "XYCTZ";
                        break;
                    }
                    case 8: {
                        this.put("ScanType", "spline scan x-z");
                        this.core.currentOrder[0] = "XYCZT";
                        break;
                    }
                    case 9: {
                        this.put("ScanType", "time series spline plane x-z");
                        this.core.currentOrder[0] = "XYTCZ";
                        break;
                    }
                    case 10: {
                        this.put("ScanType", "point mode");
                        this.core.currentOrder[0] = "XYZCT";
                        break;
                    }
                    default: {
                        this.put("ScanType", "x-y-z scan");
                        this.core.currentOrder[0] = "XYZCT";
                    }
                }
                MetadataStore store = this.getMetadataStore();
                FormatTools.populatePixels(store, this);
                for (int i3 = 0; i3 < this.core.sizeC[0]; ++i3) {
                    store.setLogicalChannel(i3, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                }
                short spectralScan = ras.readShort();
                switch (spectralScan) {
                    case 0: {
                        this.put("SpectralScan", "no spectral scan");
                        break;
                    }
                    case 1: {
                        this.put("SpectralScan", "acquired with spectral scan");
                        break;
                    }
                    default: {
                        this.put("SpectralScan", "no spectral scan");
                    }
                }
                long type = ras.readInt();
                switch ((int)type) {
                    case 0: {
                        this.put("DataType2", "original scan data");
                        break;
                    }
                    case 1: {
                        this.put("DataType2", "calculated data");
                        break;
                    }
                    case 2: {
                        this.put("DataType2", "animation");
                        break;
                    }
                    default: {
                        this.put("DataType2", "original scan data");
                    }
                }
                long overlayOffset = ras.readInt();
                long inputLUTOffset = ras.readInt();
                long outputLUTOffset = ras.readInt();
                long channelColorsOffset = ras.readInt();
                this.put("TimeInterval", ras.readDouble());
                ras.skipBytes(12);
                long timeStampOffset = ras.readInt();
                long eventListOffset = ras.readInt();
                long roiOffset = ras.readInt();
                long bleachRoiOffset = ras.readInt();
                ras.skipBytes(4);
                this.put("DisplayAspectX", ras.readDouble());
                this.put("DisplayAspectY", ras.readDouble());
                this.put("DisplayAspectZ", ras.readDouble());
                this.put("DisplayAspectTime", ras.readDouble());
                long meanOfRoisOverlayOffset = ras.readInt();
                long topoIsolineOverlayOffset = ras.readInt();
                long topoProfileOverlayOffset = ras.readInt();
                long linescanOverlayOffset = ras.readInt();
                this.put("ToolbarFlags", ras.readInt());
                ras.skipBytes(20);
                if (overlayOffset != 0L) {
                    this.parseOverlays(overlayOffset, "OffsetVectorOverlay", little);
                }
                if (inputLUTOffset != 0L) {
                    this.parseSubBlocks(inputLUTOffset, "OffsetInputLut", little);
                }
                if (outputLUTOffset != 0L) {
                    this.parseSubBlocks(outputLUTOffset, "OffsetOutputLut", little);
                }
                if (channelColorsOffset != 0L) {
                    int i4;
                    this.in.seek(channelColorsOffset + 4L);
                    int numColors = this.in.readInt();
                    int numNames = this.in.readInt();
                    if (numColors > this.core.sizeC[0]) {
                        this.in.seek(channelColorsOffset - 2L);
                        this.in.order(!little);
                        this.in.readInt();
                        numColors = this.in.readInt();
                        numNames = this.in.readInt();
                    }
                    long namesOffset = (long)this.in.readInt() + channelColorsOffset;
                    this.in.skipBytes(4);
                    if (namesOffset >= 0L) {
                        this.in.seek(namesOffset);
                        for (i4 = 0; i4 < numColors; ++i4) {
                            this.put("Intensity" + i4, this.in.readInt());
                        }
                    }
                    for (i4 = 0; i4 < numNames; ++i4) {
                        StringBuffer sb = new StringBuffer();
                        char current = (char)this.in.read();
                        while (current != '\u0000') {
                            if (current < '\u0080') {
                                sb.append(current);
                            }
                            current = (char)this.in.read();
                        }
                        if (sb.length() <= 128) {
                            this.put("ChannelName" + i4, sb.toString());
                            continue;
                        }
                        this.put("ChannelName" + i4, "");
                    }
                }
                if (timeStampOffset != 0L) {
                    this.in.seek(timeStampOffset + 4L);
                    int numberOfStamps = this.in.readInt();
                    for (i = 0; i < numberOfStamps; ++i) {
                        this.put("TimeStamp" + i, this.in.readDouble());
                    }
                }
                if (eventListOffset != 0L) {
                    this.in.seek(eventListOffset);
                    this.in.skipBytes(4);
                    int numEvents = this.in.readInt();
                    for (i = 0; i < numEvents; ++i) {
                        int size = this.in.readInt();
                        double eventTime = this.in.readDouble();
                        int eventType = this.in.readInt();
                        byte[] b = new byte[size - 16];
                        this.in.read(b);
                        this.put("Event" + i + " Time", eventTime);
                        this.put("Event" + i + " Type", eventType);
                        this.put("Event" + i + " Description", new String(b));
                    }
                }
                if (roiOffset != 0L) {
                    this.parseOverlays(roiOffset, "ROIOffset", little);
                }
                if (bleachRoiOffset != 0L) {
                    this.parseOverlays(bleachRoiOffset, "BleachROIOffset", little);
                }
                if (meanOfRoisOverlayOffset != 0L) {
                    this.parseOverlays(meanOfRoisOverlayOffset, "OffsetMeanOfRoisOverlay", little);
                }
                if (topoIsolineOverlayOffset != 0L) {
                    this.parseOverlays(topoIsolineOverlayOffset, "OffsetTopoIsolineOverlay", little);
                }
                if (topoProfileOverlayOffset != 0L) {
                    this.parseOverlays(topoProfileOverlayOffset, "OffsetTopoProfileOverlay", little);
                }
                if (linescanOverlayOffset != 0L) {
                    this.parseOverlays(linescanOverlayOffset, "OffsetLinescanOverlay", little);
                }
            }
            catch (FormatException exc) {
                if (debug) {
                    this.trace(exc);
                }
            }
            catch (IOException exc) {
                if (!debug) break block68;
                this.trace(exc);
            }
        }
        Object pixelSizeX = this.getMeta("VoxelSizeX");
        Object pixelSizeY = this.getMeta("VoxelSizeY");
        Object pixelSizeZ = this.getMeta("VoxelSizeZ");
        Float pixX = new Float(pixelSizeX == null ? "0" : pixelSizeX.toString());
        Float pixY = new Float(pixelSizeY == null ? "0" : pixelSizeY.toString());
        Float pixZ = new Float(pixelSizeZ == null ? "0" : pixelSizeZ.toString());
        MetadataStore store = this.getMetadataStore();
        store.setDimensions(pixX, pixY, pixZ, null, null, null);
        Location dir = new Location(this.currentId).getAbsoluteFile().getParentFile();
        String[] dirList = dir.list();
        for (int i = 0; i < dirList.length; ++i) {
            block69: {
                if (!dirList[i].toLowerCase().endsWith(".mdb")) continue;
                try {
                    MDBParser.parseDatabase(new Location(dir.getPath(), dirList[i]).getAbsolutePath(), this.metadata);
                }
                catch (FormatException exc) {
                    if (!debug) break block69;
                    this.trace(exc);
                }
            }
            i = dirList.length;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ZeissLSMReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Removing thumbnails");
        int numThumbs = 0;
        long prevOffset = 0L;
        byte[] b = new byte[48];
        byte[] c = new byte[48];
        for (int i = 0; i < this.ifds.length; ++i) {
            long subFileType = TiffTools.getIFDLongValue(this.ifds[i], 254, true, 0L);
            long[] offsets = TiffTools.getStripOffsets(this.ifds[i]);
            if (subFileType == 1L) {
                this.ifds[i] = null;
                ++numThumbs;
            } else if (i > 0) {
                this.in.seek(prevOffset);
                this.in.read(b);
                this.in.seek(offsets[0]);
                this.in.read(c);
                boolean equal = true;
                for (int j = 0; j < 48; ++j) {
                    if (b[j] == c[j]) continue;
                    equal = false;
                    j = 48;
                }
                if (equal) {
                    offsets[0] = offsets[0] + (offsets[0] - prevOffset);
                    TiffTools.putIFDValue(this.ifds[i], 273, offsets);
                }
            }
            prevOffset = offsets[0];
        }
        int ifdPointer = 0;
        Hashtable[] tempIFDs = new Hashtable[this.ifds.length - numThumbs];
        for (int i = 0; i < tempIFDs.length; ++i) {
            if (this.ifds[ifdPointer] != null) {
                tempIFDs[i] = this.ifds[ifdPointer];
                ++ifdPointer;
                continue;
            }
            while (this.ifds[ifdPointer] == null && ifdPointer < this.ifds.length) {
                ++ifdPointer;
            }
            tempIFDs[i] = this.ifds[ifdPointer];
            ++ifdPointer;
        }
        this.core.imageCount[0] = tempIFDs.length;
        this.ifds = tempIFDs;
        this.initMetadata();
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds.length > 1) {
            this.core.thumbSizeX[0] = TiffTools.getIFDIntValue(this.ifds[1], 256, false, 1);
            this.core.thumbSizeY[0] = TiffTools.getIFDIntValue(this.ifds[1], 257, false, 1);
        }
    }

    protected void parseOverlays(long data, String suffix, boolean little) throws IOException {
        block4: {
            if (data == 0L) {
                return;
            }
            this.in.seek(data);
            int nde = this.in.readInt();
            this.put("NumberDrawingElements-" + suffix, nde);
            int size = this.in.readInt();
            int idata = this.in.readInt();
            this.put("LineWidth-" + suffix, idata);
            idata = this.in.readInt();
            this.put("Measure-" + suffix, idata);
            this.in.readDouble();
            this.put("ColorRed-" + suffix, this.in.read());
            this.put("ColorGreen-" + suffix, this.in.read());
            this.put("ColorBlue-" + suffix, this.in.read());
            this.in.read();
            this.put("Valid-" + suffix, this.in.readInt());
            this.put("KnotWidth-" + suffix, this.in.readInt());
            this.put("CatchArea-" + suffix, this.in.readInt());
            this.put("FontHeight-" + suffix, this.in.readInt());
            this.put("FontWidth-" + suffix, this.in.readInt());
            this.put("FontEscapement-" + suffix, this.in.readInt());
            this.put("FontOrientation-" + suffix, this.in.readInt());
            this.put("FontWeight-" + suffix, this.in.readInt());
            this.put("FontItalic-" + suffix, this.in.readInt());
            this.put("FontUnderline-" + suffix, this.in.readInt());
            this.put("FontStrikeOut-" + suffix, this.in.readInt());
            this.put("FontCharSet-" + suffix, this.in.readInt());
            this.put("FontOutPrecision-" + suffix, this.in.readInt());
            this.put("FontClipPrecision-" + suffix, this.in.readInt());
            this.put("FontQuality-" + suffix, this.in.readInt());
            this.put("FontPitchAndFamily-" + suffix, this.in.readInt());
            byte[] temp = new byte[64];
            this.in.read(temp);
            this.put("FontFaceName-" + suffix, new String(temp));
            this.put("ClosedPolyline-" + suffix, this.in.read());
            this.put("OpenPolyline-" + suffix, this.in.read());
            this.put("ClosedBezierCurve-" + suffix, this.in.read());
            this.put("OpenBezierCurve-" + suffix, this.in.read());
            this.put("ArrowWithClosedTip-" + suffix, this.in.read());
            this.put("ArrowWithOpenTip-" + suffix, this.in.read());
            this.put("Ellipse-" + suffix, this.in.read());
            this.put("Circle-" + suffix, this.in.read());
            this.put("Rectangle-" + suffix, this.in.read());
            this.put("Line-" + suffix, this.in.read());
            try {
                int drawingEl = (size - 194) / nde;
                for (int i = 0; i < nde; ++i) {
                    byte[] draw = new byte[drawingEl];
                    this.in.read(draw);
                    this.put("DrawingElement" + i + "-" + suffix, new String(draw));
                }
            }
            catch (ArithmeticException exc) {
                if (!debug) break block4;
                this.trace(exc);
            }
        }
    }

    protected void parseSubBlocks(long data, String suffix, boolean little) throws IOException, FormatException {
        long numSubBlocks;
        if (data == 0L) {
            return;
        }
        this.in.seek((int)data);
        this.in.order(little);
        long size = this.in.readInt();
        if (size < 0L) {
            size += 0x100000000L;
        }
        if ((numSubBlocks = (long)this.in.readInt()) < 0L) {
            numSubBlocks += 0x100000000L;
        }
        this.put("NumSubBlocks-" + suffix, numSubBlocks);
        long numChannels = this.in.readInt();
        if (numChannels < 0L) {
            numChannels += 0x100000000L;
        }
        this.put("NumChannels-" + suffix, numChannels);
        data = this.in.readInt();
        if (data < 0L) {
            data += 0x100000000L;
        }
        this.put("LutType-" + suffix, data);
        data = this.in.readInt();
        if (data < 0L) {
            data += 0x100000000L;
        }
        this.put("Advanced-" + suffix, data);
        data = this.in.readInt();
        if (data < 0L) {
            data += 0x100000000L;
        }
        this.put("CurrentChannel-" + suffix, data);
        this.in.skipBytes(36);
        if (numSubBlocks > 100L) {
            numSubBlocks = 20L;
        }
        int i = 0;
        while ((long)i < numSubBlocks) {
            data = this.in.readInt();
            if (data < 0L) {
                data += 0x100000000L;
            }
            this.put("Type" + i + "-" + suffix, data);
            this.put("Size" + i + "-" + suffix, this.in.readInt());
            switch ((int)data) {
                case 1: {
                    int j = 0;
                    while ((long)j < numChannels) {
                        this.put("GammaChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        ++j;
                    }
                    break;
                }
                case 2: {
                    int j = 0;
                    while ((long)j < numChannels) {
                        this.put("BrightnessChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        ++j;
                    }
                    break;
                }
                case 3: {
                    int j = 0;
                    while ((long)j < numChannels) {
                        this.put("ContrastChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        ++j;
                    }
                    break;
                }
                case 4: {
                    int j = 0;
                    while ((long)j < numChannels) {
                        this.put("RampStartXChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        this.put("RampStartYChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        this.put("RampEndXChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        this.put("RampEndYChannel" + j + "-" + i + "-" + suffix, this.in.readDouble());
                        j += 4;
                        ++j;
                    }
                    break;
                }
                case 5: {
                    break;
                }
            }
            ++i;
        }
    }
}

