! Copyright (c) 2000, NVIDIA CORPORATION.  All rights reserved.
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.

!   Initialization expressions containing PARAMETER references


    MODULE d00dat_9d
      ! .. Implicit None Statement ..
      IMPLICIT NONE
      ! .. Parameters ..
      INTEGER, PARAMETER :: wp = KIND(1.0D0)
      REAL (wp), PARAMETER :: temp_wt1(64) = (/ 0.5555555555555556_wp, &
       0.8888888888888889_wp, 0.2684880898683334_wp, 0.1046562260264673_wp, &
       0.4013974147759622_wp, 0.4509165386584741_wp, 0.1344152552437842_wp, &
       0.05160328299707974_wp, 0.2006285293769890_wp, 0.01700171962994026_wp, &
       0.09292719531512454_wp, 0.1715119091363914_wp, 0.2191568584015875_wp, &
       0.2255104997982067_wp, 0.06720775429599070_wp, 0.02580759809617665_wp, &
       0.1003142786117956_wp, 0.008434565739321106_wp, 0.04646289326175799_wp, &
       0.08575592004999035_wp, 0.1095784210559246_wp, 0.002544780791561874_wp, &
       0.01644604985438781_wp, 0.03595710330712932_wp, 0.05697950949412336_wp, &
       0.07687962049900353_wp, 0.09362710998126447_wp, 0.1056698935802348_wp, &
       0.1119568730209535_wp, 0.1127552567207687_wp, 0.03360387714820773_wp, &
       0.01290380010035127_wp, 0.05015713930589954_wp, &
       0.004217630441558855_wp, 0.02323144663991027_wp, &
       0.04287796002500773_wp, 0.05478921052796287_wp, &
       0.001265156556230068_wp, 0.008223007957235930_wp, &
       0.01797855156812827_wp, 0.02848975474583355_wp, 0.03843981024945553_wp, &
       0.04681355499062801_wp, 0.05283494679011652_wp, 0.05597843651047632_wp, &
       0.3632214818455307E-03_wp, 0.002579049794685688_wp, &
       0.006115506822117246_wp, 0.01049824690962132_wp, &
       0.01540675046655950_wp, 0.02059423391591271_wp, 0.02586967932721475_wp, &
       0.03107355111168796_wp, 0.03606443278078257_wp, 0.04071551011694432_wp, &
       0.04491453165363220_wp, 0.04856433040667320_wp, 0.05158325395204846_wp, &
       0.05390549933526606_wp, 0.05548140435655936_wp, 0.05627769983125430_wp, &
       0.05637762836038472_wp, 0.01680193857410387_wp, &
       0.006451900050175737_wp/)
      REAL (wp), PARAMETER :: temp_wt2(64) = (/ 0.02507856965294977_wp, &
       0.002108815245726633_wp, 0.01161572331995513_wp, &
       0.02143898001250387_wp, 0.02739460526398143_wp, &
       0.6326073193626335E-03_wp, 0.004111503978654693_wp, &
       0.008989275784064136_wp, 0.01424487737291677_wp, &
       0.01921990512472777_wp, 0.02340677749531401_wp, 0.02641747339505826_wp, &
       0.02798921825523816_wp, 0.1807395644453884E-03_wp, &
       0.001289524082610417_wp, 0.003057753410175531_wp, &
       0.005249123454808859_wp, 0.007703375233279742_wp, &
       0.01029711695795636_wp, 0.01293483966360737_wp, 0.01553677555584398_wp, &
       0.01803221639039129_wp, 0.02035775505847216_wp, 0.02245726582681610_wp, &
       0.02428216520333660_wp, 0.02579162697602423_wp, 0.02695274966763303_wp, &
       0.02774070217827968_wp, 0.02813884991562715_wp, &
       0.5053609520786252E-04_wp, 0.3777466463269847E-03_wp, &
       0.9383698485423815E-03_wp, 0.001681142865421470_wp, &
       0.002568764943794020_wp, 0.003572892783517300_wp, &
       0.004671050372114322_wp, 0.005843449875835640_wp, &
       0.007072489995433555_wp, 0.008342838753968158_wp, &
       0.009641177729702537_wp, 0.01095573338783790_wp, &
       0.01227583056008277_wp, 0.01359157100976555_wp, 0.01489364166481518_wp, &
       0.01617321872957772_wp, 0.01742193015946417_wp, 0.01863184825613879_wp, &
       0.01979549504809750_wp, 0.02090585144581202_wp, 0.02195636630531782_wp, &
       0.02294096422938775_wp, 0.02385405210603854_wp, 0.02469052474448768_wp, &
       0.02544576996546477_wp, 0.02611567337670610_wp, 0.02669662292745036_wp, &
       0.02718551322962479_wp, 0.02757974956648187_wp, 0.02787725147661370_wp, &
       0.02807645579381725_wp, 0.02817631903301660_wp, 0.02818881418019236_wp, &
       0.008400969287051933_wp, 0.003225950025087868_wp/)
      REAL (wp), PARAMETER :: temp_wt3(64) = (/ 0.01253928482647488_wp, &
       0.001054407622853764_wp, 0.005807861659977567_wp, &
       0.01071949000625193_wp, 0.01369730263199072_wp, &
       0.3163038905577009E-03_wp, 0.002055751989327344_wp, &
       0.004494637892032068_wp, 0.007122438686458387_wp, &
       0.009609952562363883_wp, 0.01170338874765700_wp, &
       0.01320873669752913_wp, 0.01399460912761908_wp, &
       0.9059242831838712E-04_wp, 0.6447620408298260E-03_wp, &
       0.001528876705087616_wp, 0.002624561727404430_wp, &
       0.003851687616639871_wp, 0.005148558478978178_wp, &
       0.006467419831803687_wp, 0.007768387777921991_wp, &
       0.009016108195195643_wp, 0.01017887752923608_wp, &
       0.01122863291340805_wp, 0.01214108260166830_wp, 0.01289581348801211_wp, &
       0.01347637483381652_wp, 0.01387035108913984_wp, 0.01406942495781358_wp, &
       0.2234303854547696E-04_wp, 0.1888639812523945E-03_wp, &
       0.4691849097155527E-03_wp, 0.8405714326197546E-03_wp, &
       0.001284382471895813_wp, 0.001786446391758630_wp, &
       0.002335525186057160_wp, 0.002921724937917820_wp, &
       0.003536244997716778_wp, 0.004171419376984079_wp, &
       0.004820588864851268_wp, 0.005477866693918951_wp, &
       0.006137915280041385_wp, 0.006795785504882773_wp, &
       0.007446820832407591_wp, 0.008086609364788860_wp, &
       0.008710965079732087_wp, 0.009315924128069395_wp, &
       0.009897747524048750_wp, 0.01045292572290601_wp, &
       0.01097818315265891_wp, 0.01147048211469387_wp, 0.01192702605301927_wp, &
       0.01234526237224384_wp, 0.01272288498273238_wp, 0.01305783668835305_wp, &
       0.01334831146372518_wp, 0.01359275661481240_wp, 0.01378987478324094_wp, &
       0.01393862573830685_wp, 0.01403822789690862_wp, 0.01408815951650830_wp, &
       0.8822702694609804E-05_wp, 0.5403992347935378E-04_wp, &
       0.1357078405902732E-03_wp/)
      REAL (wp), PARAMETER :: temp_wt4(62) = (/ 0.2492143139346697E-03_wp, &
       0.3897452481631715E-03_wp, 0.5542953186526136E-03_wp, &
       0.7402828044420028E-03_wp, 0.9453615168885046E-03_wp, &
       0.001167484117433308_wp, 0.001404907995655566_wp, &
       0.001656112728154507_wp, 0.001919712971013880_wp, &
       0.002194406925363840_wp, 0.002478958226657568_wp, &
       0.002772195764593451_wp, 0.003073018434702578_wp, &
       0.003380397991086920_wp, 0.003693377917025651_wp, &
       0.004011068724075023_wp, 0.004332640968092983_wp, &
       0.004657317299756855_wp, 0.004984364564765539_wp, &
       0.005313086605187057_wp, 0.005642818101384444_wp, &
       0.005972919565508166_wp, 0.006302773449085759_wp, &
       0.006631781242901888_wp, 0.006959361409390423_wp, &
       0.007284947980553807_wp, 0.007607989665719057_wp, &
       0.007927949334294849_wp, 0.008244303763032868_wp, &
       0.008556543561307690_wp, 0.008864173209482494_wp, &
       0.009166711163560788_wp, 0.009463689993830065_wp, &
       0.009754656536317411_wp, 0.01003917204405684_wp, &
       0.01031681233094762_wp, 0.01058716790488520_wp, 0.01084984408933731_wp, &
       0.01110446113400693_wp, 0.01135065431598060_wp, 0.01158807403304395_wp, &
       0.01181638589083024_wp, 0.01203527078527956_wp, 0.01224442498161199_wp, &
       0.01244356019071404_wp, 0.01263240364354208_wp, 0.01281069816387736_wp, &
       0.01297820223953740_wp, 0.01313469009196015_wp, 0.01327995174393053_wp, &
       0.01341379308511010_wp, 0.01353603593495621_wp, 0.01364651810257129_wp, &
       0.01374509344300190_wp, 0.01383163190950643_wp, 0.01390601960132546_wp, &
       0.01396815880651694_wp, 0.01401796803945661_wp, 0.01405538207264996_wp, &
       0.01408035196255366_wp, 0.01409284506916041_wp, &
       0.01409440709009618_wp/)
      REAL (wp), PARAMETER :: wt_dp(254) = (/ temp_wt1(1:), temp_wt2(1:), &
       temp_wt3(1:), temp_wt4(1:) /)
    END MODULE d00dat_9d

    program p
     use d00dat_9d
     real(wp),dimension(254) :: expect
     expect(1:64) = temp_wt1
     expect(64+1:64+64) = temp_wt2
     expect(64+64+1:64+64+64) = temp_wt3
     expect(64+64+64+1:64+64+64+62) = temp_wt4
     call check( wt_dp, expect, 254)
    end program
