## Migrating from GTK 3.x to GTK 4

### Preparation in GTK 3.x

| Item                                                                                                                                                                  | status                                                                                      |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| [Do not use deprecated symbols](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.3)                                                   | can't be done, we are not using compilation flags.                                          |
| [Enable diagnostic warnings](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.4)                                                      | **DONE**, all indicated fixed                                                               |
| [Do not use GTK-specific command line arguments](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.5)                                  | not needed                                                                                  |
| [Do not use widget style properties](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.6)                                              | Probably big issue, needs more digging.                                                     |
| [Review your window creation flags](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.7)                                               | not needed                                                                                  |
| [Stop using direct access to GdkEvent structs](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.8)                                    | BIG ISSUE, many fields already have accessors in GTK 3 ...reduce the amount of porting work |
| [Stop using `gdk_pointer_warp()`](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.9)                                                 | not needed                                                                                  |
| [Stop using non-RGBA visuals](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.10)                                                    | not needed                                                                                  |
| [Stop using GtkBox padding, fill and expand child properties](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.11)                    | BIG ISSUE, maybe some monkeypath before port.                                               |
| [Stop using the state argument of GtkStyleContext getters](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.12)                       | some instances                                                                              |
| [Stop using `gdk_pixbuf_get_from_window()` and `gdk_cairo_set_source_surface()`](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.13) | not needed                                                                                  |
| Stop using GtkButton’s image-related API                                                                                                                              | BIG ISSUE                                                                                   |
| [Stop using GtkWidget event signals](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.14)                                             | BIG ISSUE                                                                                   |
| [Set a proper application ID](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.15)                                                    | Affects D-Bus                                                                               |
| [Stop using `gtk_main()` and related APIs](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.16)                                       | **DONE**                                                                                    |
| [Reduce the use of `gtk_widget_destroy()`](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.17)                                       | We're doing window.destroy(), maybe not needed                                              |
| [Reduce the use of generic container APIs](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.18)                                       | See what can be done *before* port.                                                         |
| [Review your use of icon resources](https://developer-old.gnome.org/gtk4/stable/gtk-migrating-3-to-4.html#id-1.7.4.3.19)                                              | not needed                                                                                  |

### Changes that need to be done at the time of the switch

[See](https://developer-old.gnome.org/gtk4/stable/ch41s02.html)

[Larger changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.3)

| Item                                                                                                                                                | status                                                                                                                         |
| --------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------ |
| [Stop using GdkScreen](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.4)                                                       | **DONE**                                                                                                                       |
| [Stop using the root window](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.5)                                                 | not needed (?)                                                                                                                 |
| [Stop using GdkVisual](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.6)                                                       | not needed                                                                                                                     |
| [Stop using GdkDeviceManager](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.7)                                                | not needed                                                                                                                     |
| [Adapt to GdkWindow API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.8)                                             | not needed                                                                                                                     |
| [The “iconified” window state has been renamed to “minimized”](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.9)               | not needed                                                                                                                     |
| [Adapt to GdkEvent API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.10)                                             | Direct access to GdkEvent structs is no longer possible in GTK 4....have accessors that you will have to use.                  |
| [Stop using grabs](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.11)                                                          | not needed                                                                                                                     |
| [Adapt to coordinate API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.12)                                           | not needed                                                                                                                     |
| [Adapt to GdkKeymap API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.13)                                            | no effect (?)                                                                                                                  |
| [Adapt to changes in keyboard modifier handling](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.14)                            | not needed, probably, we don't have Gdk.ModifierIntent                                                                         |
| [Replace GtkClipboard with GdkClipboard](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.15)                                    | not needed                                                                                                                     |
| [Stop using `gtk_get_current_...` APIs](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.16)                                     | not needed                                                                                                                     |
| [Convert your ui files](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.17)                                                     | not needed                                                                                                                     |
| [Adapt to GtkBuilder API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.18)                                           | not needed                                                                                                                     |
| [Adapt to event controller API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.19)                                     | maybe not needed,  we're not using Gtk.Gesture stuff                                                                           |
| [Focus handling changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.20)                                                    | "can-focus" 4 instances                                                                                                        |
| [Use the new apis for keyboard shortcuts](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.21)                                   | no effect, maybe, but not quite clear                                                                                          |
| [Stop using GtkEventBox](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.22)                                                    | 15 instances                                                                                                                   |
| [Stop using GtkButtonBox](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.23)                                                   | not needed                                                                                                                     |
| [Adapt to GtkBox API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.24)                                               | BIG ISSUE, creator function and monkeypatch?                                                                                   |
| [Adapt to GtkWindow API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.25)                                            | set_keep_above() 4 instances                                                                                                   |
| [Adapt to GtkHeaderBar and GtkActionBar API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.26)                        | not needed                                                                                                                     |
| [Adapt to GtkStack, GtkAssistant and GtkNotebook API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.27)               | maybe? depends on details not super clear from description.                                                                    |
| [Adapt to button class hierarchy changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.28)                                   | Gtk.RadioButton removed, 6 instances                                                                                           |
| [Adapt to GtkScrolledWindow API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.29)                                    | no effect (?)                                                                                                                  |
| [Adapt to GtkBin removal](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.30)                                                   | BIG ISSUE, needs to worked on case by case basis                                                                               |
| [Adapt to GtkContainer removal](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.31)                                             | BIG ISSUE, needs to worked on case by case basis                                                                               |
| [Stop using GtkContainer::border-width](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.32)                                     | 305 instances in CSS, drop all but 1 CSS                                                                                       |
| [Adapt to `gtk_widget_destroy()` removal](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.33)                                   | not needed, probably, we are only destroying windows                                                                           |
| [Adapt to coordinate API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.34)                                           | not needed                                                                                                                     |
| [Adapt to GtkStyleContext API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.35)                                      | no effect (?)                                                                                                                  |
| [Adapt to GtkCssProvider API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.36)                                       | no effect (?)                                                                                                                  |
| [Stop using GtkShadowType and GtkRelief properties](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.37)                         | **DONE**                                                                                                                       |
| [Adapt to GtkWidget’s size request changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.38)                                 | get_preferred_width() 9 instances                                                                                              |
| [Adapt to GtkWidget’s size allocation changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.39)                              | "size-allocate" signal 3 instances                                                                                             |
| [Switch to GtkWidget’s children APIs](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.40)                                       | same as "Adapt to GtkContainer removal" above                                                                                  |
| [Don’t use -gtk-gradient in your CSS](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.41)                                       | 41 instances, drop all but 1 CSS                                                                                               |
| [Don’t use -gtk-icon-effect in your CSS](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.42)                                    | **DONE**                                                                                                                       |
| [Don’t use -gtk-icon-theme in your CSS](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.43)                                     | not needed                                                                                                                     |
| [Don’t use -gtk-outline-…-radius in your CSS](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.44)                               | 35 instances, drop all but 1 CSS                                                                                               |
| [Adapt to drawing model changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.45)                                            | cairoarea.py, gtk_drawing_area_set_draw_func() using maybe enough here, snapshot?, same as "Stop using GtkWidget::draw" below. |
| [Stop using APIs to query GdkSurfaces](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.46)                                      | not needed                                                                                                                     |
| [Widgets are now visible by default](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.47)                                        | show() is no-op on init now, hide() may need to be added somewhere,  show_all() 171 instances need to be removed.              |
| [Adapt to changes in animated hiding and showing of widgets](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.48)                | not needed                                                                                                                     |
| [Stop passing commandline arguments to gtk_init](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.49)                            | not needed                                                                                                                     |
| [GdkPixbuf is deemphasized](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.50)                                                 | maybe? also, see MLT                                                                                                           |
| [GtkWidget event signals are removed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.51)                                       | BIG ISSUE, cairoarea.py needs to be first customer for fixing                                                                  |
| [Invalidation handling has changed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.52)                                         | not needed (?)                                                                                                                 |
| [Stop using GtkWidget::draw](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.53)                                                | cairoarea.py, gtk_drawing_area_set_draw_func() using maybe enough here, snapshot?                                              |
| [Window content observation has changed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.54)                                    | not needed                                                                                                                     |
| [Monitor handling has changed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.55)                                              | Instead of a monitor number, GdkMonitor is used, see e.g. utilsgtk.py                                                          |
| [Adapt to monitor API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.56)                                              | not needed                                                                                                                     |
| [Adapt to cursor API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.57)                                               | set_cursor() many instances, we need to apply changes to tline canvas widget only                                              |
| [Adapt to icon size API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.58)                                            | not needed                                                                                                                     |
| [Adapt to changes in the GtkAssistant API](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.59)                                  | not needed                                                                                                                     |
| [Adapt to changes in the API of GtkEntry, GtkSearchEntry and GtkSpinButton](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.60) | not needed (99%)                                                                                                               |
| [Adapt to changes in GtkOverlay API](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.61)                                        | not needed                                                                                                                     |
| [Use GtkFixed instead of GtkLayout](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.62)                                         | not needed                                                                                                                     |
| [Adapt to search entry changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.63)                                             | not needed                                                                                                                     |
| [Adapt to GtkScale changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.64)                                                 | not needed                                                                                                                     |
| [Stop using `gtk_window_activate_default()`](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.65)                                | not needed                                                                                                                     |
| [Stop using `gtk_widget_grab_default()`](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.66)                                    | not needed                                                                                                                     |
| [Stop setting ::has-default and ::has-focus in .ui files](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.67)                   | not needed                                                                                                                     |
| [Stop using the GtkWidget::display-changed signal](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.68)                          | not needed                                                                                                                     |
| [GtkPopover::modal has been renamed to autohide](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.69)                            | not needed                                                                                                                     |
| [gtk_widget_get_surface has been removed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.70)                                   | not needed                                                                                                                     |
| [gtk_widget_is_toplevel has been removed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.71)                                   | not needed                                                                                                                     |
| [gtk_widget_get_toplevel has been removed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.72)                                  | not needed                                                                                                                     |
| [GtkEntryBuffer ::deleted-text has changed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.73)                                 | not needed                                                                                                                     |
| [GtkMenu, GtkMenuBar and GtkMenuItem are gone](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.74)                              | GtkPopoverMenu in GTK 3. Additionally, GTK 4 introduces GtkPopoverMenuBar                                                      |
| [GtkToolbar has been removed](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.75)                                               | not needed                                                                                                                     |
| [GtkAspectFrame is no longer a frame](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.76)                                       | not needed                                                                                                                     |
| [Stop using custom tooltip windows](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.77)                                         | not needed                                                                                                                     |
| [Switch to the new Drag-and-Drop api](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.78)                                       | dnd.py etc.                                                                                                                    |
| [Adapt to GtkIconTheme API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.79)                                         | not needed                                                                                                                     |
| [Update to GtkFileChooser API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.80)                                      | ?? get_file (), get_filename (), get_filenames ()                                                                              |
| [Stop using blocking dialog functions](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.81)                                      | 1 instance, batchrendering.py                                                                                                  |
| [Stop using GtkBuildable API](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.82)                                               | not needed                                                                                                                     |
| [Adapt to GtkAboutDialog API changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.83)                                       | not needed                                                                                                                     |
| [Adapt to GtkTreeView and GtkIconView tooltip context changes](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.84)              | not needed                                                                                                                     |
| [Stop using GtkFileChooserButton](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.85)                                           | 20 instances                                                                                                                   |
| [Adapt to changed GtkSettings properties](https://developer-old.gnome.org/gtk4/stable/ch41s02.html#id-1.7.4.4.86)                                   | not needed                                                                                                                     |
| Gtk.Widget.modify_font deprecated                                                                                                                   | many instances                                                                                                                 |

[Changes to consider after the switch](https://developer-old.gnome.org/gtk4/stable/ch41s03.html)

[Consider porting to the new list widgets](https://developer-old.gnome.org/gtk4/stable/ch41s03.html#id-1.7.4.5.3) 
