package com.neilalexander.jnacl;

import com.neilalexander.jnacl.crypto.xsalsa20poly1305;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import static org.fest.assertions.Assertions.assertThat;

public class NaclSecretBoxTest {

  private byte[] key;
  private byte[] nonce;
  private byte[] plaintext;

  @BeforeMethod
  public void setUp() throws Exception {

    key = new byte[]{
        (byte) 0x14, (byte) 0x34, (byte) 0xe6, (byte) 0x74, (byte) 0xad, (byte) 0x84, (byte) 0xfd, (byte) 0xfd,
        (byte) 0xc9, (byte) 0xbc, (byte) 0x1a, (byte) 0xa0, (byte) 0x7, (byte) 0x85, (byte) 0x32, (byte) 0x5c,
        (byte) 0x8b, (byte) 0x6d, (byte) 0x57, (byte) 0x34, (byte) 0x1f, (byte) 0xc7, (byte) 0xce, (byte) 0x20,
        (byte) 0xb, (byte) 0xa4, (byte) 0x68, (byte) 0xc, (byte) 0x80, (byte) 0x78, (byte) 0x6d, (byte) 0xda
    };

    nonce = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    plaintext = new byte[]{
        (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
        (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
        (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
        (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
        (byte) 0x7b, (byte) 0x46, (byte) 0xb7, (byte) 0xae, (byte) 0xc0, (byte) 0xea, (byte) 0x6c, (byte) 0xf4,
        (byte) 0xea, (byte) 0xf4, (byte) 0xed, (byte) 0xb, (byte) 0x98, (byte) 0x55, (byte) 0xab, (byte) 0x69,
        (byte) 0x88, (byte) 0x37, (byte) 0xc6, (byte) 0xbe, (byte) 0xb, (byte) 0xa6, (byte) 0x88, (byte) 0x3e,
        (byte) 0xc5, (byte) 0x26, (byte) 0xf1, (byte) 0xc7, (byte) 0xb9, (byte) 0x97, (byte) 0xaf, (byte) 0xa8
    };
  }

  @Test
  public void test_crypto_secretbox() throws Exception {
    byte[] ciphertext = new byte[64];

    xsalsa20poly1305.crypto_secretbox(ciphertext, plaintext, plaintext.length, nonce, key);

    byte[] expected_ciphertext = new byte[]{
        (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
        (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
        (byte) 0xd3, (byte) 0x6e, (byte) 0xc5, (byte) 0x2, (byte) 0xe0, (byte) 0x58, (byte) 0x86, (byte) 0xd1,
        (byte) 0xf0, (byte) 0x27, (byte) 0x9f, (byte) 0x5, (byte) 0x5f, (byte) 0xa5, (byte) 0x25, (byte) 0x54,
        (byte) 0xd1, (byte) 0x6d, (byte) 0x16, (byte) 0xc1, (byte) 0xb1, (byte) 0x40, (byte) 0x74, (byte) 0xbb,
        (byte) 0xb8, (byte) 0x3f, (byte) 0xf0, (byte) 0xfd, (byte) 0xd7, (byte) 0x9d, (byte) 0xc2, (byte) 0xfe,
        (byte) 0x9, (byte) 0x8f, (byte) 0xe, (byte) 0xd4, (byte) 0xa2, (byte) 0xb0, (byte) 0x91, (byte) 0x13,
        (byte) 0xe, (byte) 0x6b, (byte) 0x5d, (byte) 0xb4, (byte) 0x6a, (byte) 0x20, (byte) 0xa8, (byte) 0x6b
    };

    assertThat(ciphertext).isEqualTo(expected_ciphertext);
  }

}