/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.Utils;
import com.sqlmagic.tinysql.tinySQLException;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;

public class DBFHeader {
    String tableName = null;
    short file_type = 0;
    short file_update_year = 0;
    short file_update_month = 0;
    short file_update_day = 0;
    int numFields = 0;
    int numRecords = 0;
    int headerLength = 0;
    int recordLength = 0;
    static final int BULK_SIZE = 32;
    static final int FLAG_INDEX = 0;
    static final int DATE_INDEX = 1;
    static final int NUMBER_OF_REC_INDEX = 4;
    static final int LENGTH_OF_HEADER_INDEX = 8;
    static final int LENGTH_OF_REC_INDEX = 10;
    static final int RESERVED_INDEX = 12;

    DBFHeader(RandomAccessFile randomAccessFile) throws tinySQLException {
        try {
            randomAccessFile.seek(0L);
            this.file_type = Utils.fixByte(randomAccessFile.readByte());
            this.file_update_year = Utils.fixByte(randomAccessFile.readByte());
            this.file_update_month = Utils.fixByte(randomAccessFile.readByte());
            this.file_update_day = Utils.fixByte(randomAccessFile.readByte());
            byte[] byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            this.numRecords = (int)Utils.vax_to_long(byArray);
            byArray = new byte[2];
            randomAccessFile.readFully(byArray);
            this.headerLength = Utils.vax_to_short(byArray);
            randomAccessFile.readFully(byArray);
            this.recordLength = Utils.vax_to_short(byArray);
            this.numFields = (this.headerLength - 33) / 32;
            Utils.log("HEADER=" + this.toString());
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    DBFHeader(int n, int n2) throws tinySQLException {
        this.numFields = n;
        this.recordLength = n2;
        Utils.log("DBFHeader", "numFields=" + n + " recordLength=" + n2);
    }

    public RandomAccessFile create(String string, String string2) throws tinySQLException {
        this.tableName = string2;
        try {
            this.mkDataDirectory(string);
            DBFHeader.dropTable(string, string2);
            String string3 = string + File.separator + string2 + ".DBF";
            RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "rw");
            this.write(randomAccessFile);
            return randomAccessFile;
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void write(RandomAccessFile randomAccessFile) throws tinySQLException {
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.writeByte(3);
            this.setTimestamp(randomAccessFile);
            this.setNumRecords(randomAccessFile, 0);
            this.setHeaderLength(randomAccessFile, this.numFields);
            this.setRecordLength(randomAccessFile, this.recordLength);
            this.setReserved(randomAccessFile);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    void mkDataDirectory(String string) throws NullPointerException {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public void setTimestamp(RandomAccessFile randomAccessFile) throws tinySQLException {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int n = calendar.get(5);
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(1);
            randomAccessFile.seek(1L);
            randomAccessFile.write(n3 %= 100);
            randomAccessFile.write(n2);
            randomAccessFile.write(n);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void setNumRecords(RandomAccessFile randomAccessFile, int n) throws tinySQLException {
        this.numRecords = n;
        DBFHeader.writeNumRecords(randomAccessFile, n);
    }

    public static void writeNumRecords(RandomAccessFile randomAccessFile, int n) throws tinySQLException {
        try {
            byte[] byArray = Utils.intToLittleEndian(n);
            randomAccessFile.seek(4L);
            randomAccessFile.write(byArray);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void setHeaderLength(RandomAccessFile randomAccessFile, int n) throws tinySQLException {
        this.numFields = n;
        try {
            int n2 = 33 + n * 32;
            randomAccessFile.seek(8L);
            randomAccessFile.write(Utils.shortToLittleEndian((short)n2));
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void setRecordLength(RandomAccessFile randomAccessFile, int n) throws tinySQLException {
        this.recordLength = n;
        try {
            randomAccessFile.seek(10L);
            randomAccessFile.write(Utils.shortToLittleEndian((short)n));
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void setReserved(RandomAccessFile randomAccessFile) throws tinySQLException {
        try {
            randomAccessFile.seek(12L);
            byte[] byArray = Utils.forceToSize(null, 20, (byte)0);
            randomAccessFile.write(byArray);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    static void dropTable(String string, String string2) throws tinySQLException {
        try {
            Utils.delFile(string, string2 + ".DBF");
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }
}

