/* ----- core/inv3sntrup1277, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_inv3sntrup1277_checksums[] = {
  "b30c2b6d13108ae047f7fddc44d358fbfb15efd9cc5faf66fdd8105d67c851f5",
  "195786f1a3efb32081f00cff505fe0dd2b572761c809b08f8a8c57f9704bc01d",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_inv3sntrup1277_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_inv3sntrup1277_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_inv3sntrup1277_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_inv3sntrup1277_CONSTBYTES

static void *storage_core_inv3sntrup1277_h;
static unsigned char *test_core_inv3sntrup1277_h;
static void *storage_core_inv3sntrup1277_n;
static unsigned char *test_core_inv3sntrup1277_n;
static void *storage_core_inv3sntrup1277_k;
static unsigned char *test_core_inv3sntrup1277_k;
static void *storage_core_inv3sntrup1277_c;
static unsigned char *test_core_inv3sntrup1277_c;
static void *storage_core_inv3sntrup1277_h2;
static unsigned char *test_core_inv3sntrup1277_h2;
static void *storage_core_inv3sntrup1277_n2;
static unsigned char *test_core_inv3sntrup1277_n2;
static void *storage_core_inv3sntrup1277_k2;
static unsigned char *test_core_inv3sntrup1277_k2;
static void *storage_core_inv3sntrup1277_c2;
static unsigned char *test_core_inv3sntrup1277_c2;

#define precomputed_core_inv3sntrup1277_NUM 5

static const unsigned char precomputed_core_inv3sntrup1277_h[precomputed_core_inv3sntrup1277_NUM][crypto_core_OUTPUTBYTES] = {
  {0,255,255,0,1,0,255,0,1,0,0,1,1,255,1,0,255,255,0,1,255,0,0,0,1,1,0,0,255,1,255,1,0,0,1,0,0,0,1,255,0,1,1,1,255,0,1,1,0,255,255,255,255,1,0,255,0,0,1,1,1,255,1,1,255,0,0,0,0,255,1,255,1,1,255,1,1,0,255,0,0,0,0,255,255,255,1,0,1,255,1,0,0,0,255,0,0,0,0,255,255,0,1,255,255,255,255,0,255,255,0,255,255,255,1,255,0,255,255,0,0,1,255,1,1,1,255,1,0,1,255,255,255,1,255,0,255,1,255,1,0,1,0,255,1,255,1,0,1,1,255,255,255,1,1,1,0,0,0,0,255,255,0,0,0,1,1,0,255,0,0,1,255,1,1,1,0,1,1,1,255,255,1,255,0,0,255,255,255,1,255,0,1,255,0,1,255,0,255,255,1,1,255,0,255,255,255,0,0,0,1,1,0,255,255,1,255,255,1,255,1,1,1,1,255,0,1,1,255,1,1,0,255,0,1,0,0,255,255,0,0,1,255,0,0,255,0,1,255,1,255,1,0,0,0,1,1,0,255,1,255,1,255,0,0,1,1,1,1,1,1,255,1,255,0,255,1,1,0,0,1,1,255,0,255,255,0,0,0,1,1,1,1,1,0,1,1,0,1,255,0,255,255,255,1,0,0,255,255,255,1,0,1,1,255,0,0,0,1,0,255,1,255,255,0,0,255,1,255,1,255,255,255,1,1,1,1,255,1,0,255,1,255,255,255,1,255,1,0,1,0,1,0,0,1,1,0,255,0,255,0,255,255,0,0,0,1,1,255,0,0,0,255,255,0,1,255,255,1,1,255,1,255,255,0,1,0,0,1,1,0,0,0,1,1,0,255,1,0,255,1,255,1,0,255,255,0,1,255,0,0,255,255,0,255,0,0,0,0,255,0,255,255,1,255,1,255,0,255,1,1,255,1,0,255,1,0,1,255,0,0,0,0,1,0,0,1,0,255,1,0,1,0,255,0,255,1,255,255,1,255,255,0,0,255,1,255,255,255,0,255,1,1,1,0,255,1,0,1,0,1,1,255,255,1,255,1,0,255,1,255,255,0,0,255,0,255,0,0,0,0,1,255,1,0,255,0,1,0,0,0,255,0,255,255,0,255,1,0,1,0,0,1,255,1,1,255,1,0,1,255,255,0,255,255,0,255,1,1,1,1,0,255,0,0,1,0,255,0,1,255,0,1,1,0,0,0,0,255,1,255,0,0,1,0,1,0,255,255,0,0,1,1,1,0,255,255,0,255,255,0,1,255,1,1,255,1,1,255,1,0,0,255,1,255,255,0,0,0,0,0,1,0,255,0,255,1,1,0,0,1,1,1,255,255,0,255,255,0,255,0,0,0,255,1,0,0,1,1,1,1,0,255,255,0,1,0,1,255,0,1,1,1,1,0,1,255,1,1,255,1,255,1,0,1,1,0,0,255,0,1,255,0,0,1,1,255,1,255,255,255,0,255,255,255,0,1,1,255,255,0,0,255,255,1,1,255,0,255,0,255,1,255,1,0,0,255,0,255,0,255,1,255,255,1,0,0,0,255,1,255,1,0,0,1,255,255,1,1,255,0,1,255,1,1,255,0,1,1,0,0,1,1,255,1,1,0,0,255,0,1,255,255,1,1,1,1,255,0,1,1,1,255,0,255,255,0,1,255,0,255,0,0,1,255,1,255,1,1,1,255,0,255,1,1,255,0,1,1,0,0,255,0,1,1,255,255,255,255,1,1,255,255,1,1,255,0,1,255,0,0,1,0,255,255,255,1,1,255,255,0,1,255,1,0,1,0,255,255,1,255,0,255,1,0,255,0,1,255,1,255,255,0,0,255,255,0,1,1,255,0,0,1,1,255,0,1,0,1,1,1,0,255,255,0,1,1,255,0,255,0,1,0,1,0,1,1,1,1,255,1,0,255,0,0,255,0,255,255,0,1,255,255,255,1,0,1,0,1,1,255,255,255,1,1,1,1,0,0,255,0,0,255,255,255,255,255,0,255,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,255,255,255,0,0,255,255,255,0,0,1,1,255,255,255,1,1,255,0,0,0,0,0,0,255,0,1,255,1,1,255,255,0,1,255,255,255,0,0,255,1,255,0,1,0,255,255,255,255,0,255,0,1,255,0,1,1,1,255,0,0,1,0,0,0,255,0,1,0,0,1,0,1,0,1,0,0,255,1,1,1,0,1,1,255,1,1,0,255,0,0,1,1,0,0,0,0,255,1,1,0,1,255,1,0,255,255,0,255,1,0,1,1,255,1,1,0,1,255,0,255,1,255,0,0,255,0,1,255,0,1,1,1,1,0,1,1,1,1,255,255,1,1,0,0,1,1,1,0,255,1,255,255,0,0,0,0,0,1,0,255,1,0,255,255,1,0,255,1,1,255,0,1,255,0,255,0,0,0,1,1,0,255,1,0,1,0,1,1,255,0,255,255,0,0,0,1,255,0,1,255,1,0,0,0,1,1,1,255,255,255,255,0,255,255,0,255,255,0,0,255,255,0,0,0,1,255,255,1,1,1,255,255,255,1,1,1,255,255,0,1,1,255,255,255,1,0,0,255,0,1,255,1,0,1,0,0,1,0,1,0,255,255,1,255,0,1,0,1,255,255,0,1,0,1,0,1,1,1,255,255,0,1,1,255,1,1,0,255,0,0,255,255,1,0,0,1,255,255,0,255,1,1,255,0,255,255,0,255,0,1,1,1,255,255,255,1,0,255,255,255,0,1,255,0,255,0,1,0,1,255,255,0,0,0,255,255,255,255,255,0,0,255,0,1,1,0,1,1,0,0,0},
  {255,255,255,255,255,255,0,255,0,1,0,255,1,0,1,0,255,0,0,255,255,255,255,1,0,0,1,255,0,1,255,255,255,0,1,1,1,1,1,0,255,255,255,255,1,0,255,255,1,255,255,255,1,0,0,255,255,1,255,1,0,0,255,1,0,0,0,255,1,255,255,1,255,0,255,1,255,1,0,0,255,1,1,255,0,255,1,0,1,255,0,255,255,0,255,1,1,0,0,255,1,1,0,255,1,255,0,255,255,255,0,255,1,1,255,0,1,255,255,0,0,1,1,1,255,255,255,1,0,255,255,1,0,255,255,1,1,1,1,0,255,1,0,0,1,1,0,1,0,255,0,255,255,1,0,0,0,1,0,0,1,1,0,1,1,1,255,255,255,255,1,0,1,1,0,0,1,1,255,0,255,0,255,1,0,255,0,1,255,1,0,1,0,0,255,0,1,0,1,0,1,255,255,1,255,0,1,0,0,0,0,255,0,1,255,255,255,0,255,0,255,0,0,255,0,255,255,1,1,1,0,1,255,0,0,255,255,1,255,1,0,0,0,255,1,1,1,0,1,0,255,1,255,255,0,255,1,255,255,0,1,0,1,0,1,1,1,1,255,1,255,0,0,0,255,1,1,255,0,1,1,1,255,0,255,0,1,1,1,0,255,1,1,255,0,1,1,0,0,1,255,1,255,0,255,1,1,0,0,255,255,1,0,255,0,0,1,1,0,255,1,0,0,1,255,255,255,1,255,0,1,1,255,255,0,255,0,0,0,1,255,1,255,1,0,255,255,0,0,1,0,255,0,1,1,0,1,0,255,1,0,0,0,0,0,0,0,255,255,1,0,1,255,255,0,0,1,0,255,0,1,255,1,255,255,1,0,1,1,1,0,255,255,0,255,1,0,255,255,1,0,1,255,255,1,255,0,1,1,1,255,255,255,1,255,1,0,255,255,255,0,0,0,255,255,0,1,1,255,255,1,0,255,255,1,255,0,0,255,255,1,0,0,255,1,255,1,0,0,1,255,0,1,1,1,1,1,255,255,255,1,0,1,1,1,255,255,1,255,1,1,0,0,255,0,0,255,1,0,1,0,1,0,0,1,0,255,1,1,255,255,0,1,1,1,1,255,1,255,0,0,1,255,0,255,255,255,0,1,255,0,0,0,0,1,1,255,0,1,255,0,1,0,0,255,1,1,255,1,0,255,255,1,0,255,0,255,255,0,1,255,0,0,255,255,1,0,1,255,1,255,1,1,1,1,1,0,255,1,1,255,0,0,0,1,1,0,255,0,1,1,1,255,1,1,0,255,1,1,255,0,255,0,1,1,1,0,0,1,255,0,0,1,1,1,0,255,255,0,255,0,1,1,0,1,255,0,1,1,0,0,255,0,1,1,255,255,255,1,1,1,0,1,255,0,255,1,1,0,1,255,0,255,0,255,0,1,255,0,0,1,0,1,255,1,0,255,1,0,0,0,0,255,1,1,1,1,0,1,255,1,0,255,0,255,255,0,0,255,0,1,1,0,255,1,1,0,1,0,0,1,0,0,0,0,1,0,1,1,255,1,255,255,0,0,255,0,255,255,1,0,1,255,1,1,1,0,0,255,1,1,1,255,1,1,255,255,255,1,1,1,1,255,1,0,255,255,255,1,1,255,255,0,255,0,0,255,0,0,255,0,1,0,0,1,255,255,255,1,0,255,255,255,1,255,0,255,255,0,255,255,0,1,255,255,255,255,1,0,1,255,1,255,255,255,0,255,0,1,1,255,1,0,0,0,255,1,255,255,0,255,1,0,255,0,1,255,1,1,1,0,255,0,1,0,1,255,1,0,255,1,0,1,255,1,1,0,1,255,255,1,0,1,0,0,255,1,0,0,0,1,0,0,1,0,0,1,255,255,1,0,1,255,0,0,1,255,1,1,1,255,0,1,1,255,255,1,1,255,0,255,255,1,255,255,1,1,1,1,255,1,1,0,255,0,0,1,255,1,0,255,0,0,0,1,1,0,0,0,0,1,1,255,255,255,1,1,255,1,0,0,1,255,1,0,1,1,255,1,255,1,1,255,255,0,1,1,0,255,0,1,0,0,1,255,1,255,255,1,1,1,255,1,1,0,0,255,255,255,255,1,255,0,255,0,0,255,1,255,255,255,255,255,255,255,255,0,1,255,1,255,1,255,0,0,1,1,255,255,0,255,0,0,1,1,255,1,255,255,1,0,1,0,0,255,1,0,1,255,255,1,1,1,255,255,255,1,255,0,0,0,1,0,255,0,0,0,255,1,255,255,0,255,255,0,255,0,0,1,255,1,255,255,0,0,255,1,1,1,1,255,0,1,0,255,0,0,255,255,255,0,0,1,0,1,1,1,1,255,255,0,0,255,1,1,1,255,255,1,0,1,255,255,1,255,1,0,0,1,255,255,0,0,0,1,1,1,255,1,255,255,0,0,255,0,0,1,0,255,255,1,255,255,0,255,1,255,255,1,255,0,255,1,1,255,255,1,1,255,0,0,255,0,0,255,0,1,0,0,255,0,0,1,0,255,255,1,1,255,0,1,255,255,1,0,255,1,0,0,1,1,1,1,255,1,255,0,0,1,1,1,1,1,255,1,255,255,255,255,1,1,255,0,255,0,255,0,1,0,1,1,255,1,255,255,0,255,0,0,255,0,0,0,0,1,0,0,0,255,1,1,0,0,1,255,255,1,1,255,255,1,255,1,1,0,0,0,1,255,1,0,255,1,1,255,255,1,255,0,255,255,1,255,0,1,1,255,1,1,1,0,1,255,255,0,0,0,255,1,1,0,0,255,0,1,0,1,1,1,1,0,0,255,0,255,1,1,255,1,0,1,0,1,255,0,255,255,0,255,1,1,1,0,255,255,1,0,0},
  {1,0,0,255,1,255,1,0,0,255,255,1,0,1,255,1,255,255,0,1,255,1,255,0,0,255,1,1,0,0,255,0,1,0,0,1,0,255,255,1,0,1,0,255,0,255,255,0,255,255,1,0,255,0,0,1,1,0,1,1,1,255,255,1,0,255,0,1,0,255,1,1,0,1,1,0,0,255,1,1,1,255,255,255,0,1,0,1,0,1,1,1,255,1,255,0,0,255,1,1,255,0,1,0,1,0,1,255,255,1,1,1,0,1,1,0,255,0,255,255,255,1,255,1,255,255,1,0,1,1,1,0,0,1,255,1,255,1,255,1,255,255,255,255,1,1,0,0,255,255,0,0,1,255,255,1,0,1,0,1,255,255,255,0,255,1,1,255,255,255,255,1,255,0,255,1,1,255,1,0,1,0,0,0,255,255,0,1,255,0,0,0,1,0,1,1,0,255,0,0,1,1,255,1,1,0,1,0,0,255,0,255,0,1,255,1,1,255,0,1,1,0,255,255,1,0,0,0,255,0,1,1,0,1,255,0,0,1,1,255,255,1,255,255,0,255,0,1,1,0,1,0,1,0,0,1,0,0,1,1,1,255,1,0,255,0,255,0,0,0,255,0,255,255,255,1,1,255,255,1,255,255,255,1,1,0,0,1,255,0,1,1,255,1,0,1,255,1,0,1,1,0,255,0,0,255,0,1,1,1,1,255,255,0,0,1,255,255,1,0,255,0,0,1,0,255,1,1,255,0,0,1,1,1,255,1,1,255,1,1,0,0,255,255,255,1,0,0,255,1,255,1,255,1,255,255,1,1,255,0,255,0,0,0,255,255,255,1,255,255,0,1,255,0,1,255,255,1,1,255,1,0,1,0,0,255,255,255,1,0,1,1,0,255,1,0,0,1,0,1,1,255,255,255,1,0,1,1,1,0,1,0,255,255,1,255,1,255,1,255,1,1,1,255,0,255,0,0,0,0,255,255,0,0,0,0,255,0,0,0,1,1,255,1,255,255,1,1,0,0,0,0,255,255,255,255,1,1,1,0,1,255,1,0,255,255,255,1,0,255,255,1,0,1,1,0,1,1,255,1,0,255,255,0,0,1,0,0,255,1,1,255,0,0,0,1,255,255,1,0,255,0,0,1,0,1,255,255,255,0,1,1,1,1,0,1,0,1,1,0,255,1,255,0,255,1,0,1,255,1,255,0,0,255,0,0,0,255,0,255,1,0,255,255,255,255,255,1,1,255,1,0,255,255,0,255,0,0,1,255,255,0,1,1,0,1,255,0,0,1,1,255,0,255,255,0,255,1,255,255,0,0,1,255,255,1,1,1,0,255,255,1,0,1,1,0,255,1,255,0,0,1,1,1,255,1,1,0,255,0,0,1,255,0,0,255,0,1,255,255,255,255,0,0,0,255,0,1,0,1,0,1,255,0,0,255,1,0,0,0,0,255,1,1,1,1,1,0,255,1,1,0,255,1,1,1,0,0,255,255,255,255,1,255,255,1,1,1,255,0,1,255,255,0,0,0,255,1,255,1,255,255,0,1,0,255,1,255,0,1,255,255,255,1,0,255,1,255,1,1,255,0,1,255,0,0,0,0,0,1,1,0,255,1,255,255,0,255,0,255,1,1,0,255,255,1,0,1,1,1,0,255,255,255,1,0,255,0,1,0,1,0,0,1,1,255,0,1,1,1,0,1,0,1,1,1,255,1,0,0,255,1,255,1,255,1,1,255,255,1,255,0,1,255,1,1,0,0,255,0,255,1,255,255,255,255,1,1,0,1,0,0,1,1,0,255,1,1,255,1,1,0,255,0,255,1,0,1,0,255,0,255,0,255,0,255,1,0,0,1,0,1,255,0,255,0,0,0,255,255,1,255,1,0,255,1,1,0,1,255,255,1,0,0,255,0,0,1,0,1,1,0,0,0,0,1,0,0,255,255,0,0,255,1,1,255,255,255,0,255,1,255,0,1,0,255,255,255,1,0,255,0,0,0,255,255,0,0,0,0,0,255,0,1,255,0,1,0,255,1,1,255,255,255,1,0,255,0,0,0,0,0,255,255,0,0,0,0,255,0,0,0,1,0,1,255,0,0,0,255,0,0,255,1,255,1,255,0,0,0,1,0,1,0,255,255,0,255,255,0,0,1,1,0,0,255,255,0,255,1,1,0,0,1,1,255,1,255,255,1,0,1,0,0,255,1,0,255,1,1,0,0,0,0,1,1,1,0,255,255,1,1,1,255,0,1,1,255,0,1,0,1,0,1,255,255,0,0,0,0,255,1,1,1,0,1,255,255,1,255,1,1,1,1,255,1,255,1,255,1,255,0,255,255,255,1,0,255,255,1,1,1,0,255,0,0,0,1,0,255,255,0,0,1,0,1,0,1,1,0,255,255,255,0,255,255,0,255,1,0,255,255,0,255,1,255,1,1,255,0,1,0,255,1,1,1,0,255,1,0,1,1,255,255,1,0,255,255,255,1,0,1,0,0,1,255,1,0,1,1,255,1,255,0,255,0,255,1,1,255,255,1,255,0,1,255,255,255,255,255,255,0,1,0,0,0,0,255,0,255,1,255,255,1,255,1,0,1,1,255,0,255,255,255,0,0,1,1,0,255,0,1,0,255,1,0,1,1,255,255,0,1,255,255,0,0,0,0,1,255,255,1,1,1,1,0,0,0,1,1,255,255,1,0,0,0,1,0,255,1,0,255,1,0,255,1,1,0,1,1,1,255,1,255,255,1,255,0,255,0,1,255,1,0,0,1,1,255,255,255,1,0,0,255,0,255,0,1,1,1,1,1,255,255,0,1,255,255,0,0,1,255,0,1,0,1,255,1,255,0,0,1,0,1,1,255,0,1,0,1,255,1,1,255,255,1,1,0},
  {1,1,1,0,1,0,255,1,255,255,255,0,1,1,0,255,0,1,1,1,0,1,255,1,0,1,255,255,255,0,1,1,1,1,0,0,0,0,255,1,0,0,0,255,1,1,255,255,1,0,1,1,0,255,1,0,0,0,0,1,255,0,0,1,255,255,0,0,255,1,255,0,255,255,255,0,255,0,0,1,0,255,255,1,0,0,255,255,0,255,1,1,1,255,1,0,255,1,1,255,0,255,255,255,255,1,255,255,1,0,1,0,1,255,0,1,1,0,0,0,255,0,255,255,1,0,1,0,255,1,0,1,255,0,0,255,1,0,255,1,255,1,0,1,255,0,1,1,1,1,1,0,1,0,0,1,0,255,255,0,0,1,1,0,255,0,1,1,0,1,1,255,1,255,255,0,255,0,255,1,255,0,255,255,1,255,1,255,0,255,1,0,255,1,0,1,1,255,255,0,255,255,1,1,255,0,255,1,255,0,1,255,255,1,0,0,1,1,1,255,255,0,1,255,0,0,255,0,0,1,0,255,255,255,1,0,1,255,255,255,1,1,1,255,1,255,0,1,255,1,0,255,0,1,0,255,1,0,0,1,1,0,1,0,1,255,255,255,0,1,0,255,1,1,0,1,255,1,255,255,1,255,0,1,255,0,1,1,0,255,0,1,255,255,255,255,0,255,0,255,255,255,0,1,1,255,255,255,255,0,255,0,1,0,0,0,255,255,255,1,0,255,1,0,255,1,0,255,255,0,0,0,255,1,0,0,1,1,0,255,0,1,0,0,1,255,0,0,255,0,1,255,255,0,0,0,0,255,255,0,1,1,255,255,1,0,0,0,1,0,0,0,255,255,0,255,255,255,0,255,0,1,1,255,0,1,0,1,1,255,1,255,0,255,255,255,1,1,255,1,0,0,0,255,0,255,1,1,255,255,255,255,255,1,0,255,0,1,1,1,1,0,0,255,0,1,255,1,1,1,255,255,255,255,1,255,255,0,0,1,1,1,1,1,0,255,1,1,0,1,1,0,255,1,255,0,255,1,255,1,1,255,255,1,0,1,0,255,255,1,1,0,1,255,255,1,0,255,1,1,255,0,255,255,1,1,1,1,0,1,1,0,255,255,255,255,0,0,255,255,0,255,0,255,255,1,255,255,0,255,255,1,255,255,255,1,0,0,1,255,0,0,255,255,0,0,1,0,1,0,1,1,0,255,0,255,0,0,1,0,0,255,255,255,1,0,1,255,255,255,255,0,0,0,255,255,255,1,255,0,255,1,255,1,0,255,1,0,0,255,1,0,0,1,255,255,255,255,1,1,255,0,255,0,255,1,0,0,255,0,0,1,255,0,255,1,1,255,0,255,1,0,1,255,0,255,255,1,1,1,0,255,255,1,1,255,1,0,255,255,255,1,1,255,0,255,255,0,0,1,1,0,0,1,0,255,1,1,0,255,1,0,1,1,1,255,0,1,0,0,255,255,1,1,1,1,255,1,1,0,0,255,0,255,255,1,255,255,255,0,255,255,255,1,0,1,0,1,255,1,255,1,1,1,255,0,1,1,1,0,1,0,0,255,1,1,1,1,0,0,0,0,0,255,0,0,1,255,1,0,255,1,255,1,255,1,0,1,255,255,1,255,255,255,0,0,0,0,255,1,1,1,255,1,255,0,1,1,255,255,1,0,0,0,1,1,1,255,0,1,1,255,1,255,255,0,1,0,1,255,255,1,0,0,1,1,255,0,1,255,1,0,255,255,1,1,255,255,255,1,255,255,255,0,0,1,0,255,0,1,255,1,0,1,0,0,1,255,255,255,1,255,255,1,255,0,255,0,0,1,255,255,1,255,0,0,255,255,255,0,255,1,1,1,0,1,1,255,1,255,1,1,1,1,1,1,0,0,0,0,255,0,0,1,255,0,1,0,0,255,0,1,0,0,1,1,255,0,0,1,255,1,255,1,0,255,0,1,0,1,1,1,255,255,1,0,1,255,0,1,0,0,255,255,0,1,0,255,255,255,0,0,1,1,1,0,255,0,255,0,255,1,0,1,0,0,0,255,0,0,1,0,255,1,0,1,255,0,0,255,255,255,0,0,1,1,1,1,1,0,0,255,255,255,0,0,1,255,1,255,255,255,0,1,255,255,0,0,0,0,1,1,255,255,255,255,255,1,0,0,1,255,255,1,255,1,1,0,0,0,0,1,1,255,255,1,255,0,1,0,255,1,1,1,255,0,255,255,1,1,1,255,0,255,255,0,1,255,0,0,0,0,255,0,0,255,0,1,0,1,255,1,1,0,255,255,1,255,0,0,255,255,1,255,255,255,0,0,1,255,0,255,1,1,0,255,255,255,1,0,1,255,1,0,1,0,0,1,1,0,255,1,1,1,255,1,255,255,0,1,1,1,255,0,1,255,255,1,0,255,255,1,0,0,255,1,1,1,1,255,0,255,255,1,0,255,1,255,255,1,1,255,1,1,0,255,255,0,0,255,1,255,255,1,1,0,255,255,0,0,0,255,255,255,1,1,255,0,0,1,0,1,1,1,1,1,1,1,1,255,255,0,255,0,0,0,255,1,1,255,255,1,0,0,0,0,0,0,0,255,1,255,1,1,0,255,0,0,1,0,0,1,1,0,255,1,255,1,0,0,1,1,0,1,1,255,255,255,0,1,0,0,255,255,1,1,1,1,255,1,0,255,0,1,0,255,0,255,255,1,1,1,0,1,1,0,0,255,0,1,255,255,255,255,0,255,0,1,255,0,255,0,0,0,0,255,255,0,255,255,255,0,255,255,255,1,1,1,0,255,255,0,255,0,0,1,0,1,255,1,0,1,1,0,1,255,0,1,0,0,255,0,1,0,1,1,0,0,255,0,1,255,1,255,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255},
} ;

static const unsigned char precomputed_core_inv3sntrup1277_n[precomputed_core_inv3sntrup1277_NUM][crypto_core_INPUTBYTES] = {
  {129,24,159,6,124,24,28,228,41,18,120,187,164,252,210,14,114,163,192,245,213,76,31,254,93,16,60,254,207,17,34,93,194,243,73,81,33,236,214,76,30,71,233,218,146,11,177,247,120,82,93,249,205,121,21,208,212,135,112,125,184,179,113,4,27,110,85,209,228,11,81,12,115,141,222,250,0,39,108,137,135,143,127,110,83,172,74,255,138,113,177,227,253,75,119,158,236,120,88,123,227,174,3,45,8,27,99,99,173,92,180,128,128,173,109,189,63,94,236,216,1,164,38,124,11,128,130,154,195,172,6,11,226,188,207,117,179,201,102,103,3,41,213,226,85,161,164,245,165,174,164,105,185,72,145,232,82,91,12,191,61,78,172,251,177,65,76,76,200,227,82,1,245,179,186,9,206,70,24,114,63,166,26,119,82,34,145,194,193,251,25,53,53,135,47,59,228,43,135,10,187,133,203,24,160,189,200,66,172,7,78,3,232,132,238,100,200,183,209,134,186,158,158,77,245,108,117,180,97,174,99,2,178,118,62,237,35,41,230,12,168,254,7,6,184,224,64,236,3,232,209,170,254,209,233,18,239,67,206,143,117,15,219,235,129,251,139,191,134,118,111,200,128,124,69,176,193,248,8,78,129,103,244,142,89,123,23,116,16,240,17,157,62,121,223,192,216,4,147,4,23,58,51,240,200,213,251,230,18,217,221,213,0,156,91,250,149,24,145,122,229,142,167,206,164,92,111,102,190,187,255,171,0,145,182,158,225,126,54,41,224,233,75,199,132,115,191,43,242,232,32,109,82,195,110,44,34,172,209,40,177,125,136,29,51,89,137,21,228,210,131,21,74,190,6,158,77,156,104,208,188,122,55,144,162,56,225,56,142,233,144,44,203,166,255,173,105,254,96,247,41,145,52,141,209,46,83,13,149,27,103,219,89,120,37,217,160,190,114,119,146,150,128,21,9,190,178,33,71,247,133,171,209,135,49,157,205,170,30,16,197,87,11,32,29,134,64,129,198,34,44,145,135,36,31,52,122,85,44,79,58,135,77,129,10,217,206,244,35,167,22,203,68,174,59,164,234,115,162,115,5,107,87,167,244,195,239,215,34,209,128,63,61,249,228,161,193,232,8,124,49,54,253,140,252,17,60,127,150,15,149,241,242,141,224,220,82,181,157,181,255,108,137,214,33,26,187,114,237,63,136,11,136,32,114,19,61,101,2,203,89,195,158,31,128,22,37,139,247,93,76,104,191,235,53,20,121,45,227,134,218,179,50,245,97,85,7,59,137,36,244,12,49,146,254,39,10,32,241,43,225,219,58,63,68,49,220,226,95,208,223,121,242,66,207,32,86,104,101,189,232,41,168,158,157,143,191,88,60,186,56,220,169,21,12,206,229,144,71,124,50,76,2,17,115,101,64,87,220,143,104,149,57,186,243,161,196,194,218,79,41,67,71,20,199,42,130,0,37,32,239,127,230,204,6,38,50,138,91,228,35,170,166,134,184,165,105,5,17,124,118,233,66,221,10,138,204,170,205,120,178,226,234,158,207,21,209,165,66,79,225,0,113,151,184,34,255,11,249,130,165,150,184,4,115,44,167,138,13,246,21,45,217,0,203,212,17,191,35,127,109,205,1,10,221,104,23,242,196,68,89,247,229,118,114,228,172,51,34,248,152,152,145,243,249,116,12,91,116,158,188,45,51,251,242,203,90,179,211,149,255,99,124,254,204,167,241,96,40,76,158,166,179,85,250,103,169,92,5,118,82,212,51,42,21,210,78,196,118,74,101,60,152,205,147,166,229,35,252,140,224,199,162,78,142,74,224,206,224,118,99,85,103,77,131,245,181,71,25,44,130,59,221,104,108,106,249,251,242,168,239,74,53,88,181,53,183,201,159,128,192,7,122,101,124,234,238,19,245,141,231,183,23,1,38,3,107,254,160,220,134,1,69,97,99,175,104,176,206,150,104,76,27,169,184,145,194,241,97,138,193,168,98,26,145,154,188,108,146,35,47,142,61,90,170,9,204,157,27,251,155,134,147,21,134,114,131,30,227,66,203,39,160,162,0,2,41,118,167,39,185,113,106,227,120,184,247,251,57,131,86,185,18,55,15,22,239,147,125,183,205,214,63,66,163,75,199,56,117,15,148,132,32,145,124,200,152,146,199,159,120,124,192,4,129,63,161,83,150,35,21,192,172,1,247,239,231,87,222,183,199,50,121,19,205,168,180,69,240,34,57,189,93,228,181,213,60,9,221,79,182,133,115,27,187,69,70,248,54,27,48,182,106,91,59,212,100,57,31,83,101,74,171,23,139,10,214,195,18,3,20,147,171,151,63,8,205,150,218,214,170,3,16,1,62,70,11,174,73,237,183,156,45,107,22,156,218,21,253,123,246,10,77,144,137,219,238,240,246,93,88,144,206,129,114,60,190,229,112,182,135,217,217,137,27,35,204,86,76,253,238,254,27,100,190,248,4,228,64,59,243,107,94,164,101,252,65,22,245,226,200,92,52,78,43,144,129,214,175,164,98,178,169,44,18,39,166,72,149,213,120,7,45,196,172,216,45,23,181,244,112,181,126,12,164,87,243,109,23,51,41,239,10,192,179,136,6,251,64,126,35,171,194,61,73,69,154,235,9,19,94,238,77,152,116,111,10,35,85,85,85,91,66,206,205,102,209,94,50,24,100,247,196,208,144,97,230,20,11,49,173,52,177,37,191,48,229,142,51,85,241,82,36,254,30,74,134,210,188,13,192,147,81,38,209,145,239,148,188,153,120,16,39,154,93,122,92,121,124,167,245,122,155,77,196,145,232,112,246,170,137,98,9,139,17,73,39,245,114,247,181,215,133,119,146,11,210,195,11,128,198,56,107,80,49,126,162},
  {66,33,168,141,216,174,218,131,28,104,122,253,86,105,122,163,47,240,74,78,188,134,15,56,7,33,147,52,166,190,44,182,86,131,253,141,54,99,171,55,30,175,94,86,9,54,105,189,204,72,133,180,138,213,129,173,168,15,208,149,214,186,56,102,0,216,251,170,210,247,179,221,119,4,52,246,121,8,104,29,238,113,232,251,45,119,118,83,221,109,61,109,250,67,250,83,158,165,118,235,227,90,145,190,205,157,124,12,131,150,21,108,82,181,37,39,132,154,44,187,107,150,34,1,57,249,231,32,108,108,98,211,55,159,18,10,99,250,109,180,177,183,247,200,12,134,18,10,101,224,85,147,128,55,236,108,117,130,31,236,242,209,210,67,58,89,13,68,155,186,218,154,180,185,156,119,129,222,49,194,203,244,76,167,193,37,141,122,43,47,233,51,120,200,135,253,243,17,205,218,91,141,65,25,81,130,5,167,35,37,120,79,54,114,179,59,102,156,13,44,243,160,11,110,119,143,246,198,50,244,63,192,212,47,163,205,101,255,46,45,98,96,132,135,110,38,81,178,76,105,13,129,219,216,188,246,1,158,142,149,185,189,105,37,245,70,102,93,48,231,198,216,0,150,217,215,142,135,173,29,30,171,146,139,209,118,249,235,75,34,150,34,43,43,167,242,4,124,60,136,41,164,14,29,51,164,126,186,75,43,168,238,38,125,159,5,240,122,122,153,15,115,31,209,154,206,92,140,139,202,179,169,19,53,52,138,3,140,124,99,191,90,111,152,185,38,239,15,85,102,44,101,30,1,80,108,101,40,2,225,124,33,47,197,28,190,171,8,85,21,149,106,139,69,156,120,142,163,76,62,219,144,175,178,77,165,33,56,173,74,174,145,137,157,87,197,251,162,114,178,216,196,202,13,89,223,88,228,199,59,236,23,127,15,229,226,100,166,198,203,190,164,193,33,210,11,34,104,220,61,134,86,168,164,170,74,80,223,81,124,160,202,181,206,61,246,52,68,107,231,25,211,172,30,4,246,99,89,34,158,152,145,235,11,143,28,104,170,86,158,29,239,24,111,122,182,242,57,86,0,50,58,66,226,252,63,151,235,239,148,69,57,53,195,34,104,100,221,222,213,94,58,206,237,64,200,140,161,123,244,203,190,230,167,33,197,150,201,28,196,63,41,1,40,99,178,125,79,36,226,218,111,82,59,95,249,178,173,158,206,93,56,22,241,157,149,69,21,196,133,202,91,225,180,10,161,162,132,117,2,204,247,204,188,81,66,188,186,70,115,171,219,239,191,175,213,66,225,166,165,124,224,82,27,171,147,197,193,133,25,122,45,41,38,107,83,124,19,80,132,138,249,7,56,42,105,131,156,49,0,192,228,225,247,48,128,154,217,231,108,75,211,44,53,204,87,244,102,235,220,212,124,15,84,150,240,78,15,176,237,57,19,76,115,12,248,241,108,73,29,112,50,31,63,243,212,245,237,52,16,197,29,135,95,3,40,35,42,161,30,210,199,8,241,138,225,102,249,44,162,153,69,230,68,37,120,170,120,68,55,203,56,236,93,213,104,151,33,135,90,184,209,209,41,191,218,91,77,124,174,240,38,85,220,46,164,62,183,192,80,236,186,177,206,161,91,105,7,58,74,210,160,241,244,121,52,51,114,27,5,124,83,244,150,140,65,83,50,112,79,209,52,118,175,179,201,12,218,204,130,88,241,10,233,71,228,131,83,253,105,191,228,214,238,74,66,99,102,118,46,255,174,162,183,169,214,43,122,88,194,47,102,239,195,72,89,20,171,139,167,223,188,60,123,59,212,0,167,246,144,139,194,57,162,151,66,91,32,80,127,5,20,82,132,146,50,56,181,236,221,137,232,24,174,57,250,235,86,191,235,64,45,254,0,146,13,80,253,224,46,46,176,246,73,196,253,154,126,22,21,148,196,194,212,255,214,188,197,73,154,5,6,226,174,135,111,177,3,22,29,102,229,222,220,108,144,48,251,32,175,63,118,225,80,157,57,119,239,239,242,199,202,20,140,69,144,123,53,6,41,127,215,61,4,106,199,139,16,9,195,50,71,81,156,165,120,41,99,56,107,152,70,53,242,86,173,14,142,43,196,126,112,44,15,224,157,28,250,76,8,24,21,79,233,87,252,61,235,87,131,239,80,169,63,162,80,186,231,161,183,192,184,103,42,173,51,236,16,112,84,37,21,160,116,130,238,61,112,79,21,56,0,86,98,178,121,35,255,228,96,118,50,84,0,90,212,76,156,134,17,145,80,188,1,68,215,240,157,168,46,197,38,138,162,189,179,247,146,234,152,249,71,18,213,100,0,242,155,209,36,125,77,58,126,90,136,167,167,29,251,95,67,59,220,9,238,109,113,80,203,116,205,85,206,227,64,141,53,80,101,120,168,139,142,197,117,183,236,133,142,212,22,118,170,8,37,163,7,215,223,55,250,244,87,216,74,139,162,207,31,12,153,230,200,72,131,67,61,58,97,179,141,104,95,44,85,79,119,7,176,252,9,99,43,86,2,209,184,94,172,34,15,188,147,115,46,86,14,46,248,32,222,73,120,164,208,74,41,145,133,132,199,254,193,153,126,123,109,12,162,6,100,67,119,12,217,172,199,187,193,118,26,201,219,165,103,222,223,182,91,93,77,22,107,201,66,222,252,148,121,151,18,104,99,230,141,111,10,135,44,149,22,215,202,109,114,228,250,105,99,212,174,8,212,14,71,183,135,11,147,65,65,40,218,212,2,78,197,121,25,209,109,104,10,169,11,181,236,252,242,62,47,122,157,119,182,69,172,228,185,213,215,229,195,235,122,3,207,154,155,217,3,204,135,112,123,143,138,239,2,131,210,178,217,241,230,140},
  {118,224,206,186,12,212,162,45,205,39,68,194,78,218,191,185,120,65,120,125,61,18,30,160,118,2,78,248,97,121,27,107,238,114,29,242,55,30,179,56,110,217,188,50,20,246,217,18,180,48,184,200,88,62,91,113,187,152,251,190,228,148,79,72,228,188,226,190,209,109,119,91,236,184,18,240,245,213,185,35,78,227,161,54,85,216,195,148,141,97,46,174,249,217,242,40,199,38,12,44,48,231,63,197,72,33,81,235,243,251,238,180,165,249,171,146,90,145,197,201,70,180,244,47,100,78,27,207,215,116,200,178,65,102,79,110,0,2,125,10,246,141,55,139,4,176,201,74,175,14,12,126,156,228,61,38,44,228,70,26,244,34,198,38,199,32,208,103,194,76,156,229,252,102,82,85,14,97,226,130,254,232,217,52,230,238,167,237,18,20,177,98,250,12,134,107,111,47,20,72,162,92,2,0,146,11,159,147,75,103,181,36,249,190,207,73,161,171,192,136,98,24,238,213,96,119,14,102,137,225,178,190,96,142,2,198,4,19,115,23,23,156,51,86,122,89,201,230,34,244,209,130,16,192,47,83,95,181,70,137,75,247,165,3,10,167,94,51,73,194,214,157,21,112,241,29,104,87,104,208,227,115,175,169,105,245,23,236,61,75,21,189,242,188,193,185,90,231,117,161,231,181,49,39,190,79,44,83,203,52,155,80,87,95,254,207,169,190,46,119,136,48,138,16,22,66,85,85,166,147,176,68,127,176,123,195,234,211,185,10,31,59,39,209,19,228,170,46,136,101,75,68,91,14,93,230,59,213,213,233,227,171,88,193,178,66,77,1,91,1,58,157,128,49,213,69,92,37,136,154,158,253,145,158,83,251,172,250,159,38,69,186,179,229,232,132,241,41,137,228,82,239,195,96,164,158,239,240,245,154,182,255,115,111,156,222,230,69,97,91,229,171,106,92,175,62,40,12,237,181,159,95,58,183,144,183,142,128,219,111,41,108,22,75,194,247,43,214,12,80,236,164,22,174,166,15,59,76,93,83,46,180,244,184,231,170,189,211,192,221,13,238,255,39,133,185,56,190,214,45,142,251,23,164,5,87,54,15,228,110,251,208,201,176,159,119,227,242,251,89,159,20,68,32,51,254,141,171,158,142,236,152,56,28,156,252,176,183,232,82,78,59,225,205,175,43,4,36,254,253,168,222,55,240,14,183,113,31,191,181,118,8,134,57,8,19,203,0,164,251,169,89,172,124,83,72,94,186,228,237,251,132,243,131,202,14,105,55,180,62,193,166,191,20,246,57,125,92,23,37,178,142,171,185,10,68,124,38,240,18,124,242,55,79,46,99,46,45,118,187,7,116,171,111,204,97,137,131,104,238,103,185,103,2,47,2,60,186,239,44,188,137,11,25,97,219,2,234,81,160,232,54,201,14,207,76,11,102,120,3,232,6,24,163,176,132,23,166,22,4,143,52,64,141,170,152,124,151,70,31,175,128,244,27,69,137,49,140,61,12,208,74,175,47,154,105,162,80,199,103,23,42,25,127,144,43,32,40,114,105,89,121,117,101,81,93,185,2,93,206,253,137,167,42,36,199,207,254,239,141,2,124,45,187,221,100,103,72,27,193,140,71,56,123,36,96,210,96,140,108,28,116,238,225,88,16,89,58,129,212,231,39,19,230,170,157,69,46,83,247,238,123,162,162,21,100,106,189,186,224,237,78,76,20,61,54,32,104,154,157,184,239,156,172,212,221,23,151,200,68,205,193,159,192,180,201,166,58,239,245,241,2,237,153,153,126,197,210,43,210,57,129,92,17,163,216,14,122,174,150,226,245,33,247,144,223,254,253,24,193,220,139,33,194,181,62,222,149,196,154,223,96,72,253,31,175,201,6,193,236,229,100,30,42,236,99,234,119,230,132,80,184,239,141,112,106,57,181,114,25,219,11,133,53,247,117,88,224,173,133,157,181,31,210,124,171,55,237,193,13,147,220,230,18,3,6,10,101,49,25,248,238,210,136,146,241,109,1,26,38,172,191,84,5,77,149,217,83,221,149,130,219,99,146,96,86,179,229,161,132,172,17,143,171,205,159,174,209,54,102,252,40,97,249,112,51,114,177,233,16,138,102,251,24,140,73,119,184,176,121,121,52,188,220,41,133,122,145,86,131,213,63,209,164,0,80,154,132,221,156,151,8,161,152,94,157,70,77,246,68,81,93,137,204,79,158,34,0,115,231,76,171,24,196,58,41,108,175,145,239,212,131,95,84,111,221,88,164,225,87,121,202,73,136,66,191,252,120,196,111,52,175,199,69,112,248,234,13,162,32,98,134,103,98,141,109,203,115,179,75,56,106,149,148,227,123,63,107,188,246,131,101,95,45,66,162,254,197,226,85,92,179,72,79,135,207,110,129,92,187,148,221,182,68,140,199,122,249,232,80,52,125,150,168,49,17,61,116,181,245,43,120,34,250,107,190,245,96,146,94,13,242,154,138,201,207,217,32,111,101,63,150,73,72,207,152,135,72,155,210,242,210,208,81,202,190,157,147,220,247,129,189,224,156,184,200,196,252,69,119,38,12,246,30,145,119,203,45,192,181,252,84,98,203,192,200,16,49,44,107,41,135,88,102,193,110,255,138,28,14,154,197,239,129,13,156,113,242,19,119,203,77,124,247,37,123,122,84,17,45,232,163,151,121,171,83,74,159,121,76,138,124,60,6,183,150,216,187,27,126,114,140,214,19,6,63,66,152,140,14,54,88,217,26,253,81,102,104,225,120,251,174,160,203,91,235,84,174,137,217,60,91,61,213,129,14,176,230,19,161,238,201,35,93,175,194,117,16,88,42,180,204,98,201,44,234,241,29,13,253,219,9,140,39,251,26,252},
  {240,122,144,19,159,131,9,206,112,97,181,119,181,142,2,202,38,93,108,213,160,129,247,55,12,148,178,149,171,115,6,97,233,228,223,89,145,189,124,88,104,183,64,248,186,222,190,238,194,152,55,35,121,189,76,242,0,153,238,194,19,219,246,4,28,252,30,217,197,53,151,233,1,210,162,225,145,92,144,88,234,148,229,5,105,217,162,153,99,74,240,161,148,53,127,30,14,165,169,102,211,167,230,104,79,108,244,163,61,107,52,22,248,76,36,198,220,174,171,124,95,200,192,251,165,40,216,8,54,175,150,152,31,153,229,149,18,124,164,159,131,47,24,74,233,134,178,88,62,240,192,249,77,184,78,48,177,44,75,25,232,205,253,136,236,224,109,27,62,88,191,172,120,3,123,152,206,104,18,156,17,27,15,244,74,34,161,221,137,17,43,194,44,233,33,187,46,108,59,128,208,95,130,156,105,90,90,42,238,159,141,48,195,216,82,116,135,77,81,44,158,225,54,252,197,180,61,168,222,126,60,107,63,20,97,232,198,15,198,194,17,103,74,59,136,82,129,156,199,102,201,116,177,62,15,23,145,30,145,78,132,12,11,203,96,158,216,76,22,15,212,212,163,145,191,19,62,75,169,29,140,27,84,107,84,162,91,117,191,100,175,220,244,157,203,101,67,124,160,55,20,26,209,4,156,61,158,224,91,191,6,95,174,38,160,9,88,206,154,201,73,173,252,61,88,220,171,150,55,168,231,198,26,67,250,176,160,143,217,247,235,37,50,146,109,14,156,236,94,11,49,197,45,53,142,6,202,222,245,215,107,153,68,9,222,112,192,81,173,77,224,11,18,162,172,109,139,131,41,3,36,48,12,22,42,247,189,113,183,116,66,245,34,252,86,21,8,63,123,77,191,193,181,129,121,3,92,133,241,106,64,143,62,249,4,187,175,4,166,128,91,150,194,36,95,49,4,242,55,17,57,194,147,178,250,99,131,123,156,237,22,147,238,43,119,117,20,30,172,15,146,242,111,189,185,24,129,178,134,201,246,217,36,115,106,141,97,29,255,154,171,178,235,172,132,105,108,122,141,84,60,117,156,23,193,92,246,106,91,246,223,60,97,185,122,20,69,96,105,112,155,13,86,73,102,250,161,74,234,192,22,236,78,142,197,192,30,197,224,122,154,186,75,69,207,202,104,98,53,250,65,232,237,170,39,93,237,169,163,61,0,228,223,234,127,144,229,248,172,5,126,191,248,212,25,120,88,23,183,172,246,104,88,135,116,100,145,181,50,159,221,115,98,50,206,207,56,94,251,83,156,132,167,230,41,63,15,73,87,12,59,200,165,120,50,35,245,191,165,12,141,154,166,156,188,211,66,192,226,160,77,64,239,151,240,47,240,152,68,66,96,189,200,157,174,23,114,40,255,211,110,52,155,118,57,148,167,186,201,88,45,179,56,50,37,192,63,150,166,164,161,227,82,113,124,225,219,48,131,39,160,2,125,196,77,4,172,205,196,183,178,193,99,18,17,229,131,152,109,206,22,207,95,170,246,17,187,156,42,113,196,185,178,67,163,165,169,218,229,142,184,155,169,180,47,77,225,180,26,22,76,7,5,239,177,112,108,193,51,30,222,73,226,7,35,177,137,1,190,35,240,241,105,113,82,40,147,236,69,77,45,121,167,17,195,120,165,118,207,234,216,130,41,244,188,85,17,173,67,48,251,83,23,67,116,163,226,140,227,207,28,205,175,195,63,30,220,82,21,149,13,62,44,81,109,58,78,40,219,105,15,174,247,111,204,219,164,73,61,254,147,146,240,217,135,8,182,210,134,244,21,151,166,180,68,123,134,84,31,212,37,74,189,35,123,200,218,128,200,88,88,14,229,246,4,91,104,73,209,240,52,228,43,7,92,189,21,245,183,133,2,14,82,25,37,147,189,64,151,36,146,198,214,201,51,66,86,109,33,29,41,183,68,104,87,198,144,84,233,49,238,26,45,59,232,147,74,241,6,144,144,158,194,62,8,93,210,170,252,217,168,17,185,24,140,98,220,142,60,70,205,128,80,195,117,235,21,152,108,60,164,25,247,45,137,168,65,68,231,170,196,194,48,222,43,117,143,219,78,190,160,209,7,76,60,26,44,243,107,185,134,204,122,32,86,23,197,171,246,95,88,63,80,109,168,129,221,133,139,136,88,227,92,195,239,24,143,167,59,101,203,70,24,174,82,248,101,32,80,41,62,49,50,152,143,56,216,125,54,105,191,107,118,238,100,55,18,163,133,181,49,23,23,178,38,221,118,3,66,41,202,215,106,207,197,98,167,66,151,143,70,110,138,75,109,8,126,66,161,173,77,245,88,238,89,172,73,106,248,127,186,168,254,13,186,14,62,220,59,47,133,84,29,222,39,230,52,173,61,215,163,40,203,184,168,168,132,62,254,217,236,51,138,23,189,133,180,79,4,65,16,187,202,0,165,147,27,92,215,147,71,187,204,158,129,220,34,222,4,238,132,243,147,0,129,159,38,3,194,100,159,154,38,60,162,88,25,160,244,202,211,183,247,96,71,187,188,126,217,211,129,160,121,73,252,10,152,84,168,86,34,178,98,30,139,115,65,172,64,55,119,40,160,31,21,64,114,29,149,111,178,143,97,9,119,69,176,167,45,250,177,142,108,121,68,192,211,92,78,4,190,196,145,146,208,110,38,140,252,106,112,64,249,176,89,132,248,117,134,222,196,241,53,70,152,138,7,223,29,19,123,104,252,93,132,24,130,70,46,46,43,203,64,64,178,29,90,209,34,65,61,58,66,237,61,106,151,242,156,128,81,137,151,35,255,60,50,176,173,59,34,4,94,222,166,246,203,137,118,9,118,84,14,89,17,33,117},
  {255,255,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_inv3sntrup1277_k[precomputed_core_inv3sntrup1277_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_inv3sntrup1277_c[precomputed_core_inv3sntrup1277_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_inv3sntrup1277_impl(long long impl)
{
  unsigned char *h = test_core_inv3sntrup1277_h;
  unsigned char *n = test_core_inv3sntrup1277_n;
  unsigned char *k = test_core_inv3sntrup1277_k;
  unsigned char *c = test_core_inv3sntrup1277_c;
  unsigned char *h2 = test_core_inv3sntrup1277_h2;
  unsigned char *n2 = test_core_inv3sntrup1277_n2;
  unsigned char *k2 = test_core_inv3sntrup1277_k2;
  unsigned char *c2 = test_core_inv3sntrup1277_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup1277_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_inv3sntrup1277(impl);
    printf("core_inv3sntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup1277_implementation(impl),ntruprime_dispatch_core_inv3sntrup1277_compiler(impl));
  } else {
    crypto_core = ntruprime_core_inv3sntrup1277;
    printf("core_inv3sntrup1277 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup1277_implementation(),ntruprime_core_inv3sntrup1277_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_inv3sntrup1277_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_inv3sntrup1277_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_inv3sntrup1277_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_inv3sntrup1277_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_inv3sntrup1277_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_inv3sntrup1277_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_inv3sntrup1277_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_inv3sntrup1277_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_inv3sntrup1277_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_inv3sntrup1277_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_inv3sntrup1277(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup1277")) return;
  storage_core_inv3sntrup1277_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_inv3sntrup1277_h = aligned(storage_core_inv3sntrup1277_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_inv3sntrup1277_n = callocplus(crypto_core_INPUTBYTES);
  test_core_inv3sntrup1277_n = aligned(storage_core_inv3sntrup1277_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_inv3sntrup1277_k = callocplus(crypto_core_KEYBYTES);
  test_core_inv3sntrup1277_k = aligned(storage_core_inv3sntrup1277_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_inv3sntrup1277_c = callocplus(crypto_core_CONSTBYTES);
  test_core_inv3sntrup1277_c = aligned(storage_core_inv3sntrup1277_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_inv3sntrup1277_h2 = callocplus(maxalloc);
  test_core_inv3sntrup1277_h2 = aligned(storage_core_inv3sntrup1277_h2,crypto_core_OUTPUTBYTES);
  storage_core_inv3sntrup1277_n2 = callocplus(maxalloc);
  test_core_inv3sntrup1277_n2 = aligned(storage_core_inv3sntrup1277_n2,crypto_core_INPUTBYTES);
  storage_core_inv3sntrup1277_k2 = callocplus(maxalloc);
  test_core_inv3sntrup1277_k2 = aligned(storage_core_inv3sntrup1277_k2,crypto_core_KEYBYTES);
  storage_core_inv3sntrup1277_c2 = callocplus(maxalloc);
  test_core_inv3sntrup1277_c2 = aligned(storage_core_inv3sntrup1277_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_inv3sntrup1277 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup1277();++impl)
      forked(test_core_inv3sntrup1277_impl,impl);
    ++test_core_inv3sntrup1277_h;
    ++test_core_inv3sntrup1277_n;
    ++test_core_inv3sntrup1277_k;
    ++test_core_inv3sntrup1277_c;
    ++test_core_inv3sntrup1277_h2;
    ++test_core_inv3sntrup1277_n2;
    ++test_core_inv3sntrup1277_k2;
    ++test_core_inv3sntrup1277_c2;
  }
  free(storage_core_inv3sntrup1277_c2);
  free(storage_core_inv3sntrup1277_k2);
  free(storage_core_inv3sntrup1277_n2);
  free(storage_core_inv3sntrup1277_h2);
  free(storage_core_inv3sntrup1277_c);
  free(storage_core_inv3sntrup1277_k);
  free(storage_core_inv3sntrup1277_n);
  free(storage_core_inv3sntrup1277_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

