/*
* Adplug - Replayer for many OPL2/OPL3 audio file formats.
* Copyright (C) 1999 - 2007 Simon Peter, <dn.tlp@gmx.net>, et al.
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*
* rad2.h - RAD v2 replayer class
*/

#ifndef H_ADPLUG_RAD2PLAYER
#define H_ADPLUG_RAD2PLAYER

#include "player.h"

class RADPlayer;

class Crad2Player: public CPlayer
{
public:
	static CPlayer *factory(Copl *newopl);

	Crad2Player(Copl *newopl);
	virtual ~Crad2Player();

	/***** Operational methods *****/
	bool load(const std::string &filename, const CFileProvider &fp = CProvider_Filesystem()) override;
	bool update() override;
	void rewind(int subsong = -1) override;
	float getrefresh() override;

	/***** Informational methods *****/
	std::string gettype() override;
	std::string getdesc() override         { return desc; }

	unsigned int getpatterns() override;
	unsigned int getinstruments() override;
	unsigned int getpattern() override;
	unsigned int getorders() override;
	unsigned int getorder() override;
	unsigned int getrow() override;
	unsigned int getrows() override;
	unsigned int getnchans() override;
	unsigned char getpattern(unsigned long order) override;
        void gettrackdata(unsigned char pattern, void (*callback)(void *arg, unsigned char row, unsigned char channel, unsigned char note, TrackedCmds command, unsigned char inst, unsigned char volume, unsigned char param), void *arg) override;
	unsigned int getspeed() override;
	std::string getinstrument(unsigned int n) override;

protected:
	RADPlayer *rad;
	char *data;

	std::string desc;

};

#endif
