# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 229-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53308);
 script_cve_id("CVE-2003-0025");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 229-2 (imp)";
 script_name(name);

 desc = "The remote host is missing an update to imp
announced via advisory DSA 229-2.

The advisory DSA 229-1 contained a typo in one file which could cause
certain installations to fail suddenly.

For completeness, here is the original advisory text:

Jouko Pynnonen discovered a probem with IMP, a web based IMAP mail
program.  Using carefully crafted URLs a remote attacker is able to
inject SQL code into SQL queries without proper user authentication.
Even though results of SQL queries aren't directly readable from the
screen, an attacker might. update his mail signature to contain wanted
query results and then view it on the preferences page of IMP.

The impact of SQL injection depends heavily on the underlying database
and its configuration.  If PostgreSQL is used, it's possible to
execute multiple complete SQL queries separated by semicolons.  The
database contains session id's so the attacker might hijack sessions
of people currently logged in and read their mail.  In the worst case,
if the hordemgr user has the required privilege to use the COPY SQL
command (found in PostgreSQL at least), a remote user may read or
write to any file the database user (postgres) can.  The attacker may
then be able to run arbitrary shell commands by writing them to the
postgres user's ~/.psqlrc; they'd be run when the user starts the psql
command which under some configurations happens regularly from a cron
script.

For the current stable distribution (woody) this problem has been
fixed in version 2.2.6-5.2.

For the old stable distribution (potato) this problem has been
fixed in version 2.2.6-0.potato.5.2.

For the unstable distribution (sid) this problem will be fixed in
version 2.2.6-8.

We recommend that you upgrade your IMP packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20229-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 229-2 (imp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imp", ver:"2.2.6-0.potato.5.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imp", ver:"2.2.6-5.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
