#
#VID 49e8f2ee-8147-11de-a994-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 49e8f2ee-8147-11de-a994-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64577);
 script_cve_id("CVE-2009-2404", "CVE-2009-2408", "CVE-2009-2454", "CVE-2009-2470");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: firefox, linux-firefox-devel");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   firefox linux-firefox-devel firefox3
   linux-firefox firefox35 thunderbird
   linux-thunderbird seamonkey linux-seamonkey

CVE-2009-2404
Heap-based buffer overflow in a regular-expression parser in Mozilla
Network Security Services (NSS) before 3.12.3, as used in Firefox,
Thunderbird, SeaMonkey, Evolution, Pidgin, and AOL Instant Messenger
(AIM), allows remote SSL servers to cause a denial of service
(application crash) or possibly execute arbitrary code via a long
domain name in the subject's Common Name (CN) field of an X.509
certificate, related to the cert_TestHostName function.

CVE-2009-2408
Mozilla Firefox before 3.5 and NSS before 3.12.3 do not properly
handle a '\0' character in a domain name in the subject's Common Name
(CN) field of an X.509 certificate, which allows man-in-the-middle
attackers to spoof arbitrary SSL servers via a crafted certificate
issued by a legitimate Certification Authority.

CVE-2009-2454
Cross-site scripting (XSS) vulnerability in Citrix Web Interface 4.6,
5.0, and 5.0.1 allows remote attackers to inject arbitrary web script
or HTML via unspecified vectors.

CVE-2009-2470
Mozilla Firefox before 3.0.12, and 3.5.x before 3.5.2, allows remote
SOCKS5 proxy servers to cause a denial of service (data stream
corruption) via a long domain name in a reply.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mozilla.org/security/announce/2009/mfsa2009-38.html
http://www.mozilla.org/security/announce/2009/mfsa2009-42.html
http://www.mozilla.org/security/announce/2009/mfsa2009-43.html
http://www.mozilla.org/security/announce/2009/mfsa2009-44.html
http://www.mozilla.org/security/announce/2009/mfsa2009-45.html
http://www.mozilla.org/security/announce/2009/mfsa2009-46.html
http://www.vuxml.org/freebsd/49e8f2ee-8147-11de-a994-0030843d3802.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: firefox, linux-firefox-devel");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-firefox-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"firefox3");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.13")<0) {
    security_note(0, data:"Package firefox3 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.13")<0) {
    security_note(0, data:"Package linux-firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"firefox35");
if(!isnull(bver) && revcomp(a:bver, b:"3.5.2")<0) {
    security_note(0, data:"Package firefox35 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.23")<0) {
    security_note(0, data:"Package thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.23")<0) {
    security_note(0, data:"Package linux-thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.18")<0) {
    security_note(0, data:"Package seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.18")<0) {
    security_note(0, data:"Package linux-seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
