#!/bin/sh

VERSION=$2
TAG=$(echo $VERSION | sed s/\\.//g)
DIR=visualvm-$VERSION
TAR=../visualvm_$VERSION.orig.tar.xz

rm -Rf java.net $3 $DIR

# Download the tarballs
wget --no-verbose --recursive --level 1 \
     --accept 'netbeans-profiler-visualvm_release*' \
     --accept 'visualvm_*-src.tar.gz' \
     https://java.net/downloads/visualvm/release$TAG/

# Extract the source files
mkdir $DIR
mkdir $DIR/netbeans
tar -xf java.net/downloads/visualvm/release$TAG/visualvm_*-src.tar.gz -C $DIR
tar -xf java.net/downloads/visualvm/release$TAG/netbeans-profiler-visualvm_release*.tar.gz -C $DIR/netbeans

# Add a file in the empty directories to preserve them in Git (the build fails otherwise)
for dir in $(find ./$DIR -type d -regex ``./[^.].*'' -empty); do touch $dir"/.gitignore"; done;

# Build the upstream tarball
XZ_OPT=--best tar -cJf $TAR --exclude '*.exe' $DIR

rm -Rf $DIR java.net
