/*
 * xdx - GTK+ DX-cluster client for amateur radio
 * Copyright (C) 2002-2006 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 *  text.h
 */


#ifndef XDX_TEXT_H
#define XDX_TEXT_H

/* Buffer size for reading in a single cty.dat record.  Currently the
 * entire cty.dat file is just under 80k bytes, so any single record should
 * be much less than this value, but with additions of callsign exceptions
 * record sizes will undoubtedly continue to grow.
 */
#define MAX_RECORD_SIZE 65536

typedef struct {
    gchar   *countryname;
    guchar   cq;              /* guchar max=255 */
    guchar   itu;
    gchar   *continent;
    gint     latitude;
    gint     longitude;
    gshort   timezone;
    gchar   *px;
    gchar   *exceptions;
    guint    worked;
    guint    confirmed;
}
dxcc_data;

struct info {
    gint country;
    gint cq;
    gint itu;
};

void cleanup_dxcc(void);
gint readctydata(void);
struct info lookupcountry_by_callsign(gchar *callsign);

void maintext_add(gchar     *msg,
                  gint       len,
                  gint       messagetype);

#endif /* XDX_TEXT_H */
